/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.productcatalog.factsheet.pdf;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductCatalogAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class PrintProductCatalogProductFactSheetComponent
extends DefaultScrollablePrintPopup2<ProductCatalogLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final Node<ProductCatalogLight> currentProduct;
    private final Node configNode;
    private TitledItem<DateChooser> dueDate;
    private HorizontalSeparator sep1;
    private TextLabel printOptionTitle;
    private TitledItem<CheckBox> includeCosts;
    private final List<CostOption> optionsList = new ArrayList<CostOption>();
    private TitledItem<CheckBox> includeHandlingCostInProductGrossPrice;
    private HorizontalSeparator sep2;
    private TextLabel extrasTitle;
    private TitledItem<CheckBox> includeImage;
    private TitledItem<CheckBox> includeAllergens;
    private TitledItem<CheckBox> includeAdditives;
    private TitledItem<CheckBox> includeTraces;
    private TitledItem<CheckBox> includeOthers;
    private TitledItem<CheckBox> includePurchaseWaste;
    private TitledItem<CheckBox> includeCookingWaste;
    private TitledItem<CheckBox> includeComponentComments;
    private TitledItem<CheckBox> includeProductComments;
    private TitledItem<CheckBox> includeGrossQuantity;
    private TitledItem<CheckBox> useTenderData;
    private TitledItem<CheckBox> useLinkedTender;
    private CostOption processCostOption;
    private CostOption groupProcessCostOption;
    private boolean showProductionCosts = false;
    private boolean printExternalCostFactSheet = false;

    public PrintProductCatalogProductFactSheetComponent(Node<ProductCatalogLight> node) {
        super(false, false, ReportTypeE.PRODUCT);
        this.currentProduct = node;
        Runnable r = () -> {
            UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            ModuleAccessRightComplete r1 = HUDToolkit.getCurrentAccessRight(ProductCatalogAccess.MODULE_PRODUCT_CATALOG, user);
            for (DataFieldAccessRightComplete a : r1.getFieldAccessRights()) {
                if (a.getField().getName().equals(ProductCatalogAccess.SHOW_PRODUCTION_COSTS.getFieldName())) {
                    this.showProductionCosts = true;
                    continue;
                }
                if (!a.getField().getName().equals(ProductCatalogAccess.PRINT_EXTERNAL_COST_FACT_SHEET.getFieldName())) continue;
                this.printExternalCostFactSheet = true;
            }
        };
        this.loadBeforeShowing(r);
        ProductFactSheetReportConfiguration config = new ProductFactSheetReportConfiguration(null);
        config.setDueDate(new Timestamp(System.currentTimeMillis()));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.dueDate)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setIsTimestamp(true);
        this.sep1 = new HorizontalSeparator();
        this.printOptionTitle = new TextLabel(WordsToolkit.toUpperCase((String)Words.OPTIONS));
        this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        this.includeCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COSTS_FOR_SALE, TitledItem.TitledItemOrientation.EAST);
        this.includeCosts.setTitleFont(f);
        this.includeCosts.setTitleForeground(fb);
        this.includeCosts.getElement().setChecked(this.showProductionCosts);
        this.includeCosts.getElement().addButtonListener(this);
        this.optionsList.add(new CostOption(Words.MATERIAL_PRICE, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.materialCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.materialCostDetails), fb, f, 5));
        this.processCostOption = new CostOption(Words.PRODUCT_PROCESS_COSTS, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.productProcessCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.productProcessCostDetails), fb, f, 5);
        this.optionsList.add(this.processCostOption);
        this.groupProcessCostOption = new CostOption(Words.GROUP_PROCESS_COSTS, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.groupProcessCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.groupProcessCostDetails), fb, f, 5);
        this.optionsList.add(this.groupProcessCostOption);
        this.optionsList.add(new CostOption(Words.ADDITIONAL_COSTS, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.additionalCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.additionalCostDetails), fb, f, 5));
        this.optionsList.add(new CostOption(Words.HANDLING_COSTS, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.handlingCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.handlingCostDetails), fb, f, 5));
        this.optionsList.add(new CostOption(Words.DISCOUNT, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.discountCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.discountDetails), fb, f, 5));
        this.optionsList.add(new CostOption(Words.TAXES, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.taxCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.taxCostDetails), fb, f, 5));
        this.optionsList.add(new CostOption(Words.NET_SALES_PRICE, null, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.nettoCost), null, fb, f, 5));
        this.optionsList.add(new CostOption(Words.CALCULATED_SALES_PRICE, null, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.calculatedSalesPrice), null, fb, f, 5));
        this.optionsList.add(new CostOption(Words.FIX_SALES_PRICE, null, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.fixedSalesPrice), null, fb, f, 5));
        this.optionsList.add(new CostOption(Words.GROSS_SALES_PRICE, null, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.bruttoPrice), null, fb, f, 5));
        this.includeHandlingCostInProductGrossPrice = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_HANDLING_IN_PRODUCT_PRICE, TitledItem.TitledItemOrientation.EAST);
        this.includeHandlingCostInProductGrossPrice.setTitleFont(f);
        this.includeHandlingCostInProductGrossPrice.setTitleForeground(fb);
        this.includeHandlingCostInProductGrossPrice.getElement().setChecked(this.showProductionCosts);
        this.sep2 = new HorizontalSeparator();
        this.includeAllergens = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ALLERGENS, TitledItem.TitledItemOrientation.EAST);
        this.includeAllergens.setTitleFont(f);
        this.includeAllergens.setTitleForeground(fb);
        this.includeAdditives = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ADDITIVES, TitledItem.TitledItemOrientation.EAST);
        this.includeAdditives.setTitleFont(f);
        this.includeAdditives.setTitleForeground(fb);
        this.includeTraces = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_TRACES, TitledItem.TitledItemOrientation.EAST);
        this.includeTraces.setTitleFont(f);
        this.includeTraces.setTitleForeground(fb);
        this.includeOthers = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_OTHERS, TitledItem.TitledItemOrientation.EAST);
        this.includeOthers.setTitleFont(f);
        this.includeOthers.setTitleForeground(fb);
        this.includePurchaseWaste = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PURCHASE_WASTE, TitledItem.TitledItemOrientation.EAST);
        this.includePurchaseWaste.setTitleFont(f);
        this.includePurchaseWaste.setTitleForeground(fb);
        this.includeCookingWaste = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COOKING_WASTE, TitledItem.TitledItemOrientation.EAST);
        this.includeCookingWaste.setTitleFont(f);
        this.includeCookingWaste.setTitleForeground(fb);
        this.includeImage = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_IMAGE, TitledItem.TitledItemOrientation.EAST);
        this.includeImage.setTitleFont(f);
        this.includeImage.setTitleForeground(fb);
        this.includeComponentComments = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COMPONENT_COMMENT, TitledItem.TitledItemOrientation.EAST);
        this.includeComponentComments.setTitleFont(f);
        this.includeComponentComments.setTitleForeground(fb);
        this.includeProductComments = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COMMENT, TitledItem.TitledItemOrientation.EAST);
        this.includeProductComments.setTitleFont(f);
        this.includeProductComments.setTitleForeground(fb);
        this.includeGrossQuantity = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_GROSS_QUANTITY, TitledItem.TitledItemOrientation.EAST);
        this.includeGrossQuantity.setTitleFont(f);
        this.includeGrossQuantity.setTitleForeground(fb);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (settings.getUseProductTenderScenario().booleanValue()) {
            this.useTenderData = new TitledItem<CheckBox>(new CheckBox(), Words.USE_TENDER_DATA, TitledItem.TitledItemOrientation.EAST);
            this.useTenderData.setTitleFont(f);
            this.useTenderData.setTitleForeground(fb);
            this.useLinkedTender = new TitledItem<CheckBox>(new CheckBox(), Words.USE_LINKED_TENDER, TitledItem.TitledItemOrientation.EAST);
            this.useLinkedTender.setTitleFont(f);
            this.useLinkedTender.setTitleForeground(fb);
            if (!this.printExternalCostFactSheet) {
                this.useTenderData.getElement().setChecked(false);
                this.useLinkedTender.getElement().setChecked(false);
            }
        }
        this.getViewContainer().add(this.dueDate);
        this.getViewContainer().add(this.sep1);
        this.getViewContainer().add(this.printOptionTitle);
        this.getViewContainer().add(this.includeCosts);
        for (CostOption o : this.optionsList) {
            this.getViewContainer().add(o);
        }
        this.getViewContainer().add(this.includeHandlingCostInProductGrossPrice);
        this.getViewContainer().add(this.sep2);
        this.getViewContainer().add(this.includeAllergens);
        this.getViewContainer().add(this.includeAdditives);
        this.getViewContainer().add(this.includeTraces);
        this.getViewContainer().add(this.includeOthers);
        this.getViewContainer().add(this.includePurchaseWaste);
        this.getViewContainer().add(this.includeCookingWaste);
        this.getViewContainer().add(this.includeImage);
        this.getViewContainer().add(this.includeComponentComments);
        this.getViewContainer().add(this.includeGrossQuantity);
        this.getViewContainer().add(this.includeProductComments);
        if (this.useTenderData != null) {
            this.getViewContainer().add(this.useTenderData);
            this.getViewContainer().add(this.useLinkedTender);
        }
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.sep1.setEnabled(isEnabled);
        this.printOptionTitle.setEnabled(isEnabled);
        this.includeCosts.setEnabled(isEnabled && this.showProductionCosts);
        this.includeHandlingCostInProductGrossPrice.setEnabled(isEnabled && this.showProductionCosts);
        for (CostOption o : this.optionsList) {
            o.setEnabled(isEnabled && this.showProductionCosts);
        }
        boolean productProcess = this.processCostOption.isChecked();
        this.groupProcessCostOption.setEnabled(isEnabled && productProcess);
        this.sep2.setEnabled(isEnabled);
        if (this.extrasTitle != null) {
            this.extrasTitle.setEnabled(isEnabled);
        }
        this.includeImage.setEnabled(isEnabled);
        this.includeAllergens.setEnabled(isEnabled);
        this.includeAdditives.setEnabled(isEnabled);
        this.includeTraces.setEnabled(isEnabled);
        this.includeOthers.setEnabled(isEnabled);
        this.includePurchaseWaste.setEnabled(isEnabled);
        this.includeCookingWaste.setEnabled(isEnabled);
        this.includeComponentComments.setEnabled(isEnabled);
        this.includeGrossQuantity.setEnabled(isEnabled);
        this.includeProductComments.setEnabled(isEnabled);
        if (this.useTenderData != null) {
            this.useTenderData.setEnabled(isEnabled && this.printExternalCostFactSheet);
            this.useLinkedTender.setEnabled(isEnabled && this.printExternalCostFactSheet);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "costs": {
                    this.includeCosts.getElement().setChecked(b);
                    break;
                }
                case "includeHandling": {
                    this.includeHandlingCostInProductGrossPrice.getElement().setChecked(b);
                    break;
                }
                case "allergens": {
                    this.includeAllergens.getElement().setChecked(b);
                    break;
                }
                case "additives": {
                    this.includeAdditives.getElement().setChecked(b);
                    break;
                }
                case "others": {
                    this.includeOthers.getElement().setChecked(b);
                    break;
                }
                case "traces": {
                    this.includeTraces.getElement().setChecked(b);
                    break;
                }
                case "purchase": {
                    this.includePurchaseWaste.getElement().setChecked(b);
                    break;
                }
                case "cooking": {
                    this.includeCookingWaste.getElement().setChecked(b);
                    break;
                }
                case "image": {
                    this.includeImage.getElement().setChecked(b);
                    break;
                }
                case "matprice": {
                    ((CheckBox)this.optionsList.get(0).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "matprice_1": {
                    ((CheckBox)this.optionsList.get(0).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "proprice": {
                    ((CheckBox)this.optionsList.get(1).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "proprice_1": {
                    ((CheckBox)this.optionsList.get(1).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "group_proprice": {
                    ((CheckBox)this.optionsList.get(2).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "group_proprice_1": {
                    ((CheckBox)this.optionsList.get(2).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "addprice": {
                    ((CheckBox)this.optionsList.get(3).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "addprice_1": {
                    ((CheckBox)this.optionsList.get(3).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "handprice": {
                    ((CheckBox)this.optionsList.get(4).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "handprice_1": {
                    ((CheckBox)this.optionsList.get(4).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "discount": {
                    ((CheckBox)this.optionsList.get(5).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "discount_1": {
                    ((CheckBox)this.optionsList.get(5).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "taxprice": {
                    ((CheckBox)this.optionsList.get(6).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "taxprice_1": {
                    ((CheckBox)this.optionsList.get(6).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "netto": {
                    ((CheckBox)this.optionsList.get(7).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "calc": {
                    ((CheckBox)this.optionsList.get(8).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "fix": {
                    ((CheckBox)this.optionsList.get(9).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "brutto": {
                    ((CheckBox)this.optionsList.get(10).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "comment": {
                    this.includeComponentComments.getElement().setChecked(b);
                    break;
                }
                case "brutto_qty": {
                    this.includeGrossQuantity.getElement().setChecked(b);
                    break;
                }
                case "include_product_comment": {
                    this.includeProductComments.getElement().setChecked(b);
                    break;
                }
                case "use_external_costs": {
                    if (this.useTenderData == null) break;
                    this.useTenderData.getElement().setChecked(b != false && this.printExternalCostFactSheet);
                    break;
                }
                case "use_linked_tender": {
                    if (this.useLinkedTender == null) break;
                    this.useLinkedTender.getElement().setChecked(b != false && this.printExternalCostFactSheet);
                }
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("costs", "" + this.includeCosts.getElement().isChecked());
        conf.addProperty("includeHandling", "" + this.includeHandlingCostInProductGrossPrice.getElement().isChecked());
        conf.addProperty("purchase", "" + this.includePurchaseWaste.getElement().isChecked());
        conf.addProperty("allergens", "" + this.includeAllergens.getElement().isChecked());
        conf.addProperty("additives", "" + this.includeAdditives.getElement().isChecked());
        conf.addProperty("others", "" + this.includeOthers.getElement().isChecked());
        conf.addProperty("traces", "" + this.includeTraces.getElement().isChecked());
        conf.addProperty("cooking", "" + this.includeCookingWaste.getElement().isChecked());
        conf.addProperty("image", "" + this.includeImage.getElement().isChecked());
        conf.addProperty("matprice", "" + ((CheckBox)this.optionsList.get(0).firstItem.getElement()).isChecked());
        conf.addProperty("matprice_1", "" + ((CheckBox)this.optionsList.get(0).secondItem.getElement()).isChecked());
        conf.addProperty("proprice", "" + ((CheckBox)this.optionsList.get(1).firstItem.getElement()).isChecked());
        conf.addProperty("proprice_1", "" + ((CheckBox)this.optionsList.get(1).secondItem.getElement()).isChecked());
        conf.addProperty("group_proprice", "" + ((CheckBox)this.optionsList.get(2).firstItem.getElement()).isChecked());
        conf.addProperty("group_proprice_1", "" + ((CheckBox)this.optionsList.get(2).secondItem.getElement()).isChecked());
        conf.addProperty("addprice", "" + ((CheckBox)this.optionsList.get(3).firstItem.getElement()).isChecked());
        conf.addProperty("addprice_1", "" + ((CheckBox)this.optionsList.get(3).secondItem.getElement()).isChecked());
        conf.addProperty("handprice", "" + ((CheckBox)this.optionsList.get(4).firstItem.getElement()).isChecked());
        conf.addProperty("handprice_1", "" + ((CheckBox)this.optionsList.get(4).secondItem.getElement()).isChecked());
        conf.addProperty("discount", "" + ((CheckBox)this.optionsList.get(5).firstItem.getElement()).isChecked());
        conf.addProperty("discount_1", "" + ((CheckBox)this.optionsList.get(5).secondItem.getElement()).isChecked());
        conf.addProperty("taxprice", "" + ((CheckBox)this.optionsList.get(6).firstItem.getElement()).isChecked());
        conf.addProperty("taxprice_1", "" + ((CheckBox)this.optionsList.get(6).secondItem.getElement()).isChecked());
        conf.addProperty("netto", "" + ((CheckBox)this.optionsList.get(7).firstItem.getElement()).isChecked());
        conf.addProperty("calc", "" + ((CheckBox)this.optionsList.get(8).firstItem.getElement()).isChecked());
        conf.addProperty("fix", "" + ((CheckBox)this.optionsList.get(9).firstItem.getElement()).isChecked());
        conf.addProperty("brutto", "" + ((CheckBox)this.optionsList.get(10).firstItem.getElement()).isChecked());
        conf.addProperty("comment", "" + this.includeComponentComments.getElement().isChecked());
        conf.addProperty("brutto_qty", "" + this.includeGrossQuantity.getElement().isChecked());
        conf.addProperty("include_product_comment", "" + this.includeProductComments.getElement().isChecked());
        if (this.useTenderData != null) {
            conf.addProperty("use_external_costs", "" + this.useTenderData.getElement().isChecked());
            conf.addProperty("use_linked_tender", "" + this.useLinkedTender.getElement().isChecked());
        }
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_FACT_SHEET;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProduct.getChildNamed(ProductCatalogLight_.title).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        if (this.includeHandlingCostInProductGrossPrice != null) {
            this.includeHandlingCostInProductGrossPrice.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        if (this.includeCosts != null) {
            this.includeCosts.kill();
        }
        for (CostOption o : this.optionsList) {
            o.kill();
        }
        if (this.sep2 != null) {
            this.sep2.kill();
        }
        if (this.includeAllergens != null) {
            this.includeAllergens.kill();
        }
        if (this.includeAdditives != null) {
            this.includeAdditives.kill();
        }
        if (this.includeOthers != null) {
            this.includeOthers.kill();
        }
        if (this.includeTraces != null) {
            this.includeTraces.kill();
        }
        if (this.includePurchaseWaste != null) {
            this.includePurchaseWaste.kill();
        }
        if (this.includeCookingWaste != null) {
            this.includeCookingWaste.kill();
        }
        if (this.includeImage != null) {
            this.includeImage.kill();
        }
        if (this.includeComponentComments != null) {
            this.includeComponentComments.kill();
        }
        if (this.includeGrossQuantity != null) {
            this.includeGrossQuantity.kill();
        }
        if (this.includeProductComments != null) {
            this.includeProductComments.kill();
        }
        if (this.useTenderData != null) {
            this.useTenderData.kill();
        }
        if (this.useLinkedTender != null) {
            this.useLinkedTender.kill();
        }
        this.useLinkedTender = null;
        this.printOptionTitle = null;
        this.dueDate = null;
        this.sep1 = null;
        this.includeCosts = null;
        this.optionsList.clear();
        this.sep2 = null;
        this.includeAllergens = null;
        this.includeAdditives = null;
        this.includeTraces = null;
        this.includeOthers = null;
        this.includeImage = null;
        this.includePurchaseWaste = null;
        this.includeHandlingCostInProductGrossPrice = null;
        this.includeCookingWaste = null;
        this.includeGrossQuantity = null;
        this.includeComponentComments = null;
        this.includeProductComments = null;
        this.useTenderData = null;
        this.processCostOption = null;
        this.groupProcessCostOption = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(true);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(true);
        }
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.includeCosts != null) {
            this.includeCosts.setVisible(true);
        }
        for (CostOption o : this.optionsList) {
            o.setVisible(true);
        }
        if (this.includeHandlingCostInProductGrossPrice != null) {
            this.includeHandlingCostInProductGrossPrice.setVisible(true);
        }
        if (this.sep2 != null) {
            this.sep2.setVisible(true);
        }
        if (this.extrasTitle != null) {
            this.extrasTitle.setVisible(true);
        }
        if (this.includeAllergens != null) {
            this.includeAllergens.setVisible(true);
        }
        if (this.includeAdditives != null) {
            this.includeAdditives.setVisible(true);
        }
        if (this.includeTraces != null) {
            this.includeTraces.setVisible(true);
        }
        if (this.includeOthers != null) {
            this.includeOthers.setVisible(true);
        }
        if (this.includeImage != null) {
            this.includeImage.setVisible(true);
        }
        if (this.includePurchaseWaste != null) {
            this.includePurchaseWaste.setVisible(true);
        }
        if (this.includeCookingWaste != null) {
            this.includeCookingWaste.setVisible(true);
        }
        if (this.includeComponentComments != null) {
            this.includeComponentComments.setVisible(true);
        }
        if (this.includeGrossQuantity != null) {
            this.includeGrossQuantity.setVisible(true);
        }
        if (this.includeProductComments != null) {
            this.includeProductComments.setVisible(true);
        }
        if (this.useTenderData != null) {
            this.useTenderData.setVisible(true);
            this.useLinkedTender.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(false);
        }
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.includeCosts != null) {
            this.includeCosts.setVisible(false);
        }
        for (CostOption o : this.optionsList) {
            o.setVisible(false);
        }
        if (this.includeHandlingCostInProductGrossPrice != null) {
            this.includeHandlingCostInProductGrossPrice.setVisible(false);
        }
        if (this.sep2 != null) {
            this.sep2.setVisible(false);
        }
        if (this.extrasTitle != null) {
            this.extrasTitle.setVisible(false);
        }
        if (this.includeAllergens != null) {
            this.includeAllergens.setVisible(false);
        }
        if (this.includeAdditives != null) {
            this.includeAdditives.setVisible(false);
        }
        if (this.includeTraces != null) {
            this.includeTraces.setVisible(false);
        }
        if (this.includeOthers != null) {
            this.includeOthers.setVisible(false);
        }
        if (this.includeImage != null) {
            this.includeImage.setVisible(false);
        }
        if (this.includePurchaseWaste != null) {
            this.includePurchaseWaste.setVisible(false);
        }
        if (this.includeCookingWaste != null) {
            this.includeCookingWaste.setVisible(false);
        }
        if (this.includeComponentComments != null) {
            this.includeComponentComments.setVisible(false);
        }
        if (this.includeGrossQuantity != null) {
            this.includeGrossQuantity.setVisible(false);
        }
        if (this.includeProductComments != null) {
            this.includeProductComments.setVisible(false);
        }
        if (this.useTenderData != null) {
            this.useTenderData.setVisible(false);
            this.useLinkedTender.setVisible(false);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.includeCosts.getElement()) {
            for (CostOption o : this.optionsList) {
                o.setFirstCheck(this.includeCosts.getElement().isChecked());
                o.setEnabled(this.includeCosts.getElement().isChecked());
            }
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintProductCatalogProductFactSheetComponent.this.getSelectedReport();
                PrintProductCatalogProductFactSheetComponent.this.configNode.commit();
                ProductFactSheetReportConfiguration config = (ProductFactSheetReportConfiguration)PrintProductCatalogProductFactSheetComponent.this.configNode.getValue();
                config.setStylesheet(file);
                if (PrintProductCatalogProductFactSheetComponent.this.showProductionCosts) {
                    config.setIncludeCosts(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.includeCosts.getElement()).isChecked()));
                    config.setIncludeHandlingCostToProductPrice(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.includeHandlingCostInProductGrossPrice.getElement()).isChecked()));
                    if (PrintProductCatalogProductFactSheetComponent.this.useTenderData != null) {
                        config.setUseExternalCosts(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.useTenderData.getElement()).isChecked() && PrintProductCatalogProductFactSheetComponent.this.printExternalCostFactSheet));
                        config.setUseLinkedTender(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.useLinkedTender.getElement()).isChecked() && PrintProductCatalogProductFactSheetComponent.this.printExternalCostFactSheet));
                    } else {
                        config.setUseExternalCosts(Boolean.valueOf(false));
                        config.setUseLinkedTender(Boolean.valueOf(false));
                    }
                } else {
                    config.setIncludeCosts(Boolean.valueOf(false));
                    config.setBruttoPrice(Boolean.valueOf(false));
                    config.setCalculatedSalesPrice(Boolean.valueOf(false));
                    config.setFixedSalesPrice(Boolean.valueOf(false));
                    config.setMaterialCost(Boolean.valueOf(false));
                    config.setHandlingCost(Boolean.valueOf(false));
                    config.setHandlingCostDetails(Boolean.valueOf(false));
                    config.setMaterialCostDetails(Boolean.valueOf(false));
                    config.setNettoCost(Boolean.valueOf(false));
                    config.setProductProcessCost(Boolean.valueOf(false));
                    config.setProductProcessCostDetails(Boolean.valueOf(false));
                    config.setGroupProcessCost(Boolean.valueOf(false));
                    config.setGroupProcessCostDetails(Boolean.valueOf(false));
                    config.setTaxCost(Boolean.valueOf(false));
                    config.setTaxCostDetails(Boolean.valueOf(false));
                }
                config.setIncludeImage(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.includeImage.getElement()).isChecked()));
                config.setAllergens(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.includeAllergens.getElement()).isChecked()));
                config.setAdditives(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.includeAdditives.getElement()).isChecked()));
                config.setOthers(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.includeOthers.getElement()).isChecked()));
                config.setTraces(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.includeTraces.getElement()).isChecked()));
                config.setIncludePurchaseWaste(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.includePurchaseWaste.getElement()).isChecked()));
                config.setIncludeCookingWaste(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.includeCookingWaste.getElement()).isChecked()));
                config.setIncludeComponentComments(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.includeComponentComments.getElement()).isChecked()));
                config.setIncludeBruttoQuantity(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.includeGrossQuantity.getElement()).isChecked()));
                config.setIncludeProductComments(Boolean.valueOf(((CheckBox)PrintProductCatalogProductFactSheetComponent.this.includeProductComments.getElement()).isChecked()));
                ProductCatalogLight cat = (ProductCatalogLight)PrintProductCatalogProductFactSheetComponent.this.currentProduct.getValue();
                if (!PrintProductCatalogProductFactSheetComponent.this.processCostOption.isChecked()) {
                    config.setGroupProcessCost(Boolean.valueOf(false));
                    config.setGroupProcessCostDetails(Boolean.valueOf(false));
                }
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getProductCatalogProductFactSheets(new ProductCatalogReference(cat.getId()), config).getValue();
                PrintProductCatalogProductFactSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductCatalogProductFactSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ProductCatalogLight> getCurrentNode() {
        return this.currentProduct;
    }

    @Override
    public BatchJob<ProductCatalogLight> createBatchJob(Node<ProductCatalogLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class CostOption
    extends JPanelFadable
    implements Focusable,
    ButtonListener {
        private static final long serialVersionUID = 1L;
        private TitledItem<CheckBox> firstItem;
        private ArrowConnectorIcon connector;
        private TitledItem<CheckBox> secondItem;

        public CostOption(String name1, String name2, Node first, Node second, Color fG, Font cF, int innerGap) {
            this.setOpaque(false);
            this.firstItem = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)first), name1, TitledItem.TitledItemOrientation.EAST);
            this.firstItem.setInnerGap(innerGap);
            this.firstItem.getTitle().setFont(cF);
            this.firstItem.getTitle().setForeground(fG);
            this.firstItem.getElement().addButtonListener(this);
            if (name2 != null) {
                this.connector = new ArrowConnectorIcon();
                this.secondItem = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)second), name2, TitledItem.TitledItemOrientation.EAST);
                this.secondItem.setInnerGap(innerGap);
                this.secondItem.getTitle().setFont(cF);
                this.secondItem.getTitle().setForeground(fG);
                this.secondItem.getElement().addButtonListener(this);
            }
            this.setLayout(new InnerLayout());
            this.add(this.firstItem);
            if (name2 != null) {
                this.add(this.secondItem);
                this.add(this.connector);
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.firstItem.setEnabled(isEnabled);
            if (this.secondItem != null) {
                this.secondItem.setEnabled(isEnabled);
            }
        }

        protected void checkIt() {
            this.firstItem.getElement().setChecked(true);
            if (this.secondItem != null) {
                this.secondItem.setEnabled(true);
            }
        }

        protected void uncheckIt() {
            this.firstItem.getElement().setChecked(false);
            if (this.secondItem != null) {
                this.secondItem.getElement().setChecked(false);
                this.secondItem.setEnabled(false);
            }
        }

        protected boolean isChecked() {
            return this.firstItem.getElement().isChecked();
        }

        protected boolean isDetailsChecked() {
            if (this.secondItem != null) {
                return this.secondItem.getElement().isChecked();
            }
            return false;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.firstItem.kill();
            this.firstItem = null;
            if (this.connector != null) {
                this.connector.kill();
            }
            this.connector = null;
            if (this.secondItem != null) {
                this.secondItem.kill();
            }
            this.secondItem = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.firstItem);
            CheckedListAdder.addToList(focusList, this.secondItem);
            return focusList;
        }

        @Override
        public Selectable getSelectDelegationComponent() {
            return null;
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            PrintProductCatalogProductFactSheetComponent.this.setEnabled(PrintProductCatalogProductFactSheetComponent.this.isEnabled());
            if (source == this.firstItem.getElement()) {
                this.validateSecond();
            } else if (source == this.secondItem.getElement() && this.secondItem.getElement().isChecked()) {
                this.firstItem.getElement().setChecked(true);
            }
        }

        @Override
        public void requestFocusInWindowNow() {
            this.firstItem.requestFocusInWindowNow();
        }

        public void setFirstCheck(boolean checked) {
            this.firstItem.getElement().setChecked(checked);
            this.validateSecond();
        }

        private void validateSecond() {
            if (this.secondItem != null) {
                this.secondItem.setEnabled(this.firstItem.getElement().isChecked());
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int innerGap = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_inner_horizontal_border"));
                CostOption.this.firstItem.setLocation(0, (int)(((double)parent.getHeight() - CostOption.this.firstItem.getPreferredSize().getHeight()) / 2.0));
                CostOption.this.firstItem.setSize(CostOption.this.firstItem.getPreferredSize());
                int cx = (parent.getWidth() - ArrowConnectorIcon.getPreferredWidth()) / 2;
                if (CostOption.this.connector != null) {
                    CostOption.this.connector.setLocation(cx, (int)(((double)parent.getHeight() - CostOption.this.connector.getPreferredSize().getHeight()) / 2.0));
                    CostOption.this.connector.setSize(CostOption.this.connector.getPreferredSize());
                    CostOption.this.secondItem.setLocation(CostOption.this.connector.getX() + CostOption.this.connector.getWidth() + 20, (int)(((double)parent.getHeight() - CostOption.this.secondItem.getPreferredSize().getHeight()) / 2.0));
                    CostOption.this.secondItem.setSize(CostOption.this.secondItem.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int h = (int)(CostOption.this.firstItem.getPreferredSize().getHeight() + 2.0);
                return new Dimension(0, h);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintProductCatalogProductFactSheetComponent.this.layoutInheritedComponents(parent);
            if (PrintProductCatalogProductFactSheetComponent.this.dueDate != null) {
                PrintProductCatalogProductFactSheetComponent.this.dueDate.setLocation(PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.dueDate.setSize(parent.getWidth() - 2 * PrintProductCatalogProductFactSheetComponent.this.border, (int)PrintProductCatalogProductFactSheetComponent.this.dueDate.getPreferredSize().getHeight());
                y = PrintProductCatalogProductFactSheetComponent.this.dueDate.getY() + PrintProductCatalogProductFactSheetComponent.this.dueDate.getHeight();
            }
            if (PrintProductCatalogProductFactSheetComponent.this.sep1 != null) {
                PrintProductCatalogProductFactSheetComponent.this.sep1.setLocation(0, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.sep1.setSize(parent.getWidth(), (int)PrintProductCatalogProductFactSheetComponent.this.sep1.getPreferredSize().getHeight());
                y = PrintProductCatalogProductFactSheetComponent.this.sep1.getY() + PrintProductCatalogProductFactSheetComponent.this.sep1.getHeight();
            }
            if (PrintProductCatalogProductFactSheetComponent.this.printOptionTitle != null) {
                PrintProductCatalogProductFactSheetComponent.this.printOptionTitle.setLocation(PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border);
                PrintProductCatalogProductFactSheetComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * PrintProductCatalogProductFactSheetComponent.this.border, (int)PrintProductCatalogProductFactSheetComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = PrintProductCatalogProductFactSheetComponent.this.printOptionTitle.getY() + PrintProductCatalogProductFactSheetComponent.this.printOptionTitle.getHeight();
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeCosts != null) {
                PrintProductCatalogProductFactSheetComponent.this.includeCosts.setLocation(PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.includeCosts.setSize(parent.getWidth() - 2 * PrintProductCatalogProductFactSheetComponent.this.border, (int)PrintProductCatalogProductFactSheetComponent.this.includeCosts.getPreferredSize().getHeight());
                y = PrintProductCatalogProductFactSheetComponent.this.includeCosts.getY() + PrintProductCatalogProductFactSheetComponent.this.includeCosts.getHeight();
            }
            for (CostOption o : PrintProductCatalogProductFactSheetComponent.this.optionsList) {
                o.setLocation(PrintProductCatalogProductFactSheetComponent.this.border * 2, y + PrintProductCatalogProductFactSheetComponent.this.border / 3);
                o.setSize(parent.getWidth() - 3 * PrintProductCatalogProductFactSheetComponent.this.border, (int)o.getPreferredSize().getHeight());
                y = o.getY() + o.getHeight();
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeHandlingCostInProductGrossPrice != null) {
                PrintProductCatalogProductFactSheetComponent.this.includeHandlingCostInProductGrossPrice.setLocation(PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.includeHandlingCostInProductGrossPrice.setSize(parent.getWidth() - 2 * PrintProductCatalogProductFactSheetComponent.this.border, (int)PrintProductCatalogProductFactSheetComponent.this.includeHandlingCostInProductGrossPrice.getPreferredSize().getHeight());
                y = PrintProductCatalogProductFactSheetComponent.this.includeHandlingCostInProductGrossPrice.getY() + PrintProductCatalogProductFactSheetComponent.this.includeHandlingCostInProductGrossPrice.getHeight();
            }
            if (PrintProductCatalogProductFactSheetComponent.this.sep2 != null) {
                PrintProductCatalogProductFactSheetComponent.this.sep2.setLocation(0, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.sep2.setSize(parent.getWidth(), (int)PrintProductCatalogProductFactSheetComponent.this.sep2.getPreferredSize().getHeight());
                y = PrintProductCatalogProductFactSheetComponent.this.sep2.getY() + PrintProductCatalogProductFactSheetComponent.this.sep2.getHeight();
            }
            if (PrintProductCatalogProductFactSheetComponent.this.extrasTitle != null) {
                PrintProductCatalogProductFactSheetComponent.this.extrasTitle.setLocation(PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border);
                PrintProductCatalogProductFactSheetComponent.this.extrasTitle.setSize(parent.getWidth() - 2 * PrintProductCatalogProductFactSheetComponent.this.border, (int)PrintProductCatalogProductFactSheetComponent.this.extrasTitle.getPreferredSize().getHeight());
                y = PrintProductCatalogProductFactSheetComponent.this.extrasTitle.getY() + PrintProductCatalogProductFactSheetComponent.this.extrasTitle.getHeight();
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeAllergens != null) {
                PrintProductCatalogProductFactSheetComponent.this.includeAllergens.setLocation(PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.includeAllergens.setSize((parent.getWidth() - 3 * PrintProductCatalogProductFactSheetComponent.this.border) / 2, (int)PrintProductCatalogProductFactSheetComponent.this.includeAllergens.getPreferredSize().getHeight());
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeAdditives != null) {
                PrintProductCatalogProductFactSheetComponent.this.includeAdditives.setLocation((parent.getWidth() - PrintProductCatalogProductFactSheetComponent.this.border) / 2 + PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.includeAdditives.setSize((parent.getWidth() - 3 * PrintProductCatalogProductFactSheetComponent.this.border) / 2, (int)PrintProductCatalogProductFactSheetComponent.this.includeAdditives.getPreferredSize().getHeight());
                y = PrintProductCatalogProductFactSheetComponent.this.includeAdditives.getY() + PrintProductCatalogProductFactSheetComponent.this.includeAdditives.getHeight();
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeTraces != null) {
                PrintProductCatalogProductFactSheetComponent.this.includeTraces.setLocation(PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.includeTraces.setSize((parent.getWidth() - 3 * PrintProductCatalogProductFactSheetComponent.this.border) / 2, (int)PrintProductCatalogProductFactSheetComponent.this.includeTraces.getPreferredSize().getHeight());
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeOthers != null) {
                PrintProductCatalogProductFactSheetComponent.this.includeOthers.setLocation((parent.getWidth() - PrintProductCatalogProductFactSheetComponent.this.border) / 2 + PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.includeOthers.setSize((parent.getWidth() - 3 * PrintProductCatalogProductFactSheetComponent.this.border) / 2, (int)PrintProductCatalogProductFactSheetComponent.this.includeOthers.getPreferredSize().getHeight());
                y = PrintProductCatalogProductFactSheetComponent.this.includeOthers.getY() + PrintProductCatalogProductFactSheetComponent.this.includeOthers.getHeight();
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includePurchaseWaste != null) {
                PrintProductCatalogProductFactSheetComponent.this.includePurchaseWaste.setLocation(PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.includePurchaseWaste.setSize((parent.getWidth() - 3 * PrintProductCatalogProductFactSheetComponent.this.border) / 2, (int)PrintProductCatalogProductFactSheetComponent.this.includePurchaseWaste.getPreferredSize().getHeight());
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeCookingWaste != null) {
                PrintProductCatalogProductFactSheetComponent.this.includeCookingWaste.setLocation((parent.getWidth() - PrintProductCatalogProductFactSheetComponent.this.border) / 2 + PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.includeCookingWaste.setSize((parent.getWidth() - 3 * PrintProductCatalogProductFactSheetComponent.this.border) / 2, (int)PrintProductCatalogProductFactSheetComponent.this.includeCookingWaste.getPreferredSize().getHeight());
                y = PrintProductCatalogProductFactSheetComponent.this.includeCookingWaste.getY() + PrintProductCatalogProductFactSheetComponent.this.includeCookingWaste.getHeight();
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeComponentComments != null) {
                PrintProductCatalogProductFactSheetComponent.this.includeComponentComments.setLocation(PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.includeComponentComments.setSize((parent.getWidth() - 3 * PrintProductCatalogProductFactSheetComponent.this.border) / 2, (int)PrintProductCatalogProductFactSheetComponent.this.includeComponentComments.getPreferredSize().getHeight());
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeProductComments != null) {
                PrintProductCatalogProductFactSheetComponent.this.includeProductComments.setLocation((parent.getWidth() - PrintProductCatalogProductFactSheetComponent.this.border) / 2 + PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.includeProductComments.setSize((parent.getWidth() - 3 * PrintProductCatalogProductFactSheetComponent.this.border) / 2, (int)PrintProductCatalogProductFactSheetComponent.this.includeProductComments.getPreferredSize().getHeight());
                y = PrintProductCatalogProductFactSheetComponent.this.includeProductComments.getY() + PrintProductCatalogProductFactSheetComponent.this.includeProductComments.getHeight();
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeGrossQuantity != null) {
                PrintProductCatalogProductFactSheetComponent.this.includeGrossQuantity.setLocation(PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.includeGrossQuantity.setSize((parent.getWidth() - 3 * PrintProductCatalogProductFactSheetComponent.this.border) / 2, (int)PrintProductCatalogProductFactSheetComponent.this.includeGrossQuantity.getPreferredSize().getHeight());
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeImage != null) {
                PrintProductCatalogProductFactSheetComponent.this.includeImage.setLocation((parent.getWidth() - PrintProductCatalogProductFactSheetComponent.this.border) / 2 + PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.includeImage.setSize((parent.getWidth() - 3 * PrintProductCatalogProductFactSheetComponent.this.border) / 2, (int)PrintProductCatalogProductFactSheetComponent.this.includeImage.getPreferredSize().getHeight());
                y = PrintProductCatalogProductFactSheetComponent.this.includeImage.getY() + PrintProductCatalogProductFactSheetComponent.this.includeImage.getHeight();
            }
            if (PrintProductCatalogProductFactSheetComponent.this.useTenderData != null) {
                PrintProductCatalogProductFactSheetComponent.this.useTenderData.setLocation(PrintProductCatalogProductFactSheetComponent.this.border, y + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.useTenderData.setSize((parent.getWidth() - 3 * PrintProductCatalogProductFactSheetComponent.this.border) / 2, (int)PrintProductCatalogProductFactSheetComponent.this.useTenderData.getPreferredSize().getHeight());
                PrintProductCatalogProductFactSheetComponent.this.useLinkedTender.setLocation(PrintProductCatalogProductFactSheetComponent.this.border * 2, PrintProductCatalogProductFactSheetComponent.this.useTenderData.getY() + PrintProductCatalogProductFactSheetComponent.this.useTenderData.getHeight() + PrintProductCatalogProductFactSheetComponent.this.border / 2);
                PrintProductCatalogProductFactSheetComponent.this.useLinkedTender.setSize(parent.getWidth() - 3 * PrintProductCatalogProductFactSheetComponent.this.border, (int)PrintProductCatalogProductFactSheetComponent.this.useLinkedTender.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductCatalogProductFactSheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintProductCatalogProductFactSheetComponent.this.border;
            if (PrintProductCatalogProductFactSheetComponent.this.dueDate != null) {
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.dueDate.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border / 2;
            }
            if (PrintProductCatalogProductFactSheetComponent.this.sep1 != null) {
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.sep1.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border;
            }
            if (PrintProductCatalogProductFactSheetComponent.this.printOptionTitle != null) {
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border / 2;
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeCosts != null) {
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.includeCosts.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border;
            }
            for (CostOption o : PrintProductCatalogProductFactSheetComponent.this.optionsList) {
                h = (int)((double)h + o.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border / 3;
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeHandlingCostInProductGrossPrice != null) {
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.includeHandlingCostInProductGrossPrice.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border;
            }
            if (PrintProductCatalogProductFactSheetComponent.this.sep2 != null) {
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.sep2.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border;
            }
            if (PrintProductCatalogProductFactSheetComponent.this.extrasTitle != null) {
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.extrasTitle.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border / 2;
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeAllergens != null) {
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.includeAllergens.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border / 2;
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeTraces != null) {
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.includeTraces.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border / 2;
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includePurchaseWaste != null) {
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.includePurchaseWaste.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border / 2;
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeComponentComments != null) {
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.includeComponentComments.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border;
            }
            if (PrintProductCatalogProductFactSheetComponent.this.includeGrossQuantity != null) {
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.includeGrossQuantity.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border;
            }
            if (PrintProductCatalogProductFactSheetComponent.this.useTenderData != null) {
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.useTenderData.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border / 2;
                h = (int)((double)h + PrintProductCatalogProductFactSheetComponent.this.useLinkedTender.getPreferredSize().getHeight());
                h += PrintProductCatalogProductFactSheetComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

