/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.purchase.attachdoc;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.DocumentScanPanel;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.DocumentScanToolkit;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.PurchsaeDocumentScanPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanTypeE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReceivingGroupComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.List;

public class AttachDocumentScanComponent
extends DefaultScrollablePrintPopup2<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private DocumentScanPanel documentPanel;
    private Node<PurchaseOrderLight> currentNode;

    public AttachDocumentScanComponent(Node<PurchaseOrderLight> currentNode) {
        super(false, false, false, false, ReportTypeE.PURCHASE_ORDER);
        this.currentNode = currentNode;
        this.loadBeforeShowing(() -> {
            PurchaseOrderLight orderLight = (PurchaseOrderLight)currentNode.getValue();
            try {
                OptionalWrapper complete = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrder(new PurchaseOrderReference(orderLight.getId()));
                currentNode.removeExistingValues();
                currentNode.setValue((Object)complete.getValue(), 0L);
                currentNode.updateNode();
            }
            catch (ClientServerCallException e) {
                throw new IllegalStateException(e.getMessage());
            }
        });
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            if (!n.equals("costs")) continue;
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public String getTitleString() {
        return Words.ATTACH_DOCUMENT_SCAN;
    }

    @Override
    public String getTitleValue() {
        if (this.currentNode == null || this.currentNode.getChildNamed(PurchaseOrderLight_.number) == null || this.currentNode.getChildNamed(PurchaseOrderLight_.number).getValue() == null) {
            return "";
        }
        return "" + this.currentNode.getChildNamed(PurchaseOrderLight_.number).getValue();
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.documentPanel != null) {
            this.documentPanel.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.documentPanel != null) {
            this.documentPanel.setVisible(false);
        }
    }

    @Override
    public void createComponents() {
        super.createComponents();
        this.getViewContainer().setLayout(new Layout());
        this.documentPanel = new PurchsaeDocumentScanPanel((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue(), DocumentScanTypeE.PURCHASE_ORDER);
        this.documentPanel.setOrderNode(this.currentNode);
        this.getViewContainer().add(this.documentPanel);
        this.validate();
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = super.getFocusComponents();
        return a;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.documentPanel != null) {
            this.documentPanel.kill();
        }
        this.documentPanel = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseOrderLight order = (PurchaseOrderLight)AttachDocumentScanComponent.this.currentNode.getValue(PurchaseOrderLight.class);
                OptionalWrapper orderComplete = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrder(new PurchaseOrderReference(order.getId()));
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                Node<DocumentScanComplete> document = AttachDocumentScanComponent.this.documentPanel.getDocument();
                DocumentScanComplete doc = (DocumentScanComplete)document.getValue();
                if (doc != null && doc.getFileData() != null && doc.getFileData().getId() == null) {
                    try {
                        doc.setDescription("Purchase " + order.getNumber());
                        File localFile = doc.getFileData().getLocalFile();
                        PegasusFileComplete uploadedFile = FileTransferUtil.upload((PegasusFileComplete)doc.getFileData(), (FileTransferListener[])new FileTransferListener[0]);
                        doc.setFileData(uploadedFile);
                        doc.setCreationUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                        String rawTextFromPDF = DocumentScanToolkit.readRawTextFromPDF(localFile);
                        doc.setContentAsText(rawTextFromPDF);
                        boolean foundScan = false;
                        for (PurchaseOrderReceivingGroupComplete checkinGroup : ((PurchaseOrderComplete)orderComplete.getValue()).getCheckinGroups()) {
                            if (!Boolean.TRUE.equals(checkinGroup.getMobileGeneratedGroup()) || foundScan || checkinGroup.getDocumentScan() != null) continue;
                            checkinGroup.setDocumentScan(doc);
                        }
                        String fileName = "Purchase-" + order.getNumber();
                        DocumentScanToolkit.moveScannedFile(settings, localFile, order.getOrderDate(), fileName);
                    }
                    catch (Exception e1) {
                        InnerPopupFactory.showErrorDialog("Something went wrong with the PDF file (order should be saved correctly): " + e1.getMessage(), (Component)AttachDocumentScanComponent.this);
                    }
                }
                ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).updatePurchaseOrder((PurchaseOrderComplete)orderComplete.getValue());
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return AttachDocumentScanComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<PurchaseOrderLight> getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public BatchJob<PurchaseOrderLight> createBatchJob(Node<PurchaseOrderLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void insertElements() {
        this.createComponents();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = AttachDocumentScanComponent.this.layoutInheritedComponents(parent);
            if (AttachDocumentScanComponent.this.documentPanel != null) {
                AttachDocumentScanComponent.this.documentPanel.setLocation(0, y + AttachDocumentScanComponent.this.border);
                AttachDocumentScanComponent.this.documentPanel.setSize(parent.getWidth(), parent.getHeight() - (y + 2 * AttachDocumentScanComponent.this.border));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (AttachDocumentScanComponent.this.animation != null) {
                return AttachDocumentScanComponent.this.animation.getPreferredSize();
            }
            int h = AttachDocumentScanComponent.this.getInheritedComponentsHeight();
            h += AttachDocumentScanComponent.this.border;
            h += 200;
            return new Dimension(100, h += AttachDocumentScanComponent.this.border);
        }
    }
}

