/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.retail.transaction;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.SearchReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.report.StockTransactionSearchReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration_;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;

public class PrintRetailTransactionsComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<StockTransactionSearchReportConfiguration> configNode;
    private TitledItem<ComboBox> bonded;
    private TitledItem<CheckBox> groupTransactions;
    private TitledItem<CheckBox> includeIrregularity;
    private TitledItem<CheckBox> includeCustomerData;
    private Node<FlightLight> flightNode;
    private TitledItem<ComboBox> inout;

    public PrintRetailTransactionsComponent(Node<FlightLight> node) {
        super(true, false, false, true, ReportTypeE.STOCK_TRANSACTION);
        this.flightNode = node;
        StockTransactionSearchReportConfiguration config = new StockTransactionSearchReportConfiguration(ReportTypeE.STOCK_TRANSACTION, ReportingOutputFormatE.PDF, null);
        config.setSearchConfig((ADtoSearchConfiguration)new StockTransactionSearchConfiguration());
        ((StockTransactionSearchConfiguration)config.getSearchConfig()).setFlight(new FlightReference(((FlightLight)node.getValue()).getId()));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String string = s[1];
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("bonded", "" + this.bonded.getElement().getSelectedItem().toString());
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.bonded = new TitledItem<ComboBox>(new ComboBox(this.configNode.getChildNamed(new DtoField[]{SearchReportConfiguration_.searchConfig, StockTransactionSearchConfiguration_.bonded}), NodeToolkit.getAffixList(BondedStateE.class), ConverterRegistry.getConverter(BondedStateEConverter.class)), "Bonded only", TitledItem.TitledItemOrientation.NORTH);
        this.bonded.getTitle().setFont(f);
        this.bonded.getTitle().setForeground(fb);
        this.inout = new TitledItem<ComboBox>(new ComboBox(), Words.RECEIPT_OUTGOING, TitledItem.TitledItemOrientation.NORTH);
        this.inout.getElement().addItem(IN_OUT.BOTH);
        this.inout.getElement().addItem(IN_OUT.IN);
        this.inout.getElement().addItem(IN_OUT.OUT);
        this.inout.getTitle().setFont(f);
        this.inout.getTitle().setForeground(fb);
        this.groupTransactions = new TitledItem<CheckBox>(new CheckBox(), Words.GROUP_TRANSACTIONS, TitledItem.TitledItemOrientation.EAST);
        this.includeIrregularity = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_IRREGULARITY, TitledItem.TitledItemOrientation.EAST);
        this.includeCustomerData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CUSTOMER_DATA, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.bonded);
        this.getViewContainer().add(this.inout);
        this.getViewContainer().add(this.groupTransactions);
        this.getViewContainer().add(this.includeIrregularity);
        this.getViewContainer().add(this.includeCustomerData);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.bonded != null) {
            this.bonded.setEnabled(isEnabled);
            this.inout.setEnabled(isEnabled);
        }
        boolean b = isEnabled;
        if (this.asXLS != null) {
            boolean bl = b = b && ((RadioButton)this.asXLS.getElement()).isChecked();
        }
        if (this.includeIrregularity != null) {
            this.includeIrregularity.setEnabled(b);
        }
        if (this.groupTransactions != null) {
            this.groupTransactions.setEnabled(!b);
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.setEnabled(b);
        }
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT_TRANSACTIONS;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.bonded != null && this.bonded.isInnerComponent(c)) {
            return true;
        }
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleValue() {
        return "" + ((FlightLight)this.flightNode.getValue()).getTrackingNumber();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.bonded != null) {
            this.bonded.kill();
        }
        if (this.inout != null) {
            this.inout.kill();
        }
        if (this.groupTransactions != null) {
            this.groupTransactions.kill();
        }
        if (this.includeIrregularity != null) {
            this.includeIrregularity.kill();
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.kill();
        }
        this.bonded = null;
        this.inout = null;
        this.groupTransactions = null;
        this.includeIrregularity = null;
        this.includeCustomerData = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.bonded != null) {
            this.bonded.setVisible(true);
        }
        if (this.inout != null) {
            this.inout.setVisible(true);
        }
        if (this.groupTransactions != null) {
            this.groupTransactions.setVisible(true);
        }
        if (this.includeIrregularity != null) {
            this.includeIrregularity.setVisible(true);
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.bonded != null) {
            this.bonded.setVisible(false);
        }
        if (this.inout != null) {
            this.inout.setVisible(false);
        }
        if (this.groupTransactions != null) {
            this.groupTransactions.setVisible(false);
        }
        if (this.includeIrregularity != null) {
            this.includeIrregularity.setVisible(false);
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintRetailTransactionsComponent.this.getSelectedReport();
                PrintRetailTransactionsComponent.this.configNode.commit();
                StockTransactionSearchReportConfiguration config = (StockTransactionSearchReportConfiguration)PrintRetailTransactionsComponent.this.configNode.getValue();
                config.setStylesheet(file);
                if (((RadioButton)PrintRetailTransactionsComponent.this.asPDF.getElement()).isChecked()) {
                    config.setFormat(ReportingOutputFormatE.PDF);
                } else {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                }
                if (PrintRetailTransactionsComponent.this.inout != null) {
                    if (((ComboBox)PrintRetailTransactionsComponent.this.inout.getElement()).getSelectedItem() == IN_OUT.IN) {
                        ((StockTransactionSearchConfiguration)config.getSearchConfig()).setCheckinOnly(Boolean.valueOf(true));
                    } else if (((ComboBox)PrintRetailTransactionsComponent.this.inout.getElement()).getSelectedItem() == IN_OUT.OUT) {
                        ((StockTransactionSearchConfiguration)config.getSearchConfig()).setCheckinOnly(Boolean.valueOf(false));
                    } else {
                        ((StockTransactionSearchConfiguration)config.getSearchConfig()).setCheckinOnly(null);
                    }
                }
                if (PrintRetailTransactionsComponent.this.bonded != null) {
                    ((StockTransactionSearchConfiguration)config.getSearchConfig()).setBonded((BondedStateE)((Node)((ComboBox)PrintRetailTransactionsComponent.this.bonded.getElement()).getSelectedItem()).getValue());
                }
                if (PrintRetailTransactionsComponent.this.groupTransactions != null) {
                    config.setGroupByType(Boolean.valueOf(((CheckBox)PrintRetailTransactionsComponent.this.groupTransactions.getElement()).isChecked()));
                }
                if (PrintRetailTransactionsComponent.this.includeIrregularity != null) {
                    config.setIncludeIrregularity(Boolean.valueOf(((CheckBox)PrintRetailTransactionsComponent.this.includeIrregularity.getElement()).isChecked()));
                }
                if (PrintRetailTransactionsComponent.this.includeCustomerData != null) {
                    config.setIncludeCustomerData(Boolean.valueOf(((CheckBox)PrintRetailTransactionsComponent.this.includeCustomerData.getElement()).isChecked()));
                }
                PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createFlightTransactionReport(config).getValue();
                PrintRetailTransactionsComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintRetailTransactionsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.flightNode;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintRetailTransactionsComponent.this.layoutInheritedComponents(parent) + PrintRetailTransactionsComponent.this.border;
            if (PrintRetailTransactionsComponent.this.bonded != null) {
                PrintRetailTransactionsComponent.this.bonded.setLocation(PrintRetailTransactionsComponent.this.border, y + PrintRetailTransactionsComponent.this.border / 2);
                PrintRetailTransactionsComponent.this.bonded.setSize(parent.getWidth() - 2 * PrintRetailTransactionsComponent.this.border, (int)PrintRetailTransactionsComponent.this.bonded.getPreferredSize().getHeight());
                PrintRetailTransactionsComponent.this.inout.setLocation(PrintRetailTransactionsComponent.this.border, PrintRetailTransactionsComponent.this.bonded.getY() + PrintRetailTransactionsComponent.this.bonded.getHeight() + PrintRetailTransactionsComponent.this.border / 2);
                PrintRetailTransactionsComponent.this.inout.setSize(parent.getWidth() - 2 * PrintRetailTransactionsComponent.this.border, (int)PrintRetailTransactionsComponent.this.inout.getPreferredSize().getHeight());
                PrintRetailTransactionsComponent.this.groupTransactions.setLocation(PrintRetailTransactionsComponent.this.border, PrintRetailTransactionsComponent.this.inout.getY() + PrintRetailTransactionsComponent.this.inout.getHeight() + PrintRetailTransactionsComponent.this.border / 2);
                PrintRetailTransactionsComponent.this.groupTransactions.setSize(parent.getWidth() - 2 * PrintRetailTransactionsComponent.this.border, (int)PrintRetailTransactionsComponent.this.groupTransactions.getPreferredSize().getHeight());
                PrintRetailTransactionsComponent.this.includeIrregularity.setLocation(PrintRetailTransactionsComponent.this.border, PrintRetailTransactionsComponent.this.groupTransactions.getY() + PrintRetailTransactionsComponent.this.groupTransactions.getHeight() + PrintRetailTransactionsComponent.this.border / 2);
                PrintRetailTransactionsComponent.this.includeIrregularity.setSize(parent.getWidth() - 2 * PrintRetailTransactionsComponent.this.border, (int)PrintRetailTransactionsComponent.this.includeIrregularity.getPreferredSize().getHeight());
                PrintRetailTransactionsComponent.this.includeCustomerData.setLocation(PrintRetailTransactionsComponent.this.border, PrintRetailTransactionsComponent.this.includeIrregularity.getY() + PrintRetailTransactionsComponent.this.includeIrregularity.getHeight() + PrintRetailTransactionsComponent.this.border / 2);
                PrintRetailTransactionsComponent.this.includeCustomerData.setSize(parent.getWidth() - 2 * PrintRetailTransactionsComponent.this.border, (int)PrintRetailTransactionsComponent.this.includeCustomerData.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintRetailTransactionsComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (PrintRetailTransactionsComponent.this.bonded != null) {
                h = (int)((double)h + PrintRetailTransactionsComponent.this.bonded.getPreferredSize().getHeight());
                h += PrintRetailTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintRetailTransactionsComponent.this.inout.getPreferredSize().getHeight());
                h += PrintRetailTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintRetailTransactionsComponent.this.groupTransactions.getPreferredSize().getHeight());
                h += PrintRetailTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintRetailTransactionsComponent.this.includeIrregularity.getPreferredSize().getHeight());
                h += PrintRetailTransactionsComponent.this.border / 2;
                h = (int)((double)h + PrintRetailTransactionsComponent.this.includeCustomerData.getPreferredSize().getHeight());
                h += PrintRetailTransactionsComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }

    public static enum IN_OUT {
        IN,
        OUT,
        BOTH;


        public String toString() {
            switch (this) {
                case BOTH: {
                    return Words.BOTH;
                }
                case IN: {
                    return Words.RECEIPT;
                }
                case OUT: {
                    return Words.OUTGOING;
                }
            }
            return "-";
        }
    }
}

