/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.DefaultSubGalleyModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBox;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyGridPanel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GridSpace;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.DragController;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.DragableItem;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItem;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.EquipmentTypeChooser;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.GraphicsUtils;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.TopLevelRepainter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.AircraftToolkit;
import ch.icit.pegasus.client.util.toolkits.LogicToolkit;
import ch.icit.pegasus.client.util.toolkits.MealPlanToolkit;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateComplete;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateDrawerComplete;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateVariantComplete;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.StowagePositionSpecificationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentInsertComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentReservedSpaceComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Color3DComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentInsertTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentSystemComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StowagePositionTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.Triple;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Iterator;

public class ListItemDragController
implements DragController,
LafListener,
InnerPopUpListener2 {
    private final PegasusSubModule pegasus;
    private final Skin9Field shadowSkin;
    private GalleyBox box;
    private GalleyGridPanel gridPanel;
    private ListViewItem item;
    private int minimalGridWidth = -1;
    private int minimalGridHeight = -1;
    private int aDragItemY;
    private int aDragItemX;
    private Node aSYSize;
    private InnerPopUp2 pop;
    private long unDoId;
    private DragItemType type;
    private Node currentNode;

    public ListItemDragController(PegasusSubModule peg, long id) {
        this.pegasus = peg;
        if (this.minimalGridHeight == -1) {
            this.minimalGridHeight = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("gc_minimal_drag_item_height"));
        }
        if (this.minimalGridWidth == -1) {
            this.minimalGridWidth = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("gc_minimal_drag_item_width"));
        }
        this.unDoId = id;
        this.shadowSkin = (Skin9Field)DefaultSkins.ShadowBackground.createDynamicSkin();
        this.lafAttributeChanged("All attribues changed");
    }

    @Override
    public DragableItem getDragItemImage(ListViewItem item) {
        GalleyGridPanel gridPanel = (GalleyGridPanel)this.startDragging((Node<String>)((Node)item.getUserObject(0)));
        DragableItem aDragItem = item.getDragItem();
        if (aDragItem == null) {
            aDragItem = new DragableItem(item);
        } else {
            aDragItem.stopAllAnimations(item);
        }
        if (item.getParentList().getModel().getNode().getName().equals("Inventory")) {
            aDragItem.createImage(item.getCloneImage(this.shadowSkin, this.minimalGridHeight, this.minimalGridWidth));
        } else if (item.getParentList().getModel().getNode().getName().equals("Boxes")) {
            aDragItem.createImage(this.getBoxDragImage((Node)item.getUserObject(0), gridPanel));
        }
        this.pegasus.add((Component)aDragItem, 0);
        aDragItem.setVisible(true);
        return aDragItem;
    }

    @Override
    public void moveItem(double dx, double dy, DragableItem dragItem, ListViewItem item) {
        int dragItemX;
        if (dragItem == null) {
            return;
        }
        int oldx = dragItem.getX();
        int oldy = dragItem.getY();
        Rectangle or = new Rectangle();
        or.setBounds(oldx, oldy, dragItem.getWidth(), dragItem.getHeight());
        dragItem.moveItem(dx, dy);
        Rectangle nr = new Rectangle();
        nr.setBounds(dragItem.getX(), dragItem.getY(), dragItem.getWidth(), dragItem.getHeight());
        if (item.getParentList().getModel().getNode().getName().equals("Inventory")) {
            int dragItemY;
            dragItemX = dragItem.getX() + 5;
            GalleyGridPanel aGridPanel = this.pegasus.getIntersectingGalleyGrid(dragItemX, dragItemY = dragItem.getY() + dragItem.getHeight() / 2);
            if (aGridPanel != null && aGridPanel == this.pegasus.getGalleySubGalley()) {
                Node dragNode;
                this.gridPanel = aGridPanel;
                Rectangle gridRect = aGridPanel.getGridRectangle();
                dragItemX = (int)((double)dragItemX - gridRect.getX());
                dragItemY = (int)((double)dragItemY - gridRect.getY());
                Node n = (Node)item.getUserObject(0);
                Node galleyNode = aGridPanel.getModel().getNode();
                boolean highlighed = false;
                if (n.getValue() instanceof ALoadingGroupComplete) {
                    dragNode = (Node)item.getUserObject(0);
                    if (this.pegasus.getItemInputRule().isInputAllowed(galleyNode, dragNode)) {
                        highlighed = aGridPanel.highlightMaxSpace(dragItemX, dragItemY);
                    }
                } else if (n.getValue() instanceof String && item.getUserObject(1) instanceof Triple) {
                    dragNode = (Node)item.getUserObject(0);
                    if (this.pegasus.getItemInputRule().isInputAllowed(galleyNode, dragNode)) {
                        highlighed = aGridPanel.highlightMaxSpace(dragItemX, dragItemY);
                    }
                }
                if (!highlighed) {
                    GalleyBox box = aGridPanel.getBox4ConcretCoordinates(dragItemX, dragItemY);
                    if (box != null) {
                        if (this.box != null && this.box != box) {
                            this.box.setHighLight(false);
                        }
                        aGridPanel.highlightGrid(-1, -1);
                        this.box = box;
                        if (this.box.getBoxNode().getValue() instanceof GalleyEquipmentReservedSpaceComplete) {
                            if (n.getValue() instanceof ALoadingGroupComplete) {
                                this.box.setHighLight(true);
                            }
                        } else {
                            this.box.setHighLight(true);
                        }
                    } else {
                        if (this.box != null) {
                            this.box.setHighLight(false);
                        }
                        if (this.pegasus.getItemInputRule().isInputAllowed(galleyNode, n)) {
                            Node articleNode = (Node)item.getUserObject(0);
                            Node defaultInsert = articleNode.getChildNamed(new String[]{"currentVariant-defaultInsertType"});
                            double aLx = 0.5;
                            double aLy = 1.0;
                            double aLz = 0.5;
                            Node eqType = aGridPanel.getModel().getNode().getChildNamed(new String[]{"equipmentType"});
                            SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                            GalleyEquipmentInsertTypeComplete insertType = null;
                            if (s.getLooseEquipmentType().equals(eqType.getValue())) {
                                insertType = s.getLooseEquipmentInsertType();
                            } else if (defaultInsert != null && defaultInsert.getValue() != null) {
                                insertType = (GalleyEquipmentInsertTypeComplete)defaultInsert.getValue();
                            }
                            if (insertType != null) {
                                aLx = insertType.getDimension().getDepth();
                                aLy = insertType.getDimension().getHeight();
                                aLz = insertType.getDimension().getDepth();
                            }
                            aGridPanel.setMultiplier(aLx, aLy, aLz);
                            aGridPanel.highlightGrid(dragItemX, dragItemY);
                        }
                    }
                }
            } else {
                if (this.gridPanel != null) {
                    this.gridPanel.highlightGrid(-1, -1);
                    this.gridPanel = null;
                }
                if (this.box != null) {
                    this.box.setHighLight(false);
                }
            }
        } else if (item.getParentList().getModel().getNode().getName().equals("Boxes")) {
            int dragItemY;
            dragItemX = dragItem.getX() + 5;
            GalleyGridPanel aGridPanel = this.pegasus.getIntersectingGalleyGrid(dragItemX, dragItemY = dragItem.getY() + dragItem.getHeight() / 2);
            if (aGridPanel != null) {
                Node dragNode = (Node)item.getUserObject(0);
                Node galleyNode = aGridPanel.getModel().getNode();
                if (this.pegasus.getItemInputRule().isInputAllowed(galleyNode, dragNode)) {
                    Rectangle gridRect = aGridPanel.getGridRectangle();
                    dragItemX = (int)((double)dragItemX - gridRect.getX());
                    dragItemY = (int)((double)dragItemY - gridRect.getY());
                    Node aYSize = null;
                    Node aZSize = null;
                    if (this.pegasus.getCurrentState() == 3) {
                        aYSize = ((Node)item.getUserObject(0)).getChildNamed(new String[]{"size-height"});
                        aZSize = ((Node)item.getUserObject(0)).getChildNamed(new String[]{"size-depth"});
                    } else {
                        aYSize = ((Node)item.getUserObject(0)).getChildNamed(new String[]{"dimension-height"});
                        aZSize = ((Node)item.getUserObject(0)).getChildNamed(new String[]{"dimension-depth"});
                    }
                    if (aGridPanel.isSubGrid()) {
                        aGridPanel.setMultiplier((Double)aZSize.getValue(), (Double)aYSize.getValue(), 0.0);
                    } else if (this.pegasus.getCurrentState() == 3) {
                        Node aXSize = ((Node)item.getUserObject(0)).getChildNamed(new String[]{"size-width"});
                        aGridPanel.setMultiplier((Double)aXSize.getValue(), (Double)aYSize.getValue(), (Double)aZSize.getValue());
                    }
                    if (this.pegasus.getCurrentState() == 7 && !aGridPanel.isSubGrid()) {
                        this.pegasus.highlightGridPanel(null, 0, 0);
                    } else {
                        this.pegasus.highlightGridPanel(aGridPanel, dragItemX, dragItemY);
                    }
                } else {
                    this.pegasus.highlightGridPanel(null, 0, 0);
                }
            } else {
                this.pegasus.highlightGridPanel(null, 0, 0);
            }
        }
        Rectangle nnr = or.union(nr);
        TopLevelRepainter.simpleRepaint(this.pegasus, 32L, nnr);
    }

    @Override
    public Component startDragging(Node<String> node) {
        return this.pegasus.startGalleyBoxDragging(null, null, node);
    }

    @Override
    public void stopDragging() {
        this.pegasus.stopGalleyBoxDragging();
    }

    private BufferedImage getBoxDragImage(Node node, GalleyGridPanel gridPanel) {
        Dimension gridSize = gridPanel.getGridSize();
        gridSize.setSize(gridSize.getWidth() * 2.0 / 3.0, gridSize.getHeight() * 2.0 / 3.0);
        Node aXSize = null;
        Node aYSize = null;
        if (this.pegasus.getCurrentState() == 3) {
            aXSize = node.getChildNamed(new String[]{"size-width"});
            aYSize = node.getChildNamed(new String[]{"size-height"});
        } else {
            aXSize = node.getChildNamed(new String[]{"dimension-width"});
            aYSize = node.getChildNamed(new String[]{"dimension-height"});
        }
        if (gridPanel.isSubGrid()) {
            aXSize = node.getChildNamed(new String[]{"dimension-depth"});
        }
        if (aXSize != null && aYSize != null) {
            int bWidth = this.minimalGridWidth;
            int bHeight = this.minimalGridHeight;
            BufferedImage bi = new BufferedImage(bWidth, bHeight += this.shadowSkin.getImage11(Button.ButtonState.UP).getHeight() + this.shadowSkin.getImage13(Button.ButtonState.UP).getHeight(), 2);
            this.paintBufferedImage(bi.getGraphics(), bi.getWidth(), bi.getHeight(), node);
            return bi;
        }
        return null;
    }

    private void paintBufferedImage(Graphics g, int w, int h, Node node) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.shadowSkin.paint(g2, 0, 0, w, h, Button.ButtonState.UP);
        Node n = node.getChildNamed(new String[]{"displayColor"});
        if (n != null && n.getValue() != null) {
            g2.setColor(new Color(((Color3DComplete)n.getValue()).getRed().floatValue(), ((Color3DComplete)n.getValue()).getGreen().floatValue(), ((Color3DComplete)n.getValue()).getBlue().floatValue()));
        } else {
            g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("defaultitem_drag_color")));
        }
        g2.fillRect(0, 0, w - this.shadowSkin.getImage32(Button.ButtonState.UP).getWidth(), h - this.shadowSkin.getImage23(Button.ButtonState.UP).getHeight());
        g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_box_foreground")));
        g2.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("gc_galley_box_font_type")));
        String paintString = "";
        if (node.getChildNamed(new String[]{"name"}) != null) {
            paintString = (String)node.getChildNamed(new String[]{"name"}).getValue();
        }
        GraphicsUtils.printMaxofString(g2, 10, 17, g2.getFontMetrics(), paintString, w - (10 + this.shadowSkin.getImage32(Button.ButtonState.UP).getWidth() + this.shadowSkin.getImage12(Button.ButtonState.UP).getWidth()));
        g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_box_line_color")));
        g2.drawRect(0, 0, w - this.shadowSkin.getImage32(Button.ButtonState.UP).getWidth() - 1, h - this.shadowSkin.getImage23(Button.ButtonState.UP).getHeight() - 1);
    }

    public ListViewItem getItem() {
        return this.item;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dropItem(ListViewItem item, DragableItem dragItem) {
        if (dragItem == null) {
            return false;
        }
        if (item.getParentList().getModel().getNode().getName().equals("Inventory")) {
            int dragItemY;
            this.item = item;
            int dragItemX = dragItem.getX() + 5;
            GalleyGridPanel aGridPanel = this.pegasus.getIntersectingGalleyGrid(dragItemX, dragItemY = dragItem.getY() + dragItem.getHeight() / 2);
            if (aGridPanel != null && aGridPanel == this.pegasus.getGalleySubGalley()) {
                boolean highed;
                block56: {
                    GridSpace space;
                    Rectangle gridRect = aGridPanel.getGridRectangle();
                    dragItemX = (int)((double)dragItemX - gridRect.getX());
                    dragItemY = (int)((double)dragItemY - gridRect.getY());
                    highed = false;
                    if (((Node)item.getUserObject(0)).getValue() instanceof ALoadingGroupComplete) {
                        space = aGridPanel.getMaxSpace(dragItemX, dragItemY);
                        this.gridPanel = aGridPanel;
                        if (space == null) {
                            highed = false;
                            break block56;
                        } else {
                            highed = true;
                            CabinClassComplete cc = null;
                            Node itemNode = (Node)item.getUserObject(0);
                            if (itemNode.getParent().getParent().getParent().getValue() instanceof CateringServiceComplete) {
                                itemNode = itemNode.getParent().getParent().getParent();
                                cc = ((CateringServiceComplete)itemNode.getValue()).getCabinClass();
                            } else if ((itemNode = itemNode.getParent().getParent().getParent().getParent().getParent()) != null) {
                                if (itemNode.getValue() != null) {
                                    cc = ((CateringServiceScheduleVariantComplete)itemNode.getValue()).getBase().getCabinClass();
                                } else {
                                    Node ab = itemNode.getParent().getChildNamed(new String[]{"containingService"});
                                    if (ab != null && ab.getValue() != null) {
                                        cc = ((CateringServiceScheduleComplete)ab.getValue()).getCabinClass();
                                        ab.getParent().updateNode();
                                    } else {
                                        ab = itemNode.getParent().getChildNamed(new String[]{"loadingGroup-containingService"});
                                        if (ab != null && ab.getValue() != null) {
                                            cc = ((CateringServiceScheduleComplete)ab.getValue()).getCabinClass();
                                            ab.getParent().updateNode();
                                        }
                                    }
                                }
                            }
                            Node aNode = itemNode;
                            this.insertService(cc, dragItemX, dragItemY, aNode, aGridPanel, space, dragItem, DragItemType.SERVICE);
                            return true;
                        }
                    }
                    if (item.getUserObject(1) instanceof Triple) {
                        space = aGridPanel.getMaxSpace(dragItemX, dragItemY);
                        this.gridPanel = aGridPanel;
                        if (space == null) {
                            highed = false;
                        } else {
                            highed = true;
                            CabinClassComplete cc = null;
                            Triple data = (Triple)item.getUserObject(1);
                            cc = data.getT() instanceof CateringServiceComplete ? ((CateringServiceComplete)data.getT()).getCabinClass() : ((CateringServiceScheduleComplete)data.getT()).getCabinClass();
                            String t = (String)((Node)item.getUserObject(0)).getValue();
                            DragItemType dragType = t.contains("SPML") ? DragItemType.SPML_SPACE : DragItemType.ALACARTE_SPACE;
                            this.insertReplacementService(cc, dragItemX, dragItemY, (Triple<MealTypeComplete, Object, String>)data, aGridPanel, space, dragItem, dragType);
                            return true;
                        }
                    }
                }
                if (highed) return false;
                GalleyBox box = aGridPanel.getBox4ConcretCoordinates(dragItemX, dragItemY);
                if (box != null) {
                    if (box.getBoxNode().getValue() instanceof GalleyEquipmentReservedSpaceComplete) {
                        if (((Node)item.getUserObject(0)).getValue() instanceof ALoadingGroupComplete) {
                            CabinClassComplete cc = null;
                            Node itemNode = (Node)item.getUserObject(0);
                            if (itemNode.getParent().getParent().getParent().getValue() instanceof CateringServiceComplete) {
                                itemNode = itemNode.getParent().getParent().getParent();
                                cc = ((CateringServiceComplete)itemNode.getValue()).getCabinClass();
                            } else if ((itemNode = itemNode.getParent().getParent().getParent().getParent().getParent()) != null) {
                                if (itemNode.getValue() != null) {
                                    cc = ((CateringServiceScheduleVariantComplete)itemNode.getValue()).getCabinClass();
                                } else if ((itemNode = itemNode.getParent().getChildNamed(new String[]{"containingService"})) != null && itemNode.getValue() != null) {
                                    cc = ((CateringServiceScheduleVariantComplete)itemNode.getValue()).getCabinClass();
                                    itemNode.getParent().updateNode();
                                }
                            }
                            Node aNode = itemNode;
                            this.insertService(cc, dragItemX, dragItemY, aNode, aGridPanel, box.getBoxNode(), dragItem, DragItemType.ADD_SERVICE_TO_SERVICE);
                            this.box = box;
                            return true;
                        }
                        if (aGridPanel != null) {
                            aGridPanel.highlightGrid(-1, -1);
                        }
                        item.processDraggReturn(false);
                        return false;
                    }
                    this.box = box;
                    DragItemType itemType = null;
                    Node n = (Node)item.getUserObject(0);
                    itemType = n.getValue() instanceof BasicArticleLight ? DragItemType.ARTICLE : (n.getValue() instanceof ProductComplete ? DragItemType.PRODUCT : (n.getValue() instanceof EquipmentTemplateComplete ? DragItemType.EQUIPMENT : DragItemType.ADD_SERVICE_TO_SERVICE));
                    this.pegasus.showProductInsertPopUp(10, dragItem.getHeight() / 2, this, dragItem, itemType, true, box.getBoxNode(), null, item, aGridPanel);
                    return true;
                }
                Node articleNode = (Node)item.getUserObject(0);
                Node defaultInsert = articleNode.getChildNamed(new String[]{"currentVariant-defaultInsertType"});
                Node eqType = aGridPanel.getModel().getNode().getChildNamed(new String[]{"equipmentType"});
                SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                GalleyEquipmentInsertTypeComplete iT = null;
                if (s.getLooseEquipmentType().equals(eqType.getValue())) {
                    iT = s.getLooseEquipmentInsertType();
                } else if (defaultInsert != null && defaultInsert.getValue() != null) {
                    iT = (GalleyEquipmentInsertTypeComplete)defaultInsert.getValue();
                }
                double aLx = 0.5;
                double aLy = 1.0;
                double aLz = 0.5;
                if (iT != null) {
                    aLx = iT.getDimension().getDepth();
                    aLy = iT.getDimension().getHeight();
                    aLz = iT.getDimension().getDepth();
                }
                if (aGridPanel.isEmptyField(dragItemX, dragItemY, aLx, aLy, aLz) == 1) {
                    this.gridPanel = aGridPanel;
                    DragItemType insertType = null;
                    Node n = (Node)item.getUserObject(0);
                    if (n.getValue() instanceof BasicArticleLight) {
                        insertType = DragItemType.ARTICLE;
                    } else if (n.getValue() instanceof ProductComplete) {
                        insertType = DragItemType.PRODUCT;
                    } else if (n.getValue() instanceof EquipmentTemplateComplete) {
                        insertType = DragItemType.EQUIPMENT;
                    }
                    GridSpace space = new GridSpace(aGridPanel.getGrid().getDiscretIndexX(dragItemX, aLz), aGridPanel.getGrid().getDiscretIndexY(dragItemY, aLy), aLz, aLy);
                    this.pegasus.showProductInsertPopUp(10, dragItem.getHeight() / 2, this, dragItem, insertType, false, space, (Node<GalleyEquipmentInsertTypeComplete>)defaultInsert, item, aGridPanel);
                    return false;
                }
                if (aGridPanel != null) {
                    aGridPanel.highlightGrid(-1, -1);
                }
                item.processDraggReturn(false);
                return false;
            }
            if (aGridPanel != null) {
                aGridPanel.highlightGrid(-1, -1);
            }
            item.processDraggReturn(false);
            return false;
        }
        if (!item.getParentList().getModel().getNode().getName().equals("Boxes")) return false;
        int dragItemX = dragItem.getX() + 5;
        int dragItemY = dragItem.getY() + dragItem.getHeight() / 2;
        this.item = item;
        GalleyGridPanel aGridPanel = this.pegasus.getIntersectingGalleyGrid(dragItemX, dragItemY);
        if (aGridPanel != null && aGridPanel.isGridActiv()) {
            Rectangle gridRect = aGridPanel.getGridRectangle();
            dragItemX = (int)((double)dragItemX - gridRect.getX());
            dragItemY = (int)((double)dragItemY - gridRect.getY());
            Node aNYSize = null;
            aNYSize = this.pegasus.getCurrentState() == 3 ? ((Node)item.getUserObject(0)).getChildNamed(new String[]{"size-height"}) : ((Node)item.getUserObject(0)).getChildNamed(new String[]{"dimension-height"});
            double aXSize = 0.0;
            double aYSize = (Double)aNYSize.getValue();
            double aZSize = 0.0;
            if (!aGridPanel.isSubGrid()) {
                Node aNXSize = ((Node)item.getUserObject(0)).getChildNamed(new String[]{"size-width"});
                aXSize = (Double)aNXSize.getValue();
                Node aNZSize = ((Node)item.getUserObject(0)).getChildNamed(new String[]{"size-depth"});
                aZSize = (Double)aNZSize.getValue();
            } else {
                Node aNZSize = ((Node)item.getUserObject(0)).getChildNamed(new String[]{"dimension-depth"});
                aXSize = (Double)aNZSize.getValue();
            }
            Node<GalleyEquipmentInsertComplete> clone = null;
            int res = aGridPanel.isEmptyField(dragItemX, dragItemY, aXSize, aYSize, aZSize);
            if (res > 0) {
                if (this.pegasus.getCurrentState() == 3) {
                    aNYSize = ((Node)item.getUserObject(0)).getChildNamed(new String[]{"size-height"});
                    this.gridPanel = aGridPanel;
                    this.aDragItemY = dragItemY;
                    this.aDragItemX = dragItemX;
                    this.aSYSize = aNYSize;
                    this.pop = InnerPopUp2.getInnerPopUp();
                    this.pop.setAttributes(null, true, true, Words.CREATE_NEW_POSITION);
                    this.pop.setView(new EquipmentTypeChooser((StowagePositionTypeComplete)((Node)item.getUserObject(0)).getValue()));
                    this.pop.showPopUp(5, dragItem.getHeight() / 2, 200, -1, this, dragItem, PopupType.NORMAL);
                    return true;
                }
                Node dragNode = (Node)item.getUserObject(0);
                Node galleyNode = aGridPanel.getModel().getNode();
                if (!this.pegasus.getItemInputRule().isInputAllowed(galleyNode, dragNode)) {
                    if (aGridPanel != null) {
                        aGridPanel.highlightGrid(-1, -1);
                    }
                    item.processDraggReturn(false);
                    return false;
                }
                GalleyBox aBox = aGridPanel.getBox4ConcretCoordinates(dragItemX, dragItemY);
                aNYSize = ((Node)item.getUserObject(0)).getChildNamed(new String[]{"dimension-height"});
                clone = !aGridPanel.isSubGrid() ? LogicToolkit.getNewGalleyEquipmentInsert((Node<GalleyEquipmentInsertTypeComplete>)((Node)item.getUserObject(0)), (Node<GalleyEquipmentComplete>)((DefaultSubGalleyModel)aGridPanel.getModel()).getInsertsNode().getParent(), this.unDoId) : LogicToolkit.getNewGalleyEquipmentInsert((Node<GalleyEquipmentInsertTypeComplete>)((Node)item.getUserObject(0)), (Node<GalleyEquipmentComplete>)aGridPanel.getModel().getNode(), this.unDoId);
                double ypos = aGridPanel.getGrid().getDiscretIndexY(dragItemY, (Double)aNYSize.getValue());
                Node aXPos = clone.getChildNamed(new String[]{"coordinates-x"});
                Node aZPos = clone.getChildNamed(new String[]{"coordinates-z"});
                if (aGridPanel.isSubGrid()) {
                    Node anZSize = ((Node)item.getUserObject(0)).getChildNamed(new String[]{"dimension-depth"});
                    double zpos = aGridPanel.getGrid().getDiscretIndexX(dragItemX, (Double)anZSize.getValue());
                    if (aZPos instanceof Node) {
                        aZPos.setValue((Object)zpos, this.unDoId);
                    }
                } else if (aBox == null) {
                    Node aNXSize = ((Node)item.getUserObject(0)).getChildNamed(new String[]{"dimension-width"});
                    double xpos = aGridPanel.getGrid().getDiscretIndexX(dragItemX, (Double)aNXSize.getValue());
                    if (aXPos instanceof Node) {
                        aXPos.setValue((Object)xpos, this.unDoId);
                    }
                }
                Node aYPos = clone.getChildNamed(new String[]{"coordinates-y"});
                if (aYPos instanceof Node) {
                    aYPos.setValue((Object)ypos, this.unDoId);
                }
                if (aGridPanel.isSubGrid()) {
                    ((DefaultSubGalleyModel)aGridPanel.getModel()).getInsertsNode().addChild(clone, this.unDoId);
                }
                if (aGridPanel != null) {
                    aGridPanel.highlightGrid(-1, -1);
                }
                item.processDraggReturn(true);
                return true;
            }
            if (aGridPanel != null) {
                aGridPanel.highlightGrid(-1, -1);
            }
            this.item.processDraggReturn(false);
            return false;
        }
        if (aGridPanel != null) {
            aGridPanel.highlightGrid(-1, -1);
        }
        this.item.processDraggReturn(false);
        return false;
    }

    private void insertReplacementService(CabinClassComplete cc, int dragItemX, int dragItemY, Triple<MealTypeComplete, Object, String> data, final GalleyGridPanel aGridPanel, final GridSpace space, DragableItem dragItem, final DragItemType dragType) {
        if (cc == null) {
            return;
        }
        if (!this.hasClassPlanned(cc)) {
            final int ax = dragItemX;
            final int ay = dragItemY;
            InnerPopUp2 aPopUp = InnerPopUp2.getInnerPopUp();
            aPopUp.setAttributes(null, true, true, "");
            InnerPopUpListener2 l = new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    if (xargs == null) {
                        ListItemDragController.this.gridPanel.selectBox(null, -1, -1);
                        ListItemDragController.this.gridPanel.highlightGrid(-1, -1);
                        ListItemDragController.this.item.processDraggReturn(false);
                    } else {
                        ListItemDragController.this.pegasus.showProductInsertPopUp(ax, ay, ListItemDragController.this, aGridPanel.getGrid(), dragType, false, space, null, ListItemDragController.this.item, aGridPanel);
                    }
                }
            };
            InnerPopupFactory.showWarningDialog(Words.ATT_STW_INSERT_WITHOUTCLASS_POPUP_WARING, l, (Component)dragItem);
        } else {
            Node<GalleyEquipmentInsertTypeComplete> insertType = null;
            this.pegasus.showProductInsertPopUp(10, dragItem.getHeight() / 2, this, dragItem, dragType, false, space, insertType, this.item, aGridPanel);
        }
    }

    private void insertService(CabinClassComplete cc, int dragItemX, int dragItemY, final Node aNode, final GalleyGridPanel aGridPanel, final Object space, Component dragItem, final DragItemType itemType) {
        if (cc == null) {
            return;
        }
        if (!this.hasClassPlanned(cc)) {
            final int ax = dragItemX;
            final int ay = dragItemY;
            InnerPopUp2 aPopUp = InnerPopUp2.getInnerPopUp();
            aPopUp.setAttributes(null, true, true, "");
            InnerPopUpListener2 l = new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    if (xargs == null) {
                        ListItemDragController.this.gridPanel.selectBox(null, -1, -1);
                        ListItemDragController.this.gridPanel.highlightGrid(-1, -1);
                        ListItemDragController.this.item.processDraggReturn(false);
                    } else {
                        CabinClassComplete cc = null;
                        Node aaNode = aNode;
                        if (aNode.getValue() instanceof CateringServiceScheduleComplete) {
                            cc = ((CateringServiceScheduleComplete)aNode.getValue()).getCabinClass();
                        } else if (aNode.getValue() instanceof CateringServiceComplete) {
                            cc = ((CateringServiceComplete)aNode.getValue()).getCabinClass();
                        } else if (aNode.getValue() instanceof CateringServiceScheduleVariantComplete) {
                            cc = ((CateringServiceScheduleVariantComplete)aNode.getValue()).getCabinClass();
                        }
                        if (cc != null) {
                            ListItemDragController.this.pegasus.addCabinClass(cc);
                        }
                        ListItemDragController.this.pegasus.showProductInsertPopUp(ax, ay, ListItemDragController.this, aGridPanel.getGrid(), itemType, false, space, null, ListItemDragController.this.item, aGridPanel);
                    }
                }
            };
            InnerPopupFactory.showWarningDialog(Words.ATT_STW_INSERT_WITHOUTCLASS_POPUP_WARING, l, dragItem);
        } else {
            Node insertType = null;
            if (this.item.getUserObject(0) instanceof Node && ((Node)this.item.getUserObject(0)).getValue() instanceof ALoadingGroupComplete) {
                insertType = ((Node)this.item.getUserObject(0)).getChildNamed(new String[]{"insertType"});
            }
            this.pegasus.showProductInsertPopUp(10, dragItem.getHeight() / 2, this, dragItem, itemType, false, space, insertType, this.item, aGridPanel);
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (source == this.pop) {
            if (xargs == null) {
                if (this.gridPanel != null) {
                    this.gridPanel.highlightGrid(-1, -1);
                }
                this.item.processDraggReturn(false);
                return;
            }
            Node t = (Node)xargs[0];
            String name = (String)xargs[1];
            Boolean useAlternative = (Boolean)xargs[2];
            String frontName = (String)xargs[3];
            Node frontType = (Node)xargs[4];
            String rearName = (String)xargs[5];
            Node rearType = (Node)xargs[6];
            GalleyEquipmentSystemComplete system = (GalleyEquipmentSystemComplete)this.pegasus.getAircraftNode().getChildNamed(new String[]{"equipmentSystem"}).getValue();
            Node<StowagePositionSpecificationComplete> cc = AircraftToolkit.getNewStowagePosition(system, (Node<StowagePositionTypeComplete>)((Node)this.item.getUserObject(0)), (GalleyEquipmentTypeComplete)t.getValue());
            Node clone = cc.getChildNamed(new String[]{"defaultPositions"}).getChildAt(0);
            Node n = clone.getChildNamed(new String[]{"code"});
            if (n instanceof Node) {
                n.setValue((Object)name, this.unDoId);
            }
            double ypos = this.gridPanel.getGrid().getDiscretIndexY(this.aDragItemY, (Double)this.aSYSize.getValue());
            Node aXPos = clone.getChildNamed(new String[]{"location-x"});
            Node aZPos = clone.getChildNamed(new String[]{"location-z"});
            if (this.gridPanel.isSubGrid()) {
                Node anZSize = ((Node)this.item.getUserObject(0)).getChildNamed(new String[]{"dimension-depth"});
                double zpos = this.gridPanel.getGrid().getDiscretIndexX(this.aDragItemX, (Double)anZSize.getValue());
                if (aZPos instanceof Node) {
                    aZPos.setValue((Object)zpos, this.unDoId);
                }
            } else {
                Node aNXSize = ((Node)this.item.getUserObject(0)).getChildNamed(new String[]{"size-width"});
                double xpos = this.gridPanel.getGrid().getDiscretIndexX(this.aDragItemX, (Double)aNXSize.getValue());
                if (aXPos instanceof Node) {
                    aXPos.setValue((Object)xpos, this.unDoId);
                }
            }
            Node aYPos = clone.getChildNamed(new String[]{"location-y"});
            if (aYPos instanceof Node) {
                aYPos.setValue((Object)ypos, this.unDoId);
            }
            if (useAlternative.booleanValue()) {
                AircraftToolkit.splitStowagePosition(cc, frontName, (GalleyEquipmentTypeComplete)frontType.getValue(), rearName, (GalleyEquipmentTypeComplete)rearType.getValue());
            }
            Node stowageList = this.gridPanel.getModel().getNode().getChildNamed(new String[]{"stowagePositionSpecifications"});
            stowageList.addChildSilent(cc, (NodeListener)this.gridPanel.getModel(), false, this.unDoId);
            GalleyBox box = this.gridPanel.addBox(this.aDragItemX, this.aDragItemY, cc);
            this.gridPanel.selectBox(box, -1, -1);
            this.gridPanel.highlightGrid(-1, -1);
            this.item.processDraggReturn(true);
        } else {
            String t;
            if (xargs == null || xargs.length == 0) {
                if (this.box != null) {
                    this.box.setHighLight(false);
                }
                this.item.processDraggReturn(false);
                if (this.gridPanel != null) {
                    this.gridPanel.highlightGrid(-1, -1);
                }
                return;
            }
            if (this.box != null) {
                this.box.setHighLight(false);
            }
            DragItemType returnType = (DragItemType)((Object)xargs[0]);
            Object aAmount = null;
            if (returnType == DragItemType.ARTICLE) {
                aAmount = xargs[1];
            } else {
                String menge = (String)xargs[1];
                aAmount = 0;
                try {
                    aAmount = Integer.valueOf(menge);
                }
                catch (NumberFormatException e) {
                    this.item.processDraggReturn(false);
                    return;
                }
            }
            boolean invokeIt = true;
            this.unDoId = System.currentTimeMillis();
            this.currentNode = null;
            this.type = returnType;
            boolean doInsert = false;
            Node itemNode = (Node)this.item.getUserObject(0);
            if (returnType == DragItemType.SERVICE || returnType == DragItemType.ADD_SERVICE_TO_SERVICE) {
                t = (String)xargs[5];
                int itemsPerTray = 0;
                try {
                    itemsPerTray = Integer.valueOf(t);
                }
                catch (NumberFormatException system) {
                    // empty catch block
                }
                if (this.gridPanel != null) {
                    Node tray = (Node)xargs[2];
                    String serviceName = MealPlanToolkit.createServicePartString(itemNode, false);
                    Node<GalleyEquipmentReservedSpaceComplete> dsNode = null;
                    if (returnType == DragItemType.SERVICE) {
                        GridSpace gridSpace = (GridSpace)xargs[3];
                        dsNode = LogicToolkit.getNewReservedSpace(gridSpace, (Node<GalleyEquipmentInsertTypeComplete>)tray, (Node<GalleyEquipmentComplete>)this.gridPanel.getModel().getNode(), itemsPerTray, serviceName);
                        this.gridPanel.getModel().getNode().getChildNamed(new String[]{"deliverySpaces"}).addChild(dsNode, System.currentTimeMillis());
                    } else {
                        Node<GalleyEquipmentReservedSpaceComplete> space;
                        dsNode = space = (Node<GalleyEquipmentReservedSpaceComplete>)xargs[3];
                    }
                    this.currentNode = dsNode;
                }
            } else if (returnType == DragItemType.ALACARTE_SPACE || returnType == DragItemType.SPML_SPACE) {
                t = (String)xargs[5];
                int itemsPerTray = 0;
                try {
                    itemsPerTray = Integer.valueOf(t);
                }
                catch (NumberFormatException tray) {
                    // empty catch block
                }
                if (this.gridPanel != null) {
                    Node tray = (Node)xargs[2];
                    String serviceName = null;
                    serviceName = (String)itemNode.getValue();
                    GridSpace gridSpace = (GridSpace)xargs[3];
                    Node<GalleyEquipmentReservedSpaceComplete> dsNode = null;
                    dsNode = LogicToolkit.getNewReservedSpace(gridSpace, (Node<GalleyEquipmentInsertTypeComplete>)tray, (Node<GalleyEquipmentComplete>)this.gridPanel.getModel().getNode(), itemsPerTray, serviceName);
                    this.gridPanel.getModel().getNode().getChildNamed(new String[]{"deliverySpaces"}).addChild(dsNode, System.currentTimeMillis());
                    this.currentNode = dsNode;
                }
                Object data = this.item.getUserObject(1);
                itemNode = new Node();
                itemNode.setValue(data, 0L);
            } else if (returnType == DragItemType.PRODUCT || returnType == DragItemType.ARTICLE || returnType == DragItemType.EQUIPMENT) {
                GridSpace gridSpace = null;
                if (xargs.length >= 4) {
                    gridSpace = (GridSpace)xargs[3];
                }
                Node tray = null;
                if (xargs.length >= 3) {
                    tray = (Node)xargs[2];
                }
                Node<GalleyEquipmentInsertComplete> iNode = null;
                if (xargs.length >= 5 && ((Boolean)xargs[4]).booleanValue()) {
                    String t2 = (String)xargs[5];
                    int itemsPerTray = 1;
                    try {
                        itemsPerTray = Integer.valueOf(t2);
                    }
                    catch (NumberFormatException e) {
                        itemsPerTray = 1;
                    }
                    String spaceName = "";
                    iNode = LogicToolkit.getNewReservedSpace(gridSpace, (Node<GalleyEquipmentInsertTypeComplete>)tray, (Node<GalleyEquipmentComplete>)this.gridPanel.getModel().getNode(), itemsPerTray, spaceName);
                } else if (gridSpace == null) {
                    iNode = this.box.getBoxNode();
                } else {
                    String spaceName = "";
                    if (returnType == DragItemType.EQUIPMENT) {
                        EquipmentTemplateComplete eq = (EquipmentTemplateComplete)itemNode.getValue();
                        try {
                            EquipmentTemplateVariantComplete eqv = (EquipmentTemplateVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getEquipmentTemplateVariant((EquipmentTemplateVariantReference)eq.getCurrentVariant()).getValue();
                            if (eqv.getDrawers().size() == 1) {
                                spaceName = ((EquipmentTemplateDrawerComplete)eqv.getDrawers().get(0)).getDrawerName();
                            }
                        }
                        catch (ClientServerCallException e) {
                            e.printStackTrace();
                        }
                    }
                    iNode = LogicToolkit.getNewGalleyEquipmentInsert(gridSpace, (Node<GalleyEquipmentInsertTypeComplete>)tray, spaceName, (Node<GalleyEquipmentComplete>)this.gridPanel.getModel().getNode());
                }
                if (this.gridPanel != null && iNode != null && gridSpace != null) {
                    doInsert = true;
                    this.gridPanel.getModel().getNode().getChildNamed(new String[]{"deliverySpaces"}).addChild(iNode, System.currentTimeMillis());
                }
                this.currentNode = iNode;
            } else {
                this.currentNode = this.box.getBoxNode();
            }
            int maxSeqNr = this.pegasus.getLabel().getMaxSequenceNumber() + 1;
            try {
                LogicToolkit.addNewDeliveryBatch((Node<? extends DeliverySpaceComplete>)this.currentNode, itemNode, aAmount, this.unDoId, this.type, source.getCaller(), this.pegasus, true, null, maxSeqNr);
            }
            catch (Exception e) {
                InnerPopupFactory.showErrorDialog(e, "Unable to add", (Component)this.pegasus);
                invokeIt = false;
            }
            if (invokeIt) {
                if (this.gridPanel != null) {
                    this.gridPanel.highlightGrid(-1, -1);
                }
                this.item.processDraggReturn(true);
            } else {
                this.item.processDraggReturn(false);
            }
        }
    }

    private boolean hasClassPlanned(CabinClassComplete testedClass) {
        Node confs = this.pegasus.getStowingList().getChildNamed(new String[]{"seatConfigurations"});
        Iterator it = confs.getChilds();
        while (it.hasNext()) {
            Node scc = (Node)it.next();
            if (!((SeatConfigurationComplete)scc.getValue()).getCabinClass().equals((Object)testedClass)) continue;
            return true;
        }
        return false;
    }

    public static enum DragItemType {
        ARTICLE,
        PRODUCT,
        SERVICE,
        ADD_SERVICE_TO_SERVICE,
        EQUIPMENT,
        SPML_SPACE,
        ALACARTE_SPACE;

    }
}

