/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.GalleyEquipmentTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.logic.Toolkit;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.panels.HorizontalCombinedView;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.server.core.dtos.masterdata.AlternativeStowagePositionTypePlacementComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StowagePositionTypeAlternativeConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StowagePositionTypeComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EquipmentTypeChooser
extends PopUpInsert
implements ButtonListener,
NodeListener,
ItemListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> typeCombo;
    private TitledItem<TextField> nameInput;
    private TitledItem<CheckBox> useAlternatives;
    private TitledItem<HorizontalCombinedView> frontAlt;
    private TitledItem<HorizontalCombinedView> rearAlt;
    private StowagePositionTypeComplete currentType;
    private HorizontalSeparator sep1;
    private Node currentNode;
    private int currentState;
    private static final int STATE_CREATE = 3;
    private static final int STATE_SPLIT = 5;
    private static final int STATE_EDIT = 7;
    private boolean isInAction = true;
    private boolean isSplitting = false;

    public EquipmentTypeChooser(Node currentNode) {
        this((StowagePositionTypeComplete)currentNode.getChildNamed(new String[]{"type"}).getValue(), false);
        this.currentState = 7;
        this.currentNode = currentNode;
        Converter viewConverter = ConverterRegistry.getConverter(GalleyEquipmentTypeConverter.class);
        this.typeCombo.getElement().setViewConverter(viewConverter);
        this.typeCombo.getElement().setNode(currentNode.getChildNamed(new String[]{"defaultGalleyEquipmentType"}));
        this.fillTypeCombo(true);
        this.nameInput.getElement().setNode(currentNode.getChildNamed(new String[]{"code"}));
        this.useAlternatives.setEnabled(false);
        this.isInAction = false;
    }

    public EquipmentTypeChooser(StowagePositionTypeComplete currentType) {
        this(currentType, true);
    }

    private boolean isInserted(GalleyEquipmentTypeComplete eq, ViewNode all) {
        Iterator it = all.getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (!((GalleyEquipmentTypeComplete)n.getValue()).getCode().equals(eq.getCode())) continue;
            return true;
        }
        return false;
    }

    private boolean isInserted(Node<GalleyEquipmentTypeComplete> eq, ComboBox box) {
        for (int i = 0; i < box.getItemCount(); ++i) {
            Node t = (Node)box.getItemAt(i);
            if (!((GalleyEquipmentTypeComplete)eq.getValue()).getCode().equals(((GalleyEquipmentTypeComplete)t.getValue()).getCode())) continue;
            return true;
        }
        return false;
    }

    private void fillTypeCombo(boolean withNode) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (this.currentType.equals((Object)settings.getLooseStowageType())) {
            ViewNode allN = new ViewNode("");
            allN.addChild(NodeToolkit.getAffixClass(SystemSettingsComplete.class).getChildNamed(new String[]{"looseEquipmentType"}), 0L);
            this.typeCombo.getElement().refreshPossibleValues((Node)allN);
        } else {
            Node n = NodeToolkit.getAffixList(GalleyEquipmentTypeComplete.class);
            Node selected = null;
            if (withNode) {
                ViewNode allN = new ViewNode("");
                Iterator it = n.getChilds();
                while (it.hasNext()) {
                    Node eq = (Node)it.next();
                    if (!Toolkit.isDimensionEquals(((GalleyEquipmentTypeComplete)eq.getValue()).getSize(), this.currentType.getSize()) || ((GalleyEquipmentTypeComplete)eq.getValue()).equals((Object)settings.getLooseEquipmentType()) || this.isInserted((GalleyEquipmentTypeComplete)eq.getValue(), allN)) continue;
                    eq.setConverter(GalleyEquipmentTypeConverter.class);
                    allN.addChild(eq, 0L);
                    if (!((GalleyEquipmentTypeComplete)eq.getValue()).getIsDefaultEquipment().booleanValue()) continue;
                    selected = eq;
                }
                this.typeCombo.getElement().refreshPossibleValues((Node)allN);
            } else {
                Iterator it = n.getChilds();
                while (it.hasNext()) {
                    Node eq = (Node)it.next();
                    if (!Toolkit.isDimensionEquals(((GalleyEquipmentTypeComplete)eq.getValue()).getSize(), this.currentType.getSize()) || ((GalleyEquipmentTypeComplete)eq.getValue()).equals((Object)settings.getLooseEquipmentType()) || this.isInserted((Node<GalleyEquipmentTypeComplete>)eq, this.typeCombo.getElement())) continue;
                    eq.setConverter(GalleyEquipmentTypeConverter.class);
                    this.typeCombo.getElement().addItem(eq);
                    if (!((GalleyEquipmentTypeComplete)eq.getValue()).getIsDefaultEquipment().booleanValue()) continue;
                    selected = eq;
                }
            }
            if (selected != null) {
                if (this.typeCombo.getElement().getNode() != null) {
                    if (this.typeCombo.getElement().getNode().getValue() == null) {
                        this.typeCombo.getElement().getNode().setValue(selected.getValue(), 0L);
                    }
                } else {
                    this.typeCombo.getElement().setSelectedItem(selected);
                }
            }
        }
    }

    public EquipmentTypeChooser(StowagePositionTypeComplete currentType, boolean fill) {
        this.currentState = 3;
        this.currentType = currentType;
        this.setOpaque(false);
        this.typeCombo = new TitledItem<ComboBox>(new ComboBox(), Words.DEFAULT_DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.typeCombo.getElement().setViewConverter(ConverterRegistry.getConverter(GalleyEquipmentTypeConverter.class));
        this.typeCombo.setProgress(1.0f);
        this.sep1 = new HorizontalSeparator();
        this.useAlternatives = new TitledItem<CheckBox>(new CheckBox(), Words.USER_ALTERNATIVE, TitledItem.TitledItemOrientation.EAST);
        this.useAlternatives.getElement().addButtonListener(this);
        this.nameInput = new TitledItem<TextField>(new TextField(), Words.POSITION_NAME, TitledItem.TitledItemOrientation.NORTH);
        this.nameInput.getElement().getTextField().getDocument().addDocumentListener(this);
        HorizontalCombinedView h1 = new HorizontalCombinedView(new TextField(), new ComboBox());
        HorizontalCombinedView h2 = new HorizontalCombinedView(new TextField(), new ComboBox());
        ((ComboBox)h1.getInnerComponent(1)).setProgress(1.0f);
        ((ComboBox)h2.getInnerComponent(1)).setProgress(1.0f);
        ((ComboBox)h1.getInnerComponent(1)).setViewConverter(ConverterRegistry.getConverter(GalleyEquipmentTypeConverter.class));
        ((ComboBox)h2.getInnerComponent(1)).setViewConverter(ConverterRegistry.getConverter(GalleyEquipmentTypeConverter.class));
        this.frontAlt = new TitledItem<HorizontalCombinedView>(h1, Words.FRONT_POSITION, TitledItem.TitledItemOrientation.NORTH);
        this.rearAlt = new TitledItem<HorizontalCombinedView>(h2, Words.REAR_POSITION, TitledItem.TitledItemOrientation.NORTH);
        ((TextField)this.frontAlt.getElement().getInnerComponent(0)).getTextField().getDocument().addDocumentListener(this);
        ((TextField)this.rearAlt.getElement().getInnerComponent(0)).getTextField().getDocument().addDocumentListener(this);
        if (fill) {
            this.fillTypeCombo(false);
        }
        this.setLayout(new Layout());
        this.checkifUseAlternativesIsEnabled(null, false);
        this.add(this.typeCombo);
        this.add(this.nameInput);
        this.add(this.sep1);
        this.add(this.useAlternatives);
        this.add(this.frontAlt);
        this.add(this.rearAlt);
    }

    public EquipmentTypeChooser(Node currentNode, StowagePositionTypeComplete newType) {
        this.currentState = 5;
        this.isSplitting = true;
        this.currentNode = currentNode;
        this.setOpaque(false);
        Node n = NodeToolkit.getAffixList(GalleyEquipmentTypeComplete.class);
        this.typeCombo = new TitledItem<ComboBox>(new ComboBox(), Words.DEFAULT_DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.typeCombo.setProgress(1.0f);
        this.sep1 = new HorizontalSeparator();
        this.useAlternatives = new TitledItem<CheckBox>(new CheckBox(), Words.USER_ALTERNATIVE, TitledItem.TitledItemOrientation.EAST);
        this.useAlternatives.getElement().setChecked(true);
        this.nameInput = new TitledItem<TextField>(new TextField(), Words.POSITION_NAME, TitledItem.TitledItemOrientation.NORTH);
        this.nameInput.getElement().setText((String)currentNode.getChildNamed(new String[]{"code"}).getValue());
        this.nameInput.getElement().getTextField().getDocument().addDocumentListener(this);
        ComboBox combo1 = new ComboBox();
        ComboBox combo2 = new ComboBox();
        Iterator it = n.getChilds();
        while (it.hasNext()) {
            Node eq = (Node)it.next();
            if (!Toolkit.isDimensionEquals(((GalleyEquipmentTypeComplete)eq.getValue()).getSize(), newType.getSize()) || this.isInserted((Node<GalleyEquipmentTypeComplete>)eq, combo1)) continue;
            eq.setConverter(ConverterRegistry.getConverter(GalleyEquipmentTypeConverter.class));
            combo1.addItem(eq);
            combo2.addItem(eq);
        }
        HorizontalCombinedView h1 = new HorizontalCombinedView(new TextField(), combo1);
        HorizontalCombinedView h2 = new HorizontalCombinedView(new TextField(), combo2);
        ((ComboBox)h1.getInnerComponent(1)).setProgress(1.0f);
        ((ComboBox)h2.getInnerComponent(1)).setProgress(1.0f);
        this.frontAlt = new TitledItem<HorizontalCombinedView>(h1, Words.FRONT_POSITION, TitledItem.TitledItemOrientation.NORTH);
        this.rearAlt = new TitledItem<HorizontalCombinedView>(h2, Words.REAR_POSITION, TitledItem.TitledItemOrientation.NORTH);
        ((TextField)this.frontAlt.getElement().getInnerComponent(0)).getTextField().getDocument().addDocumentListener(this);
        ((TextField)this.rearAlt.getElement().getInnerComponent(0)).getTextField().getDocument().addDocumentListener(this);
        this.frontAlt.getElement().setFixComp(0);
        this.rearAlt.getElement().setFixComp(0);
        this.setLayout(new Layout());
        this.typeCombo.setEnabled(false);
        this.nameInput.setEnabled(false);
        this.useAlternatives.setEnabled(false);
        this.add(this.typeCombo);
        this.add(this.nameInput);
        this.add(this.sep1);
        this.add(this.useAlternatives);
        this.add(this.frontAlt);
        this.add(this.rearAlt);
    }

    private void checkifUseAlternativesIsEnabled(StowagePositionTypeComplete t1, boolean withViewNode) {
        StowagePositionTypeComplete t = this.currentType;
        if (t1 != null) {
            t = t1;
        }
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (t.getAlternatives().size() > 0 && !t.equals((Object)settings.getLooseStowageType())) {
            this.useAlternatives.setEnabled(true);
            if (this.useAlternatives.getElement().isChecked()) {
                this.frontAlt.setEnabled(true);
                this.rearAlt.setEnabled(true);
            } else {
                this.frontAlt.setEnabled(false);
                this.rearAlt.setEnabled(false);
            }
            StowagePositionTypeComplete spType1 = ((AlternativeStowagePositionTypePlacementComplete)((StowagePositionTypeAlternativeConfigurationComplete)t.getAlternatives().get(0)).getPlacedTypes().get(0)).getStowagePositionType();
            StowagePositionTypeComplete spType2 = ((AlternativeStowagePositionTypePlacementComplete)((StowagePositionTypeAlternativeConfigurationComplete)t.getAlternatives().get(0)).getPlacedTypes().get(1)).getStowagePositionType();
            ComboBox cob1 = (ComboBox)this.frontAlt.getElement().getInnerComponent(1);
            ComboBox cob2 = (ComboBox)this.rearAlt.getElement().getInnerComponent(1);
            cob1.removeAllItems();
            cob2.removeAllItems();
            if (withViewNode) {
                ViewNode view1 = new ViewNode("");
                ViewNode view2 = new ViewNode("");
                Node n = NodeToolkit.getAffixList(GalleyEquipmentTypeComplete.class);
                Iterator it = n.getChilds();
                while (it.hasNext()) {
                    Node eq = (Node)it.next();
                    if (Toolkit.isDimensionEquals(((GalleyEquipmentTypeComplete)eq.getValue()).getSize(), spType1.getSize()) && !((GalleyEquipmentTypeComplete)eq.getValue()).equals((Object)settings.getLooseEquipmentType())) {
                        view1.addChild(eq, 0L);
                    }
                    if (!Toolkit.isDimensionEquals(((GalleyEquipmentTypeComplete)eq.getValue()).getSize(), spType2.getSize()) || ((GalleyEquipmentTypeComplete)eq.getValue()).equals((Object)settings.getLooseEquipmentType())) continue;
                    view2.addChild(eq, 0L);
                }
                cob1.refreshPossibleValues((Node)view1);
                cob2.refreshPossibleValues((Node)view2);
            } else {
                Node n = NodeToolkit.getAffixList(GalleyEquipmentTypeComplete.class);
                Iterator it = n.getChilds();
                while (it.hasNext()) {
                    Node eq = (Node)it.next();
                    eq.setConverter(ConverterRegistry.getConverter(GalleyEquipmentTypeConverter.class));
                    if (Toolkit.isDimensionEquals(((GalleyEquipmentTypeComplete)eq.getValue()).getSize(), spType1.getSize()) && !((GalleyEquipmentTypeComplete)eq.getValue()).equals((Object)settings.getLooseEquipmentType())) {
                        cob1.addItem(eq);
                    }
                    if (!Toolkit.isDimensionEquals(((GalleyEquipmentTypeComplete)eq.getValue()).getSize(), spType2.getSize()) || ((GalleyEquipmentTypeComplete)eq.getValue()).equals((Object)settings.getLooseEquipmentType())) continue;
                    cob2.addItem(eq);
                }
            }
        } else {
            this.useAlternatives.setEnabled(false);
            this.frontAlt.setEnabled(false);
            this.rearAlt.setEnabled(false);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.useAlternatives.getElement()) {
            if (this.useAlternatives.getElement().isChecked()) {
                this.frontAlt.setEnabled(true);
                this.rearAlt.setEnabled(true);
            } else {
                this.frontAlt.setEnabled(false);
                this.rearAlt.setEnabled(false);
            }
            this.popup.rebuildFocusCycle();
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        this.nameInput.getElement().getTextField().getDocument().removeDocumentListener(this);
        super.kill();
        this.typeCombo.kill();
        this.typeCombo = null;
        this.nameInput.kill();
        this.nameInput = null;
        this.useAlternatives.kill();
        this.useAlternatives = null;
        this.frontAlt.kill();
        this.frontAlt = null;
        this.rearAlt.kill();
        this.rearAlt = null;
        this.sep1.kill();
        this.sep1 = null;
        if (this.currentNode != null) {
            this.currentNode.removeNodeListener((NodeListener)this);
        }
        this.currentNode = null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        String name1 = ((TextField)this.frontAlt.getElement().getInnerComponent(0)).getText();
        Node defaultType1 = (Node)((ComboBox)this.frontAlt.getElement().getInnerComponent(1)).getSelectedItem();
        String name2 = ((TextField)this.rearAlt.getElement().getInnerComponent(0)).getText();
        Node defaultType2 = (Node)((ComboBox)this.rearAlt.getElement().getInnerComponent(1)).getSelectedItem();
        if (this.isSplitting) {
            Object[] o = new Object[]{this.currentNode, name1, defaultType1.getValue(), name2, defaultType2.getValue()};
            return o;
        }
        Object[] o = new Object[]{this.typeCombo.getElement().getSelectedItem(), this.nameInput.getElement().getText(), this.useAlternatives.getElement().isChecked(), name1, defaultType1, name2, defaultType2};
        return o;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        ComboBox box2;
        ComboBox box1;
        if (this.typeCombo.getElement().getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.typeCombo.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        if ((box1 = (ComboBox)this.frontAlt.getElement().getInnerComponent(1)).getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(box1.getCurrentPopUp())) continue;
                return true;
            }
        }
        if ((box2 = (ComboBox)this.rearAlt.getElement().getInnerComponent(1)).getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(box2.getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        switch (this.currentState) {
            case 3: 
            case 7: {
                this.nameInput.getElement().requestFocusInWindowNow();
                return true;
            }
            case 5: {
                ((TextField)this.frontAlt.getElement().getInnerComponent(0)).requestFocusInWindowNow();
                return true;
            }
        }
        return false;
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        if (node.getName().equals("type")) {
            this.typeCombo.getElement().removeAllItems();
            StowagePositionTypeComplete t = (StowagePositionTypeComplete)node.getValue();
            Iterator it = NodeToolkit.getAffixList(GalleyEquipmentTypeComplete.class).getChilds();
            while (it.hasNext()) {
                Node eq = (Node)it.next();
                if (!Toolkit.isDimensionEquals(((GalleyEquipmentTypeComplete)eq.getValue()).getSize(), t.getSize())) continue;
                this.typeCombo.getElement().addItem(eq);
            }
            this.isInAction = true;
            this.typeCombo.getElement().setSelectedItem(this.currentNode.getChildNamed(new String[]{"defaultGalleyEquipmentType"}));
            this.isInAction = false;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.isInAction) {
            return;
        }
        if (e.getSource() == this.typeCombo.getElement()) {
            Node d = (Node)this.typeCombo.getElement().getSelectedItem();
            Node sct = this.currentNode.getChildNamed(new String[]{"defaultGalleyEquipmentType"});
            if (sct instanceof ProxyNode) {
                ((ProxyNode)sct).setRefNode(d);
            } else if (sct instanceof Node) {
                sct.setValue(d.getValue(), System.currentTimeMillis());
            }
        }
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        switch (this.currentState) {
            case 3: {
                ComboBox c;
                TextField t;
                CheckedListAdder.addToList(a, this.nameInput);
                CheckedListAdder.addToList(a, this.typeCombo);
                if (this.useAlternatives.isEnabled()) {
                    a.add(this.useAlternatives.getElement());
                }
                if (this.frontAlt.isEnabled()) {
                    t = (TextField)this.frontAlt.getElement().getInnerComponent(0);
                    c = (ComboBox)this.frontAlt.getElement().getInnerComponent(1);
                    CheckedListAdder.addToList(a, t);
                    a.add(c);
                }
                if (!this.rearAlt.isEnabled()) break;
                t = (TextField)this.rearAlt.getElement().getInnerComponent(0);
                c = (ComboBox)this.rearAlt.getElement().getInnerComponent(1);
                CheckedListAdder.addToList(a, t);
                a.add(c);
                break;
            }
            case 7: {
                ComboBox c;
                TextField t;
                CheckedListAdder.addToList(a, this.nameInput);
                a.add(this.typeCombo.getElement());
                if (this.frontAlt.isEnabled()) {
                    t = (TextField)this.frontAlt.getElement().getInnerComponent(0);
                    c = (ComboBox)this.frontAlt.getElement().getInnerComponent(1);
                    CheckedListAdder.addToList(a, t);
                    a.add(c);
                }
                if (!this.rearAlt.isEnabled()) break;
                t = (TextField)this.rearAlt.getElement().getInnerComponent(0);
                c = (ComboBox)this.rearAlt.getElement().getInnerComponent(1);
                CheckedListAdder.addToList(a, t);
                a.add(c);
                break;
            }
            case 5: {
                ComboBox c;
                TextField t;
                if (this.frontAlt.isEnabled()) {
                    t = (TextField)this.frontAlt.getElement().getInnerComponent(0);
                    c = (ComboBox)this.frontAlt.getElement().getInnerComponent(1);
                    CheckedListAdder.addToList(a, t);
                    a.add(c);
                }
                if (!this.rearAlt.isEnabled()) break;
                t = (TextField)this.rearAlt.getElement().getInnerComponent(0);
                c = (ComboBox)this.rearAlt.getElement().getInnerComponent(1);
                CheckedListAdder.addToList(a, t);
                a.add(c);
            }
        }
        return a;
    }

    @Override
    public boolean validateContent() {
        boolean isValid = true;
        if (this.useAlternatives.getElement().isChecked()) {
            if (((TextField)this.rearAlt.getElement().getInnerComponent(0)).getText().equals("")) {
                isValid = false;
                ((TextField)this.rearAlt.getElement().getInnerComponent(0)).setInvalid();
            }
            if (((TextField)this.frontAlt.getElement().getInnerComponent(0)).getText().equals("")) {
                isValid = false;
                ((TextField)this.frontAlt.getElement().getInnerComponent(0)).setInvalid();
            }
        }
        if (this.nameInput.getElement().getText().equals("")) {
            isValid = false;
            this.nameInput.getElement().setInvalid();
        }
        return isValid;
    }

    private void textChanged(DocumentEvent e) {
        if (e.getDocument() == this.nameInput.getElement().getTextField().getDocument()) {
            this.nameInput.getElement().setValid();
        } else if (((TextField)this.frontAlt.getElement().getInnerComponent(0)).getTextField().getDocument() == e.getDocument()) {
            ((TextField)this.frontAlt.getElement().getInnerComponent(0)).setValid();
        } else {
            ((TextField)this.rearAlt.getElement().getInnerComponent(0)).setValid();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    @Override
    public boolean isClosableWithEnter() {
        if (this.typeCombo.getElement().hasFocus()) {
            return !this.typeCombo.getElement().isPopupVisible();
        }
        if (this.useAlternatives.getElement().hasFocus()) {
            return false;
        }
        ComboBox b1 = (ComboBox)this.frontAlt.getElement().getInnerComponent(1);
        ComboBox b2 = (ComboBox)this.rearAlt.getElement().getInnerComponent(1);
        if (b1.hasFocus()) {
            return !b1.isPopupVisible();
        }
        if (b2.hasFocus()) {
            return !b2.isPopupVisible();
        }
        return true;
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int yBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("popup_yborder"));
            EquipmentTypeChooser.this.nameInput.setLocation(0, 0);
            EquipmentTypeChooser.this.nameInput.setSize(parent.getWidth(), (int)EquipmentTypeChooser.this.nameInput.getPreferredSize().getHeight());
            int currentY = EquipmentTypeChooser.this.nameInput.getY() + EquipmentTypeChooser.this.nameInput.getHeight();
            EquipmentTypeChooser.this.typeCombo.setLocation(0, currentY + yBorder);
            EquipmentTypeChooser.this.typeCombo.setSize(parent.getWidth(), (int)EquipmentTypeChooser.this.typeCombo.getPreferredSize().getHeight());
            EquipmentTypeChooser.this.sep1.setLocation(0, EquipmentTypeChooser.this.typeCombo.getY() + EquipmentTypeChooser.this.typeCombo.getHeight() + yBorder);
            EquipmentTypeChooser.this.sep1.setSize(parent.getWidth(), (int)EquipmentTypeChooser.this.sep1.getPreferredSize().getHeight());
            EquipmentTypeChooser.this.useAlternatives.setLocation(0, EquipmentTypeChooser.this.sep1.getY() + EquipmentTypeChooser.this.sep1.getHeight() + yBorder);
            EquipmentTypeChooser.this.useAlternatives.setSize(parent.getWidth(), (int)EquipmentTypeChooser.this.useAlternatives.getPreferredSize().getHeight());
            EquipmentTypeChooser.this.frontAlt.setLocation(0, EquipmentTypeChooser.this.useAlternatives.getY() + EquipmentTypeChooser.this.useAlternatives.getHeight() + yBorder);
            EquipmentTypeChooser.this.frontAlt.setSize(parent.getWidth(), (int)EquipmentTypeChooser.this.frontAlt.getPreferredSize().getHeight());
            EquipmentTypeChooser.this.rearAlt.setLocation(0, EquipmentTypeChooser.this.frontAlt.getY() + EquipmentTypeChooser.this.frontAlt.getHeight() + yBorder);
            EquipmentTypeChooser.this.rearAlt.setSize(parent.getWidth(), (int)EquipmentTypeChooser.this.rearAlt.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int yBorder;
            int border = yBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("popup_yborder")).intValue();
            int h = 0;
            h = (int)((double)h + EquipmentTypeChooser.this.nameInput.getPreferredSize().getHeight());
            h += border / 2;
            h = (int)((double)h + EquipmentTypeChooser.this.typeCombo.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + EquipmentTypeChooser.this.sep1.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + EquipmentTypeChooser.this.useAlternatives.getPreferredSize().getHeight());
            h += border / 2;
            h = (int)((double)h + EquipmentTypeChooser.this.frontAlt.getPreferredSize().getHeight());
            h += border / 2;
            h = (int)((double)h + EquipmentTypeChooser.this.rearAlt.getPreferredSize().getHeight());
            return new Dimension(200, h);
        }
    }
}

