/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.LayoutManager;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.LayoutablePanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Timer;

public abstract class FadeInOutPanel
extends BorderedInletPanel
implements ActionListener,
LayoutablePanel,
LafListener,
Fadable,
MouseListener {
    private static final long serialVersionUID = 1L;
    private boolean isFadeIn;
    private boolean isFadeAction = false;
    private boolean isPermanent = false;
    private boolean isDestroyAfterFadeOut;
    private long theStartTime;
    private Timer theAnimationTimer;
    protected float theProgress = 0.0f;
    protected Skin9Field theSkin = (Skin9Field)DefaultSkins.ShadowBackground.createDynamicSkin();
    protected LayoutManager theLayoutManager;

    public FadeInOutPanel() {
        this(false);
    }

    public FadeInOutPanel(boolean hasBackground) {
        if (hasBackground) {
            this.hasSkin = true;
            this.hasBackground = true;
        } else {
            this.addMouseListener(this);
            this.hasSkin = false;
            this.hasBackground = false;
            this.useCliping = false;
            this.hasTitle = false;
        }
        this.setOpaque(false);
        this.setLayout(null);
    }

    @Override
    public AlphaFader<?> getFader() {
        return null;
    }

    public void setPermanent(boolean isPermanent) {
        this.isPermanent = isPermanent;
    }

    @Override
    public Component add(Component comp) {
        return super.add(comp, 0);
    }

    @Override
    public void fadeIn() {
        this.isFadeAction = true;
        this.theProgress = 0.0f;
        this.setVisible(true);
        this.isFadeIn = true;
        this.theStartTime = System.currentTimeMillis();
        this.ensureTimer();
    }

    @Override
    public void fadeIn(long animationTime) {
        this.fadeIn();
    }

    @Override
    public void fadeOut(boolean destroy, long animationTime) {
        this.fadeOut(destroy);
    }

    private void ensureTimer() {
        if (this.theAnimationTimer == null) {
            this.theAnimationTimer = new Timer(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("animationRate")), this);
        }
        this.theAnimationTimer.setRepeats(true);
        this.theAnimationTimer.start();
    }

    @Override
    public void fadeOut(boolean destroy) {
        this.isDestroyAfterFadeOut = destroy;
        this.isFadeAction = true;
        this.isFadeIn = false;
        this.theStartTime = System.currentTimeMillis();
        this.ensureTimer();
    }

    public boolean isFadedIn() {
        return (double)this.theProgress >= 1.0;
    }

    public boolean isExpanded() {
        return true;
    }

    protected float lookUpComposite() {
        float aComposite = this.theProgress;
        Container p = this;
        while (p.getParent() != null) {
            if (!((p = p.getParent()) instanceof FadeInOutPanel)) continue;
            if (((FadeInOutPanel)p).getProgress() < aComposite) {
                aComposite = ((FadeInOutPanel)p).getProgress();
            }
            return aComposite;
        }
        return aComposite;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isFadeAction) {
            return;
        }
        if (this.isFadeIn) {
            this.theProgress = (float)(System.currentTimeMillis() - this.theStartTime) / (float)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("animationTime")).intValue();
            if (this.theProgress >= 1.0f) {
                this.theProgress = 1.0f;
                this.theAnimationTimer.stop();
                this.theAnimationTimer = null;
                this.isFadeAction = false;
            }
            if (this.getParent() != null) {
                this.getParent().repaint(32L);
            }
        } else {
            this.theProgress = (float)(System.currentTimeMillis() - this.theStartTime) / (float)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("animationTime")).intValue();
            this.theProgress = 1.0f - this.theProgress;
            if (this.theProgress <= 0.0f) {
                this.isFadeAction = false;
                this.theProgress = 0.0f;
                this.theAnimationTimer.stop();
                this.theAnimationTimer = null;
                this.setVisible(false);
                if (this.getParent() != null && !this.isPermanent) {
                    this.getParent().remove(this);
                }
                if (this.isDestroyAfterFadeOut) {
                    this.kill();
                }
            } else {
                this.getParent().repaint(32L);
            }
        }
    }

    @Override
    public boolean isAnimating(AlphaFader.FadeType fadeIn) {
        return false;
    }

    @Override
    public void setProgress(float progress) {
        this.theProgress = progress;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    public void setLayoutManager(LayoutManager mag) {
        this.theLayoutManager = mag;
    }

    public LayoutManager getLayoutManager() {
        return this.theLayoutManager;
    }

    public String getTitleString() {
        if (this.hasTitle) {
            return this.getTitleText();
        }
        return "";
    }

    public void setTitleString(String t) {
        if (this.hasTitle) {
            this.setTitleText(t);
        }
    }

    @Override
    public float getProgress() {
        return this.theProgress;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

