/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.ProductGroupTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbGroupTable;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.modules.product.details.utils.GroupComparator;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.ProductBreadCrumbPanel;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.GroupConfigPopupInsert;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.ProductNavigatorConverter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ConfigButton;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.AlignedSizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ProductGroupTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ProductBreadCrumbGroupTable
extends BreadCrumbGroupTable {
    private static final long serialVersionUID = 1L;
    private boolean isClosed;

    public ProductBreadCrumbGroupTable(IDataHandler dataHandler, BreadCrumbPanel master, String buttonText, Node node, RDProvider provider) {
        super(dataHandler, master, buttonText, provider);
    }

    @Override
    public void addButtonPressed() {
        SimpleProductComponentGroupComplete group = new SimpleProductComponentGroupComplete();
        group.setClientOId(Long.valueOf(ADTO.getNextId()));
        group.setNumber(Integer.valueOf(this.table.getModel().getNode().getChildCount() + 1));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)group, true, false);
        this.table.setRequestFocusOnAdd(true);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        this.table.setRequestFocusOnAdd(false);
        this.table.validate();
    }

    public ProductBreadCrumbPanel getProductMaster() {
        return (ProductBreadCrumbPanel)this.master;
    }

    @Override
    public boolean hasAddButton() {
        return !this.isClosed;
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
        boolean bl = this.isClosed = !this.getProductMaster().canEditSpecification();
        if (this.isClosed) {
            this.showAddButton(false);
        } else {
            this.showAddButton(true);
        }
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    @Override
    public void childRemoved() {
        this.master.recalucalteTotalPrice(true);
        this.writeNumbers();
        this.table.validate();
    }

    @Override
    public int getSortingIndex() {
        return 0;
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        int wd = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) * 3 + 3 * this.table.getCellPadding() + 2 * this.table.getInnerCellPadding() + ConfigButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.GROUP_NAME, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo("", null, null, null, "", wd, wd, wd));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        return columns;
    }

    @Override
    public Table2RowPanel getGroupTableRow(Table2RowModel model, boolean isHeader) {
        return new GroupTableRow(model);
    }

    @Override
    public Comparator<?> getGroupComparator() {
        return ComparatorRegistry.getComparator(GroupComparator.class);
    }

    public Converter getTitleConverter() {
        return ConverterRegistry.getConverter(ProductNavigatorConverter.class);
    }

    private class GroupTableRow
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel number;
        private ComboBox groupType;
        private TextField name;
        private DeleteButton deleteButton;
        private ArrowButton downButton;
        private ArrowButton upButton;
        private ConfigButton config;

        public GroupTableRow(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            this.number = new TextLabel(m.getNode().getChildNamed(new String[]{"number"}), ConverterRegistry.getConverter(IntegerConverter.class));
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            if (Boolean.TRUE.equals(settings.getUseMasterDataForProductGroupNames()) && Boolean.TRUE.equals(((ComplexProductVariantComplete)ProductBreadCrumbGroupTable.this.getProductMaster().getSelectedVariant().getValue()).getUseMasterDataForProductGroupTypes())) {
                this.groupType = new ComboBox(m.getNode().getChildNamed(SimpleProductComponentGroupComplete_.groupType), NodeToolkit.getAffixList(ProductGroupTypeComplete.class), ConverterRegistry.getConverter(ProductGroupTypeConverter.class));
            } else {
                this.name = new TextField(m.getNode().getChildNamed(new String[]{"name"}));
                this.name.setSelectionDelegate(this);
            }
            this.downButton = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Down);
            this.upButton = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Up);
            this.config = new ConfigButton(SizedSkin1Field.SkinSize.SMALL);
            this.downButton.addButtonListener(this);
            this.upButton.addButtonListener(this);
            this.upButton.setProgress(1.0f);
            this.downButton.setProgress(1.0f);
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.THREE);
            this.config.addButtonListener(this);
            this.number.setProgress(1.0f);
            this.setLayout(new MasterRowPanelLayout());
            this.add(this.number);
            if (this.groupType != null) {
                this.add(this.groupType);
            }
            if (this.name != null) {
                this.add(this.name);
            }
            this.add(this.upButton);
            this.add(this.downButton);
            this.add(this.deleteButton);
            this.add(this.config);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.number.getText();
                }
                case 1: {
                    if (this.name != null) {
                        return this.name.getText();
                    }
                    return this.groupType.getSelectedItem().toString();
                }
            }
            return null;
        }

        @Override
        public Component getFocusDelegationComponent() {
            if (this.name != null) {
                return this.name;
            }
            if (this.groupType != null) {
                return this.groupType;
            }
            return null;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.name != null) {
                this.name.requestFocusInWindowNow();
            }
            if (this.groupType != null) {
                this.groupType.requestFocusInWindowNow();
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.number.kill();
            if (this.name != null) {
                this.name.kill();
            }
            if (this.groupType != null) {
                this.groupType.kill();
            }
            this.downButton.kill();
            this.upButton.kill();
            this.deleteButton.kill();
            this.config.kill();
            this.number = null;
            this.name = null;
            this.groupType = null;
            this.downButton = null;
            this.upButton = null;
            this.deleteButton = null;
            this.config = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean isClosed = ProductBreadCrumbGroupTable.this.isClosed;
            this.number.setEnabled(isEnabled);
            if (this.name != null) {
                this.name.setEnabled(isEnabled && !isClosed);
            }
            if (this.groupType != null) {
                this.groupType.setEnabled(isEnabled && !isClosed);
            }
            if (!isEnabled || isClosed) {
                this.upButton.setEnabled(isEnabled && !isClosed);
                this.downButton.setEnabled(isEnabled && !isClosed);
            } else {
                this.ensureArrowButtonState();
            }
            this.deleteButton.setEnabled(isEnabled && !isClosed);
            this.config.setEnabled(isEnabled);
        }

        @Override
        public void updateRowOrder() {
            this.ensureArrowButtonState();
        }

        private void ensureArrowButtonState() {
            Object number = this.model.getNode().getChildNamed(new String[]{"number"}).getValue();
            int index = number != null ? (Integer)number : 0;
            int max = ProductBreadCrumbGroupTable.this.table.getRowCount();
            boolean up = true;
            boolean down = true;
            if (index == 1) {
                up = false;
            }
            if (index == max) {
                down = false;
            }
            boolean isClosed = ProductBreadCrumbGroupTable.this.isClosed;
            this.upButton.setEnabled(up && !isClosed);
            this.downButton.setEnabled(down && !isClosed);
        }

        private void moveUp() {
            int i = (Integer)this.model.getNode().getChildNamed(new String[]{"number"}).getValue();
            if (i == 1) {
                return;
            }
            int index = i - 1;
            int oppositeIndex = index - 1;
            GroupTableRow p = (GroupTableRow)this.model.getParentModel().getTable().getRowAt(oppositeIndex);
            try {
                int i2 = (Integer)p.getModel().getNode().getChildNamed(new String[]{"number"}).getValue();
                long id = System.currentTimeMillis();
                this.model.getNode().getChildNamed(new String[]{"number"}).setValue((Object)(--i), id);
                p.getModel().getNode().getChildNamed(new String[]{"number"}).setValue((Object)(++i2), id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.model.getParentModel().getTable().updateOrder();
            this.model.getParentModel().getTable().relayoutRequested();
        }

        private void moveDown() {
            int max;
            int i = (Integer)this.model.getNode().getChildNamed(new String[]{"number"}).getValue();
            if (i == (max = this.model.getParentModel().getTable().getRowCount())) {
                return;
            }
            int index = i - 1;
            int oppositeIndex = index + 1;
            GroupTableRow p = (GroupTableRow)this.model.getParentModel().getTable().getRowAt(oppositeIndex);
            try {
                int i2 = (Integer)p.getModel().getNode().getChildNamed(new String[]{"number"}).getValue();
                long id = System.currentTimeMillis();
                this.model.getNode().getChildNamed(new String[]{"number"}).setValue((Object)(++i), id);
                p.getModel().getNode().getChildNamed(new String[]{"number"}).setValue((Object)(--i2), id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.model.getParentModel().getTable().updateOrder();
            this.model.getParentModel().getTable().relayoutRequested();
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                ProductBreadCrumbGroupTable.this.master.groupRemoved(this);
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
                ProductBreadCrumbGroupTable.this.writeNumbers();
            } else if (source == this.downButton) {
                this.moveDown();
            } else if (source == this.upButton) {
                this.moveUp();
            } else if (source == this.config) {
                this.showConfigPopup(x, y);
            }
        }

        private void showConfigPopup(int x, int y) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(this.config, false, false, "Config Product Group");
            popUp.hideCancelButton();
            boolean isClosed = ProductBreadCrumbGroupTable.this.isClosed;
            popUp.setView(new GroupConfigPopupInsert(ProductBreadCrumbGroupTable.this.provider, this.model.getNode(), (Node<Boolean>)this.model.getNode().getChildNamed(new String[]{"showInCatalog"}), (Node<String>)this.model.getNode().getChildNamed(new String[]{"comment"}), (Node<Boolean>)this.model.getNode().getChildNamed(new String[]{"useImage"}), (Node<PegasusFileComplete>)this.model.getNode().getChildNamed(new String[]{"image"}), (Node<Boolean>)this.model.getNode().getChildNamed(new String[]{"labeled"}), (Node<Boolean>)this.model.getNode().getChildNamed(SimpleProductComponentGroupComplete_.showAllergens), isClosed));
            popUp.showPopUp(x, y, 700, -1, null, this.config, PopupType.NORMAL);
            ((GroupConfigPopupInsert)popUp.getView()).revalidate();
            ((GroupConfigPopupInsert)popUp.getView()).invalidate();
            ((GroupConfigPopupInsert)popUp.getView()).validate();
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            if (this.name != null) {
                CheckedListAdder.addToList(a, this.name);
                CheckedListAdder.addToList(a, this.groupType);
                if (this.upButton.isEnabled()) {
                    CheckedListAdder.addToList(a, this.upButton);
                }
                if (this.downButton.isEnabled()) {
                    CheckedListAdder.addToList(a, this.downButton);
                }
                CheckedListAdder.addToList(a, this.deleteButton);
                CheckedListAdder.addToList(a, this.config);
            }
            return a;
        }

        private class MasterRowPanelLayout
        extends DefaultLayout {
            private MasterRowPanelLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = GroupTableRow.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                GroupTableRow.this.number.setLocation(GroupTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - GroupTableRow.this.number.getPreferredSize().getHeight()) / 2.0));
                GroupTableRow.this.number.setSize(w - 2 * GroupTableRow.this.getCellPadding(), (int)GroupTableRow.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = GroupTableRow.this.getModel().getParentModel().getColumnWidth(1);
                if (GroupTableRow.this.name != null) {
                    GroupTableRow.this.name.setLocation(currentX + GroupTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - GroupTableRow.this.name.getPreferredSize().getHeight()) / 2.0));
                    GroupTableRow.this.name.setSize(w - 2 * GroupTableRow.this.getCellPadding(), (int)GroupTableRow.this.name.getPreferredSize().getHeight());
                }
                if (GroupTableRow.this.groupType != null) {
                    GroupTableRow.this.groupType.setLocation(currentX + GroupTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - GroupTableRow.this.groupType.getPreferredSize().getHeight()) / 2.0));
                    GroupTableRow.this.groupType.setSize(w - 2 * GroupTableRow.this.getCellPadding(), (int)GroupTableRow.this.groupType.getPreferredSize().getHeight());
                }
                currentX += w;
                w = GroupTableRow.this.getModel().getParentModel().getColumnWidth(2);
                GroupTableRow.this.setControlsX(currentX);
                GroupTableRow.this.config.setLocation(currentX + GroupTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - GroupTableRow.this.config.getPreferredSize().getHeight()) / 2.0));
                GroupTableRow.this.config.setSize(GroupTableRow.this.config.getPreferredSize());
                GroupTableRow.this.upButton.setLocation(GroupTableRow.this.config.getX() + GroupTableRow.this.config.getWidth() + GroupTableRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - GroupTableRow.this.upButton.getPreferredSize().getHeight()) / 2.0));
                GroupTableRow.this.upButton.setSize(GroupTableRow.this.upButton.getPreferredSize());
                GroupTableRow.this.downButton.setLocation(GroupTableRow.this.upButton.getX() + GroupTableRow.this.upButton.getWidth() + GroupTableRow.this.getInnerCellPadding(), GroupTableRow.this.upButton.getY());
                GroupTableRow.this.downButton.setSize(GroupTableRow.this.downButton.getPreferredSize());
                GroupTableRow.this.deleteButton.setLocation(GroupTableRow.this.downButton.getX() + GroupTableRow.this.downButton.getWidth() + GroupTableRow.this.getCellPadding(), GroupTableRow.this.downButton.getY());
                GroupTableRow.this.deleteButton.setSize(GroupTableRow.this.deleteButton.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, GroupTableRow.this.getDefaultRowHeight());
            }
        }
    }
}

