/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.sob.sobreturn;

import ch.icit.pegasus.client.converter.MoneyTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.SalesOnBoardServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.ReturnMoneyComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.ReturnMoneyComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.sob.MoneyTypComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SOBReturnToolComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private final FlightLight flightLight;
    private Node<List<ReturnMoneyComplete>> moneyList;
    private Table2 table;
    private boolean isLoadingRemains = false;

    public SOBReturnToolComponent(FlightLight flightLight) {
        super(false, false);
        this.flightLight = flightLight;
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.createComponents();
        this.isLoadingRemains = true;
        this.popup.setOkButtonText(Words.SAVE);
        this.removeInheritedComponents();
        this.ensureAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SOBReturnToolComponent.this.moneyList = INodeCreator.getDefaultImpl().createNodes(((SalesOnBoardServiceManager)ServiceManagerRegistry.getService(SalesOnBoardServiceManager.class)).getReturnMoneys(new FlightReference(SOBReturnToolComponent.this.flightLight.getId())).getList(), true);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(MoneyTypComplete.class);
                return SOBReturnToolComponent.this.moneyList;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SOBReturnToolComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingRemains) {
            this.removeAnimation(false);
            this.createInners();
            this.table.getModel().setNode(node);
            this.isLoadingRemains = false;
        } else {
            super.remoteObjectLoaded(node);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
        }
    }

    private void createInners() {
        this.table = new Table2(true, Words.ADD, true, false);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                ReturnMoneyComplete mon = new ReturnMoneyComplete();
                mon.setPrice(new PriceComplete(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency(), Double.valueOf(0.0)));
                SOBReturnToolComponent.this.moneyList.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)mon, false, false), System.currentTimeMillis());
            }

            @Override
            public void childRemoved() {
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", 150, 150, 150));
        columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", 150, 150, 150));
        columns.add(new TableColumnInfo(Words.COMMENT, null, null, null, "", 150, 150, 150));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.getViewContainer().add(this.table);
    }

    @Override
    public String getTitleString() {
        return WordsToolkit.toUpperCase((String)Words.ARTICLE_NAME);
    }

    @Override
    protected String getFinishedText() {
        return Words.DATA_SAVED;
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingRemains) {
            return Words.LOAD_DATA;
        }
        return Words.SAVE_DATA;
    }

    @Override
    public String getTitleValue() {
        return this.flightLight.getOutboundCode();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            this.popup.hidePopUp(new Object[0]);
        } else if (isOK == PopupAction.OK_FOREGROUND) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    SOBReturnToolComponent.this.ensureAnimation();
                    SOBReturnToolComponent.this.setEnabled(false);
                    SOBReturnToolComponent.this.moneyList.commitThis();
                    ((SalesOnBoardServiceManager)ServiceManagerRegistry.getService(SalesOnBoardServiceManager.class)).updateReturnMoney(new FlightReference(SOBReturnToolComponent.this.flightLight.getId()), new ListWrapper((List)SOBReturnToolComponent.this.moneyList.getValue()));
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            SOBReturnToolComponent.this.popup.hidePopUp(new Object[0]);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog("Error while saving", (Component)SOBReturnToolComponent.this);
                            SOBReturnToolComponent.this.popup.hidePopUp(new Object[0]);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox type;
        private InputComboBox price;
        private TextField comment;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.type = new ComboBox(m.getNode().getChildNamed(ReturnMoneyComplete_.moneyTyp), NodeToolkit.getAffixList(MoneyTypComplete.class), ConverterRegistry.getConverter(MoneyTypeConverter.class));
            this.price = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{ReturnMoneyComplete_.price, PriceComplete_.price}), m.getNode().getChildNamed(new DtoField[]{ReturnMoneyComplete_.price, PriceComplete_.currency}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.price.setPossibleUnits(NodeToolkit.getAffixList(CurrencyComplete.class));
            this.comment = new TextField(m.getNode().getChildNamed(ReturnMoneyComplete_.comment));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.type.setProgress(1.0f);
            this.price.setProgress(1.0f);
            this.delete.setProgress(1.0f);
            this.comment.setProgress(1.0f);
            this.setLayout(new Layout());
            this.add(this.type);
            this.add(this.price);
            this.add(this.comment);
            this.add(this.delete);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (this.delete == source) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.type.kill();
            this.price.kill();
            this.comment.kill();
            this.delete.kill();
            this.type = null;
            this.price = null;
            this.comment = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(ReturnMoneyComplete_.moneyTyp).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new DtoField[]{ReturnMoneyComplete_.price, PriceComplete_.price}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(ReturnMoneyComplete_.comment).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.type.setEnabled(isEnabled);
            this.price.setEnabled(isEnabled);
            this.comment.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.comment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.comment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.comment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.comment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = SOBReturnToolComponent.this.layoutInheritedComponents(parent);
            if (SOBReturnToolComponent.this.table != null) {
                SOBReturnToolComponent.this.table.setLocation(SOBReturnToolComponent.this.border, SOBReturnToolComponent.this.border);
                SOBReturnToolComponent.this.table.setSize(parent.getWidth() - 2 * SOBReturnToolComponent.this.border, parent.getHeight() - SOBReturnToolComponent.this.border);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SOBReturnToolComponent.this.getInheritedComponentsHeight() + SOBReturnToolComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

