/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table;

import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class RowContentPanel
extends JPanel
implements LafListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private RowEditor view;

    public RowContentPanel(RowEditor view) {
        this.view = view;
        this.install();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.view.setEnabled(isEnabled);
    }

    public RowEditor getRowEditor() {
        return this.view;
    }

    protected void kill() {
        if (this.view != null) {
            this.view.kill();
        }
        this.view = null;
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    protected long getUnDoId() {
        return this.view.getUnDoId();
    }

    protected void grapDefaultFocus() {
        this.view.requestFocusInWindowNow();
    }

    private void install() {
        this.lafAttributeChanged("All attribues changed");
        this.view.setLocation(0, 0);
        this.setFocusable(true);
        this.addMouseListener(this);
        this.setLayout(new RowContentPanelLayout());
        this.add(this.view);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintChildren(g2);
    }

    @Override
    public void lafAttributeChanged(String att) {
        if ("All attribues changed".equals(att) || "inner_panel_background_color".equals(att)) {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.repaint(32L);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public int getPreferredHeight() {
        return (int)((RowContentPanelLayout)this.getLayout()).preferredLayoutSize(this).getHeight();
    }

    public Object getInnerSelectedDTO() {
        if (this.view != null) {
            return this.view.getInnerSelectedDTO();
        }
        return null;
    }

    private class RowContentPanelLayout
    extends DefaultLayout {
        private RowContentPanelLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            RowContentPanel.this.view.setLocation(0, 0);
            RowContentPanel.this.view.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, RowContentPanel.this.view != null ? RowContentPanel.this.view.getPreferredHeight() : 0);
        }
    }
}

