/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.commiter;

import ch.icit.pegasus.client.gui.table.commiter.ClientFileTransferListener;
import ch.icit.pegasus.client.gui.table.commiter.FileReferenceWriteBack;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import java.io.File;
import javax.swing.SwingUtilities;

public class FileCommitter
extends RemoteCommitter
implements FileTransferListener {
    private File ref;
    private ClientFileTransferListener delegationListener;
    private PegasusFileComplete uploadedFile;
    private FileReferenceWriteBack writeBackAlgorithm;
    private FileCategoryE category;

    public FileCommitter(File fileRef) {
        this(fileRef, FileCategoryE.DEFAULT);
    }

    public FileCommitter(File ref, FileCategoryE category) {
        this.ref = ref;
        this.category = category;
    }

    public void writeFileReferenceBack(PegasusFileComplete f) {
        if (this.writeBackAlgorithm != null) {
            this.writeBackAlgorithm.writeBack(f);
        }
    }

    public void setWriteBackAlgorithm(FileReferenceWriteBack run) {
        this.writeBackAlgorithm = run;
    }

    @Override
    public void commit(ClientFileTransferListener listener) {
        this.delegationListener = listener;
        if (this.ref == null) {
            return;
        }
        try {
            PegasusFileComplete f;
            PegasusFileComplete r = new PegasusFileComplete();
            r.setCategory(this.category);
            r.setLocalFile(this.ref);
            this.uploadedFile = f = FileTransferUtil.upload((PegasusFileComplete)r, (FileTransferListener[])new FileTransferListener[]{this});
            this.writeFileReferenceBack(f);
            if (this.delegationListener != null) {
                this.delegationListener.fileUploaded(this.ref, f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PegasusFileComplete getRemoteRef() {
        return this.uploadedFile;
    }

    public File getFile() {
        return this.ref;
    }

    @Override
    public long getRemaining() {
        return this.ref.length();
    }

    public void exceptionOccurred(Exception exception) {
        if (this.delegationListener != null) {
            this.delegationListener.exceptionOccurred(exception);
        } else {
            System.err.println("Unable to save file: " + exception.getMessage());
        }
    }

    public void statusChanged(final File file, final FileTransferState state) {
        if (this.delegationListener != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileCommitter.this.delegationListener.statusChanged(file, state);
                }
            });
        }
    }
}

