/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.combobox.CustomScrollBarUI;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ScrollPane
extends JScrollPane
implements Killable {
    private static final long serialVersionUID = 1L;
    protected boolean isKilled = false;
    private MyMouseWheelListener l;
    private static int defaultBlockIncrement = -1;

    public ScrollPane(boolean withInnerScroll) {
        if (withInnerScroll) {
            this.l = new MyMouseWheelListener();
            this.addMouseWheelListener(this.l);
        }
        this.init();
    }

    public ScrollPane() {
        this(true);
        this.init();
    }

    public ScrollPane(JComponent comp) {
        super(comp);
        this.init();
    }

    private void init() {
        this.getHorizontalScrollBar().setUI(new CustomScrollBarUI(0));
        this.getVerticalScrollBar().setUI(new CustomScrollBarUI(1));
        this.setBorder(BorderFactory.createEmptyBorder());
        int increment = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("scrollbar_block_increment"));
        this.getHorizontalScrollBar().setBlockIncrement(increment);
        this.getHorizontalScrollBar().setUnitIncrement(increment);
        this.getVerticalScrollBar().setBlockIncrement(increment);
        this.getVerticalScrollBar().setUnitIncrement(increment);
    }

    public void setUseSpecialBounds(boolean use, int min, int max) {
        if (use) {
            BoundedRangeModel model = this.getVerticalScrollBar().getModel();
            model.setMaximum(max);
            model.setMinimum(min);
        }
    }

    public void installDefaultColor() {
        Color c = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.setScrollPaneBackground(c);
        this.getViewport().setBackground(c);
    }

    public void setScrollPaneBackground(Color c) {
        this.setBackground(c);
        this.getHorizontalScrollBar().setBackground(c);
        this.getVerticalScrollBar().setBackground(c);
    }

    private void removeBarListeners(JScrollBar bar) {
        JPanelKillable.removeAllComponentListeners(bar);
        for (AdjustmentListener l : bar.getAdjustmentListeners()) {
            bar.removeAdjustmentListener(l);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        if (this.getVerticalScrollBar() != null) {
            this.removeBarListeners(this.getVerticalScrollBar());
        }
        if (this.getHorizontalScrollBar() != null) {
            this.removeBarListeners(this.getHorizontalScrollBar());
        }
        JPanelKillable.removeAllComponentListeners(this);
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this.setViewportView(null);
        this.removeAll();
        if (this.l != null) {
            this.l.kill();
            this.l = null;
        }
    }

    @Override
    public boolean isKilled() {
        return this.isKilled;
    }

    public void ensureViewable(JComponent selectedWidget) {
        Component c = this.getViewport().getView();
        Point p = SwingUtilities.convertPoint(selectedWidget.getParent(), selectedWidget.getX(), selectedWidget.getY(), c);
        Dimension d = selectedWidget.getSize();
        int current = this.getVerticalScrollBar().getValue();
        int max = c.getHeight() - this.getViewport().getHeight();
        int nv = 0;
        if (p.y > current && p.y + d.height < current + this.getViewport().getHeight()) {
            nv = current;
        } else if (p.y < current) {
            nv = p.y - 15;
        } else {
            int df = (int)((double)this.getViewport().getHeight() - d.getHeight());
            nv = p.y - df;
        }
        if (nv < 0) {
            nv = 0;
        }
        if (nv > max - this.getViewport().getHeight()) {
            nv = max - this.getViewport().getHeight();
        }
        this.getVerticalScrollBar().setValue(nv);
    }

    class MyMouseWheelListener
    implements MouseWheelListener {
        private JScrollBar bar;
        private int previousValue = 0;
        private JScrollPane parentScrollPane;

        private JScrollPane getParentScrollPane() {
            if (this.parentScrollPane == null) {
                Container parent;
                for (parent = ScrollPane.this.getParent(); !(parent instanceof JScrollPane) && parent != null; parent = parent.getParent()) {
                }
                this.parentScrollPane = (JScrollPane)parent;
            }
            return this.parentScrollPane;
        }

        public MyMouseWheelListener() {
            this.bar = ScrollPane.this.getVerticalScrollBar();
        }

        public void kill() {
            this.bar = null;
            this.parentScrollPane = null;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            JScrollPane parent = this.getParentScrollPane();
            if (parent != null) {
                if (e.getWheelRotation() < 0) {
                    if (this.bar.getValue() == 0 && this.previousValue == 0) {
                        parent.dispatchEvent(this.cloneEvent(e));
                    }
                } else if (this.bar.getValue() == this.getMax() && this.previousValue == this.getMax()) {
                    parent.dispatchEvent(this.cloneEvent(e));
                }
                this.previousValue = this.bar.getValue();
            } else {
                ScrollPane.this.removeMouseWheelListener(this);
            }
        }

        private int getMax() {
            return this.bar.getMaximum() - this.bar.getVisibleAmount();
        }

        private MouseWheelEvent cloneEvent(MouseWheelEvent e) {
            return new MouseWheelEvent((Component)this.getParentScrollPane(), e.getID(), e.getWhen(), e.getModifiers(), 1, 1, e.getClickCount(), false, e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
        }
    }
}

