/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.prototypes.ToggleSkinButton_NEW;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.i18n.Words;

public class LinearFunctionSign
extends ToggleSkinButton_NEW
implements NodeListener,
ButtonListener {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_ADD = 3;
    public static final int TYPE_SUBSTRACT = 5;
    private Node<Boolean> node;
    private int type = 3;

    public LinearFunctionSign(Node<Boolean> n) {
        super(DefaultSkins.FunctionSignIcon);
        if (((Boolean)n.getValue()).booleanValue()) {
            this.install(3);
        } else {
            this.install(5);
        }
        this.node = n;
        this.node.addNodeListener((NodeListener)this);
        this.addButtonListener(this);
        this.valueChanged(this.node);
    }

    public LinearFunctionSign(int type) {
        super(DefaultSkins.FunctionSignIcon);
        this.install(type);
    }

    @Override
    public boolean isChecked(boolean checked) {
        return 3 == this.type;
    }

    private void install(int type) {
        this.setToolTipText(Words.CHANGE_SIGN);
        this.type = type;
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void kill() {
        super.kill();
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.removeButtonListener(this);
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        boolean b = (Boolean)this.node.getValue();
        if (b) {
            this.setType(3);
        } else {
            this.setType(5);
        }
        this.repaint(32L);
    }

    private void setType(int t) {
        this.type = t;
        this.repaint(32L);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.switchNodeValue();
    }

    private void switchNodeValue() {
        boolean b = (Boolean)this.node.getValue();
        if (this.node instanceof Node) {
            this.node.setValue((Object)(!b ? 1 : 0), System.currentTimeMillis());
        }
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }
}

