/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.calendar;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.icons.impl.CheckBoxRO;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.toolkits.QuantityToolkit;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.production_new.productiontargets.DeliveryLoadToTruckTargetComplete;
import ch.icit.pegasus.server.core.dtos.production_new.productiontargets.DeliveryPreparationTargetComplete;
import ch.icit.pegasus.server.core.dtos.production_new.productiontargets.DeliveryProductionTargetComplete;
import ch.icit.pegasus.server.core.dtos.production_new.productiontargets.ProductProductionTargetComplete;
import ch.icit.pegasus.server.core.dtos.production_new.productiontargets.ProductionTargetComplete;
import ch.icit.pegasus.server.core.dtos.production_new.productiontargets.RecipeProductionTargetComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ProductionTargetTable
extends Table2 {
    private final RDProvider provider;
    private Node<List<ProductionTargetComplete>> allEntries;
    private CostCenterComplete filterDepartment;
    private CustomerLight filterCustomer;

    public ProductionTargetTable(RDProvider provider) {
        super(true, "Add");
        this.provider = provider;
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ProductionTargetTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                Node rowNode = ProductionTargetTable.this.generateRowNode();
                ProductionTargetTable.this.getModel().getNode().addChild(rowNode, 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("Produce Items", null, null, null, "", 0, 120, Integer.MAX_VALUE));
        int tw = 2 * this.getCellPadding() + CheckBox.getPreferredWidth();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo("Sum", null, null, null, "", 90, 90, 90));
        int dw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", dw, dw, dw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public void setNode(Node<List<ProductionTargetComplete>> node) {
        if (this.getModel().getNode() != null) {
            this.getModel().getNode().removeAllChilds();
        }
        this.allEntries = new ListNode();
        this.getModel().setNode((Node)new ListNode());
        HashMap<Object, Node> index = new HashMap<Object, Node>();
        for (ProductionTargetComplete productionTarget : (List)node.getValue()) {
            Node rowNode;
            if (productionTarget instanceof DeliveryProductionTargetComplete) {
                rowNode = this.generateRowNode();
                rowNode.getChildNamed(new String[]{"target"}).setValue((Object)productionTarget, 0L);
                rowNode.getChildNamed(new String[]{"validation"}).setValue((Object)false, 0L);
                rowNode.getChildNamed(new String[]{"items"}).addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)productionTarget, false, false), 0L);
                this.allEntries.addChild(rowNode, 0L);
                continue;
            }
            if (productionTarget instanceof RecipeProductionTargetComplete) {
                rowNode = (Node)index.get(((RecipeProductionTargetComplete)productionTarget).getRecipe());
                if (rowNode == null) {
                    rowNode = this.generateRowNode();
                    rowNode.getChildNamed(new String[]{"target"}).setValue((Object)productionTarget, 0L);
                    rowNode.getChildNamed(new String[]{"validation"}).setValue((Object)false, 0L);
                    this.allEntries.addChild(rowNode, 0L);
                    index.put(((RecipeProductionTargetComplete)productionTarget).getRecipe(), rowNode);
                }
                rowNode.getChildNamed(new String[]{"items"}).addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)productionTarget, false, false), 0L);
                continue;
            }
            if (!(productionTarget instanceof ProductProductionTargetComplete)) continue;
            rowNode = (Node)index.get(((ProductProductionTargetComplete)productionTarget).getProduct());
            if (rowNode == null) {
                rowNode = this.generateRowNode();
                rowNode.getChildNamed(new String[]{"target"}).setValue((Object)productionTarget, 0L);
                rowNode.getChildNamed(new String[]{"validation"}).setValue((Object)false, 0L);
                this.allEntries.addChild(rowNode, 0L);
                index.put(((ProductProductionTargetComplete)productionTarget).getProduct(), rowNode);
            }
            rowNode.getChildNamed(new String[]{"items"}).addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)productionTarget, false, false), 0L);
        }
        try {
            this.updateRows();
            this.filterRows();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateRows() throws Exception {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        Iterator it = this.allEntries.getFailSafeChildIterator();
        while (it.hasNext()) {
            ProductProductionTargetComplete rTarget;
            Node innerItem;
            Iterator it2;
            QuantityComplete sum;
            Node item = (Node)it.next();
            Object target = item.getChildNamed(new String[]{"target"}).getValue();
            if (target instanceof RecipeProductionTargetComplete) {
                sum = new QuantityComplete(Double.valueOf(0.0), ((RecipeProductionTargetComplete)target).getRecipe().getCurrentVariant().getYield().getUnit());
                it2 = item.getChildNamed(new String[]{"items"}).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    innerItem = (Node)it2.next();
                    rTarget = (RecipeProductionTargetComplete)innerItem.getValue();
                    sum = QuantityToolkit.add(rTarget.getQuantity(), sum);
                }
                item.getChildNamed(new String[]{"sum"}).setValue((Object)sum, 0L);
            }
            if (target instanceof ProductProductionTargetComplete) {
                sum = new QuantityComplete(Double.valueOf(0.0), settings.getPieceUnit());
                it2 = item.getChildNamed(new String[]{"items"}).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    innerItem = (Node)it2.next();
                    rTarget = (ProductProductionTargetComplete)innerItem.getValue();
                    sum = QuantityToolkit.add(rTarget.getQuantity(), sum);
                }
                item.getChildNamed(new String[]{"sum"}).setValue((Object)sum, 0L);
            }
            if (!(target instanceof DeliveryProductionTargetComplete)) continue;
            item.getChildNamed(new String[]{"sum"}).setValue((Object)new QuantityComplete(Double.valueOf(1.0), settings.getPieceUnit()), 0L);
        }
    }

    private void filterRows() {
        this.getModel().setNode((Node)new ListNode());
        Iterator it = this.allEntries.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node item = (Node)it.next();
            boolean showItem = false;
            if (this.filterCustomer == null && this.filterDepartment == null) {
                showItem = true;
            } else {
                Iterator it2 = item.getChildNamed(new String[]{"items"}).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    Node innerItem = (Node)it2.next();
                    Object target = innerItem.getValue();
                    if (!(target instanceof ProductionTargetComplete)) continue;
                    if (this.filterCustomer != null && (this.filterCustomer.equals((Object)((ProductionTargetComplete)target).getCustomer()) || this.filterCustomer.equals((Object)((ProductionTargetComplete)target).getFlight().getCustomer()))) {
                        showItem = true;
                    }
                    if (this.filterDepartment == null || !this.filterDepartment.equals((Object)((ProductionTargetComplete)target).getDepartment())) continue;
                    showItem = true;
                }
            }
            if (!showItem) continue;
            this.getModel().getNode().addChild(item, 0L);
        }
    }

    private Node generateRowNode() {
        DTONode rowNode = new DTONode();
        DTOProxyNode productionTarget = new DTOProxyNode();
        productionTarget.setName("target");
        Node validation = new Node();
        validation.setName("validation");
        Node sum = new Node();
        sum.setName("sum");
        ListNode items = new ListNode();
        items.setName("items");
        rowNode.addChild((Node)productionTarget, 0L);
        rowNode.addChild(validation, 0L);
        rowNode.addChild(sum, 0L);
        rowNode.addChild((Node)items, 0L);
        return rowNode;
    }

    public void filterByDepartment(CostCenterComplete department) {
        this.filterDepartment = department;
        this.filterRows();
    }

    public void filterByCustomer(CustomerLight customer) {
        this.filterCustomer = customer;
        this.filterRows();
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private TextLabel targetName;
        private CheckBoxRO validationState;
        private TextLabel amount;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            DateTimeConverter converter;
            super(m);
            this.setSelectable(true);
            Object target = this.model.getNode().getChildNamed(new String[]{"target"}).getValue();
            String itemName = "";
            if (target instanceof RecipeProductionTargetComplete) {
                itemName = "Recipe " + ((RecipeProductionTargetComplete)target).getRecipe().getNumber() + " " + ((RecipeProductionTargetComplete)target).getRecipe().getCurrentVariant().getRecipe().getCurrentVariant().getName();
            }
            if (target instanceof ProductProductionTargetComplete) {
                itemName = "Product " + ((ProductProductionTargetComplete)target).getProduct().getNumber() + " " + ((ProductProductionTargetComplete)target).getProduct().getCurrentVariant().getName();
            }
            if (target instanceof DeliveryPreparationTargetComplete) {
                converter = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
                itemName = "Prepare Flight " + ((DeliveryPreparationTargetComplete)target).getFlight().getOutboundCode() + " " + converter.convert((Object)((DeliveryPreparationTargetComplete)target).getFlight().getStd(), null, new Object[0]);
            }
            if (target instanceof DeliveryLoadToTruckTargetComplete) {
                converter = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
                itemName = "Deliver Flight " + ((DeliveryLoadToTruckTargetComplete)target).getFlight().getOutboundCode() + " " + converter.convert((Object)((DeliveryLoadToTruckTargetComplete)target).getFlight().getStd(), null, new Object[0]);
            }
            this.targetName = new TextLabel(itemName);
            this.validationState = new CheckBoxRO((Node<Boolean>)this.model.getNode().getChildNamed(new String[]{"validation"}));
            this.amount = new TextLabel(this.model.getNode().getChildNamed(new String[]{"sum"}), ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            this.setLayout(new Layout());
            this.add(this.targetName);
            this.add(this.validationState);
            this.add(this.amount);
        }

        @Override
        public Object getObject4Column(int column) {
            Object target = this.model.getNode().getChildNamed(new String[]{"target"}).getValue();
            if (target instanceof RecipeProductionTargetComplete) {
                return "1R" + ((RecipeProductionTargetComplete)target).getRecipe().getNumber();
            }
            if (target instanceof ProductProductionTargetComplete) {
                return "2P" + ((ProductProductionTargetComplete)target).getProduct().getNumber();
            }
            if (target instanceof DeliveryPreparationTargetComplete) {
                return "3P" + ((DeliveryPreparationTargetComplete)target).getFlight().getStd();
            }
            if (target instanceof DeliveryLoadToTruckTargetComplete) {
                return "4L" + ((DeliveryLoadToTruckTargetComplete)target).getFlight().getStd();
            }
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.targetName.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.targetName.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.targetName.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.targetName.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.validationState.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.targetName.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.validationState.setSize(TableRowImpl.this.validationState.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.amount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.amount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.amount.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.amount.getPreferredSize().getHeight());
            }
        }
    }
}

