/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.color;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.Color3DComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Color3DComplete_;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ColorChooser
extends JPanelFadable
implements Validatable,
Nodable,
ButtonListener,
Focusable {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextField> red;
    private TitledItem<TextField> green;
    private TitledItem<TextField> blue;
    private EditButton edit;
    private Node<Color3DComplete> node;

    public ColorChooser() {
        this.setOpaque(false);
        this.red = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), "Red [0-1]", TitledItem.TitledItemOrientation.NORTH);
        this.green = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), "Green [0-1]", TitledItem.TitledItemOrientation.NORTH);
        this.blue = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), "Blue [0-1]", TitledItem.TitledItemOrientation.NORTH);
        this.edit = new EditButton();
        this.edit.addButtonListener(this);
        this.setLayout(new AALayout());
        this.add(this.red);
        this.add(this.green);
        this.add(this.blue);
        this.add(this.edit);
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        this.red.getElement().setNode(node.getChildNamed(Color3DComplete_.red));
        this.green.getElement().setNode(node.getChildNamed(Color3DComplete_.green));
        this.blue.getElement().setNode(node.getChildNamed(Color3DComplete_.blue));
    }

    @Override
    public void setValid() {
        this.red.getElement().setValid();
        this.green.getElement().setValid();
        this.blue.getElement().setValid();
    }

    @Override
    public void setInvalid() {
        this.red.getElement().setInvalid();
        this.green.getElement().setInvalid();
        this.blue.getElement().setInvalid();
    }

    @Override
    public void setWarning() {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.red.setEnabled(isEnabled);
        this.green.setEnabled(isEnabled);
        this.blue.setEnabled(isEnabled);
        this.edit.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.red.kill();
        this.green.kill();
        this.blue.kill();
        this.edit.kill();
        this.red = null;
        this.green = null;
        this.blue = null;
        this.edit = null;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.edit) {
            double r = (Double)this.node.getChildNamed(Color3DComplete_.red).getValue();
            double g = (Double)this.node.getChildNamed(Color3DComplete_.green).getValue();
            double b = (Double)this.node.getChildNamed(Color3DComplete_.blue).getValue();
            int ri = (int)(255.0 * r);
            int gi = (int)(255.0 * g);
            int bi = (int)(255.0 * b);
            InnerPopupFactory.showColorChooser(new Color(ri, gi, bi), x, y, source, new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    if (xargs == null) {
                        return;
                    }
                    Color color = (Color)xargs[0];
                    long id = System.currentTimeMillis();
                    double rv = (double)color.getRed() / 255.0;
                    double gv = (double)color.getGreen() / 255.0;
                    double bv = (double)color.getBlue() / 255.0;
                    ColorChooser.this.node.getChildNamed(Color3DComplete_.red).setValue((Object)rv, id);
                    ColorChooser.this.node.getChildNamed(Color3DComplete_.green).setValue((Object)gv, id);
                    ColorChooser.this.node.getChildNamed(Color3DComplete_.blue).setValue((Object)bv, id);
                }
            });
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.addAll(this.red.getFocusComponents());
        a.addAll(this.green.getFocusComponents());
        a.addAll(this.blue.getFocusComponents());
        a.addAll(this.edit.getFocusComponents());
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.red.setVisibleContainer(pane);
        this.green.setVisibleContainer(pane);
        this.blue.setVisibleContainer(pane);
        this.edit.setVisibleContainer(pane);
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.red.requestFocusInWindowNow();
    }

    @Override
    public void setPermanent(boolean isPermantent) {
    }

    private class AALayout
    extends DefaultLayout {
        private AALayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ColorChooser.this.red.setLocation(0, 0);
            ColorChooser.this.red.setSize(100, (int)ColorChooser.this.red.getPreferredSize().getHeight());
            ColorChooser.this.green.setLocation(ColorChooser.this.red.getX() + ColorChooser.this.red.getWidth() + 15, ColorChooser.this.red.getY());
            ColorChooser.this.green.setSize(100, (int)ColorChooser.this.green.getPreferredSize().getHeight());
            ColorChooser.this.blue.setLocation(ColorChooser.this.green.getX() + ColorChooser.this.green.getWidth() + 15, ColorChooser.this.green.getY());
            ColorChooser.this.blue.setSize(100, (int)ColorChooser.this.blue.getPreferredSize().getHeight());
            ColorChooser.this.edit.setLocation(ColorChooser.this.blue.getX() + ColorChooser.this.blue.getWidth() + 15, (int)((double)(ColorChooser.this.blue.getY() + ColorChooser.this.blue.getHeight()) - ColorChooser.this.edit.getPreferredSize().getHeight() - 4.0));
            ColorChooser.this.edit.setSize(ColorChooser.this.edit.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension((int)(345.0 + ColorChooser.this.edit.getPreferredSize().getWidth()), (int)ColorChooser.this.red.getPreferredSize().getHeight());
        }
    }
}

