/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.combobox.utils;

import ch.icit.pegasus.client.gui.utils.combobox.activators.ActivationAdapter;
import ch.icit.pegasus.client.gui.utils.combobox.iconmapper.IconMapper;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;

public class PopupInsertElement
implements Comparable<PopupInsertElement> {
    private Object userObject;
    private String text;
    private String displayedText;
    private int lastWidth = -1;
    private boolean isOver = false;

    public PopupInsertElement(Object userObject, String text) {
        this.userObject = userObject;
        this.text = text;
    }

    public Skin1Field getPaintingSkin(IconMapper iconMapper) {
        if (iconMapper != null) {
            return iconMapper.mapIcon(this.userObject);
        }
        return null;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public String getText() {
        return this.text;
    }

    public ActivationAdapter.ActivationType isActivated(ActivationAdapter activitionAdapter) {
        if (activitionAdapter != null) {
            return activitionAdapter.isElementActive(this.userObject);
        }
        return ActivationAdapter.ActivationType.OK;
    }

    public String getDisplayString(int maxWidth, Font f, Component printParent) {
        if (this.lastWidth == -1 || this.lastWidth != maxWidth) {
            int border;
            this.lastWidth = maxWidth;
            this.displayedText = this.text;
            FontMetrics fm = printParent.getFontMetrics(f);
            int tempW = fm.stringWidth(this.displayedText);
            if (tempW < maxWidth) {
                return this.displayedText;
            }
            String tempS = this.displayedText;
            if (this.text == null || this.text != null && this.text.equals("") || maxWidth == 0 || f == null) {
                return "";
            }
            int textWidth = fm.stringWidth(this.text);
            if (textWidth > maxWidth - 2 * (border = 5)) {
                int currentIndex = this.text.length() - 1;
                String sub = this.text.substring(0, currentIndex);
                sub = sub + "...";
                textWidth = fm.stringWidth(sub);
                boolean out = false;
                while (textWidth > maxWidth - 2 * border && !out) {
                    if (--currentIndex < 0) {
                        out = true;
                        sub = ".";
                        textWidth = fm.stringWidth(sub);
                        continue;
                    }
                    sub = this.text.substring(0, currentIndex);
                    sub = sub + "...";
                    textWidth = fm.stringWidth(sub);
                }
                this.displayedText = sub;
            } else {
                this.displayedText = this.text;
            }
        }
        return this.displayedText;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isOver() {
        return this.isOver;
    }

    public void setOver(boolean isOver) {
        this.isOver = isOver;
    }

    @Override
    public int compareTo(PopupInsertElement o) {
        if (this.userObject != null && o.userObject != null && this.userObject instanceof Node && o.userObject instanceof Node) {
            Node n1 = (Node)this.userObject;
            Node n2 = (Node)o.userObject;
            if (n1.getValue() instanceof Comparable && n2.getValue() instanceof Comparable) {
                Comparable c1 = (Comparable)n1.getValue();
                Comparable c2 = (Comparable)n2.getValue();
                if (c1 == null) {
                    return c2 == null ? 0 : 1;
                }
                if (c2 == null) {
                    return -1;
                }
                if (c1 instanceof BasicArticleLight) {
                    if (c2 instanceof BasicArticleLight) {
                        return c1.compareTo(c2);
                    }
                    return 1;
                }
                if (c1 instanceof RecipeVariantLight) {
                    if (c2 instanceof RecipeVariantLight) {
                        return c1.compareTo(c2);
                    }
                    return -1;
                }
                return c1.compareTo(c2);
            }
        }
        if (this.text == null) {
            return o.text == null ? 0 : 1;
        }
        if (o.text == null) {
            return -1;
        }
        return o.text.compareTo(this.text);
    }
}

