/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.datechooser;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Component;
import java.awt.Font;
import java.sql.Date;

public class DateRenderer
extends TextLabel {
    private static final long serialVersionUID = 1L;
    private static int prefWidth = -1;
    private Date currentDate;

    public DateRenderer(Node node) {
        super(node, ConverterRegistry.getConverter(DateConverter.class));
    }

    public DateRenderer() {
        this((Node)null);
    }

    public DateRenderer(Date date) {
        super(((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)date, null, new Object[0]));
        this.currentDate = date;
    }

    public Date getDate() {
        return this.currentDate;
    }

    public static int getPreferredWidth(Component c) {
        DateRenderer.ensurePrefWidth(c);
        return prefWidth;
    }

    private static void ensurePrefWidth(Component c) {
        if (prefWidth == -1) {
            int alphanuerics;
            String t = AttributeLoader.getAttributeLoader().getAttribute("datechooser_min_text");
            Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            prefWidth = alphanuerics = c.getFontMetrics(f).stringWidth(t);
        }
    }

    public static String getValueString(Date value) {
        return ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)value, null, new Object[0]);
    }
}

