/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.datechooser;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserListener;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooserListener;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.textfield.AbstractTextField;
import ch.icit.pegasus.client.gui.utils.textfield.DateTimeTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class DateTimeChooser
extends DefaultPanel
implements Nodable,
DateChooserListener,
TextFieldListener,
UIStateLoadable {
    private static final long serialVersionUID = 1L;
    private DateChooser date = new DateChooser(null, true);
    private DateTimeTextField time = new DateTimeTextField(TextFieldType.DAYTIME);
    private String cId;
    private DateTimeChooserListener filterChain;

    public DateTimeChooser(Node<Timestamp> dateNode) {
        this.setLayout(new Layout());
        this.setNode(dateNode);
        this.time.setProgress(1.0f);
        this.date.setProgress(1.0f);
        this.date.setIsTimestamp(true);
        this.date.addDateChooserListener(this);
        this.time.addTextFieldListener(this);
        this.add(this.date);
        this.add(this.time);
    }

    public static int getPreferredWidth(Component c) {
        int tw = DateChooser.getPreferredWidth(c, false);
        tw += 2;
        return tw += DateTimeTextField.getPreferredWidth(c, TextFieldType.DAYTIME);
    }

    @Override
    public void setNode(Node<?> dateNode) {
        this.date.setNode((Node)dateNode);
        this.time.setNode((Node)dateNode);
    }

    public Node getNode() {
        return this.date.getNode();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.date);
        CheckedListAdder.addToList(a, this.time);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.date.setVisibleContainer(pane);
        this.time.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.date.requestFocusInWindowNow();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.date.setEnabled(isEnabled);
        this.time.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.date.kill();
        this.time.kill();
        this.date = null;
        this.time = null;
    }

    public Timestamp getTimestamp() {
        if (this.date.getNode().getValue() instanceof Timestamp) {
            return (Timestamp)this.date.getNode().getValue();
        }
        Date cDate = (Date)this.date.getNode().getValue();
        return new Timestamp(cDate.getTime());
    }

    public DateChooser getDateChooser() {
        return this.date;
    }

    public DateTimeTextField getDateTimeTextField() {
        return this.time;
    }

    public void setCId(String id) {
        this.cId = id;
    }

    public String getCId() {
        return this.cId;
    }

    public void addDateTimeChooserListener(DateTimeChooserListener filterChain) {
        this.filterChain = filterChain;
    }

    @Override
    public void valueChanged(AbstractTextField field) {
        if (this.filterChain != null) {
            this.filterChain.dateTimeChanged(this, this.getTimestamp());
        }
    }

    @Override
    public void dateChanged(DateChooser source, java.util.Date selectedDate) {
        if (this.filterChain != null) {
            this.filterChain.dateTimeChanged(this, this.getTimestamp());
        }
    }

    @Override
    public String getPersistString() {
        String t = "";
        t = t + this.date.getPersistString() + "|";
        t = t + this.time.getPersistString();
        return t;
    }

    @Override
    public void loadState(String state, String id) {
        String[] splits = state.split("\\|");
        if (splits.length >= 1) {
            this.date.loadState(splits[0], "dateTime_date");
        }
        if (splits.length >= 2) {
            this.time.loadState(splits[1], "dateTime_time");
        }
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public boolean shouldPersist() {
        return true;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)DateTimeChooser.this.date.getPreferredSize().getHeight();
            int w = (int)(DateTimeChooser.this.date.getPreferredSize().getWidth() + 2.0 + DateTimeChooser.this.time.getPreferredSize().getWidth());
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            DateTimeChooser.this.date.setLocation(0, 0);
            DateTimeChooser.this.date.setSize(DateTimeChooser.this.date.getPreferredSize());
            DateTimeChooser.this.time.setLocation(DateTimeChooser.this.date.getWidth() + 2, 0);
            DateTimeChooser.this.time.setSize(52, (int)DateTimeChooser.this.time.getPreferredSize().getHeight());
        }
    }
}

