/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.layouter;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.panels.DisablePanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;

public class DetailsParagraphLayout
extends DefaultLayout
implements AttributeListener {
    private int vertical_border = 10;
    private int horizontal_border = 10;
    int startHBorder = 15;
    private DisablePanel disablePanel;
    private LoadingAnimation animation;
    private final ArrayList<ArrayList<Component>> components = new ArrayList();
    private final ArrayList<ArrayList<TableLayoutConstraint>> constrains = new ArrayList();

    public ArrayList<ArrayList<Component>> getComponents() {
        return this.components;
    }

    public void setLoadingAnimation(LoadingAnimation l) {
        this.animation = l;
    }

    public void setDisablePanel(DisablePanel p) {
        this.disablePanel = p;
    }

    public void setVerticalBorder(int b) {
        this.vertical_border = b;
    }

    public void setHorizontalStartBorder(int b) {
        this.startHBorder = b;
    }

    public void setHorizontalBorder(int b) {
        this.horizontal_border = b;
    }

    public int getVerticalBorder() {
        return this.vertical_border;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (comp instanceof LoadingAnimation || comp instanceof DisablePanel) {
            return;
        }
        if (constraints == null) {
            return;
        }
        TableLayoutConstraint cons = (TableLayoutConstraint)constraints;
        while (cons.getColumn() >= this.components.size()) {
            this.components.add(new ArrayList());
            this.constrains.add(new ArrayList());
        }
        ArrayList<Component> col = this.components.get(cons.getColumn());
        ArrayList<TableLayoutConstraint> col2 = this.constrains.get(cons.getColumn());
        while (cons.getRow() >= col.size()) {
            col.add(null);
            col2.add(null);
        }
        col.set(cons.getRow(), comp);
        col2.set(cons.getRow(), cons);
    }

    private int getRowHeight(int column, int maxRow) {
        int currentY = 0;
        ArrayList<Component> columns = this.components.get(column);
        int cR = 0;
        for (Component row : columns) {
            if (cR <= maxRow && row != null) {
                currentY = (int)((double)currentY + row.getPreferredSize().getHeight());
            }
            ++cR;
        }
        return currentY + this.vertical_border;
    }

    private int getCurrentY4Span(int maxRow, int startcolumn, int maxcolumn) {
        int maxY = 0;
        for (int currentC = startcolumn; currentC < this.components.size() && currentC < maxcolumn; ++currentC) {
            int cY = this.getRowHeight(currentC, maxRow);
            if (cY <= maxY) continue;
            maxY = cY;
        }
        return maxY;
    }

    @Override
    public void layoutContainer(Container parent) {
        int startY;
        int currentY;
        int w = parent.getWidth();
        int currentX = this.horizontal_border;
        int maxY = currentY = (startY = this.vertical_border);
        if (this.disablePanel != null) {
            this.disablePanel.setLocation(0, 0);
            this.disablePanel.setSize(parent.getSize());
        }
        if (this.animation != null) {
            this.animation.setLocation((int)((double)parent.getWidth() - this.animation.getPreferredSize().getWidth()) - 2, (int)((double)parent.getHeight() - this.animation.getPreferredSize().getHeight()) / 2);
            this.animation.setSize(this.animation.getPreferredSize());
        }
        int col = 0;
        for (ArrayList<Component> columns : this.components) {
            int maxWidth = 0;
            int rowC = 0;
            for (Component row : columns) {
                if (row != null) {
                    int cmY;
                    currentX = this.getCurrentX(rowC, col);
                    TableLayoutConstraint cons = this.constrains.get(col).get(rowC);
                    currentY = cmY = this.getCurrentY4Span(rowC - 1, col, col + cons.getxSpan());
                    if (rowC > 0) {
                        currentY += rowC * this.vertical_border;
                    }
                    row.setLocation(currentX, currentY);
                    int tw = (int)row.getPreferredSize().getWidth();
                    int th = (int)row.getPreferredSize().getHeight();
                    Dimension pref = this.preferredLayoutRowSize(row, rowC);
                    int dif = w - (int)(pref.getWidth() + (double)(2 * this.startHBorder));
                    if (cons.getxSpan() != 1) {
                        tw = w - 2 * this.startHBorder;
                    } else if (dif != 0 && cons.getxExpand() != -1.0) {
                        double factor = cons.getxExpand();
                        int add = (int)((double)dif * factor);
                        tw += add;
                    }
                    if (tw > w) {
                        tw = w;
                    }
                    row.setSize(tw, th);
                    if ((double)cons.getxSpan() == 1.0 && maxWidth < row.getWidth()) {
                        maxWidth = row.getWidth();
                    }
                    currentY += row.getHeight() + this.vertical_border;
                }
                ++rowC;
            }
            ++col;
            if (maxY < currentY) {
                maxY = currentY;
            }
            currentX += maxWidth + this.horizontal_border;
            currentY = startY;
        }
    }

    public int getCurrentX(int currentRow, int currentColumn) {
        if (currentColumn == 0) {
            return this.startHBorder;
        }
        int column = 0;
        for (ArrayList<Component> columns : this.components) {
            int rowC = 0;
            for (Component row : columns) {
                if (rowC == currentRow && column == currentColumn - 1) {
                    return row.getX() + row.getWidth() + this.horizontal_border;
                }
                ++rowC;
            }
            ++column;
        }
        return 0;
    }

    public Dimension preferredLayoutRowSize(Component parent, int effectedRow) {
        int prefW = 0;
        int colC = 0;
        for (ArrayList<Component> columns : this.components) {
            int rowC = 0;
            for (Component row : columns) {
                if (row != null && rowC == effectedRow) {
                    prefW = (int)((double)prefW + row.getPreferredSize().getWidth());
                    prefW += this.horizontal_border;
                }
                ++rowC;
            }
            ++colC;
        }
        return new Dimension(prefW -= this.horizontal_border, 0);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int startY;
        int currentY;
        int currentX = this.horizontal_border;
        int maxY = currentY = (startY = this.vertical_border);
        int col = 0;
        for (ArrayList<Component> columns : this.components) {
            int maxWidthI = 0;
            int rowC = 0;
            for (Component row : columns) {
                if (row != null) {
                    int cmY;
                    TableLayoutConstraint cons = this.constrains.get(col).get(rowC);
                    currentY = cmY = this.getCurrentY4Span(rowC - 1, col, col + cons.getxSpan());
                    if (rowC > 0) {
                        currentY += rowC * this.vertical_border;
                    }
                    if ((double)cons.getxSpan() == 1.0 && (double)maxWidthI < row.getPreferredSize().getWidth()) {
                        maxWidthI = (int)row.getPreferredSize().getWidth();
                    }
                    currentY = (int)((double)currentY + (row.getPreferredSize().getHeight() + (double)this.vertical_border));
                }
                ++rowC;
            }
            ++col;
            if (maxY < currentY) {
                maxY = currentY;
            }
            currentX += maxWidthI + this.horizontal_border;
            currentY = startY;
        }
        return new Dimension(currentX, ++maxY);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp instanceof LoadingAnimation || comp instanceof DisablePanel) {
            return;
        }
        for (ArrayList<Component> column : this.components) {
            if (!column.contains(comp)) continue;
            column.remove(comp);
        }
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.vertical_border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_editor_paragraph_vertical_gap"));
            this.horizontal_border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_editor_paragraph_horizontal_gap"));
        }
    }
}

