/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.tabbed.TabButton;
import ch.icit.pegasus.client.gui.utils.tabbed.TabListener;
import ch.icit.pegasus.client.gui.utils.tabbed.TabbedButtonPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class TabbedItem<T extends Component>
extends DefaultPanel
implements TabListener {
    private static final long serialVersionUID = 1L;
    private Map<Button, T> buttonViewMap = new HashMap<Button, T>();
    private List<T> views = new ArrayList<T>();
    private T selectedView;
    private TabbedButtonPanel buttonPanel;
    private boolean isPrefSizeSet;
    private Dimension prefSize;

    public TabbedItem() {
        this.setLayout(new TabbedTLayout());
        this.setOpaque(false);
        this.setProgress(1.0f);
        this.buttonPanel = new TabbedButtonPanel(false);
        this.buttonPanel.addTabListener(this);
        this.add(this.buttonPanel);
    }

    public void clearTabbedItem() {
        this.clear(false);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.clear(true);
        this.selectedView = null;
        this.buttonPanel.kill();
        this.buttonPanel = null;
    }

    public List<T> getViews() {
        return Collections.unmodifiableList(this.views);
    }

    public void removeHeaders() {
        this.buttonPanel.clear();
    }

    protected void clear(boolean withNull) {
        Set<Map.Entry<Button, T>> a = this.buttonViewMap.entrySet();
        for (Map.Entry<Button, T> b : a) {
            b.getKey().kill();
            if (!(b.getValue() instanceof Killable)) continue;
            ((Killable)b.getValue()).kill();
        }
        this.views.clear();
        this.buttonViewMap.clear();
        this.selectedView = null;
        if (withNull) {
            this.buttonViewMap = null;
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.selectedView != null) {
            ((Component)this.selectedView).setEnabled(isEnabled);
        }
        this.buttonPanel.setEnabled(isEnabled);
        for (Component t : this.views) {
            t.setEnabled(isEnabled);
        }
    }

    public void setPreferredSize(int w, int h) {
        this.prefSize = new Dimension(w, h);
        this.isPrefSizeSet = true;
    }

    public void addView(T view, TabButton but, boolean autoSelect) {
        this.buttonViewMap.put(but, view);
        this.views.add(view);
        this.buttonPanel.addTabButton(but);
        this.add((Component)view);
        if (autoSelect) {
            if (this.selectedView == null) {
                for (Map.Entry<Button, T> t : this.buttonViewMap.entrySet()) {
                    if (!((Component)t.getValue()).equals(view)) continue;
                    this.buttonPanel.select((TabButton)t.getKey());
                    this.newTabSelected(t.getKey());
                }
            } else {
                if (view instanceof Fadable) {
                    ((Fadable)view).setProgress(0.0f);
                }
                ((Component)view).setVisible(false);
            }
        } else {
            if (view instanceof Fadable) {
                ((Fadable)view).setProgress(0.0f);
            }
            ((Component)view).setVisible(false);
        }
    }

    public void addView(T view, TabButton but) {
        this.addView(view, but, true);
    }

    protected void selectT(T l) {
        if (this.selectedView != null) {
            if (this.selectedView instanceof Fadable) {
                ((Fadable)this.selectedView).fadeOut(false);
            } else {
                ((Component)this.selectedView).setVisible(false);
            }
        }
        this.selectedView = l;
        if (this.selectedView != null) {
            if (this.selectedView instanceof Fadable) {
                ((Fadable)this.selectedView).fadeIn();
            } else {
                ((Component)this.selectedView).setVisible(true);
            }
        }
        this.updateFocusCycle();
    }

    public abstract void updateFocusCycle();

    @Override
    public void newTabSelected(Button selectedTab) {
        Component view = (Component)this.buttonViewMap.get(selectedTab);
        this.selectT(view);
    }

    public T getSelectedView() {
        return this.selectedView;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.selectedView instanceof Focusable ? ((Focusable)this.selectedView).getFocusComponents() : null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class TabbedTLayout
    extends DefaultLayout {
        private TabbedTLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (TabbedItem.this.buttonPanel != null) {
                TabbedItem.this.buttonPanel.setLocation(0, 0);
                TabbedItem.this.buttonPanel.setSize(parent.getWidth(), (int)TabbedItem.this.buttonPanel.getPreferredSize().getHeight());
            }
            for (Component view : TabbedItem.this.views) {
                view.setLocation(0, TabbedItem.this.buttonPanel.getY() + TabbedItem.this.buttonPanel.getHeight());
                view.setSize(parent.getWidth(), parent.getHeight() - view.getY());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)TabbedItem.this.buttonPanel.getPreferredSize().getHeight();
            int w = (int)TabbedItem.this.buttonPanel.getPreferredSize().getWidth();
            if (TabbedItem.this.selectedView != null) {
                h = (int)((double)h + TabbedItem.this.selectedView.getPreferredSize().getHeight());
                if ((double)w < TabbedItem.this.selectedView.getPreferredSize().getWidth()) {
                    w = (int)TabbedItem.this.selectedView.getPreferredSize().getWidth();
                }
            }
            w = TabbedItem.this.isPrefSizeSet ? (int)TabbedItem.this.prefSize.getWidth() : (w += 25);
            return new Dimension(w, h);
        }
    }
}

