/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ArticleCategoryDetailsPopupInsert
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private CheckBox useCustomsData;
    private TitledItem<TextField> customsNo;
    private TitledItem<TextField> tariff;
    private TitledItem<TextField> entry;
    private Node<ArticleCategoryLight> catNode;

    public ArticleCategoryDetailsPopupInsert(Node<ArticleCategoryLight> catNode) {
        this.useCustomsData = new CheckBox((Node<Boolean>)catNode.getChildNamed(ArticleCategoryLight_.useCustomsData));
        this.customsNo = new TitledItem<TextField>(new TextField(catNode.getChildNamed(ArticleCategoryLight_.customsNumber)), Words.CUSTOMS_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.tariff = new TitledItem<TextField>(new TextField(catNode.getChildNamed(ArticleCategoryLight_.customsTariff)), Words.CUSTOMS_TARIFF, TitledItem.TitledItemOrientation.NORTH);
        this.entry = new TitledItem<TextField>(new TextField(catNode.getChildNamed(ArticleCategoryLight_.customsAdditionalEntry)), Words.CUSTOMS_ADDITIONAL_ENTRY, TitledItem.TitledItemOrientation.NORTH);
        this.useCustomsData.addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        this.setLayout(new Layout());
        this.add(this.useCustomsData);
        this.add(this.customsNo);
        this.add(this.tariff);
        this.add(this.entry);
        this.setEnabled(true);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.useCustomsData);
        CheckedListAdder.addToList(a, this.customsNo);
        CheckedListAdder.addToList(a, this.tariff);
        CheckedListAdder.addToList(a, this.entry);
        return a;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.useCustomsData.setEnabled(enabled);
        boolean rest = enabled && this.useCustomsData.isChecked();
        this.customsNo.setEnabled(rest);
        this.tariff.setEnabled(rest);
        this.entry.setEnabled(rest);
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        Object[] o = new Object[]{this.catNode};
        return o;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(450, 350);
        }

        @Override
        public void layoutContainer(Container parent) {
            int horizontalBorder = 10;
            int inner_horizontalBorder = 5;
            int inner_verticalBorder = 5;
            int cy = 5;
            int w = parent.getWidth();
            int w3tl = (int)(((double)w - ((double)(2 * horizontalBorder + 3 * inner_horizontalBorder) + ArticleCategoryDetailsPopupInsert.this.useCustomsData.getPreferredSize().getWidth())) / 3.0);
            ArticleCategoryDetailsPopupInsert.this.useCustomsData.setLocation(horizontalBorder, (int)((double)(cy + inner_verticalBorder) + ArticleCategoryDetailsPopupInsert.this.customsNo.getPreferredSize().getHeight() - ArticleCategoryDetailsPopupInsert.this.useCustomsData.getPreferredSize().getHeight()) - 3);
            ArticleCategoryDetailsPopupInsert.this.useCustomsData.setSize(ArticleCategoryDetailsPopupInsert.this.useCustomsData.getPreferredSize());
            ArticleCategoryDetailsPopupInsert.this.customsNo.setLocation(ArticleCategoryDetailsPopupInsert.this.useCustomsData.getX() + ArticleCategoryDetailsPopupInsert.this.useCustomsData.getWidth() + inner_horizontalBorder, cy + inner_verticalBorder);
            ArticleCategoryDetailsPopupInsert.this.customsNo.setSize(w3tl, (int)ArticleCategoryDetailsPopupInsert.this.customsNo.getPreferredSize().getHeight());
            ArticleCategoryDetailsPopupInsert.this.tariff.setLocation(ArticleCategoryDetailsPopupInsert.this.customsNo.getX() + ArticleCategoryDetailsPopupInsert.this.customsNo.getWidth() + inner_horizontalBorder, cy + inner_verticalBorder);
            ArticleCategoryDetailsPopupInsert.this.tariff.setSize(w3tl, (int)ArticleCategoryDetailsPopupInsert.this.customsNo.getPreferredSize().getHeight());
            ArticleCategoryDetailsPopupInsert.this.entry.setLocation(ArticleCategoryDetailsPopupInsert.this.tariff.getX() + ArticleCategoryDetailsPopupInsert.this.tariff.getWidth() + inner_horizontalBorder, cy + inner_verticalBorder);
            ArticleCategoryDetailsPopupInsert.this.entry.setSize(w3tl, (int)ArticleCategoryDetailsPopupInsert.this.entry.getPreferredSize().getHeight());
            cy = ArticleCategoryDetailsPopupInsert.this.tariff.getY() + ArticleCategoryDetailsPopupInsert.this.tariff.getHeight() + inner_verticalBorder;
        }
    }
}

