/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.StringPopUpInsert;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import java.awt.Component;

public class ProductInfoLoadingPopupInsert
extends StringPopUpInsert {
    private static final long serialVersionUID = 1L;
    private Node prodNode;
    private int currentMagicNumber;
    private boolean isVariant = false;
    private Node variantNode;

    public ProductInfoLoadingPopupInsert(Node productNode, int magicNr) {
        super((String)null);
        this.currentMagicNumber = magicNr;
        if (productNode.getValue() instanceof ProductVariantReference) {
            this.prodNode = productNode.getChildNamed(new String[]{"product"});
            this.variantNode = productNode;
            this.isVariant = true;
        } else {
            this.prodNode = productNode;
        }
        if (this.prodNode.getValue(ProductComplete.class) == null) {
            if (this.prodNode.getValue(ProductReference.class) == null) {
                this.remoteObjectLoaded(productNode);
            } else {
                this.ensureAnimation("Load Product", "Load Product");
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        ProductReference l = (ProductReference)ProductInfoLoadingPopupInsert.this.prodNode.getValue(ProductReference.class);
                        try {
                            ProductComplete ac = (ProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductByReference(l).getValue();
                            ProductInfoLoadingPopupInsert.this.prodNode.removeExistingValues();
                            ProductInfoLoadingPopupInsert.this.prodNode.setValue((Object)ac, 0L);
                            if (ProductInfoLoadingPopupInsert.this.variantNode != null && ProductInfoLoadingPopupInsert.this.variantNode.getValue(ProductVariantComplete.class) == null) {
                                ProductVariantReference vr = (ProductVariantReference)ProductInfoLoadingPopupInsert.this.variantNode.getValue();
                                ProductVariantComplete fv = (ProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantByReference(new ProductVariantReference(vr.getId())).getValue();
                                ProductInfoLoadingPopupInsert.this.variantNode.removeExistingValues();
                                ProductInfoLoadingPopupInsert.this.variantNode.setValue((Object)fv, 0L);
                                ProductInfoLoadingPopupInsert.this.variantNode.updateNode();
                            }
                            return ProductInfoLoadingPopupInsert.this.prodNode;
                        }
                        catch (ClientServerCallException e) {
                            ViewNode r = new ViewNode("Error");
                            r.setValue((Object)e, 0L);
                            return r;
                        }
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return ProductInfoLoadingPopupInsert.this;
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            }
        } else {
            this.remoteObjectLoaded(productNode);
        }
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (node != null && node.getValue() instanceof ClientServerCallException) {
            InnerPopupFactory.showErrorDialog((Exception)((Object)((ClientServerCallException)((Object)node.getValue()))), (Component)this);
            this.hideAnimation();
            return;
        }
        this.hideAnimation();
        String t = null;
        t = this.variantNode != null ? ProductToolkit.getProductInfoString((ProductComplete)this.prodNode.getValue(ProductComplete.class), (ProductVariantLight)this.variantNode.getValue(ProductVariantLight.class), this.currentMagicNumber) : ProductToolkit.getProductInfoString((ProductComplete)this.prodNode.getValue(ProductComplete.class), this.currentMagicNumber);
        this.initMultiLabelThings(t, true);
    }
}

