/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.ScreenViewProvider;
import ch.icit.pegasus.client.converter.LocationConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.nullscreen.EmptySpace;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Screen;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.LoadablePopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class SwitchLocationPopupInsert
extends LoadablePopupInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> location;
    private boolean isSwitched = false;
    private UserComplete user;
    private MainFrame mainFrame;

    public SwitchLocationPopupInsert(UserComplete currentUser, MainFrame mainFrame) {
        this.user = currentUser;
        this.mainFrame = mainFrame;
        this.setLayout(new Layout());
        this.showAnimation(Words.LOAD_LOCATIONS);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                List t = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getEligibleLocations().getList();
                Node n = new Node();
                n.setValue((Object)t, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SwitchLocationPopupInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND && !this.isSwitched) {
            if (!ThreadSafeLoader.isOperationFinished() || !ThreadSafeLoader.isBackgroundOperationFinished()) {
                InnerPopupFactory.showErrorDialog("<b>" + Words.UNABLE_TO_SWITCH_LOCATION + "</b><br/>" + Words.PLEASE_FINISH_ALL_FIRST, (Component)this);
                return;
            }
            this.isSwitched = true;
            this.popup.enableOKButton(false);
            this.popup.enableCancelButton(false);
            this.showAnimation(Words.SWITCH_LOCATION);
            if (this.location != null) {
                this.location.setVisible(false);
            }
            this.revalidate();
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    try {
                        ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).switchLocation((LocationComplete)((ComboBox)SwitchLocationPopupInsert.this.location.getElement()).getNode().getValue());
                        UserComplete u = (UserComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getUser((UserReference)SwitchLocationPopupInsert.this.user).getValue();
                        ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).setCurrentUser(u);
                        FilterChainConfiguration c = new FilterChainConfiguration();
                        c.addProperty("location", ((LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue()).getHomeBase().getCode());
                        FilterChainConfiguration.saveConfiguration("location", (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), c, ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
                        return null;
                    }
                    catch (ClientServerCallException e) {
                        ViewNode r = new ViewNode("Error");
                        r.setValue((Object)e, 0L);
                        return r;
                    }
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            SwitchLocationPopupInsert.this.popup.hidePopUp(new Object[0]);
                            InnerPopupFactory.showMessageDialog(Words.LOCATION_SWITCH_SUCCESSFULLY, SwitchLocationPopupInsert.this.mainFrame);
                            String defName = SwitchLocationPopupInsert.this.mainFrame.getLatestDefName();
                            String titleName = "";
                            if (defName != null && defName.contains("ch.icit")) {
                                defName = HUDToolkit.getInvokerNameForTopScreenClass(defName);
                            }
                            boolean hasAccess2CurrentScreen = false;
                            for (ModuleAccessRightComplete r : ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getModules()) {
                                if (!r.getModule().getInvokingName().equals(defName)) continue;
                                hasAccess2CurrentScreen = true;
                                titleName = r.getModule().getDisplayName();
                            }
                            if (!hasAccess2CurrentScreen) {
                                for (ModuleAccessRightComplete r : ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getModules()) {
                                    if (r.getModule().getInvokingName().equals(defName)) continue;
                                    defName = r.getModule().getInvokingName();
                                    titleName = r.getModule().getDisplayName();
                                }
                                if (defName == null) {
                                    defName = EmptySpace.class.getName();
                                }
                            }
                            Object screen = null;
                            screen = ScreenViewProvider.forName(HUDToolkit.getScreenClassForInvoker(defName), SwitchLocationPopupInsert.this.mainFrame, titleName, SwitchLocationPopupInsert.this.mainFrame.getCurrenScreen());
                            if (screen != null) {
                                SwitchLocationPopupInsert.this.mainFrame.showScreen((Screen)screen, defName);
                            }
                            SwitchLocationPopupInsert.this.mainFrame.updateVersion();
                        }

                        public void errorOccurred(ClientException exception) {
                            exception.printStackTrace();
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
            return;
        }
        super.enterPressed(isOK);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.location != null) {
            return this.location.getFocusComponents();
        }
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.location != null) {
            return this.location.getElement().isInnerComponent(c);
        }
        return false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.hideAnimation();
        List l = (List)node.getValue();
        this.location = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode((Object)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue()), INodeCreator.getDefaultImpl().createNodes(l, true), ConverterRegistry.getConverter(LocationConverter.class)), Words.CURRENT_LOCATION, TitledItem.TitledItemOrientation.NORTH);
        this.add(this.location);
        this.revalidate();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (SwitchLocationPopupInsert.this.loadingAnimation != null) {
                return SwitchLocationPopupInsert.this.loadingAnimation.getPreferredSize();
            }
            if (SwitchLocationPopupInsert.this.location != null) {
                return SwitchLocationPopupInsert.this.location.getPreferredSize();
            }
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (SwitchLocationPopupInsert.this.loadingAnimation != null) {
                SwitchLocationPopupInsert.this.loadingAnimation.setLocation((int)(((double)parent.getWidth() - SwitchLocationPopupInsert.this.loadingAnimation.getPreferredSize().getHeight()) / 2.0), (int)((double)parent.getHeight() - SwitchLocationPopupInsert.this.loadingAnimation.getPreferredSize().getHeight()) / 2);
                SwitchLocationPopupInsert.this.loadingAnimation.setSize(SwitchLocationPopupInsert.this.loadingAnimation.getPreferredSize());
            }
            if (SwitchLocationPopupInsert.this.location != null) {
                SwitchLocationPopupInsert.this.location.setLocation(10, 10);
                SwitchLocationPopupInsert.this.location.setSize(parent.getWidth() - 20, (int)SwitchLocationPopupInsert.this.location.getPreferredSize().getHeight());
            }
        }
    }
}

