/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.rightdependant;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDField;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class RDComboBox
extends RDField<ComboBox, TextLabel> {
    private static final long serialVersionUID = 1L;
    private Converter viewConverter;
    private boolean ref;
    private boolean nullable;
    private Node possibles;
    private Node selectedItem;
    private List<Object> items = new ArrayList<Object>();
    private int selectedIndex;
    private ItemListener listener;

    public RDComboBox(RDProvider provider, Converter viewConverter) {
        this(provider, viewConverter, false);
    }

    public RDComboBox(RDProvider provider, Converter viewConverter, boolean isNullable, boolean isReference) {
        super(provider);
        this.ref = isReference;
        this.setNullable(isNullable);
        this.viewConverter = viewConverter;
    }

    public RDComboBox(RDProvider provider, Converter viewConverter, boolean isNullable) {
        this(provider, viewConverter, isNullable, false);
    }

    public JComponent getCurrent() {
        if (this.wField != null) {
            return this.wField;
        }
        return this.rField;
    }

    @Override
    public Dimension getNodeLessPreferredSize() {
        int h = ((Skin3Field)DefaultSkins.ComboBoxTexture.createDynamicSkin()).getImageLeft(Button.ButtonState.UP).getHeight();
        return new Dimension(h * 3, h);
    }

    public boolean isInnerComponent(Component c) {
        if (this.wField != null) {
            return ((ComboBox)this.wField).isInnerComponent(c);
        }
        return false;
    }

    @Override
    public ComboBox createEditor(Node<?> node) {
        ComboBox comboBox = new ComboBox(node, this.possibles, this.viewConverter, this.isNullable(), this.ref);
        for (Object o : this.items) {
            comboBox.addItem(o);
        }
        comboBox.setProgress(1.0f);
        if (this.listener != null) {
            comboBox.addItemListener(this.listener);
        }
        if (this.selectedItem != null) {
            comboBox.setSelectedItem(this.selectedItem);
        }
        comboBox.setEnabled(this.isEnabled);
        return comboBox;
    }

    @Override
    public TextLabel createRenderer(Node<?> node) {
        TextLabel t = new TextLabel(node, this.viewConverter);
        t.setReadOnlyTextField(true);
        t.setNodeBased(false);
        if (node == null) {
            if (this.items.size() > 0 && this.items.size() > this.selectedIndex) {
                t.setText((String)this.items.get(this.selectedIndex));
            } else if (this.selectedItem != null) {
                t.setText((String)this.viewConverter.convert(this.selectedItem.getValue(), this.selectedItem, new Object[0]));
            }
        }
        t.setEnabled(this.isEnabled);
        return t;
    }

    public void refreshPossibleValues(Node node) {
        if (this.wField != null) {
            ((ComboBox)this.wField).refreshPossibleValues(node);
        } else {
            this.possibles = node;
        }
    }

    public void setSelectedItem(Node node) {
        if (this.wField != null) {
            ((ComboBox)this.wField).setSelectedItem(node);
        } else if (this.rField != null) {
            ((TextLabel)this.rField).setNode(node);
        } else {
            this.selectedItem = node;
        }
    }

    public void addItemListener(ItemListener listener) {
        if (this.wField != null) {
            ((ComboBox)this.wField).addItemListener(listener);
        } else {
            this.listener = listener;
        }
    }

    public void setViewConverter(Converter viewConverter) {
        if (this.wField != null) {
            ((ComboBox)this.wField).setViewConverter(viewConverter);
        }
        if (this.rField != null) {
            ((TextLabel)this.rField).setViewConverter(viewConverter);
        }
        this.viewConverter = viewConverter;
    }

    public void removeItemListener(ItemListener listener) {
        if (this.wField != null) {
            ((ComboBox)this.wField).removeItemListener(listener);
        }
        this.listener = null;
    }

    public Object getSelectedItem() {
        if (this.wField != null) {
            return ((ComboBox)this.wField).getSelectedItem();
        }
        if (this.rField != null && ((TextLabel)this.rField).getNode() != null) {
            return ((TextLabel)this.rField).getNode();
        }
        return this.selectedItem;
    }

    public void removeAllItems() {
        if (this.wField != null) {
            ((ComboBox)this.wField).removeAllItems();
        }
    }

    public void addItem(Object string) {
        if (this.wField != null) {
            ((ComboBox)this.wField).addItem(string);
        } else {
            this.items.add(string);
        }
    }

    public void setSelectedItem(Object item) {
        if (this.wField != null) {
            ((ComboBox)this.wField).setSelectedItem(item);
        } else if (this.rField != null) {
            if (item instanceof String) {
                ((TextLabel)this.rField).setText((String)item);
            } else {
                Object t = this.viewConverter.convert(item, null, new Object[0]);
                if (t instanceof String) {
                    ((TextLabel)this.rField).setText((String)t);
                }
            }
        }
    }

    public void updateSelectableValues(List<Node<?>> list) {
        if (this.wField != null) {
            ((ComboBox)this.wField).updateSelectableValues(list);
        }
    }

    public Node getPossibleValues() {
        return this.wField != null ? ((ComboBox)this.wField).getPossibleValues() : this.possibles;
    }

    public void setSelectedIndex(int i) {
        this.selectedIndex = i;
        if (this.wField != null) {
            ((ComboBox)this.wField).setSelectedIndex(i);
        } else if (this.rField != null) {
            ((TextLabel)this.rField).setText((String)this.items.get(i));
        }
    }

    public int getSelectedIndex() {
        if (this.wField != null) {
            return ((ComboBox)this.wField).getSelectedIndex();
        }
        return this.selectedIndex;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }
}

