/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tabbed;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class TabButton
extends Button
implements LafListener,
ImageConsumer {
    private static final long serialVersionUID = 8771024610903401672L;
    protected BufferedImage image_texture_active;
    protected BufferedImage image_texture_up;
    protected TextLabel text;
    private boolean isActive;
    private static Font normalFont;
    private static Font activFont;

    public TabButton(String text) {
        this(text, false);
    }

    public TabButton(String text, boolean isActive) {
        this.lafAttributeChanged("All attribues changed");
        this.text = new TextLabel(text);
        this.text.setProgress(1.0f);
        this.setLayout(new Layout());
        this.add(this.text);
        this.setProgress(1.0f);
        this.setOpaque(false);
        this.setActive(isActive);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle r = null;
        if (this.isActive) {
            r = new Rectangle(0, 0, this.image_texture_active.getWidth(), this.image_texture_active.getHeight());
            g2.setPaint(new TexturePaint(this.image_texture_active, r));
        } else {
            r = new Rectangle(0, 0, this.image_texture_up.getWidth(), this.image_texture_up.getHeight());
            g2.setPaint(new TexturePaint(this.image_texture_up, r));
        }
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintChildren(g2);
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
        normalFont = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        activFont = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("stowing_tab_title_font_type_activ"));
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
        if (this.isActive) {
            this.text.setFont(activFont);
        } else {
            this.text.setFont(normalFont);
        }
        this.repaint(32L);
    }

    @Override
    public void loadImages() {
        if (this.image_texture_active == null) {
            this.image_texture_active = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("gc_stowing_tab_texture_active"));
            this.image_texture_up = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("gc_stowing_tab_texture_up"));
        }
    }

    @Override
    public void clearImages() {
        this.image_texture_active = null;
        this.loadImages();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            TabButton.this.text.setLocation((int)((double)parent.getWidth() - TabButton.this.text.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - TabButton.this.text.getPreferredSize().getHeight()) / 2);
            TabButton.this.text.setSize(TabButton.this.text.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, TabButton.this.image_texture_active.getHeight());
        }
    }
}

