/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.textfield;

import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumberDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    private TextFieldType type;
    private boolean isMinusAllowed;
    private JTextField field;
    private int maxKommastellen;

    public NumberDocument(TextFieldType type, boolean isMinusAllowed, JTextField field, int maxKommastellen) {
        this.type = type;
        this.isMinusAllowed = isMinusAllowed;
        this.field = field;
        this.maxKommastellen = maxKommastellen;
    }

    public TextFieldType getType() {
        return this.type;
    }

    public void setType(TextFieldType type) {
        this.type = type;
    }

    public boolean isMinusAllowed() {
        return this.isMinusAllowed;
    }

    public void setMinusAllowed(boolean isMinusAllowed) {
        this.isMinusAllowed = isMinusAllowed;
    }

    public int getMaxKommastellen() {
        return this.maxKommastellen;
    }

    public void setMaxKommastellen(int maxKommastellen) {
        this.maxKommastellen = maxKommastellen;
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        boolean valid;
        if (this.type == TextFieldType.INT || this.type == TextFieldType.INT_NULLABLE) {
            block20: {
                valid = true;
                if (text != null && !text.isEmpty()) {
                    try {
                        int n = Integer.valueOf(text);
                    }
                    catch (NumberFormatException e) {
                        valid = false;
                        if (offset != 0 || !text.equals("-") || !this.isMinusAllowed || this.field.getText().contains("-")) break block20;
                        valid = true;
                    }
                }
            }
            if (valid) {
                super.replace(offset, length, text, attrs);
            }
        }
        if (this.type == TextFieldType.LONG) {
            block21: {
                valid = true;
                if (text != null && !text.isEmpty()) {
                    try {
                        long e = Long.valueOf(text);
                    }
                    catch (NumberFormatException e) {
                        valid = false;
                        if (offset != 0 || !text.equals("-") || !this.isMinusAllowed || this.field.getText().contains("-")) break block21;
                        valid = true;
                    }
                }
            }
            if (valid) {
                super.replace(offset, length, text, attrs);
            }
        } else if (this.type == TextFieldType.DOUBLE) {
            valid = true;
            if (text != null) {
                String inputText;
                String t;
                block22: {
                    t = text;
                    inputText = this.field.getText();
                    t = NumberTextField.getUnifiedDecimalString(t);
                    inputText = NumberTextField.getUnifiedDecimalString(inputText);
                    if (!text.isEmpty()) {
                        try {
                            Double.valueOf(t);
                        }
                        catch (NumberFormatException e) {
                            valid = false;
                            if (t.equals(".")) {
                                if (!inputText.contains(".")) {
                                    valid = true;
                                }
                            }
                            if (offset != 0 || !t.equals("-") || !this.isMinusAllowed || inputText.contains("-")) break block22;
                            valid = true;
                        }
                    }
                }
                if (!this.checkIt(t, inputText, offset, length)) {
                    valid = false;
                }
            }
            if (valid) {
                super.replace(offset, length, text, attrs);
            }
        }
    }

    private boolean checkIt(String t, String inputText, int offset, int length) {
        boolean valid = true;
        int i = t.indexOf(".");
        if (i != -1) {
            i = inputText.indexOf(".");
            if (i != -1 && (i <= offset || i >= offset + length)) {
                valid = false;
            }
            i = t.indexOf(".");
            if (t.length() - 1 - i > this.maxKommastellen) {
                valid = false;
            }
        } else {
            i = inputText.indexOf(".");
            if (i != -1 && i < offset && inputText.length() - 1 - i >= this.maxKommastellen) {
                valid = false;
            }
        }
        return valid;
    }
}

