/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.admin.inserts;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.LocationConverter;
import ch.icit.pegasus.client.converter.ReportConfigurationConverter;
import ch.icit.pegasus.client.converter.ReportConfigurationTypeConverter;
import ch.icit.pegasus.client.converter.ReportTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DataInsert;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.ReportConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.file.ReportConfigurationTypeE;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.AMasterDataComplete;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReportConfigurationInsert
extends DataInsert<ReportConfigurationComplete> {
    private static final long serialVersionUID = 1L;

    public ReportConfigurationInsert() {
        super((MasterDataModule)null);
    }

    @Override
    public void insertElements() {
    }

    @Override
    public ReportConfigurationComplete getNewObject() {
        return new ReportConfigurationComplete();
    }

    @Override
    public Class<? extends ReportConfigurationComplete> getMasterDataClass() {
        return ReportConfigurationComplete.class;
    }

    @Override
    public DetailsPanel getDetails() {
        return new ReportConfigurationInsertPanelConfig();
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node r1 = NodeToolkit.getAffixList(ReportTypeE.class);
                if (r1 == null) {
                    StaticEnumServiceManager.getAllReportTypes();
                }
                List repConfigs = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAll(ReportConfigurationComplete.class, true).getList();
                StaticEnumServiceManager.getAllReportConfigurationTypes();
                Node r = INodeCreator.getDefaultImpl().createNodes(repConfigs, false);
                return r;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ReportConfigurationInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<Exception> errors = new ArrayList<Exception>();
                Iterator it = ReportConfigurationInsert.this.masterDataTable.getModel().getNode().getChilds();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    n.commitThis(ReportConfigurationComplete.class);
                    ReportConfigurationComplete us = (ReportConfigurationComplete)n.getValue(ReportConfigurationComplete.class);
                    try {
                        us = n.getChildNamed(ADTO.ID_).getValue() == null ? (ReportConfigurationComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).create((AMasterDataComplete)us).getValue() : (us.getIsDeleted() != false && us.getDeleteTime() == null ? (ReportConfigurationComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).delete((AMasterDataComplete)us).getValue() : (us.getIsDeleted() == false && us.getDeleteTime() != null ? (ReportConfigurationComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).restore((AMasterDataComplete)us).getValue() : (ReportConfigurationComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).update((AMasterDataComplete)us).getValue()));
                        ReportConfigurationInsert.this.updateNode(n, (ADTO)us);
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                }
                if (!errors.isEmpty()) {
                    throw new ClientExceptionCollection("", errors);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ReportConfigurationInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public String getInsertName() {
        return Words.REPORT_CONFIGURATION;
    }

    private class ReportConfigurationInsertPanelConfig
    extends DetailsPanel
    implements ItemListener {
        private static final long serialVersionUID = 1L;
        private Node<?> node;
        private TitledItem<ComboBox> configType;
        private TitledItem<TextField> originReportName;
        private TitledItem<CheckBox> showReport;
        private TitledItem<ComboBox> locationSelection;
        private TitledItem<ComboBox> reportType;
        private TitledItem<CheckBox> showDefault;
        private TitledItem<CheckBox> hideReport;
        private TitledItem<NumberTextField> maxLabelEntries;
        private TitledItem<SearchComboBox> labelReport;

        public ReportConfigurationInsertPanelConfig() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.hideReport = new TitledItem<CheckBox>(new CheckBox(), Words.HIDE_REPORT, TitledItem.TitledItemOrientation.EAST);
            this.reportType = new TitledItem<ComboBox>(new ComboBox(null, NodeToolkit.getAffixList(ReportTypeE.class), ConverterRegistry.getConverter(ReportTypeConverter.class)), Words.REPORT_TYPE, TitledItem.TitledItemOrientation.NORTH);
            this.showDefault = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_DEFAULT_REPORT, TitledItem.TitledItemOrientation.EAST);
            this.labelReport = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getLabelLayoutSearchBox(true, null), Words.LABEL_LAYOUT, TitledItem.TitledItemOrientation.NORTH);
            this.maxLabelEntries = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), Words.LABEL_ENTRY_COUNT, TitledItem.TitledItemOrientation.NORTH);
            this.configType = new TitledItem<ComboBox>(new ComboBox(null, NodeToolkit.getAffixList(ReportConfigurationTypeE.class), ConverterRegistry.getConverter(ReportConfigurationTypeConverter.class)), Words.TYPE, TitledItem.TitledItemOrientation.NORTH);
            this.originReportName = new TitledItem<TextField>(new TextField(), Words.REPORT_NAME, TitledItem.TitledItemOrientation.NORTH);
            this.showReport = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_REPORT, TitledItem.TitledItemOrientation.EAST);
            this.locationSelection = new TitledItem<ComboBox>(new ComboBox(null, NodeToolkit.getAffixList(LocationComplete.class), ConverterRegistry.getConverter(LocationConverter.class)), Words.LOCATION, TitledItem.TitledItemOrientation.NORTH);
            this.configType.getElement().addItemListener(this);
            this.setLayout(new AALayout());
            this.reportType.getFader().setPermanent(true);
            this.showDefault.getFader().setPermanent(true);
            this.maxLabelEntries.getFader().setPermanent(true);
            this.labelReport.getFader().setPermanent(true);
            this.configType.getFader().setPermanent(true);
            this.originReportName.getFader().setPermanent(true);
            this.showReport.getFader().setPermanent(true);
            this.locationSelection.getFader().setPermanent(true);
            this.hideReport.getFader().setPermanent(true);
            this.add(this.hideReport);
            this.add(this.showDefault);
            this.add(this.reportType);
            this.add(this.labelReport);
            this.add(this.maxLabelEntries);
            this.add(this.configType);
            this.add(this.originReportName);
            this.add(this.showReport);
            this.add(this.locationSelection);
        }

        private void showLabelEntryConfig() {
            if (!this.maxLabelEntries.getFader().isFaded()) {
                this.maxLabelEntries.fadeIn();
            }
            if (!this.labelReport.getFader().isFaded()) {
                this.labelReport.fadeIn();
            }
            if (this.hideReport.getFader().isFaded()) {
                this.hideReport.fadeOut(false);
            }
            if (this.showDefault.getFader().isFaded()) {
                this.showDefault.fadeOut(false);
            }
            if (this.originReportName.getFader().isFaded()) {
                this.originReportName.fadeOut(false);
            }
            if (this.showReport.getFader().isFaded()) {
                this.showReport.fadeOut(false);
            }
            if (this.locationSelection.getFader().isFaded()) {
                this.locationSelection.fadeOut(false);
            }
        }

        private void showShowDefaultConfig() {
            if (!this.showDefault.getFader().isFaded()) {
                this.showDefault.fadeIn();
            }
            if (!this.hideReport.getFader().isFaded()) {
                this.hideReport.fadeIn();
            }
            if (!this.originReportName.getFader().isFaded()) {
                this.originReportName.fadeIn();
            }
            if (this.maxLabelEntries.getFader().isFaded()) {
                this.maxLabelEntries.fadeOut(false);
            }
            if (this.labelReport.getFader().isFaded()) {
                this.labelReport.fadeOut(false);
            }
            if (this.showReport.getFader().isFaded()) {
                this.showReport.fadeOut(false);
            }
            if (this.locationSelection.getFader().isFaded()) {
                this.locationSelection.fadeOut(false);
            }
        }

        private void showLocationOverride() {
            if (!this.originReportName.getFader().isFaded()) {
                this.originReportName.fadeIn();
            }
            if (!this.showReport.getFader().isFaded()) {
                this.showReport.fadeIn();
            }
            if (!this.locationSelection.getFader().isFaded()) {
                this.locationSelection.fadeIn();
            }
            if (this.hideReport.getFader().isFaded()) {
                this.hideReport.fadeOut(false);
            }
            if (this.showDefault.getFader().isFaded()) {
                this.showDefault.fadeOut(false);
            }
            if (this.maxLabelEntries.getFader().isFaded()) {
                this.maxLabelEntries.fadeOut(false);
            }
            if (this.labelReport.getFader().isFaded()) {
                this.labelReport.fadeOut(false);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.configType);
            CheckedListAdder.addToList(a, this.reportType);
            CheckedListAdder.addToList(a, this.showDefault);
            CheckedListAdder.addToList(a, this.hideReport);
            CheckedListAdder.addToList(a, this.labelReport);
            CheckedListAdder.addToList(a, this.maxLabelEntries);
            CheckedListAdder.addToList(a, this.originReportName);
            CheckedListAdder.addToList(a, this.showReport);
            CheckedListAdder.addToList(a, this.locationSelection);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.showDefault.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.showDefault.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.reportType != null) {
                this.reportType.kill();
            }
            if (this.showDefault != null) {
                this.showDefault.kill();
            }
            if (this.labelReport != null) {
                this.labelReport.kill();
            }
            if (this.maxLabelEntries != null) {
                this.maxLabelEntries.kill();
            }
            if (this.configType != null) {
                this.configType.kill();
            }
            if (this.originReportName != null) {
                this.originReportName.kill();
            }
            if (this.showReport != null) {
                this.showReport.kill();
            }
            if (this.locationSelection != null) {
                this.locationSelection.kill();
            }
            if (this.hideReport != null) {
                this.hideReport.kill();
            }
            this.configType = null;
            this.originReportName = null;
            this.showReport = null;
            this.locationSelection = null;
            this.reportType = null;
            this.showDefault = null;
            this.labelReport = null;
            this.maxLabelEntries = null;
            this.hideReport = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            this.showDefault.setEnabled(b);
            this.hideReport.setEnabled(b);
            this.reportType.setEnabled(b);
            Node repNode = (Node)this.reportType.getElement().getSelectedItem();
            boolean useLabel = false;
            if (repNode != null && repNode.getValue() instanceof ReportTypeE && repNode.getValue() == ReportTypeE.LABEL) {
                useLabel = true;
            }
            this.labelReport.setEnabled(b && useLabel);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(ReportConfigurationConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.node = node;
            this.showDefault.getElement().setNode(this.node.getChildNamed(ReportConfigurationComplete_.showDefault));
            this.hideReport.getElement().setNode(this.node.getChildNamed(ReportConfigurationComplete_.hideReport));
            this.reportType.getElement().setNode(node.getChildNamed(ReportConfigurationComplete_.reportType));
            this.reportType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ReportTypeE.class));
            this.labelReport.getElement().setNode(node.getChildNamed(ReportConfigurationComplete_.reportFile));
            this.maxLabelEntries.getElement().setNode(node.getChildNamed(ReportConfigurationComplete_.maxLabelEntries));
            this.configType.getElement().setNode(node.getChildNamed(ReportConfigurationComplete_.type));
            this.originReportName.getElement().setNode(node.getChildNamed(ReportConfigurationComplete_.originReportName));
            this.showReport.getElement().setNode(node.getChildNamed(ReportConfigurationComplete_.showReport));
            this.locationSelection.getElement().setNode(node.getChildNamed(ReportConfigurationComplete_.location));
            this.revalidate();
            ReportConfigurationInsert.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return null;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                return;
            }
            Node c = (Node)this.configType.getElement().getSelectedItem();
            switch ((ReportConfigurationTypeE)c.getValue()) {
                case HIDE_DEFAULT: {
                    this.showShowDefaultConfig();
                    break;
                }
                case MAX_LABEL_ENTRIES: {
                    this.showLabelEntryConfig();
                    break;
                }
                case REPLACE_IN_LOCATION: {
                    this.showLocationOverride();
                    break;
                }
            }
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                ReportConfigurationInsertPanelConfig.this.configType.setLocation(ReportConfigurationInsert.this.masterDataTable.getCellPadding(), ReportConfigurationInsert.this.masterDataTable.getCellPadding());
                ReportConfigurationInsertPanelConfig.this.configType.setSize(300, (int)ReportConfigurationInsertPanelConfig.this.configType.getPreferredSize().getHeight());
                int cy = ReportConfigurationInsertPanelConfig.this.configType.getY() + ReportConfigurationInsertPanelConfig.this.configType.getHeight();
                ReportConfigurationInsertPanelConfig.this.reportType.setLocation(ReportConfigurationInsert.this.masterDataTable.getCellPadding(), cy + ReportConfigurationInsert.this.masterDataTable.getCellPadding());
                ReportConfigurationInsertPanelConfig.this.reportType.setSize(400, (int)ReportConfigurationInsertPanelConfig.this.reportType.getPreferredSize().getHeight());
                cy = ReportConfigurationInsertPanelConfig.this.reportType.getY() + ReportConfigurationInsertPanelConfig.this.reportType.getHeight();
                Node rt = (Node)((ComboBox)ReportConfigurationInsertPanelConfig.this.configType.getElement()).getSelectedItem();
                if (rt == null || rt.getValue() == null) {
                    return;
                }
                switch ((ReportConfigurationTypeE)rt.getValue()) {
                    case HIDE_DEFAULT: {
                        ReportConfigurationInsertPanelConfig.this.showDefault.setLocation(ReportConfigurationInsert.this.masterDataTable.getCellPadding(), cy + ReportConfigurationInsert.this.masterDataTable.getCellPadding());
                        ReportConfigurationInsertPanelConfig.this.showDefault.setSize(250, (int)ReportConfigurationInsertPanelConfig.this.showDefault.getPreferredSize().getHeight());
                        ReportConfigurationInsertPanelConfig.this.hideReport.setLocation(ReportConfigurationInsert.this.masterDataTable.getCellPadding(), ReportConfigurationInsertPanelConfig.this.showDefault.getY() + ReportConfigurationInsertPanelConfig.this.showDefault.getHeight());
                        ReportConfigurationInsertPanelConfig.this.hideReport.setSize(ReportConfigurationInsertPanelConfig.this.hideReport.getPreferredSize());
                        ReportConfigurationInsertPanelConfig.this.originReportName.setLocation(ReportConfigurationInsert.this.masterDataTable.getCellPadding(), ReportConfigurationInsertPanelConfig.this.hideReport.getY() + ReportConfigurationInsertPanelConfig.this.hideReport.getHeight());
                        ReportConfigurationInsertPanelConfig.this.originReportName.setSize(300, (int)ReportConfigurationInsertPanelConfig.this.originReportName.getPreferredSize().getHeight());
                        break;
                    }
                    case MAX_LABEL_ENTRIES: {
                        ReportConfigurationInsertPanelConfig.this.labelReport.setLocation(ReportConfigurationInsert.this.masterDataTable.getCellPadding(), cy + ReportConfigurationInsert.this.masterDataTable.getCellPadding());
                        ReportConfigurationInsertPanelConfig.this.labelReport.setSize(250, (int)ReportConfigurationInsertPanelConfig.this.labelReport.getPreferredSize().getHeight());
                        ReportConfigurationInsertPanelConfig.this.maxLabelEntries.setLocation(ReportConfigurationInsert.this.masterDataTable.getCellPadding(), ReportConfigurationInsertPanelConfig.this.labelReport.getY() + ReportConfigurationInsertPanelConfig.this.labelReport.getHeight() + ReportConfigurationInsert.this.masterDataTable.getCellPadding());
                        ReportConfigurationInsertPanelConfig.this.maxLabelEntries.setSize(250, (int)ReportConfigurationInsertPanelConfig.this.maxLabelEntries.getPreferredSize().getHeight());
                        break;
                    }
                    case REPLACE_IN_LOCATION: {
                        ReportConfigurationInsertPanelConfig.this.originReportName.setLocation(ReportConfigurationInsert.this.masterDataTable.getCellPadding(), cy + ReportConfigurationInsert.this.masterDataTable.getCellPadding());
                        ReportConfigurationInsertPanelConfig.this.originReportName.setSize(250, (int)ReportConfigurationInsertPanelConfig.this.labelReport.getPreferredSize().getHeight());
                        ReportConfigurationInsertPanelConfig.this.showReport.setLocation(ReportConfigurationInsert.this.masterDataTable.getCellPadding(), ReportConfigurationInsertPanelConfig.this.originReportName.getY() + ReportConfigurationInsertPanelConfig.this.originReportName.getHeight() + ReportConfigurationInsert.this.masterDataTable.getCellPadding());
                        ReportConfigurationInsertPanelConfig.this.showReport.setSize(ReportConfigurationInsertPanelConfig.this.showReport.getPreferredSize());
                        ReportConfigurationInsertPanelConfig.this.locationSelection.setLocation(ReportConfigurationInsert.this.masterDataTable.getCellPadding(), ReportConfigurationInsertPanelConfig.this.showReport.getY() + ReportConfigurationInsertPanelConfig.this.showReport.getHeight() + ReportConfigurationInsert.this.masterDataTable.getCellPadding());
                        ReportConfigurationInsertPanelConfig.this.locationSelection.setSize(300, (int)ReportConfigurationInsertPanelConfig.this.locationSelection.getPreferredSize().getHeight());
                        break;
                    }
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

