/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.aircraft;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.AircraftServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftReference;
import ch.icit.pegasus.server.core.dtos.masterdata.AircraftTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentSystemComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.List;

public class AircraftModuleDataHandler
extends DefaultDataHandler<AircraftReference, AircraftLight> {
    public AircraftModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<AircraftReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                AircraftLight d = (AircraftLight)node.getValue(AircraftLight.class);
                AircraftLight dto = (AircraftLight)((AircraftServiceManager)ServiceManagerRegistry.getService(AircraftServiceManager.class)).updateAircraft(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<AircraftLight> createEmptyNode() {
        AircraftLight d = new AircraftLight();
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<AircraftLight> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                AircraftLight d = (AircraftLight)node.getValue(AircraftLight.class);
                AircraftLight dto = (AircraftLight)((AircraftServiceManager)ServiceManagerRegistry.getService(AircraftServiceManager.class)).createAircraft(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                AircraftModuleDataHandler.this.setCurrentLoadMaximum(5);
                AircraftModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                AircraftModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AircraftTypeComplete.class);
                AircraftModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(GalleyEquipmentSystemComplete.class);
                AircraftModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                AircraftModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getTrolleyScanSettingsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return AircraftModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                AircraftLight air = (AircraftLight)node.getValue(AircraftLight.class);
                AircraftLight nair = (AircraftLight)((AircraftServiceManager)ServiceManagerRegistry.getService(AircraftServiceManager.class)).getAircraftLight(new AircraftReference(air.getId())).getValue();
                List galleyNames = ((AircraftServiceManager)ServiceManagerRegistry.getService(AircraftServiceManager.class)).getGalleys(new AircraftReference(air.getId())).getList();
                Node galleyNodes = INodeCreator.getDefaultImpl().createNodes(galleyNames, false, false);
                galleyNodes.setName("usedGalleys");
                NodeToolkit.addAffix((Node)galleyNodes);
                node.removeExistingValues();
                node.setValue((Object)nair, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<AircraftLight> resetData(Node<AircraftLight> node) {
        CustomerLight cID = ((AircraftLight)node.getValue(AircraftLight.class)).getCustomer();
        AircraftTypeComplete aircraftCode = ((AircraftLight)node.getValue(AircraftLight.class)).getType();
        AircraftLight n = new AircraftLight();
        n.setCustomer(cID);
        n.setType(aircraftCode);
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<AircraftLight> getCommittingClass() {
        return AircraftLight.class;
    }

    @Override
    public void doRemoteValidation(Node<AircraftReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

