/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.aircraft.details;

import ch.icit.pegasus.client.gui.modules.aircraft.details.utils.Air2TableRowImpl;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PaxClassDetailsPanel
extends TableDetailsPanel<AircraftLight> {
    private static final long serialVersionUID = 1L;

    public PaxClassDetailsPanel(RowEditor<AircraftLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.PAX_AND_CREW_CLASS);
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(AircraftLight_.seatConfigurations));
        this.recalculateUsableValue4Combo();
    }

    public void recalculateUsableValue4Combo() {
        ArrayList<Node> selectableCabinClasses = new ArrayList<Node>();
        if (this.table == null) {
            return;
        }
        for (Table2RowPanel p : this.table.getRows()) {
            Node cabinClassNode = p.getModel().getNode().getChildNamed(SeatConfigurationComplete_.cabinClass);
            selectableCabinClasses.add(cabinClassNode);
        }
        for (Table2RowPanel rowPanel : this.table.getRows()) {
            Air2TableRowImpl rowPanelImpl = (Air2TableRowImpl)rowPanel;
            rowPanelImpl.setUsableNodes(selectableCabinClasses);
        }
    }

    @Override
    public void resetParagraph() {
        this.table.getModel().setNode(this.editor.getModel().getNode().getChildNamed(AircraftLight_.seatConfigurations));
    }

    private CabinClassComplete getFreeCabinClass() {
        Node l = NodeToolkit.getAffixList(CabinClassComplete.class);
        Iterator it = l.getChilds();
        while (it.hasNext()) {
            Node cabinClassNode = (Node)it.next();
            boolean found = false;
            Iterator<Table2RowPanel> it2 = this.table.getRows().iterator();
            while (it2.hasNext() && !found) {
                Node cabinClassForSeatConfiguration;
                Node seatConfigurationNode = it2.next().getModel().getNode();
                if (cabinClassNode.getValue() == null || (cabinClassForSeatConfiguration = seatConfigurationNode.getChildNamed(SeatConfigurationComplete_.cabinClass)) == null || cabinClassForSeatConfiguration.getValue() == null || !((CabinClassComplete)cabinClassForSeatConfiguration.getValue()).equals(cabinClassNode.getValue())) continue;
                found = true;
            }
            if (found) continue;
            return (CabinClassComplete)cabinClassNode.getValue();
        }
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        int totalPax = 0;
        for (Table2RowPanel p : this.table.getRows()) {
            Air2TableRowImpl rr = (Air2TableRowImpl)p;
            List<ScreenValidationObject> r = rr.validateRow();
            validationObjects.addAll(r);
            totalPax += rr.getPax().intValue();
        }
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (totalPax > s.getMaxNumPax()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.TOTAL_PAX_PER_LEG_MUST_NOT_EXCEED, (Object[])new Object[]{totalPax, s.getMaxNumPax()})));
        }
        return validationObjects;
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> headers = new ArrayList<TableColumnInfo>();
        headers.add(new TableColumnInfo(0.0, 0.0, Words.CABIN_CLASS_SHORT, null, null, null, "", 200, 200, 200));
        headers.add(new TableColumnInfo(1.0, 0.0, Words.CAPACITY, null, null, null, "", 70, 70, 70));
        int delWidth = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        headers.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", delWidth += 2 * this.table.getCellPadding(), delWidth, delWidth));
        return headers;
    }

    @Override
    public void configTable(Table2 table) {
        table.setDontUseScrollBar(15);
        table.setMaxRows(NodeToolkit.getAffixList(CabinClassComplete.class).getChildCount(), false);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        SeatConfigurationComplete newSeatConfiguration = new SeatConfigurationComplete();
        newSeatConfiguration.setClientOId(Long.valueOf(ADTO.getNextId()));
        newSeatConfiguration.setNumber(Integer.valueOf(0));
        CabinClassComplete freeCabinClass = this.getFreeCabinClass();
        if (freeCabinClass != null) {
            newSeatConfiguration.setCabinClass(freeCabinClass);
            this.table.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)newSeatConfiguration, true, false), System.currentTimeMillis());
            this.recalculateUsableValue4Combo();
            this.editor.revalidate();
        }
    }

    @Override
    public void childRemoved() {
        this.recalculateUsableValue4Combo();
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        Air2TableRowImpl rowPanel = new Air2TableRowImpl(model, this, this.provider);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }
}

