/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details;

import ch.icit.pegasus.client.gui.modules.article.details.SupplierConditionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.article.details.utils.ArticlePackingVariantsTable;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class UnitDetailsPanel
extends DefaultDetailsPanel<BasicArticleLight> {
    private ArticlePackingVariantsTable packingTable;

    public UnitDetailsPanel(RowEditor<BasicArticleLight> editor, RDProvider provider, Node<?> storeUnit, SupplierConditionDetailsPanel conditionPanel, boolean addRow) {
        super(editor, provider);
        this.setTitleText(Words.UNITS);
        this.packingTable = new ArticlePackingVariantsTable(provider, storeUnit, (Node)new ViewNode(""), conditionPanel, addRow);
        this.setCustomLayouter(new Layout());
        this.addToView(this.packingTable);
    }

    @Override
    public void setNode(Node<?> node) {
        this.packingTable.setNode(node);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.packingTable.setEnabled(isEnabled);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        ArrayList<Object> baseList = new ArrayList<Object>();
        Iterator it = this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.packingQuantitiesVariants).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node base = (Node)it.next();
            base.commitThis();
            baseList.add(base.getValue());
        }
        Collections.sort(baseList, (o1, o2) -> o1.getPeriod().compareTo(o2.getPeriod()));
        ArrayList<Object> supplierList = new ArrayList<Object>();
        Iterator itSC = this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.suppliers).getFailSafeChildIterator();
        while (itSC.hasNext()) {
            Node base = (Node)itSC.next();
            base.commitThis();
            supplierList.add(base.getValue());
        }
        long lastDate = -1L;
        boolean periodErrorFound = false;
        boolean baseUnitErrorFound = false;
        boolean storeUnitErrorFound = false;
        boolean grammageUnitErrorFound = false;
        boolean supplierBaseUnitErrorFound = false;
        boolean supplierStoreUnitErrorFound = false;
        UnitComplete baseUnit = (UnitComplete)this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.baseUnit).getValue();
        baseUnit.resolveReferences();
        baseUnit.resolveParents();
        baseUnit.resolveChilds();
        UnitComplete storeUnit = (UnitComplete)this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.priceUnit).getValue();
        storeUnit.resolveReferences();
        storeUnit.resolveParents();
        storeUnit.resolveChilds();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        UnitComplete grammageUnit = settings.getDefaultCustomsPenaltyUnit();
        grammageUnit.resolveReferences();
        grammageUnit.resolveParents();
        grammageUnit.resolveChilds();
        for (PackagingQuantityBaseComplete packagingQuantityBaseComplete : baseList) {
            Date startDate = packagingQuantityBaseComplete.getPeriod().getStartDate();
            Date endDate = packagingQuantityBaseComplete.getPeriod().getEndDate();
            PeriodComplete period = new PeriodComplete(startDate, endDate);
            if (lastDate != -1L && lastDate + 1L != period.getStartDate().getTime()) {
                periodErrorFound = true;
            }
            if (!this.hasUnit(packagingQuantityBaseComplete.getPackingQuantities(), baseUnit)) {
                baseUnitErrorFound = true;
            }
            if (!this.hasUnit(packagingQuantityBaseComplete.getPackingQuantities(), storeUnit)) {
                storeUnitErrorFound = true;
            }
            if (!this.hasUnit(packagingQuantityBaseComplete.getPackingQuantities(), grammageUnit)) {
                grammageUnitErrorFound = true;
            }
            lastDate = period.getEndDate().getTime();
        }
        for (SupplierConditionBaseComplete supplierConditionBaseComplete : supplierList) {
            for (SupplierConditionCategoryComplete sccc : supplierConditionBaseComplete.getSupplierConditionCategory()) {
                for (SupplierConditionComplete scc : sccc.getConditions()) {
                    if (!Boolean.TRUE.equals(scc.getUsePackingQuantity()) || scc.getPackingQuantities() == null) continue;
                    if (!this.hasUnit(scc.getPackingQuantities(), baseUnit)) {
                        supplierBaseUnitErrorFound = true;
                    }
                    if (this.hasUnit(scc.getPackingQuantities(), storeUnit)) continue;
                    supplierStoreUnitErrorFound = true;
                }
            }
        }
        if (periodErrorFound) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_THE_GIVEN_VARIANTS_AREN_T_OVERLAPPING_AVOID_GABS));
        }
        if (baseList.size() == 0) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.PACKING_TABLE_MUST_HAVE_AT_LEAST_ONE_VARIANT));
        }
        if (baseUnitErrorFound) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_BASE_UNIT_IS_IN_EVERY_PACKING_TABLE, (Object[])new Object[]{baseUnit.getUnitSystem().getName()})));
        }
        if (grammageUnitErrorFound) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Words.ENSURE_GRAMMAGE_UNIT_IS_IN_EVERY_PACKING_TABLE, (Object[])new Object[]{grammageUnit.getUnitSystem().getName()})));
        }
        if (storeUnitErrorFound) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_STORE_UNIT_IS_IN_EVERY_PACKING_TABLE, (Object[])new Object[]{storeUnit.getUnitSystem().getName()})));
            this.packingTable.invalidateStoreUnit(false);
        } else {
            this.packingTable.invalidateStoreUnit(true);
        }
        if (supplierBaseUnitErrorFound) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_BASE_UNIT_SUPPLIER_CONDITION_IS_IN_EVERY_PACKING_TABLE, (Object[])new Object[]{baseUnit.getUnitSystem().getName()})));
        }
        if (supplierStoreUnitErrorFound) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_STORE_UNIT_SUPPLIER_CONDITION_IS_IN_EVERY_PACKING_TABLE, (Object[])new Object[]{storeUnit.getUnitSystem().getName()})));
        }
        return validationObjects;
    }

    private boolean hasUnit(List<PackagingQuantityComplete> packingQuantities, UnitComplete baseUnit) {
        for (PackagingQuantityComplete packingQuantity : packingQuantities) {
            if (packingQuantity != null && packingQuantity.getUnit() != null) {
                packingQuantity.getUnit().resolveReferences();
                packingQuantity.getUnit().resolveChilds();
                packingQuantity.getUnit().resolveParents();
            }
            if (packingQuantity == null || packingQuantity.getUnit() == null || packingQuantity.getUnit().getUnitSystem() == null || !packingQuantity.getUnit().getUnitSystem().equals((Object)baseUnit.getUnitSystem())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.packingTable.requestFocusInWindowNow();
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.packingTable.getFocusComponents();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return UnitDetailsPanel.this.packingTable.getPreferredSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            UnitDetailsPanel.this.packingTable.setLocation(0, 0);
            UnitDetailsPanel.this.packingTable.setSize(parent.getSize());
        }
    }
}

