/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.changenotification.utils;

import ch.icit.pegasus.client.gui.modules.changenotification.utils.ChangeNotificationPanel;
import ch.icit.pegasus.client.gui.modules.changenotification.utils.ChangeNotificationPanelEntry;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.notification.ChangeNotificationServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationReference;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationSettingsComplete;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationStateE;
import ch.icit.pegasus.server.core.dtos.search.ChangeNotificationSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class NotificationUpdater
implements Killable {
    private final ChangeNotificationPanel panel;
    private final ChangeNotificationSettingsComplete changeNotificationSettings;
    private int updateIntervalInMillis;
    private Timer timer;
    private boolean killed;
    private int timeToFadeOutInMillis;

    public NotificationUpdater(ChangeNotificationPanel panel) {
        this.panel = panel;
        this.changeNotificationSettings = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getChangeNotificationSettings();
        this.updateIntervalInMillis = this.changeNotificationSettings != null ? this.changeNotificationSettings.getUpdateInterval() : 60;
        this.updateIntervalInMillis *= 1000;
        this.timeToFadeOutInMillis = this.changeNotificationSettings != null ? this.changeNotificationSettings.getAutoFadeOutSeconds() : 60;
        this.timeToFadeOutInMillis *= 1000;
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    public void ensureTimer() {
        if (this.timer == null) {
            this.timer = new Timer("NotificationUpdater", true);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    NotificationUpdater.this.updateData();
                }
            }, this.updateIntervalInMillis, (long)this.updateIntervalInMillis);
            this.updateData();
        }
    }

    private void updateData() {
        if (this.panel.getNode() == null) {
            return;
        }
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ChangeNotificationSearchConfiguration c = new ChangeNotificationSearchConfiguration();
                c.setState(ChangeNotificationStateE.OPEN);
                SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)c);
                HashSet alreadyInserted = new HashSet();
                for (ChangeNotificationPanelEntry panel : NotificationUpdater.this.panel.getEntries()) {
                    alreadyInserted.add(panel.getNode());
                }
                ViewNode n = new ViewNode("");
                ArrayList<ChangeNotificationLight> fromServer = new ArrayList<ChangeNotificationLight>();
                for (ChangeNotificationLight f : sri) {
                    fromServer.add(f);
                }
                n.setValue(fromServer, 0L);
                Iterator<ChangeNotificationPanelEntry> it = NotificationUpdater.this.panel.getEntries().iterator();
                ArrayList toRemove = new ArrayList();
                while (it.hasNext()) {
                    ChangeNotificationPanelEntry entry = it.next();
                    Node<?> node = entry.getNode();
                    if (!fromServer.contains(node.getValue())) {
                        ChangeNotificationLight value = (ChangeNotificationLight)node.getValue();
                        Timestamp clientTimestamp = new Timestamp(System.currentTimeMillis());
                        ChangeNotificationLight changeNotificationLight = (ChangeNotificationLight)((ChangeNotificationServiceManager)ServiceManagerRegistry.getService(ChangeNotificationServiceManager.class)).getChangeNotificationLight(new ChangeNotificationReference(value.getId())).getValue();
                        if (changeNotificationLight == null || clientTimestamp.getTime() > changeNotificationLight.getProcessedAtTimestamp().getTime() + (long)NotificationUpdater.this.timeToFadeOutInMillis) {
                            toRemove.add(node);
                            continue;
                        }
                        node.removeExistingValues();
                        node.setValue((Object)changeNotificationLight, 0L);
                        node.updateNode();
                        continue;
                    }
                    int i = fromServer.indexOf(node.getValue());
                    node.removeExistingValues();
                    node.setValue(fromServer.get(i), 0L);
                    node.updateNode();
                    fromServer.remove(i);
                }
                for (Node node : toRemove) {
                    NotificationUpdater.this.panel.getNode().removeChild(node, 0L);
                }
                for (ChangeNotificationLight changeNotificationLight : fromServer) {
                    Node np = INodeCreator.getDefaultImpl().getNode4DTO((Object)changeNotificationLight, true, false);
                    NotificationUpdater.this.panel.getNode().addChild(np, 0L);
                }
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        NotificationUpdater.this.panel.validate();
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)NotificationUpdater.this.panel);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private boolean hasChanged(ChangeNotificationLight n1, ChangeNotificationLight n2) {
        if (!n1.getState().equals((Object)n2.getState())) {
            return true;
        }
        return !n1.getRemark().equals(n2.getRemark());
    }

    @Override
    public void kill() {
        if (this.killed) {
            return;
        }
        this.stopTimer();
        this.killed = true;
    }

    @Override
    public boolean isKilled() {
        return this.killed;
    }
}

