/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.checkout.article.chargebased.details;

import ch.icit.pegasus.client.gui.modules.shared.CheckInOutTemplateDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.GroupCheckinoutTemplateComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.GroupCheckinoutTemplateLight;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplatePositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplateReference;
import ch.icit.pegasus.server.core.dtos.store.StockCheckoutGroupComplete_;
import ch.icit.pegasus.server.core.dtos.store.StockCheckoutGroupLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckoutComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.Iterator;

public class CheckoutTemplateDetailsPanel
extends CheckInOutTemplateDetailsPanel<StockCheckoutGroupLight> {
    private static final long serialVersionUID = 1L;

    public CheckoutTemplateDetailsPanel(RowEditor<StockCheckoutGroupLight> editor, RDProvider provider) {
        super(editor, provider);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (this.copy == source) {
            this.editor.showCommittingAnimation(Words.COPY_TEMPLATE);
            this.editor.setEnabled(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    Node data = CheckoutTemplateDetailsPanel.this.editor.getModel().getNode();
                    GroupCheckinoutTemplateLight g = (GroupCheckinoutTemplateLight)((SearchTextField2)CheckoutTemplateDetailsPanel.this.groupSearch.getElement()).getNode().getValue();
                    data.getChildNamed(StockCheckoutGroupComplete_.costCenter).setValue((Object)g.getCostCenter(), 0L);
                    Node poses = data.getChildNamed(StockCheckoutGroupComplete_.stockCheckouts);
                    Iterator it = poses.getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node pos = (Node)it.next();
                        poses.removeChild(pos, 0L);
                    }
                    GroupCheckinoutTemplateComplete gc = (GroupCheckinoutTemplateComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getGroupCheckinoutTemplate((OrderTemplateReference)g).getValue();
                    for (OrderTemplatePositionComplete p : gc.getPositions()) {
                        ManualStockCheckoutComplete pos = new ManualStockCheckoutComplete();
                        pos.setAmount(new StoreQuantityComplete(p.getAmount()));
                        pos.setStorePosition(p.getReceivingStorePosition());
                        Node nPos = INodeCreator.getDefaultImpl().getNode4DTO((Object)pos, true, false);
                        Node article = nPos.getChildNamed(DtoFieldConstants.ARTICLE);
                        if (article == null) {
                            article = new DTOProxyNode();
                            article.setName(DtoFieldConstants.ARTICLE);
                            nPos.addChild(article, 0L);
                        }
                        article.setValue((Object)p.getArticle(), 0L);
                        poses.addChild(nPos, 0L);
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            CheckoutTemplateDetailsPanel.this.editor.hideCommittingAnimation();
                            CheckoutTemplateDetailsPanel.this.editor.setEnabled(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showExceptionPopUp((Throwable)exception, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), CheckoutTemplateDetailsPanel.this.editor);
                            CheckoutTemplateDetailsPanel.this.editor.hideCommittingAnimation();
                            CheckoutTemplateDetailsPanel.this.editor.setEnabled(true);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }
}

