/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.tables.CustomerSearchTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.AllergenInfoSheetExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.AllergenInfoSheetExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.AllergenInfoSheetExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DayOfWeekE;
import ch.icit.pegasus.server.core.dtos.util.DayOfWeekTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class AllergenInfoSheetExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useAllergenInfoSheetExchange;
    private CustomerSearchTable reportedCustomers;
    private TitledItem<CheckBox> separateReportByCustomer;
    private TitledItem<CheckBox> usedArchivedAllergenInfoSheet;
    private TitledItem<CheckBox> reportByDay;
    private TitledItem<TextField> mailTargets;
    private TitledItem<SearchComboBox> styleSheet;
    private TitledItem<CheckBox> sendErrorReport;
    private TitledItem<TextField> errorReportTargets;
    private TablePanelAddSaveButton saveButton;
    private TablePanelAddSaveButton runMonday;
    private TablePanelAddSaveButton runThursday;
    private final DataExchangeModule module;
    protected Node<AllergenInfoSheetExchangeSettingsComplete> settings;
    protected AllergenInfoSheetExchangeSettingsComplete arisc;

    public AllergenInfoSheetExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useAllergenInfoSheetExchange = new TitledItem<CheckBox>(new CheckBox(), Words.ENABLE_ARTICLE_CONSUMPTION, TitledItem.TitledItemOrientation.EAST);
        this.useAllergenInfoSheetExchange.getElement().addButtonListener(this);
        this.reportedCustomers = new CustomerSearchTable("Reported Customers");
        this.separateReportByCustomer = new TitledItem<CheckBox>(new CheckBox(), "Separate Reports by Customer", TitledItem.TitledItemOrientation.EAST);
        this.usedArchivedAllergenInfoSheet = new TitledItem<CheckBox>(new CheckBox(), "Use Archived AIS PDFs", TitledItem.TitledItemOrientation.EAST);
        this.reportByDay = new TitledItem<CheckBox>(new CheckBox(), "Split Report by Day", TitledItem.TitledItemOrientation.EAST);
        this.mailTargets = new TitledItem<TextField>(new TextField(), "EMail Targets (seperated by;)", TitledItem.TitledItemOrientation.NORTH);
        this.styleSheet = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getAllergenInfoSheetStyleSheetSearchBox(true, null), "Style Sheet", TitledItem.TitledItemOrientation.NORTH);
        this.sendErrorReport = new TitledItem<CheckBox>(new CheckBox(), "Send Error Report", TitledItem.TitledItemOrientation.EAST);
        this.sendErrorReport.getElement().addButtonListener(this);
        this.errorReportTargets = new TitledItem<TextField>(new TextField(), "Error Message Notification Address", TitledItem.TitledItemOrientation.NORTH);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.runMonday = new TablePanelAddSaveButton();
        this.runMonday.setText("Monday");
        this.runMonday.addButtonListener(this);
        this.runThursday = new TablePanelAddSaveButton();
        this.runThursday.setText("Thursday");
        this.runThursday.addButtonListener(this);
        this.useAllergenInfoSheetExchange.getElement().setNode(this.settings.getChildNamed(AllergenInfoSheetExchangeSettingsComplete_.useAllergenInfoSheetExchange));
        this.reportedCustomers.setNode(this.settings.getChildNamed(AllergenInfoSheetExchangeSettingsComplete_.reportedCustomers));
        this.separateReportByCustomer.getElement().setNode(this.settings.getChildNamed(AllergenInfoSheetExchangeSettingsComplete_.separateReportByCustomer));
        this.usedArchivedAllergenInfoSheet.getElement().setNode(this.settings.getChildNamed(AllergenInfoSheetExchangeSettingsComplete_.usedArchivedAllergenInfoSheet));
        this.reportByDay.getElement().setNode(this.settings.getChildNamed(AllergenInfoSheetExchangeSettingsComplete_.reportByDay));
        this.mailTargets.getElement().setNode(this.settings.getChildNamed(AllergenInfoSheetExchangeSettingsComplete_.mailTargets));
        this.styleSheet.getElement().setNode(this.settings.getChildNamed(AllergenInfoSheetExchangeSettingsComplete_.styleSheet));
        this.sendErrorReport.getElement().setNode(this.settings.getChildNamed(AllergenInfoSheetExchangeSettingsComplete_.sendErrorReport));
        this.errorReportTargets.getElement().setNode(this.settings.getChildNamed(AllergenInfoSheetExchangeSettingsComplete_.errorReportTargets));
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useAllergenInfoSheetExchange);
        this.configPanel.add(this.reportedCustomers);
        this.configPanel.add(this.separateReportByCustomer);
        this.configPanel.add(this.usedArchivedAllergenInfoSheet);
        this.configPanel.add(this.reportByDay);
        this.configPanel.add(this.mailTargets);
        this.configPanel.add(this.styleSheet);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.runMonday);
        this.configPanel.add(this.runThursday);
        this.configPanel.add(this.sendErrorReport);
        this.configPanel.add(this.errorReportTargets);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                try {
                    AllergenInfoSheetExchangeInsert.this.arisc = (AllergenInfoSheetExchangeSettingsComplete)((AllergenInfoSheetExchangeServiceManager)ServiceManagerRegistry.getService(AllergenInfoSheetExchangeServiceManager.class)).getAllergenInfoSheetExchangeSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (AllergenInfoSheetExchangeInsert.this.arisc == null) {
                    AllergenInfoSheetExchangeSettingsComplete s = new AllergenInfoSheetExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    AllergenInfoSheetExchangeInsert.this.arisc = s;
                }
                AllergenInfoSheetExchangeInsert.this.arisc.setMondayTimerSettings(AllergenInfoSheetExchangeInsert.this.createTimerService(DayOfWeekE.MONDAY));
                AllergenInfoSheetExchangeInsert.this.arisc.setThursdayTimerSettings(AllergenInfoSheetExchangeInsert.this.createTimerService(DayOfWeekE.THURSDAY));
                AllergenInfoSheetExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)AllergenInfoSheetExchangeInsert.this.arisc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return AllergenInfoSheetExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useAllergenInfoSheetExchange.setEnabled(isEnabled);
            boolean b = isEnabled && this.useAllergenInfoSheetExchange.getElement().isChecked();
            this.reportedCustomers.setEnabled(isEnabled);
            this.separateReportByCustomer.setEnabled(isEnabled);
            this.usedArchivedAllergenInfoSheet.setEnabled(isEnabled);
            this.reportByDay.setEnabled(isEnabled);
            this.mailTargets.setEnabled(isEnabled);
            this.styleSheet.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            this.runMonday.setEnabled(isEnabled);
            this.runThursday.setEnabled(isEnabled);
            this.sendErrorReport.setEnabled(isEnabled);
            this.errorReportTargets.setEnabled(isEnabled && this.sendErrorReport.getElement().isChecked());
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.saveButton.kill();
            this.runThursday.kill();
            this.runMonday.kill();
            this.useAllergenInfoSheetExchange.kill();
            this.reportedCustomers.kill();
            this.separateReportByCustomer.kill();
            this.usedArchivedAllergenInfoSheet.kill();
            this.reportByDay.kill();
            this.mailTargets.kill();
            this.styleSheet.kill();
            this.sendErrorReport.kill();
            this.errorReportTargets.kill();
        }
        this.reportedCustomers = null;
        this.separateReportByCustomer = null;
        this.usedArchivedAllergenInfoSheet = null;
        this.reportByDay = null;
        this.mailTargets = null;
        this.styleSheet = null;
        this.sendPanel = null;
        this.configPanel = null;
        this.saveButton = null;
        this.runMonday = null;
        this.runThursday = null;
        this.useAllergenInfoSheetExchange = null;
        this.sendErrorReport = null;
        this.errorReportTargets = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.ARTICLE_CONSUMPTION;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.saveButton) {
            this.setEnabled(false);
            this.ensureAnimation(Words.SAVE_DATA);
            this.saveConfig();
            this.module.started();
        } else if (source == this.sendErrorReport.getElement()) {
            this.setEnabled(this.isEnabled());
        } else if (source == this.runMonday) {
            this.setEnabled(false);
            this.ensureAnimation("Generate Monday Report");
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    ((AllergenInfoSheetExchangeServiceManager)ServiceManagerRegistry.getService(AllergenInfoSheetExchangeServiceManager.class)).sendMondayReport();
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            AllergenInfoSheetExchangeInsert.this.hideAnimation();
                            AllergenInfoSheetExchangeInsert.this.setEnabled(true);
                        }

                        public void errorOccurred(ClientException e) {
                            AllergenInfoSheetExchangeInsert.this.setEnabled(true);
                            InnerPopupFactory.showErrorDialog((Exception)e, (Component)AllergenInfoSheetExchangeInsert.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (source == this.runThursday) {
            this.setEnabled(false);
            this.ensureAnimation("Generate Monday Report");
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    ((AllergenInfoSheetExchangeServiceManager)ServiceManagerRegistry.getService(AllergenInfoSheetExchangeServiceManager.class)).sendThursdayReport();
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            AllergenInfoSheetExchangeInsert.this.hideAnimation();
                            AllergenInfoSheetExchangeInsert.this.setEnabled(true);
                        }

                        public void errorOccurred(ClientException e) {
                            AllergenInfoSheetExchangeInsert.this.setEnabled(true);
                            InnerPopupFactory.showErrorDialog((Exception)e, (Component)AllergenInfoSheetExchangeInsert.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateArticleConsumptionConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                AllergenInfoSheetExchangeInsert.this.settings.commit(AllergenInfoSheetExchangeSettingsComplete.class);
                AllergenInfoSheetExchangeSettingsComplete arisc = (AllergenInfoSheetExchangeSettingsComplete)AllergenInfoSheetExchangeInsert.this.settings.getValue();
                if (Boolean.TRUE.equals(arisc.getUseAllergenInfoSheetExchange())) {
                    arisc.setMondayTimerSettings(AllergenInfoSheetExchangeInsert.this.createTimerService(DayOfWeekE.MONDAY));
                    TimerServiceSettingsComplete tsMonday = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(arisc.getMondayTimerSettings()).getValue();
                    arisc.setMondayTimerSettings(tsMonday);
                    arisc.setThursdayTimerSettings(AllergenInfoSheetExchangeInsert.this.createTimerService(DayOfWeekE.THURSDAY));
                    TimerServiceSettingsComplete tsThursday = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(arisc.getThursdayTimerSettings()).getValue();
                    arisc.setThursdayTimerSettings(tsThursday);
                    arisc.setMondayTimerSettingsRecheck(AllergenInfoSheetExchangeInsert.this.createTimerServiceCheck(DayOfWeekE.MONDAY));
                    TimerServiceSettingsComplete tsMondayCheck = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(arisc.getMondayTimerSettingsRecheck()).getValue();
                    arisc.setMondayTimerSettingsRecheck(tsMondayCheck);
                    arisc.setThursdayTimerSettingsRecheck(AllergenInfoSheetExchangeInsert.this.createTimerServiceCheck(DayOfWeekE.THURSDAY));
                    TimerServiceSettingsComplete tsThursdayCheck = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(arisc.getThursdayTimerSettingsRecheck()).getValue();
                    arisc.setThursdayTimerSettingsRecheck(tsThursdayCheck);
                    arisc = (AllergenInfoSheetExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)arisc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.ALLERGEN_INFO_SHEET_EXCHANGE_MONDAY, true, arisc.getMondayTimerSettings(), -1L);
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.ALLERGEN_INFO_SHEET_EXCHANGE_THURSDAY, true, arisc.getThursdayTimerSettings(), -1L);
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.ALLERGEN_INFO_SHEET_EXCHANGE_MONDAY_RECHECK, true, arisc.getMondayTimerSettingsRecheck(), -1L);
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.ALLERGEN_INFO_SHEET_EXCHANGE_THURSDAY_RECHECK, true, arisc.getThursdayTimerSettingsRecheck(), -1L);
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)arisc, false, false);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.ALLERGEN_INFO_SHEET_EXCHANGE_MONDAY);
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.ALLERGEN_INFO_SHEET_EXCHANGE_THURSDAY);
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.ALLERGEN_INFO_SHEET_EXCHANGE_MONDAY_RECHECK);
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.ALLERGEN_INFO_SHEET_EXCHANGE_THURSDAY_RECHECK);
                    arisc = (AllergenInfoSheetExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)arisc).getValue();
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)arisc, false, false);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        AllergenInfoSheetExchangeInsert.this.hideAnimation();
                        AllergenInfoSheetExchangeInsert.this.module.ended();
                        AllergenInfoSheetExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)AllergenInfoSheetExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerService(DayOfWeekE monday) {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DayOfWeekTimeComplete(monday, Integer.valueOf(0), Integer.valueOf(15)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private TimerServiceSettingsComplete createTimerServiceCheck(DayOfWeekE monday) {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DayOfWeekTimeComplete(monday, Integer.valueOf(1), Integer.valueOf(15)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            AllergenInfoSheetExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            AllergenInfoSheetExchangeInsert.this.useAllergenInfoSheetExchange.setLocation(border, border + AllergenInfoSheetExchangeInsert.this.configPanel.getTitleHeight());
            AllergenInfoSheetExchangeInsert.this.useAllergenInfoSheetExchange.setSize(AllergenInfoSheetExchangeInsert.this.useAllergenInfoSheetExchange.getPreferredSize());
            AllergenInfoSheetExchangeInsert.this.reportedCustomers.setLocation(border, AllergenInfoSheetExchangeInsert.this.useAllergenInfoSheetExchange.getY() + AllergenInfoSheetExchangeInsert.this.useAllergenInfoSheetExchange.getHeight() + border);
            AllergenInfoSheetExchangeInsert.this.reportedCustomers.setSize(250, 250);
            AllergenInfoSheetExchangeInsert.this.separateReportByCustomer.setLocation(border, AllergenInfoSheetExchangeInsert.this.reportedCustomers.getY() + AllergenInfoSheetExchangeInsert.this.reportedCustomers.getHeight() + border);
            AllergenInfoSheetExchangeInsert.this.separateReportByCustomer.setSize(AllergenInfoSheetExchangeInsert.this.separateReportByCustomer.getPreferredSize());
            AllergenInfoSheetExchangeInsert.this.usedArchivedAllergenInfoSheet.setLocation(border, AllergenInfoSheetExchangeInsert.this.separateReportByCustomer.getY() + AllergenInfoSheetExchangeInsert.this.separateReportByCustomer.getHeight() + border);
            AllergenInfoSheetExchangeInsert.this.usedArchivedAllergenInfoSheet.setSize(AllergenInfoSheetExchangeInsert.this.usedArchivedAllergenInfoSheet.getPreferredSize());
            AllergenInfoSheetExchangeInsert.this.reportByDay.setLocation(border, AllergenInfoSheetExchangeInsert.this.usedArchivedAllergenInfoSheet.getY() + AllergenInfoSheetExchangeInsert.this.usedArchivedAllergenInfoSheet.getHeight() + border);
            AllergenInfoSheetExchangeInsert.this.reportByDay.setSize(AllergenInfoSheetExchangeInsert.this.reportByDay.getPreferredSize());
            AllergenInfoSheetExchangeInsert.this.mailTargets.setLocation(border, AllergenInfoSheetExchangeInsert.this.reportByDay.getY() + AllergenInfoSheetExchangeInsert.this.reportByDay.getHeight() + border);
            AllergenInfoSheetExchangeInsert.this.mailTargets.setSize(parent.getWidth() - 2 * border, (int)AllergenInfoSheetExchangeInsert.this.mailTargets.getPreferredSize().getHeight());
            AllergenInfoSheetExchangeInsert.this.styleSheet.setLocation(border, AllergenInfoSheetExchangeInsert.this.mailTargets.getY() + AllergenInfoSheetExchangeInsert.this.mailTargets.getHeight() + border);
            AllergenInfoSheetExchangeInsert.this.styleSheet.setSize(250, (int)AllergenInfoSheetExchangeInsert.this.styleSheet.getPreferredSize().getHeight());
            AllergenInfoSheetExchangeInsert.this.sendErrorReport.setLocation(border, AllergenInfoSheetExchangeInsert.this.styleSheet.getY() + AllergenInfoSheetExchangeInsert.this.styleSheet.getHeight() + border);
            AllergenInfoSheetExchangeInsert.this.sendErrorReport.setSize(AllergenInfoSheetExchangeInsert.this.sendErrorReport.getPreferredSize());
            AllergenInfoSheetExchangeInsert.this.errorReportTargets.setLocation(border, AllergenInfoSheetExchangeInsert.this.sendErrorReport.getY() + AllergenInfoSheetExchangeInsert.this.sendErrorReport.getHeight() + border);
            AllergenInfoSheetExchangeInsert.this.errorReportTargets.setSize(parent.getWidth() - 2 * border, (int)AllergenInfoSheetExchangeInsert.this.errorReportTargets.getPreferredSize().getHeight());
            AllergenInfoSheetExchangeInsert.this.saveButton.setLocation(border, (int)((double)parent.getHeight() - ((double)border + AllergenInfoSheetExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            AllergenInfoSheetExchangeInsert.this.saveButton.setSize(AllergenInfoSheetExchangeInsert.this.saveButton.getPreferredSize());
            AllergenInfoSheetExchangeInsert.this.runMonday.setLocation(AllergenInfoSheetExchangeInsert.this.saveButton.getX() + AllergenInfoSheetExchangeInsert.this.saveButton.getWidth() + border, AllergenInfoSheetExchangeInsert.this.saveButton.getY());
            AllergenInfoSheetExchangeInsert.this.runMonday.setSize(AllergenInfoSheetExchangeInsert.this.runMonday.getPreferredSize());
            AllergenInfoSheetExchangeInsert.this.runThursday.setLocation(AllergenInfoSheetExchangeInsert.this.runMonday.getX() + AllergenInfoSheetExchangeInsert.this.runMonday.getWidth() + border, AllergenInfoSheetExchangeInsert.this.saveButton.getY());
            AllergenInfoSheetExchangeInsert.this.runThursday.setSize(AllergenInfoSheetExchangeInsert.this.runThursday.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            AllergenInfoSheetExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (AllergenInfoSheetExchangeInsert.this.animation != null) {
                AllergenInfoSheetExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - AllergenInfoSheetExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - AllergenInfoSheetExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                AllergenInfoSheetExchangeInsert.this.animation.setSize(AllergenInfoSheetExchangeInsert.this.animation.getPreferredSize());
            }
            if (AllergenInfoSheetExchangeInsert.this.isInserted) {
                AllergenInfoSheetExchangeInsert.this.configPanel.setLocation(border, border);
                AllergenInfoSheetExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                AllergenInfoSheetExchangeInsert.this.sendPanel.setLocation(AllergenInfoSheetExchangeInsert.this.configPanel.getX() + AllergenInfoSheetExchangeInsert.this.configPanel.getWidth() + border, border);
                AllergenInfoSheetExchangeInsert.this.sendPanel.setSize(AllergenInfoSheetExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

