/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.UserSearchTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.exchange.CustomsDeadlineExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.ESpecsSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.report.especs.ESpecsConfig;
import ch.icit.pegasus.server.core.dtos.store.customsdeadline.CustomsDeadlineSettingsComplete;
import ch.icit.pegasus.server.core.dtos.store.customsdeadline.CustomsDeadlineSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CustomsDeadlineExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useAutoCheck;
    private TitledItem<TextField> defaultDeadlineDays;
    private TitledItem<TextField> defaultWarningDays;
    private TitledItem<TextField> recipients;
    private HorizontalSeparator sep1;
    private TablePanelAddSaveButton checkButton;
    private TablePanelAddSaveButton saveButton;
    private UserSearchTable usersToInform;
    private final DataExchangeModule module;
    private Node<CustomsDeadlineSettingsComplete> settings;

    public CustomsDeadlineExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
        ESpecsConfig e = new ESpecsConfig();
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useAutoCheck = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(CustomsDeadlineSettingsComplete_.useAutoCheck)), "Auto Check Customs Deadlines", TitledItem.TitledItemOrientation.EAST);
        this.useAutoCheck.getElement().addButtonListener(this);
        this.defaultDeadlineDays = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(CustomsDeadlineSettingsComplete_.defaultDeadlineDays), TextFieldType.LONG), "Default Deadline Days", TitledItem.TitledItemOrientation.NORTH);
        this.defaultWarningDays = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(CustomsDeadlineSettingsComplete_.defaultWarningDays), TextFieldType.LONG), "Default Deadline Warning Days", TitledItem.TitledItemOrientation.NORTH);
        this.recipients = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(CustomsDeadlineSettingsComplete_.mailRecipients)), "Email Recipients", TitledItem.TitledItemOrientation.NORTH);
        this.sep1 = new HorizontalSeparator();
        this.usersToInform = new UserSearchTable();
        this.usersToInform.getModel().setNode(this.settings.getChildNamed(ESpecsSettingsComplete_.user));
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.checkButton = new TablePanelAddSaveButton();
        this.checkButton.setText(Words.CHECK_ALL);
        this.checkButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.defaultDeadlineDays);
        this.configPanel.add(this.defaultWarningDays);
        this.configPanel.add(this.useAutoCheck);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.sep1);
        this.configPanel.add(this.usersToInform);
        this.configPanel.add(this.recipients);
        this.sendPanel.add(this.checkButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                CustomsDeadlineSettingsComplete esc = null;
                try {
                    esc = (CustomsDeadlineSettingsComplete)((CustomsDeadlineExchangeServiceManager)ServiceManagerRegistry.getService(CustomsDeadlineExchangeServiceManager.class)).getCustomsDeadlineSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (esc == null) {
                    CustomsDeadlineSettingsComplete s = new CustomsDeadlineSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc = s;
                }
                if (esc.getDeadlineCheckTimer() == null) {
                    esc.setDeadlineCheckTimer(CustomsDeadlineExchangeInsert.this.createTimerServiceTime());
                }
                CustomsDeadlineExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)esc, false, false);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return CustomsDeadlineExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerServiceTime() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(20), Integer.valueOf(50)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useAutoCheck.setEnabled(isEnabled);
            boolean b = isEnabled && this.useAutoCheck.getElement().isChecked();
            this.checkButton.setEnabled(b);
            this.defaultWarningDays.setEnabled(b);
            this.defaultDeadlineDays.setEnabled(b);
            this.sep1.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
            this.recipients.setEnabled(b);
            this.usersToInform.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.recipients.kill();
            this.recipients.kill();
            this.saveButton.kill();
            this.sep1.kill();
            this.useAutoCheck.kill();
            this.usersToInform.kill();
            this.usersToInform = null;
            this.defaultDeadlineDays.kill();
            this.defaultDeadlineDays = null;
            this.defaultWarningDays.kill();
            this.defaultWarningDays = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.checkButton = null;
        this.saveButton = null;
        this.sep1 = null;
        this.useAutoCheck = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.NOPRO_EXCHANGE;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.checkButton || source == this.saveButton) {
            this.settings.commit();
            this.setEnabled(false);
            if (source == this.checkButton) {
                this.ensureAnimation(Words.EXCHANGE);
                this.processFiles(true);
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateESpecsConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateESpecsConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                CustomsDeadlineExchangeInsert.this.settings.commit(CustomsDeadlineSettingsComplete.class);
                CustomsDeadlineSettingsComplete customsDeadlineSettings = (CustomsDeadlineSettingsComplete)CustomsDeadlineExchangeInsert.this.settings.getValue();
                if (customsDeadlineSettings.getDeadlineCheckTimer() == null) {
                    customsDeadlineSettings.setDeadlineCheckTimer(CustomsDeadlineExchangeInsert.this.createTimerServiceTime());
                }
                TimerServiceSettingsComplete checkerTs = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(customsDeadlineSettings.getDeadlineCheckTimer()).getValue();
                customsDeadlineSettings = (CustomsDeadlineSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)customsDeadlineSettings).getValue();
                ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.CUSTOMS_DEADLINE, customsDeadlineSettings.getUseAutoCheck().booleanValue(), checkerTs, -1L);
                CustomsDeadlineExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)customsDeadlineSettings, false, false);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        CustomsDeadlineExchangeInsert.this.hideAnimation();
                        CustomsDeadlineExchangeInsert.this.module.ended();
                        CustomsDeadlineExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)CustomsDeadlineExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles(boolean read) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((CustomsDeadlineExchangeServiceManager)ServiceManagerRegistry.getService(CustomsDeadlineExchangeServiceManager.class)).checkCustomsDeadline();
                ViewNode n = new ViewNode("");
                n.setValue((Object)true, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        CustomsDeadlineExchangeInsert.this.hideAnimation();
                        CustomsDeadlineExchangeInsert.this.module.ended();
                        CustomsDeadlineExchangeInsert.this.setEnabled(true);
                        InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_PROCESSED, CustomsDeadlineExchangeInsert.this.checkButton);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_PROCESS, (Component)CustomsDeadlineExchangeInsert.this.checkButton);
                        CustomsDeadlineExchangeInsert.this.hideAnimation();
                        CustomsDeadlineExchangeInsert.this.setEnabled(true);
                        CustomsDeadlineExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            CustomsDeadlineExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            CustomsDeadlineExchangeInsert.this.useAutoCheck.setLocation(border, border + CustomsDeadlineExchangeInsert.this.configPanel.getTitleHeight());
            CustomsDeadlineExchangeInsert.this.useAutoCheck.setSize(CustomsDeadlineExchangeInsert.this.useAutoCheck.getPreferredSize());
            CustomsDeadlineExchangeInsert.this.sep1.setLocation(1, CustomsDeadlineExchangeInsert.this.useAutoCheck.getY() + CustomsDeadlineExchangeInsert.this.useAutoCheck.getHeight() + 1);
            CustomsDeadlineExchangeInsert.this.sep1.setSize(parent.getWidth() - 2, (int)CustomsDeadlineExchangeInsert.this.sep1.getPreferredSize().getHeight());
            CustomsDeadlineExchangeInsert.this.defaultDeadlineDays.setLocation(CustomsDeadlineExchangeInsert.this.useAutoCheck.getX(), CustomsDeadlineExchangeInsert.this.sep1.getY() + CustomsDeadlineExchangeInsert.this.sep1.getHeight() + border / 2);
            CustomsDeadlineExchangeInsert.this.defaultDeadlineDays.setSize(200, (int)CustomsDeadlineExchangeInsert.this.defaultDeadlineDays.getPreferredSize().getHeight());
            CustomsDeadlineExchangeInsert.this.defaultWarningDays.setLocation(border, CustomsDeadlineExchangeInsert.this.defaultDeadlineDays.getY() + CustomsDeadlineExchangeInsert.this.defaultDeadlineDays.getHeight() + border);
            CustomsDeadlineExchangeInsert.this.defaultWarningDays.setSize(200, (int)CustomsDeadlineExchangeInsert.this.defaultWarningDays.getPreferredSize().getHeight());
            CustomsDeadlineExchangeInsert.this.recipients.setLocation(border, CustomsDeadlineExchangeInsert.this.defaultWarningDays.getY() + CustomsDeadlineExchangeInsert.this.defaultWarningDays.getHeight() + border);
            CustomsDeadlineExchangeInsert.this.recipients.setSize(200, (int)CustomsDeadlineExchangeInsert.this.recipients.getPreferredSize().getHeight());
            CustomsDeadlineExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - CustomsDeadlineExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + CustomsDeadlineExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            CustomsDeadlineExchangeInsert.this.saveButton.setSize(CustomsDeadlineExchangeInsert.this.saveButton.getPreferredSize());
            CustomsDeadlineExchangeInsert.this.usersToInform.setLocation(border, CustomsDeadlineExchangeInsert.this.recipients.getY() + CustomsDeadlineExchangeInsert.this.recipients.getHeight() + border);
            CustomsDeadlineExchangeInsert.this.usersToInform.setSize(parent.getWidth() - 2 * CustomsDeadlineExchangeInsert.this.usersToInform.getX(), parent.getHeight() - CustomsDeadlineExchangeInsert.this.usersToInform.getY());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            CustomsDeadlineExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            CustomsDeadlineExchangeInsert.this.checkButton.setLocation((int)((double)parent.getWidth() - CustomsDeadlineExchangeInsert.this.checkButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (2.0 * CustomsDeadlineExchangeInsert.this.checkButton.getPreferredSize().getHeight() + (double)(2 * border))));
            CustomsDeadlineExchangeInsert.this.checkButton.setSize(CustomsDeadlineExchangeInsert.this.checkButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (CustomsDeadlineExchangeInsert.this.animation != null) {
                CustomsDeadlineExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - CustomsDeadlineExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - CustomsDeadlineExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                CustomsDeadlineExchangeInsert.this.animation.setSize(CustomsDeadlineExchangeInsert.this.animation.getPreferredSize());
            }
            if (CustomsDeadlineExchangeInsert.this.isInserted) {
                CustomsDeadlineExchangeInsert.this.configPanel.setLocation(border, border);
                CustomsDeadlineExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                CustomsDeadlineExchangeInsert.this.sendPanel.setLocation(CustomsDeadlineExchangeInsert.this.configPanel.getX() + CustomsDeadlineExchangeInsert.this.configPanel.getWidth() + border, border);
                CustomsDeadlineExchangeInsert.this.sendPanel.setSize(CustomsDeadlineExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

