/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.converter.DayTimeConverter;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.MailTable;
import ch.icit.pegasus.client.gui.utils.textfield.DateTimeTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.FlightTransactionGeneratorServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailReceiptComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.FlightTransactionGeneratorSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.FlightTransactionGeneratorSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class FlightTransactionGeneratorInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel configPanel;
    private TextLabel infoText;
    private TablePanelAddSaveButton processingButton;
    private TablePanelAddSaveButton saveButton;
    private TitledItem<DateTimeTextField> processingTime;
    private final DataExchangeModule module;
    protected Node<FlightTransactionGeneratorSettingsComplete> settings;
    protected FlightTransactionGeneratorSettingsComplete processingSettings;
    private TitledItem<CheckBox> autoSentMail;
    private TablePanelAddSaveButton processingButtonMail;
    private TitledItem<DateTimeTextField> processingTimeMail;
    private MailTable usersToInform;

    public FlightTransactionGeneratorInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.infoText = new TextLabel(Words.SCHEDULED_FLIGHT_TRANSACTION_PROCESSING_INFO_TEXT);
        this.processingTime = new TitledItem<DateTimeTextField>(new DateTimeTextField(this.settings.getChildNamed(FlightTransactionGeneratorSettingsComplete_.processingTime), TextFieldType.DAYTIME), Words.DAILY_PROCESSING_TIME, TitledItem.TitledItemOrientation.NORTH);
        this.processingButton = new TablePanelAddSaveButton();
        this.processingButton.setText(Words.GENERATE_TRANSACTIONS);
        this.processingButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.autoSentMail = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(FlightTransactionGeneratorSettingsComplete_.autoSentMail)), Words.ENABLE_STATISTIC_TRANSACTION, TitledItem.TitledItemOrientation.EAST);
        this.autoSentMail.getElement().addButtonListener(this);
        this.processingTimeMail = new TitledItem<DateTimeTextField>(new DateTimeTextField(this.settings.getChildNamed(FlightTransactionGeneratorSettingsComplete_.processingTimeMail), TextFieldType.DAYTIME), Words.MAIL_SENT_TIME, TitledItem.TitledItemOrientation.NORTH);
        this.usersToInform = new MailTable(){

            @Override
            public Node createNewNode() {
                EMailReceiptComplete receipt = new EMailReceiptComplete();
                receipt.setClientOId(Long.valueOf(ADTO.getNextId()));
                receipt.setMailAddress("");
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)receipt, true, false);
            }
        };
        this.usersToInform.getModel().setNode(this.settings.getChildNamed(new DtoField[]{FlightTransactionGeneratorSettingsComplete_.eMailDataExchangeSettings, EMailDataExchangeSettingsComplete_.mailReceipts}));
        this.processingButtonMail = new TablePanelAddSaveButton();
        this.processingButtonMail.setText(Words.SENT_MAIL);
        this.processingButtonMail.addButtonListener(this);
        this.setLayout(new Layout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.infoText);
        this.configPanel.add(this.processingTime);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.processingButton);
        this.configPanel.add(this.autoSentMail);
        this.configPanel.add(this.processingTimeMail);
        this.configPanel.add(this.processingButtonMail);
        this.configPanel.add(this.usersToInform);
        this.add(this.configPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                UnitToolkit.loadUnits();
                try {
                    FlightTransactionGeneratorInsert.this.processingSettings = (FlightTransactionGeneratorSettingsComplete)((FlightTransactionGeneratorServiceManager)ServiceManagerRegistry.getService(FlightTransactionGeneratorServiceManager.class)).getSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (FlightTransactionGeneratorInsert.this.processingSettings == null) {
                    FlightTransactionGeneratorSettingsComplete s = new FlightTransactionGeneratorSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    FlightTransactionGeneratorInsert.this.processingSettings = s;
                }
                FlightTransactionGeneratorInsert.this.processingSettings.setTimerServiceSettings(FlightTransactionGeneratorInsert.this.createDailyTimerService(3, 0));
                FlightTransactionGeneratorInsert.this.processingSettings.setProcessingTime(DayTimeConverter.mapTime((String)"03:00"));
                FlightTransactionGeneratorInsert.this.processingSettings.setTimerServiceSettingsMail(FlightTransactionGeneratorInsert.this.createDailyTimerService(6, 0));
                FlightTransactionGeneratorInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)FlightTransactionGeneratorInsert.this.processingSettings, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return FlightTransactionGeneratorInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createDailyTimerService(int hourOfDay, int minuteOfHour) {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(hourOfDay), Integer.valueOf(minuteOfHour), Integer.valueOf(0)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.infoText.setEnabled(isEnabled);
            this.processingButton.setEnabled(isEnabled);
            this.processingTime.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            this.autoSentMail.setEnabled(isEnabled);
            this.processingButtonMail.setEnabled(isEnabled);
            this.processingTimeMail.setEnabled(isEnabled);
            this.usersToInform.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.configPanel.kill();
            this.processingTime.kill();
            this.saveButton.kill();
            this.infoText.kill();
        }
        this.infoText = null;
        this.configPanel = null;
        this.processingButton = null;
        this.processingTime = null;
        this.saveButton = null;
        if (this.isInserted) {
            this.autoSentMail.kill();
            this.processingTimeMail.kill();
            this.usersToInform.kill();
        }
        this.autoSentMail = null;
        this.processingButtonMail = null;
        this.processingTimeMail = null;
        this.usersToInform = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.SCHEDULED_FLIGHT_TRANSACTION_PROCESSING;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.processingButton || source == this.saveButton || source == this.processingButtonMail) {
            this.setEnabled(false);
            if (source == this.processingButton) {
                this.ensureAnimation(Words.SEND_FLIGHT_TRANSACTION_GENERATOR_DATA);
                this.processFiles();
            } else if (source == this.processingButtonMail) {
                this.ensureAnimation(Words.SEND_MAIL_TRANSACTION_STATISTIC);
                this.processFilesMail();
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateFlightTransationGeneratorConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateFlightTransationGeneratorConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                FlightTransactionGeneratorInsert.this.settings.commit(FlightTransactionGeneratorSettingsComplete.class);
                FlightTransactionGeneratorSettingsComplete arisc = (FlightTransactionGeneratorSettingsComplete)FlightTransactionGeneratorInsert.this.settings.getValue();
                if (FlightTransactionGeneratorInsert.this.processingTime != null && FlightTransactionGeneratorInsert.this.processingTime.getElement() != null && ((DateTimeTextField)FlightTransactionGeneratorInsert.this.processingTime.getElement()).getText() != null) {
                    arisc.setProcessingTime(DayTimeConverter.mapTime((String)((DateTimeTextField)FlightTransactionGeneratorInsert.this.processingTime.getElement()).getText()));
                }
                if (FlightTransactionGeneratorInsert.this.processingTimeMail != null && FlightTransactionGeneratorInsert.this.processingTimeMail.getElement() != null && ((DateTimeTextField)FlightTransactionGeneratorInsert.this.processingTimeMail.getElement()).getText() != null) {
                    arisc.setProcessingTimeMail(DayTimeConverter.mapTime((String)((DateTimeTextField)FlightTransactionGeneratorInsert.this.processingTimeMail.getElement()).getText()));
                }
                arisc.setTimerServiceSettings(FlightTransactionGeneratorInsert.this.createDailyTimerService(3, 0));
                arisc.setTimerServiceSettingsMail(FlightTransactionGeneratorInsert.this.createDailyTimerService(6, 0));
                ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.FLIGHT_TRANSACTION_GENERATOR, true, arisc.getTimerServiceSettings(), -1L);
                arisc = (FlightTransactionGeneratorSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)arisc).getValue();
                FlightTransactionGeneratorInsert.this.settings.commit(FlightTransactionGeneratorSettingsComplete.class);
                FlightTransactionGeneratorSettingsComplete sfftsc = (FlightTransactionGeneratorSettingsComplete)FlightTransactionGeneratorInsert.this.settings.getValue();
                sfftsc.setAutoSentMail(Boolean.valueOf(((CheckBox)FlightTransactionGeneratorInsert.this.autoSentMail.getElement()).isChecked()));
                if (FlightTransactionGeneratorInsert.this.processingTimeMail != null && FlightTransactionGeneratorInsert.this.processingTimeMail.getElement() != null && ((DateTimeTextField)FlightTransactionGeneratorInsert.this.processingTimeMail.getElement()).getText() != null) {
                    sfftsc.setProcessingTimeMail(DayTimeConverter.mapTime((String)((DateTimeTextField)FlightTransactionGeneratorInsert.this.processingTimeMail.getElement()).getText()));
                }
                if (sfftsc.getEMailDataExchangeSettings() == null) {
                    sfftsc.setEMailDataExchangeSettings(new EMailDataExchangeSettingsComplete());
                }
                sfftsc.getEMailDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.EMAIL);
                List<Table2RowPanel> uTIFList = FlightTransactionGeneratorInsert.this.usersToInform.getRows();
                sfftsc.getEMailDataExchangeSettings().setMailReceipts(new ArrayList());
                for (Table2RowPanel utif : uTIFList) {
                    EMailReceiptComplete l = (EMailReceiptComplete)utif.getModel().getNode().getValue();
                    if (sfftsc.getEMailDataExchangeSettings().getMailReceipts().contains(l)) continue;
                    sfftsc.getEMailDataExchangeSettings().getMailReceipts().add(l);
                }
                if (sfftsc != null && Boolean.TRUE.equals(sfftsc.getAutoSentMail())) {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.STATISTIC_FOR_FLIGHT_TRANSACTION, true, sfftsc.getTimerServiceSettingsMail(), -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.STATISTIC_FOR_FLIGHT_TRANSACTION);
                }
                sfftsc = (FlightTransactionGeneratorSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)sfftsc).getValue();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        FlightTransactionGeneratorInsert.this.hideAnimation();
                        FlightTransactionGeneratorInsert.this.module.ended();
                        FlightTransactionGeneratorInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)FlightTransactionGeneratorInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((FlightTransactionGeneratorServiceManager)ServiceManagerRegistry.getService(FlightTransactionGeneratorServiceManager.class)).createFlightTransactions();
                n.setValue((Object)true, 0L);
                FlightTransactionGeneratorInsert.this.processingSettings = (FlightTransactionGeneratorSettingsComplete)((FlightTransactionGeneratorServiceManager)ServiceManagerRegistry.getService(FlightTransactionGeneratorServiceManager.class)).getSettings().getValue();
                FlightTransactionGeneratorInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)FlightTransactionGeneratorInsert.this.processingSettings, false, false);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        FlightTransactionGeneratorInsert.this.hideAnimation();
                        FlightTransactionGeneratorInsert.this.module.ended();
                        FlightTransactionGeneratorInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_PROCESSED, FlightTransactionGeneratorInsert.this.processingButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_PROCESS_FLIGHT_TRANSACTIONS, (Component)FlightTransactionGeneratorInsert.this.processingButton);
                        FlightTransactionGeneratorInsert.this.hideAnimation();
                        FlightTransactionGeneratorInsert.this.setEnabled(true);
                        FlightTransactionGeneratorInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFilesMail() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((FlightTransactionGeneratorServiceManager)ServiceManagerRegistry.getService(FlightTransactionGeneratorServiceManager.class)).createStatisticForFlightTransactions();
                n.setValue((Object)true, 0L);
                FlightTransactionGeneratorInsert.this.processingSettings = (FlightTransactionGeneratorSettingsComplete)((FlightTransactionGeneratorServiceManager)ServiceManagerRegistry.getService(FlightTransactionGeneratorServiceManager.class)).getSettings().getValue();
                if (FlightTransactionGeneratorInsert.this.processingSettings.getTimerServiceSettingsMail() == null) {
                    TimerServiceSettingsComplete ts = FlightTransactionGeneratorInsert.this.createDailyTimerService(1, 45);
                    FlightTransactionGeneratorInsert.this.processingSettings.setTimerServiceSettingsMail(ts);
                    FlightTransactionGeneratorInsert.this.processingSettings.setProcessingTime(DayTimeConverter.mapTime((String)"01:45"));
                }
                FlightTransactionGeneratorInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)FlightTransactionGeneratorInsert.this.processingSettings, false, false);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        FlightTransactionGeneratorInsert.this.hideAnimation();
                        FlightTransactionGeneratorInsert.this.module.ended();
                        FlightTransactionGeneratorInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_PROCESSED, FlightTransactionGeneratorInsert.this.processingButtonMail);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_PROCESS_FLIGHT_TRANSACTIONS, (Component)FlightTransactionGeneratorInsert.this.processingButtonMail);
                        FlightTransactionGeneratorInsert.this.hideAnimation();
                        FlightTransactionGeneratorInsert.this.setEnabled(true);
                        FlightTransactionGeneratorInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            FlightTransactionGeneratorInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            FlightTransactionGeneratorInsert.this.infoText.setLocation(border, border + FlightTransactionGeneratorInsert.this.configPanel.getTitleHeight());
            FlightTransactionGeneratorInsert.this.infoText.setSize(parent.getWidth() - 2 * border, (int)FlightTransactionGeneratorInsert.this.infoText.getPreferredSize().getHeight());
            FlightTransactionGeneratorInsert.this.processingTime.setLocation(border, FlightTransactionGeneratorInsert.this.infoText.getY() + FlightTransactionGeneratorInsert.this.infoText.getHeight());
            FlightTransactionGeneratorInsert.this.processingTime.setSize(250, (int)FlightTransactionGeneratorInsert.this.processingTime.getPreferredSize().getHeight());
            FlightTransactionGeneratorInsert.this.saveButton.setLocation(border, (int)((double)parent.getHeight() - ((double)border + FlightTransactionGeneratorInsert.this.saveButton.getPreferredSize().getHeight())));
            FlightTransactionGeneratorInsert.this.saveButton.setSize(FlightTransactionGeneratorInsert.this.saveButton.getPreferredSize());
            FlightTransactionGeneratorInsert.this.processingButton.setLocation(border + FlightTransactionGeneratorInsert.this.saveButton.getWidth() + border, (int)((double)parent.getHeight() - ((double)border + FlightTransactionGeneratorInsert.this.processingButton.getPreferredSize().getHeight())));
            FlightTransactionGeneratorInsert.this.processingButton.setSize(FlightTransactionGeneratorInsert.this.processingButton.getPreferredSize());
            FlightTransactionGeneratorInsert.this.autoSentMail.setLocation(border, FlightTransactionGeneratorInsert.this.processingTime.getY() + 3 * FlightTransactionGeneratorInsert.this.processingTime.getHeight());
            FlightTransactionGeneratorInsert.this.autoSentMail.setSize(FlightTransactionGeneratorInsert.this.autoSentMail.getPreferredSize());
            FlightTransactionGeneratorInsert.this.processingTimeMail.setLocation(border, FlightTransactionGeneratorInsert.this.autoSentMail.getY() + FlightTransactionGeneratorInsert.this.autoSentMail.getHeight());
            FlightTransactionGeneratorInsert.this.processingTimeMail.setSize(parent.getWidth() - 2 * border, (int)FlightTransactionGeneratorInsert.this.processingTimeMail.getPreferredSize().getHeight());
            FlightTransactionGeneratorInsert.this.usersToInform.setLocation(border, FlightTransactionGeneratorInsert.this.processingTimeMail.getY() + FlightTransactionGeneratorInsert.this.processingTimeMail.getHeight() + border);
            FlightTransactionGeneratorInsert.this.usersToInform.setSize(parent.getWidth() - 2 * FlightTransactionGeneratorInsert.this.usersToInform.getX(), 150);
            FlightTransactionGeneratorInsert.this.processingButtonMail.setLocation(border + FlightTransactionGeneratorInsert.this.saveButton.getWidth() + 180 + border, (int)((double)parent.getHeight() - ((double)border + FlightTransactionGeneratorInsert.this.saveButton.getPreferredSize().getHeight())));
            FlightTransactionGeneratorInsert.this.processingButtonMail.setSize(FlightTransactionGeneratorInsert.this.processingButtonMail.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (FlightTransactionGeneratorInsert.this.animation != null) {
                FlightTransactionGeneratorInsert.this.animation.setLocation((int)((double)parent.getWidth() - FlightTransactionGeneratorInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - FlightTransactionGeneratorInsert.this.animation.getPreferredSize().getHeight()) / 2);
                FlightTransactionGeneratorInsert.this.animation.setSize(FlightTransactionGeneratorInsert.this.animation.getPreferredSize());
            }
            if (FlightTransactionGeneratorInsert.this.isInserted) {
                FlightTransactionGeneratorInsert.this.configPanel.setLocation(border, border);
                FlightTransactionGeneratorInsert.this.configPanel.setSize(parent.getWidth() - 2 * border, parent.getHeight() - 2 * border);
            }
        }
    }
}

