/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.converter.RetailInMotionTransactionExchangeLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.MailTable;
import ch.icit.pegasus.client.gui.utils.tables.RetailInMotionTransactionExchangeSheetListTable;
import ch.icit.pegasus.client.gui.utils.tables.RetailInMotionUnitMappingEditTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailReceiptComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionTransactionExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionTransactionExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionUnitMappingSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionTransactionDataExportLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DayOfMonthE;
import ch.icit.pegasus.server.core.dtos.util.DayOfMonthTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetailInMotionTransactionExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static Logger log = LoggerFactory.getLogger(RetailInMotionTransactionExchangeInsert.class);
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> useRetailInMotionTransactionSync;
    private TitledItem<CheckBox> autoSendActive;
    private TitledItem<TextField> headerTemplate;
    private TitledItem<TextField> defaultMailSender;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TextLabel lastUpdates;
    private RetailInMotionUnitMappingEditTable unitMapping;
    private RetailInMotionTransactionExchangeSheetListTable history;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton saveButton;
    private TextButton resetLastSendDate;
    private MailTable usersToInform;
    private final DataExchangeModule module;
    protected Node<List<RetailInMotionTransactionDataExportLight>> retailInMotionData;
    protected Node<RetailInMotionTransactionExchangeSettingsComplete> settings;
    protected RetailInMotionTransactionExchangeSettingsComplete rimtesc;

    public RetailInMotionTransactionExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useRetailInMotionTransactionSync = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionTransactionExchangeSettingsComplete_.useRetailInMotionInterface)), Words.ENABLE_RETAIL_IN_MOTION_TRANSACTION_EXCHANGE, TitledItem.TitledItemOrientation.EAST);
        this.useRetailInMotionTransactionSync.getElement().addButtonListener(this);
        this.autoSendActive = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionTransactionExchangeSettingsComplete_.autoSendMail)), Words.AUTO_SEND, TitledItem.TitledItemOrientation.EAST);
        this.headerTemplate = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{RetailInMotionTransactionExchangeSettingsComplete_.eMailDataExchangeSettings, EMailDataExchangeSettingsComplete_.mailHeaderTemplate})), Words.HEADER_TEMPLATE, TitledItem.TitledItemOrientation.NORTH);
        this.defaultMailSender = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{RetailInMotionTransactionExchangeSettingsComplete_.eMailDataExchangeSettings, EMailDataExchangeSettingsComplete_.defaultMailSender})), Words.MAIL_SENDER, TitledItem.TitledItemOrientation.NORTH);
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(RetailInMotionTransactionExchangeLastUpdateConverter.class));
        this.usersToInform = new MailTable(){

            @Override
            public Node createNewNode() {
                EMailReceiptComplete receipt = new EMailReceiptComplete();
                receipt.setClientOId(Long.valueOf(ADTO.getNextId()));
                receipt.setMailAddress("");
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)receipt, true, false);
            }
        };
        this.usersToInform.getModel().setNode(this.settings.getChildNamed(new DtoField[]{RetailInMotionTransactionExchangeSettingsComplete_.eMailDataExchangeSettings, EMailDataExchangeSettingsComplete_.mailReceipts}));
        this.unitMapping = new RetailInMotionUnitMappingEditTable();
        this.unitMapping.getModel().setNode(this.settings.getChildNamed(RetailInMotionTransactionExchangeSettingsComplete_.unitMapping));
        this.history = new RetailInMotionTransactionExchangeSheetListTable();
        this.history.setNode(this.retailInMotionData);
        this.resetLastSendDate = new TextButton("Reset last send Date");
        this.resetLastSendDate.setProgress(1.0f);
        this.resetLastSendDate.addButtonListener(this);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useRetailInMotionTransactionSync);
        this.configPanel.add(this.autoSendActive);
        this.configPanel.add(this.headerTemplate);
        this.configPanel.add(this.defaultMailSender);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.resetLastSendDate);
        this.configPanel.add(this.usersToInform);
        this.configPanel.add(this.unitMapping);
        this.sendPanel.add(this.history);
        this.sendPanel.add(this.sendButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                UnitToolkit.loadUnits();
                try {
                    RetailInMotionTransactionExchangeInsert.this.rimtesc = (RetailInMotionTransactionExchangeSettingsComplete)((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionTransactionExchangeSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (RetailInMotionTransactionExchangeInsert.this.rimtesc == null) {
                    RetailInMotionTransactionExchangeSettingsComplete s = new RetailInMotionTransactionExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    RetailInMotionTransactionExchangeInsert.this.rimtesc = s;
                }
                RetailInMotionTransactionExchangeInsert.this.rimtesc.setTimerServiceSettings(RetailInMotionTransactionExchangeInsert.this.createMonthlyTimerService());
                RetailInMotionTransactionExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)RetailInMotionTransactionExchangeInsert.this.rimtesc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                RetailInMotionTransactionExchangeInsert.this.retailInMotionData = new ViewNode("data");
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return RetailInMotionTransactionExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createMonthlyTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DayOfMonthTimeComplete(DayOfMonthE.FIFTH, Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0)));
        s.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useRetailInMotionTransactionSync.setEnabled(isEnabled);
            boolean b = isEnabled && this.useRetailInMotionTransactionSync.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.autoSendActive.setEnabled(b);
            this.headerTemplate.setEnabled(b);
            this.defaultMailSender.setEnabled(isEnabled);
            this.lastUpdates.setEnabled(b);
            this.history.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            this.resetLastSendDate.setEnabled(b);
            this.usersToInform.setEnabled(b);
            this.unitMapping.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.autoSendActive.kill();
            this.history.kill();
            this.headerTemplate.kill();
            this.defaultMailSender.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.useRetailInMotionTransactionSync.kill();
            this.resetLastSendDate.kill();
            this.resetLastSendDate = null;
            this.usersToInform.kill();
            this.usersToInform = null;
            this.unitMapping.kill();
            this.unitMapping = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.sendButton = null;
        this.history = null;
        this.autoSendActive = null;
        this.lastUpdates = null;
        this.defaultMailSender = null;
        this.headerTemplate = null;
        this.saveButton = null;
        this.useRetailInMotionTransactionSync = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.RETAIL_INMOTION;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.saveButton) {
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation(Words.EXCHANGE_DATA_WITH_RETAIL_IN_MOTION);
                this.processFiles();
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateRetailinMotionConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else if (source == this.resetLastSendDate) {
            this.settings.getChildNamed(new DtoField[]{RetailInMotionTransactionExchangeSettingsComplete_.eMailDataExchangeSettings, EMailDataExchangeSettingsComplete_.lastDataTransaction}).setValue((Object)new Timestamp(0L), 0L);
            this.settings.commit();
            this.lastUpdates.setNode((Node)this.settings);
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateRetailinMotionConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                RetailInMotionTransactionExchangeInsert.this.settings.commit(RetailInMotionTransactionExchangeSettingsComplete.class);
                RetailInMotionTransactionExchangeSettingsComplete rimtesc = (RetailInMotionTransactionExchangeSettingsComplete)RetailInMotionTransactionExchangeInsert.this.settings.getValue();
                rimtesc.getEMailDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.EMAIL);
                rimtesc.setTimerServiceSettings(RetailInMotionTransactionExchangeInsert.this.createMonthlyTimerService());
                List<Table2RowPanel> uTIFList = RetailInMotionTransactionExchangeInsert.this.usersToInform.getRows();
                rimtesc.getEMailDataExchangeSettings().setMailReceipts(new ArrayList());
                for (Table2RowPanel table2RowPanel : uTIFList) {
                    EMailReceiptComplete l = (EMailReceiptComplete)table2RowPanel.getModel().getNode().getValue();
                    if (rimtesc.getEMailDataExchangeSettings().getMailReceipts().contains(l)) continue;
                    rimtesc.getEMailDataExchangeSettings().getMailReceipts().add(l);
                }
                List<Table2RowPanel> uMList = RetailInMotionTransactionExchangeInsert.this.unitMapping.getRows();
                rimtesc.setUnitMapping(new ArrayList());
                for (Table2RowPanel um : uMList) {
                    RetailInMotionUnitMappingSettingsComplete l = (RetailInMotionUnitMappingSettingsComplete)um.getModel().getNode().getValue();
                    if (rimtesc.getUnitMapping().contains(l)) continue;
                    rimtesc.getUnitMapping().add(l);
                }
                if (rimtesc.getUseRetailInMotionInterface().booleanValue()) {
                    rimtesc = (RetailInMotionTransactionExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimtesc).getValue();
                    Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimtesc, false, false);
                    RetailInMotionTransactionExchangeInsert.this.lastUpdates.setNode(node);
                    RetailInMotionTransactionExchangeInsert.this.history.setNode(RetailInMotionTransactionExchangeInsert.this.retailInMotionData);
                } else {
                    rimtesc = (RetailInMotionTransactionExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimtesc).getValue();
                    RetailInMotionTransactionExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimtesc, false, false);
                    ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    RetailInMotionTransactionExchangeInsert.this.lastUpdates.setNode((Node)RetailInMotionTransactionExchangeInsert.this.settings);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        RetailInMotionTransactionExchangeInsert.this.hideAnimation();
                        RetailInMotionTransactionExchangeInsert.this.module.ended();
                        RetailInMotionTransactionExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)RetailInMotionTransactionExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).sendRetailInMotionTransactionData();
                n.setValue((Object)true, 0L);
                RetailInMotionTransactionExchangeInsert.this.rimtesc = (RetailInMotionTransactionExchangeSettingsComplete)((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionTransactionExchangeSettings().getValue();
                RetailInMotionTransactionExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)RetailInMotionTransactionExchangeInsert.this.rimtesc, false, false);
                RetailInMotionTransactionExchangeInsert.this.lastUpdates.setNode((Node)RetailInMotionTransactionExchangeInsert.this.settings);
                RetailInMotionTransactionExchangeInsert.this.history.setNode(RetailInMotionTransactionExchangeInsert.this.retailInMotionData);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        RetailInMotionTransactionExchangeInsert.this.hideAnimation();
                        RetailInMotionTransactionExchangeInsert.this.module.ended();
                        RetailInMotionTransactionExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, RetailInMotionTransactionExchangeInsert.this.sendButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_CREATE_RETAIL_IN_MOTION_IMPORT, (Component)RetailInMotionTransactionExchangeInsert.this.sendButton);
                        RetailInMotionTransactionExchangeInsert.this.hideAnimation();
                        RetailInMotionTransactionExchangeInsert.this.setEnabled(true);
                        RetailInMotionTransactionExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            RetailInMotionTransactionExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            RetailInMotionTransactionExchangeInsert.this.useRetailInMotionTransactionSync.setLocation(border, border + RetailInMotionTransactionExchangeInsert.this.configPanel.getTitleHeight());
            RetailInMotionTransactionExchangeInsert.this.useRetailInMotionTransactionSync.setSize(RetailInMotionTransactionExchangeInsert.this.useRetailInMotionTransactionSync.getPreferredSize());
            RetailInMotionTransactionExchangeInsert.this.autoSendActive.setLocation(border, RetailInMotionTransactionExchangeInsert.this.useRetailInMotionTransactionSync.getY() + RetailInMotionTransactionExchangeInsert.this.useRetailInMotionTransactionSync.getHeight());
            RetailInMotionTransactionExchangeInsert.this.autoSendActive.setSize(RetailInMotionTransactionExchangeInsert.this.autoSendActive.getPreferredSize());
            RetailInMotionTransactionExchangeInsert.this.headerTemplate.setLocation(border, RetailInMotionTransactionExchangeInsert.this.autoSendActive.getY() + RetailInMotionTransactionExchangeInsert.this.autoSendActive.getHeight() + border);
            RetailInMotionTransactionExchangeInsert.this.headerTemplate.setSize(220, (int)RetailInMotionTransactionExchangeInsert.this.headerTemplate.getPreferredSize().getHeight());
            RetailInMotionTransactionExchangeInsert.this.defaultMailSender.setLocation(RetailInMotionTransactionExchangeInsert.this.headerTemplate.getX() + RetailInMotionTransactionExchangeInsert.this.headerTemplate.getWidth() + border, RetailInMotionTransactionExchangeInsert.this.headerTemplate.getY());
            RetailInMotionTransactionExchangeInsert.this.defaultMailSender.setSize(220, (int)RetailInMotionTransactionExchangeInsert.this.defaultMailSender.getPreferredSize().getHeight());
            RetailInMotionTransactionExchangeInsert.this.lastUpdates.setLocation(border, RetailInMotionTransactionExchangeInsert.this.defaultMailSender.getY() + RetailInMotionTransactionExchangeInsert.this.defaultMailSender.getHeight());
            RetailInMotionTransactionExchangeInsert.this.lastUpdates.setSize(RetailInMotionTransactionExchangeInsert.this.lastUpdates.getPreferredSize());
            RetailInMotionTransactionExchangeInsert.this.resetLastSendDate.setLocation(RetailInMotionTransactionExchangeInsert.this.lastUpdates.getX() + RetailInMotionTransactionExchangeInsert.this.lastUpdates.getWidth() + border, RetailInMotionTransactionExchangeInsert.this.lastUpdates.getY());
            RetailInMotionTransactionExchangeInsert.this.resetLastSendDate.setSize(RetailInMotionTransactionExchangeInsert.this.resetLastSendDate.getPreferredSize());
            RetailInMotionTransactionExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - RetailInMotionTransactionExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + RetailInMotionTransactionExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            RetailInMotionTransactionExchangeInsert.this.saveButton.setSize(RetailInMotionTransactionExchangeInsert.this.saveButton.getPreferredSize());
            RetailInMotionTransactionExchangeInsert.this.usersToInform.setLocation(border, RetailInMotionTransactionExchangeInsert.this.resetLastSendDate.getY() + RetailInMotionTransactionExchangeInsert.this.resetLastSendDate.getHeight() + border);
            RetailInMotionTransactionExchangeInsert.this.usersToInform.setSize(parent.getWidth() - 2 * RetailInMotionTransactionExchangeInsert.this.usersToInform.getX(), 150);
            RetailInMotionTransactionExchangeInsert.this.unitMapping.setLocation(border, RetailInMotionTransactionExchangeInsert.this.usersToInform.getY() + RetailInMotionTransactionExchangeInsert.this.usersToInform.getHeight() + border);
            RetailInMotionTransactionExchangeInsert.this.unitMapping.setSize(parent.getWidth() - 2 * RetailInMotionTransactionExchangeInsert.this.unitMapping.getX(), parent.getHeight() - (RetailInMotionTransactionExchangeInsert.this.unitMapping.getY() + RetailInMotionTransactionExchangeInsert.this.saveButton.getHeight() + 2 * border));
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            RetailInMotionTransactionExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            RetailInMotionTransactionExchangeInsert.this.history.setLocation(0, RetailInMotionTransactionExchangeInsert.this.sendPanel.getTitleHeight());
            RetailInMotionTransactionExchangeInsert.this.history.setSize(parent.getWidth(), RetailInMotionTransactionExchangeInsert.this.sendPanel.getHeight() - (border + RetailInMotionTransactionExchangeInsert.this.sendPanel.getTitleHeight() + 100));
            RetailInMotionTransactionExchangeInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - RetailInMotionTransactionExchangeInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (RetailInMotionTransactionExchangeInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            RetailInMotionTransactionExchangeInsert.this.sendButton.setSize(RetailInMotionTransactionExchangeInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (RetailInMotionTransactionExchangeInsert.this.animation != null) {
                RetailInMotionTransactionExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - RetailInMotionTransactionExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - RetailInMotionTransactionExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                RetailInMotionTransactionExchangeInsert.this.animation.setSize(RetailInMotionTransactionExchangeInsert.this.animation.getPreferredSize());
            }
            if (RetailInMotionTransactionExchangeInsert.this.isInserted) {
                RetailInMotionTransactionExchangeInsert.this.configPanel.setLocation(border, border);
                RetailInMotionTransactionExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                RetailInMotionTransactionExchangeInsert.this.sendPanel.setLocation(RetailInMotionTransactionExchangeInsert.this.configPanel.getX() + RetailInMotionTransactionExchangeInsert.this.configPanel.getWidth() + border, border);
                RetailInMotionTransactionExchangeInsert.this.sendPanel.setSize(RetailInMotionTransactionExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

