/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule.details.utils;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dailyops.FlightDailyOpsModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.flight.FlightModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.flight.details.AdditionalOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SealDefinitionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SpecialMenusDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.MultiPaxTable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.multiprint.ScrollablePopupInsert;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightParameterConfig;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.StowagePositionIdentifier;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanReference;
import ch.icit.pegasus.server.core.dtos.mealplan.MealplanTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FlightStowingListSwitchPopup
extends ScrollablePopupInsert {
    private static final long serialVersionUID = 1L;
    private LoadingAnimation animation;
    private Node<FlightLight> flight;
    private Node<StowingListTemplateVariantLight> newStowingList;
    private Node<AircraftLight> newAircraft;
    private Node<MealPlanLight> newMealPlan;
    private Node<Map<StowingListTemplateLegComplete, FlightLegComplete>> stwLegMapping;
    private Node<Map<StowagePositionIdentifier, StowagePositionIdentifier>> aircraftMappingNode;
    private Node<Map<MealplanTemplateLegComplete, StowingListTemplateVariantLegComplete>> mealPlanLegMapping;
    private Node<Map<ALoadingGroupComplete, ALoadingGroupComplete>> mealPlanServiceMapping;
    private SpecialMenusDetailsPanel spmlDetails;
    private AdditionalOrderDetailsPanel additionals;
    private SealDefinitionDetailsPanel sealsPanel;
    private MultiPaxTable paxTable;
    private RowEditor editor;
    private FlightModuleDataHandler dataHandler;

    public FlightStowingListSwitchPopup(FlightModuleDataHandler dataHandler, Node<FlightLight> flight, Node<StowingListTemplateVariantLight> newStowingList, Node<AircraftLight> newAircraft, Node<MealPlanLight> newMealPlan, Node<Map<StowingListTemplateLegComplete, FlightLegComplete>> stwLegMapping, Node<Map<StowagePositionIdentifier, StowagePositionIdentifier>> aircraftMappingNode, Node<Map<MealplanTemplateLegComplete, StowingListTemplateVariantLegComplete>> mealPlanLegMapping, Node<Map<ALoadingGroupComplete, ALoadingGroupComplete>> mealPlanServiceMapping, SpecialMenusDetailsPanel spmlDetails, AdditionalOrderDetailsPanel additionals, SealDefinitionDetailsPanel sealsPanel, MultiPaxTable paxTable, RowEditor editor) {
        this.flight = flight;
        this.dataHandler = dataHandler;
        this.newStowingList = newStowingList;
        this.newAircraft = newAircraft;
        this.newMealPlan = newMealPlan;
        this.stwLegMapping = stwLegMapping;
        this.aircraftMappingNode = aircraftMappingNode;
        this.mealPlanLegMapping = mealPlanLegMapping;
        this.mealPlanServiceMapping = mealPlanServiceMapping;
        this.spmlDetails = spmlDetails;
        this.additionals = additionals;
        this.sealsPanel = sealsPanel;
        this.paxTable = paxTable;
        this.editor = editor;
        this.switchNow();
    }

    private void showAnimation(String text) {
        this.setEnabled(false);
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.getViewContainer().add((Component)this.animation, 0);
            this.animation.stateChanged(text);
            this.animation.start();
            this.animation.fadeIn();
        }
    }

    private void hideAnimation() {
        this.setEnabled(true);
        if (this.animation != null) {
            this.animation.kill();
            this.animation = null;
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        if (this.popup != null) {
            this.popup.enableCancelButton(false);
            this.popup.enableOKButton(false);
        }
    }

    private void switchNow() {
        this.editor.getModel().setNode(null);
        this.showAnimation(Words.SWITCH_STOWING_LIST);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList warnings = new ArrayList();
                FlightLight pFlight = (FlightLight)FlightStowingListSwitchPopup.this.flight.getValue();
                StowingListTemplateVariantLight pStowingList = (StowingListTemplateVariantLight)FlightStowingListSwitchPopup.this.newStowingList.getValue();
                AircraftLight pAircraft = FlightStowingListSwitchPopup.this.newAircraft != null ? (AircraftLight)FlightStowingListSwitchPopup.this.newAircraft.getValue() : null;
                MealPlanLight pMealPlan = FlightStowingListSwitchPopup.this.newMealPlan != null ? (MealPlanLight)FlightStowingListSwitchPopup.this.newMealPlan.getValue() : null;
                Map pStwMapping = (Map)FlightStowingListSwitchPopup.this.stwLegMapping.getValue();
                Map pAircraftMapping = FlightStowingListSwitchPopup.this.aircraftMappingNode != null ? (Map)FlightStowingListSwitchPopup.this.aircraftMappingNode.getValue() : null;
                Map pMealPlanLegMapping = FlightStowingListSwitchPopup.this.mealPlanLegMapping != null ? (Map)FlightStowingListSwitchPopup.this.mealPlanLegMapping.getValue() : null;
                Map pMealPlanServiceMapping = FlightStowingListSwitchPopup.this.mealPlanServiceMapping != null ? (Map)FlightStowingListSwitchPopup.this.mealPlanServiceMapping.getValue() : null;
                FlightComplete fc = null;
                if (FlightStowingListSwitchPopup.this.flight.getValue(FlightComplete.class) == null) {
                    throw new IllegalStateException("No Flight found");
                }
                fc = (FlightComplete)FlightStowingListSwitchPopup.this.flight.getValue(FlightComplete.class);
                Boolean canCreateFlight = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).canCreateFlight(fc.getOutboundCode(), new TimestampWrapper(fc.getStd()), fc.getInboundCode(), new TimestampWrapper(fc.getSta()), new FlightReference(fc.getId()));
                if (!Boolean.TRUE.equals(canCreateFlight)) {
                    DateTimeConverter c = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
                    throw new ClientGetFromServerException("A Flight with Outbound (" + fc.getOutboundCode() + ") at " + c.convert((Object)fc.getStd(), null, new Object[0]) + " and Inbound (" + fc.getInboundCode() + ") at " + c.convert((Object)fc.getSta(), null, new Object[0]) + " already exists.");
                }
                FlightComplete fr = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(fc, new ListWrapper(warnings), false, false, false, false).getObject();
                fr = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).switchStowingList(new FlightParameterConfig(fr, (StowingListTemplateVariantReference)pStowingList, (AircraftReference)pAircraft, (MealPlanReference)pMealPlan, pStwMapping, pAircraftMapping, pMealPlanLegMapping, pMealPlanServiceMapping, warnings, false)).getValue();
                if (!warnings.isEmpty()) {
                    InnerPopupFactory.showWarningDialog((List<ScreenValidationObject>)ScreenValidationObject.convertListFromString(warnings), "", (Component)FlightStowingListSwitchPopup.this);
                }
                FlightDailyOpsModuleDataHandler.loadSealConfiguration(fr);
                FlightModuleDataHandler.revalidateMasterData(fr, true, null);
                FlightStowingListSwitchPopup.this.flight.removeExistingValues();
                FlightStowingListSwitchPopup.this.flight.setValue((Object)fr, 0L);
                FlightStowingListSwitchPopup.this.flight.updateNode();
                FlightStowingListSwitchPopup.this.dataHandler.newStwSetted(fr.getActiveStowingList());
                return FlightStowingListSwitchPopup.this.flight;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (FlightStowingListSwitchPopup.this.editor != null) {
                            FlightStowingListSwitchPopup.this.editor.getModel().setNode(FlightStowingListSwitchPopup.this.flight);
                        }
                        if (FlightStowingListSwitchPopup.this.sealsPanel != null) {
                            FlightStowingListSwitchPopup.this.sealsPanel.updateSeals((Node<FlightLight>)FlightStowingListSwitchPopup.this.flight);
                        }
                        if (FlightStowingListSwitchPopup.this.spmlDetails != null) {
                            FlightStowingListSwitchPopup.this.spmlDetails.updateInserts();
                        }
                        if (FlightStowingListSwitchPopup.this.additionals != null) {
                            FlightStowingListSwitchPopup.this.additionals.updateInserts();
                        }
                        InnerPopupFactory.showMessageDialog(Words.STOWING_LIST_SUCCESSFULLY_SWITCHED, FlightStowingListSwitchPopup.this);
                        FlightStowingListSwitchPopup.this.hideAnimation();
                        FlightStowingListSwitchPopup.this.popup.hidePopUp(new Object[0]);
                    }

                    public void errorOccurred(ClientException exception) {
                        FlightStowingListSwitchPopup.this.errorOccurred(exception);
                        FlightStowingListSwitchPopup.this.popup.hidePopUp(new Object[0]);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }
}

