/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flighttools;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.flighttools.UpdateStowingListInsert;
import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.screentemplates.TitledScreenInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightToolsAccess;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class FlightToolsModule
extends TitledScreenInsert
implements ItemListener,
InnerPopUpListener2,
AbstractDataInsertModule,
Module {
    private static final long serialVersionUID = 1L;
    private boolean isChanging = false;
    private TitledItem<ComboBox> masterDataSelection = new TitledItem<ComboBox>(new ComboBox(null, null, null), "Choose Section", TitledItem.TitledItemOrientation.NORTH);
    private UpdateStowingListInsert insert;

    public FlightToolsModule() {
        this.setLayout(new Layout());
        RDProvider p = new RDProvider(HUDToolkit.getCurrentAccessRight(FlightToolsAccess.MODULE_FLIGHT_TOOLS, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser()), false);
        this.setInsert(new UpdateStowingListInsert(this, p));
        this.setEnabled(true);
        this.add(this.masterDataSelection);
        this.masterDataSelection.getElement().addItemListener(this);
    }

    @Override
    public void setMainFrame(MainFrame frame) {
        super.setMainFrame(frame);
        this.fillGUI();
    }

    private void fillGUI() {
        RDProvider p = new RDProvider(HUDToolkit.getCurrentAccessRight(FlightToolsAccess.MODULE_FLIGHT_TOOLS, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser()), false);
        this.masterDataSelection.getElement().addItem("");
        if (p.isWritable("flightupdate_flightonly")) {
            this.masterDataSelection.getElement().addItem(Tools.UPDATE_FLIGHT_ONLY);
        }
        if (p.isWritable("flightupdate_rconly")) {
            this.masterDataSelection.getElement().addItem(Tools.UPDATE_RC_ONLY);
        }
        if (p.isWritable("flightupdate_stw")) {
            this.masterDataSelection.getElement().addItem(Tools.RELOAD_STW);
        }
        if (p.isWritable("flightsob_upload")) {
            this.masterDataSelection.getElement().addItem(Tools.SEND_SOB);
        }
        if (p.isWritable("flight_update_flight_data")) {
            this.masterDataSelection.getElement().addItem(Tools.UPDATE_FLIGHT_DATA);
        }
        if (p.isWritable("flight_update_to_open")) {
            this.masterDataSelection.getElement().addItem(Tools.UPDATE_FLIGHT_STATE);
        }
        if (p.isWritable("flight_revert_and_recalc")) {
            this.masterDataSelection.getElement().addItem(Tools.RECALCULATE_TRANSACTION);
        }
        if (p.isWritable("flight_calculate_rim")) {
            this.masterDataSelection.getElement().addItem(Tools.CALCULATE_RIM);
        }
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    public void started() {
        this.getMainFrame().getTitleBar().setHUDButtonsEnabled(false, 1155);
    }

    public void ended() {
        this.getMainFrame().getTitleBar().setHUDButtonsEnabled(true, 1155);
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    public void redo() {
    }

    public void undo() {
    }

    private void setInsert(UpdateStowingListInsert insert) {
        if (this.insert != null) {
            this.insert.fadeOut(true);
            this.insert = null;
        }
        this.insert = insert;
        if (this.insert != null) {
            this.add(this.insert);
            this.insert.fadeIn();
            this.insert.loadData();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.getMainFrame() != null) {
            this.getMainFrame().showHUDButtons(105);
        }
        if (e.getStateChange() == 1) {
            this.isChanging = true;
            this.popUpClosed(null, new Object[0]);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.insert != null) {
            this.insert.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.insert != null) {
            this.insert.kill();
        }
        this.insert = null;
        if (this.masterDataSelection != null) {
            this.masterDataSelection.kill();
        }
        this.masterDataSelection = null;
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (this.isChanging) {
            if (xargs == null) {
                return;
            }
            if (this.masterDataSelection.getElement().getSelectedItem() == Tools.RELOAD_STW) {
                this.showRelaod();
            } else if (this.masterDataSelection.getElement().getSelectedItem() == Tools.SEND_SOB) {
                this.showSendSobData();
            } else if (this.masterDataSelection.getElement().getSelectedItem() == Tools.UPDATE_FLIGHT_DATA) {
                this.showUpdateFlightData();
            } else if (this.masterDataSelection.getElement().getSelectedItem() == Tools.UPDATE_FLIGHT_ONLY) {
                this.showUpdateFlightOnly();
            } else if (this.masterDataSelection.getElement().getSelectedItem() == Tools.UPDATE_FLIGHT_STATE) {
                this.showUpdateFlightState();
            } else if (this.masterDataSelection.getElement().getSelectedItem() == Tools.UPDATE_RC_ONLY) {
                this.showUpdateRCOnly();
            } else if (this.masterDataSelection.getElement().getSelectedItem() == Tools.RECALCULATE_TRANSACTION) {
                this.showRecalculateTransactions();
            } else if (this.masterDataSelection.getElement().getSelectedItem() == Tools.CALCULATE_RIM) {
                this.showCalculateRetailinMotion();
            }
        } else {
            this.setEnabled(false);
        }
    }

    private void showCalculateRetailinMotion() {
        if (this.insert != null) {
            this.insert.showCalculateRetailinMotion();
        }
    }

    private void showRecalculateTransactions() {
        if (this.insert != null) {
            this.insert.showRevertTransaction();
        }
    }

    private void showUpdateRCOnly() {
        if (this.insert != null) {
            this.insert.showUpdateRCOnly();
        }
    }

    private void showUpdateFlightState() {
        if (this.insert != null) {
            this.insert.showUpdateFlightState();
        }
    }

    private void showUpdateFlightOnly() {
        if (this.insert != null) {
            this.insert.showUpdateFlightOnly();
        }
    }

    private void showSendSobData() {
        if (this.insert != null) {
            this.insert.showSendSobData();
        }
    }

    private void showUpdateFlightData() {
        if (this.insert != null) {
            this.insert.showUpdateFlightData();
        }
    }

    private void showRelaod() {
        if (this.insert != null) {
            this.insert.showReload();
        }
    }

    @Override
    public void setSelectionEnabled(boolean isEnabled) {
        if (this.masterDataSelection != null) {
            this.masterDataSelection.setEnabled(isEnabled);
        }
    }

    @Override
    public void dataSaved() {
    }

    @Override
    public void setLoading(boolean b) {
    }

    @Override
    public String getScreenTitle() {
        return FlightToolsAccess.MODULE_FLIGHT_TOOLS.getDisplayName();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = FlightToolsModule.this.layoutTitle(parent);
            FlightToolsModule.this.masterDataSelection.setLocation(0, y + 15);
            FlightToolsModule.this.masterDataSelection.setSize(450, (int)FlightToolsModule.this.masterDataSelection.getPreferredSize().getHeight());
            if (FlightToolsModule.this.insert != null) {
                FlightToolsModule.this.insert.setLocation(0, FlightToolsModule.this.masterDataSelection.getY() + FlightToolsModule.this.masterDataSelection.getHeight() + 15);
                FlightToolsModule.this.insert.setSize(parent.getWidth(), parent.getHeight() - (FlightToolsModule.this.insert.getY() + 10));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private static enum Tools {
        UPDATE_FLIGHT_ONLY,
        UPDATE_RC_ONLY,
        RELOAD_STW,
        SEND_SOB,
        UPDATE_FLIGHT_DATA,
        UPDATE_FLIGHT_STATE,
        RECALCULATE_TRANSACTION,
        CALCULATE_RIM;


        public String toString() {
            switch (this) {
                case RELOAD_STW: {
                    return "Reload Stw from Flight Schedule (Flight & RC update included)";
                }
                case SEND_SOB: {
                    return "Resend Sob Data to FTP";
                }
                case UPDATE_FLIGHT_DATA: {
                    return "Reload Flight Data from Flight Schedule";
                }
                case UPDATE_FLIGHT_ONLY: {
                    return "Update Flight";
                }
                case UPDATE_FLIGHT_STATE: {
                    return "Set Flight back to OPEN";
                }
                case UPDATE_RC_ONLY: {
                    return "Update RC only";
                }
                case RECALCULATE_TRANSACTION: {
                    return "Revert and recalc transactions for DF";
                }
                case CALCULATE_RIM: {
                    return "Calculate Retail inMotion";
                }
            }
            return super.toString();
        }
    }
}

