/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.importer.utils;

import ch.icit.pegasus.client.gui.modules.importer.ImporterModule;
import ch.icit.pegasus.client.gui.modules.importer.LoadingInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.utils.ImportType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ImporterItemView
extends DefaultPanel
implements ButtonListener,
InnerPopUpListener2,
Comparable<ImporterItemView> {
    private static final long serialVersionUID = 5222199337771435741L;
    private TitledItem<TextButton> importButton;
    private ViewButton downloadTemplateButton;
    private InfoButton infoButton;
    private ImportType importType;
    private final boolean active;
    private String description;
    private ImporterModule module;

    public ImporterItemView(boolean active, ImportType type, String desciption, ImporterModule module) {
        this.active = active;
        this.description = desciption;
        this.importType = type;
        this.module = module;
        this.importButton = new TitledItem<TextButton>(new TextButton("Select"), this.description, TitledItem.TitledItemOrientation.EAST);
        this.downloadTemplateButton = new ViewButton();
        this.infoButton = new InfoButton();
        this.importButton.getElement().addButtonListener(this);
        this.downloadTemplateButton.addButtonListener(this);
        this.infoButton.installStringViewer(this.createInfoText());
        this.setLayout(new FlowLayout(0, 10, 0));
        this.importButton.setEnabled(active);
        this.add(this.importButton);
        this.add(this.infoButton);
        this.add(this.downloadTemplateButton);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled && this.active);
    }

    private String createInfoText() {
        return this.importType.getDescription();
    }

    private File downloadFile() throws IOException {
        File tempFile = File.createTempFile("ImporterFile_", ".xlsx");
        URL url = this.createURL();
        if (url == null) {
            return null;
        }
        FileUtils.copyURLToFile((URL)url, (File)tempFile);
        return tempFile;
    }

    private URL createURL() throws MalformedURLException {
        return ImporterItemView.class.getResource("/importtemplates/" + this.importType.getTemplateId());
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.importButton);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.importButton.requestFocusInWindowNow();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.importButton.getElement()) {
            File fileName = FileChooserUtil.loadFile();
            if (fileName != null) {
                File selectedFile = fileName;
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, Words.IMPORT + " " + this.importType);
                LoadingInsert view = new LoadingInsert(this.importType, selectedFile);
                popUp.setView(view);
                popUp.showPopUpWithinScreenMiddle(450, 300, this, source);
            }
        } else if (source == this.downloadTemplateButton) {
            this.module.setEnabled(false);
            try {
                File f = this.downloadFile();
                if (f == null) {
                    InnerPopupFactory.showErrorDialog("No template ready. Please contact support.", (Component)this);
                }
                this.module.setEnabled(true);
                Desktop.getDesktop().open(f);
            }
            catch (IOException e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
            this.module.setEnabled(true);
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    public ImportType getImportType() {
        return this.importType;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(ImporterItemView o) {
        return this.getDescription().compareTo(o.getDescription());
    }
}

