/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.itemsubstitution.details.utils;

import ch.icit.pegasus.client.gui.modules.itemsubstitution.details.utils.ItemByItemSubstitutionDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.recipe.RecipeServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.calculator.IBasicArticle;
import ch.icit.pegasus.server.core.calculator.IUnit;
import ch.icit.pegasus.server.core.calculator.UnitCalculator;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionComplete_;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionEntryComplete;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionEntryComplete_;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionTypeE;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ItemSubstitutionAccess;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.InUseStateE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public abstract class RecipeByArticleSubstitutionDetailsPanel<T extends IDTO>
extends ItemByItemSubstitutionDetailsPanel<T> {
    private static final long serialVersionUID = -4552350129677539999L;

    public RecipeByArticleSubstitutionDetailsPanel(RowEditor<T> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.RECIPE_BY_ARTICLE_SUBSTITUTIONS);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean b = isEnabled;
        if (!this.getShowFlightColumn() && Boolean.TRUE.equals(this.editor.getModel().getNode().getChildNamed(FlightLight_.substitutionsApproved).getValue())) {
            b = this.provider.isWritable(ItemSubstitutionAccess.EDIT_APPROVED_FLIGHT);
        }
        super.setEnabled(b);
    }

    @Override
    public Table2Model createNewTableModel(List<TableColumnInfo> columns) {
        Table2Model m = new Table2Model(columns, true){

            @Override
            public boolean shouldAddRow(Node node) {
                boolean t = super.shouldAddRow(node);
                return t && node.getChildNamed(ItemSubstitutionEntryComplete_.substitutionType).getValue() == ItemSubstitutionTypeE.RECIPE_BY_ARTICLE;
            }
        };
        return m;
    }

    public abstract boolean getShowFlightColumn();

    @Override
    public void setNode(Node<?> node) {
        if (this.getShowFlightColumn()) {
            this.table.getModel().setNode(node.getChildNamed(ItemSubstitutionComplete_.substitutions));
        } else {
            this.table.getModel().setNode(node.getChildNamed(new DtoField[]{ItemSubstitutionComplete_.substitutions, ItemSubstitutionComplete_.substitutions}));
        }
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        if (this.getShowFlightColumn()) {
            columns.add(new TableColumnInfo(Words.FLIGHT, null, null, null, "", 100, 100, 100));
        }
        columns.add(new TableColumnInfo(Words.CABIN_CLASS, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.PRODUCT, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.ORIGIN_RECIPE, null, null, null, "", 100, 100, 100));
        int wt = 2 * this.table.getCellPadding() + CheckBox.getPreferredWidth() + 5 + InputComboBox.getPreferredWidth(this.table, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
        columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", wt, wt, wt));
        columns.add(new TableColumnInfo(Words.SUBSTITUTE_ARTICLE, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", wt, wt, wt));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo(Words.UNKNOWN_ALLERGENS, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.REMARK, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        if (this.getShowFlightColumn()) {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.15);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.15);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.2);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.2);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.2);
            ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(8)).setxExpand(0.1);
            columns.get(9).setxExpand(0.0);
        } else {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.15);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.2);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.25);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.25);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(7)).setxExpand(0.15);
            ((TableColumnInfo)columns.get(8)).setxExpand(0.0);
        }
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
        table.setUseWriteAccessRight(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        ItemSubstitutionEntryComplete le = new ItemSubstitutionEntryComplete();
        le.setSubstitutionType(ItemSubstitutionTypeE.RECIPE_BY_ARTICLE);
        le.setClientOId(Long.valueOf(ADTO.getNextId()));
        le.setReplacedQuantity(new QuantityComplete(Double.valueOf(0.0), settings.getPieceUnit()));
        le.setOriginQuantity(new QuantityComplete(Double.valueOf(0.0), settings.getPieceUnit()));
        le.setUseCompleteOriginQuantity(Boolean.valueOf(true));
        le.setUseCompleteReplacedQuantity(Boolean.valueOf(true));
        this.table.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)le, true, false), System.currentTimeMillis());
        this.editor.revalidate();
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        List<ScreenValidationObject> validationObjects = super.validateParagraph();
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl r = (TableRowImpl)p;
            List<ScreenValidationObject> b = r.validateRow();
            validationObjects.addAll(b);
        }
        return validationObjects;
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl r = (TableRowImpl)p;
            List b = r.validateRemoteRow();
            callBack.addAll(b);
        }
    }

    @Override
    public boolean isRemoteValidation() {
        return true;
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        if (isHeader) {
            return new Table2HeaderPanel(model, 7);
        }
        TableRowImpl p = new TableRowImpl(model);
        return p;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    SearchTextField2Listener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<FlightLight> flight;
        private SearchComboBox cabinClass;
        private SearchTextField2<ProductComplete> productSearch;
        private SearchTextField2<RecipeComplete> originRecipe;
        private SearchTextField2<BasicArticleLight> replaceArticle;
        private InfoButton replacedArticleInfo;
        private CheckBox useCompleteOrigin;
        private CheckBox useCompleteReplaced;
        private InputComboBox originAmount;
        private InputComboBox replacedAmount;
        private CheckBox unknownAllergens;
        private TextField remark;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            if (RecipeByArticleSubstitutionDetailsPanel.this.getShowFlightColumn()) {
                this.flight = SearchTextField2Factory.getFlightSearchField(true, m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.flight));
                Object[] o = new Object[]{m.getNode().getParent().getParent().getChildNamed(ItemSubstitutionComplete_.date), true};
                this.flight.setAdditionalSearchField(o);
                this.flight.addSearchTextFieldListener(this);
                this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.flight).addNodeListener((NodeListener)this);
            }
            this.productSearch = SearchTextField2Factory.getProductSearchField(true, m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.prod));
            this.productSearch.addSearchTextFieldListener(this);
            Node customerNode = RecipeByArticleSubstitutionDetailsPanel.this.editor.getModel().getNode().getChildNamed(ItemSubstitutionComplete_.customer);
            Object[] ps = new Object[3];
            ps[2] = customerNode;
            this.productSearch.setAdditionalSearchField(ps);
            this.originRecipe = SearchTextField2Factory.getRecipeSearchField(true, m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.originRp));
            this.originRecipe.addSearchTextFieldListener(this);
            this.cabinClass = SearchComboBoxFactory.getCabinClassSearchField(true, m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.cabinClass));
            this.cabinClass.addSearchTextFieldListener(this);
            Object[] o = new Object[5];
            o[4] = InUseStateE.ALL;
            this.replaceArticle = SearchTextField2Factory.getBasicArticleSearchField(true, m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.newArticle));
            this.replaceArticle.setAdditionalSearchField(o);
            this.replaceArticle.addSearchTextFieldListener(this);
            this.replacedArticleInfo = new InfoButton();
            this.useCompleteOrigin = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.useCompleteOriginQuantity));
            this.useCompleteReplaced = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.useCompleteReplacedQuantity));
            this.useCompleteOrigin.addButtonListener(this);
            this.useCompleteReplaced.addButtonListener(this);
            this.originAmount = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{ItemSubstitutionEntryComplete_.originQuantity, QuantityComplete_.quantity}), m.getNode().getChildNamed(new DtoField[]{ItemSubstitutionEntryComplete_.originQuantity, QuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.replacedAmount = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{ItemSubstitutionEntryComplete_.replacedQuantity, QuantityComplete_.quantity}), m.getNode().getChildNamed(new DtoField[]{ItemSubstitutionEntryComplete_.replacedQuantity, QuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.unknownAllergens = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.unknownAllergens));
            this.remark = new TextField(m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.remark), TextFieldType.NORMAL);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            RecipeByArticleSubstitutionDetailsPanel.this.registerDateListenerForRow(this);
            RecipeByArticleSubstitutionDetailsPanel.this.updateArticleInfoIcon(this.replacedArticleInfo, (Node<ItemSubstitutionEntryComplete>)this.model.getNode(), (Node<BasicArticleComplete>)this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.newArticle));
            RecipeByArticleSubstitutionDetailsPanel.this.updateSelectableUnits(this.replacedAmount, (Node<ItemSubstitutionEntryComplete>)this.model.getNode(), (DtoField<BasicArticleLight>)ItemSubstitutionEntryComplete_.newArticle);
            this.setLayout(new InnerLayout());
            if (RecipeByArticleSubstitutionDetailsPanel.this.getShowFlightColumn()) {
                this.add(this.flight);
            }
            this.add(this.productSearch);
            this.add(this.originRecipe);
            this.add(this.cabinClass);
            this.add(this.replaceArticle);
            this.add(this.replacedArticleInfo);
            this.add(this.originAmount);
            this.add(this.replacedAmount);
            this.add(this.remark);
            this.add(this.delete);
            this.add(this.unknownAllergens);
            this.add(this.useCompleteOrigin);
            this.add(this.useCompleteReplaced);
        }

        public List<ScreenValidationObject> validateRow() {
            ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
            boolean substitutionsWritable = RecipeByArticleSubstitutionDetailsPanel.this.provider.isWritable(ItemSubstitutionComplete_.substitutions);
            if (substitutionsWritable) {
                int index = RecipeByArticleSubstitutionDetailsPanel.this.table.getRowIndex(this) + 1;
                if (RecipeByArticleSubstitutionDetailsPanel.this.getShowFlightColumn()) {
                    if (this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.flight).getValue() == null) {
                        this.flight.setInvalid();
                        a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.FLIGHT_ON_ROW_MUST_BE_SET, (Object[])new Object[]{index})));
                    } else {
                        this.flight.setValid();
                    }
                }
                if (this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.originRp).getValue() != null) {
                    this.originRecipe.setValid();
                } else {
                    this.originRecipe.setInvalid();
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.RECIPE_ON_ROW_MUST_BE_SET, (Object[])new Object[]{index})));
                }
            }
            return a;
        }

        private List<ScreenValidationObject> validateRemoteRow() throws ClientServerCallException {
            ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
            boolean substitutionsWritable = RecipeByArticleSubstitutionDetailsPanel.this.provider.isWritable(ItemSubstitutionComplete_.substitutions);
            if (substitutionsWritable) {
                int index = RecipeByArticleSubstitutionDetailsPanel.this.table.getRowIndex(this) + 1;
                if (((Boolean)this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.useCompleteOriginQuantity).getValue()).booleanValue() || ((Boolean)this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.useCompleteReplacedQuantity).getValue()).booleanValue()) {
                    RecipeComplete originRecipe = (RecipeComplete)this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.originRp).getValue(RecipeComplete.class);
                    BasicArticleComplete replaceArticle = (BasicArticleComplete)this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.newArticle).getValue(BasicArticleComplete.class);
                    Timestamp validity = RecipeByArticleSubstitutionDetailsPanel.this.getShowFlightColumn() ? ((FlightLight)this.flight.getNode().getValue()).getStd() : ((FlightLight)RecipeByArticleSubstitutionDetailsPanel.this.editor.getModel().getTypeSafeNode().getValue(FlightLight.class)).getStd();
                    RecipeVariantComplete recipeVariant = (RecipeVariantComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).resolveVariant((RecipeReference)originRecipe, new TimestampWrapper(validity)).getValue();
                    UnitComplete defaultRecipeUnit = RecipeByArticleSubstitutionDetailsPanel.this.settings.getDefaultRecipeUnit();
                    if (!UnitCalculator.isUnitInArticlesPackagingTableAtTime((IBasicArticle)replaceArticle, (IUnit)recipeVariant.getYield().getUnit(), (Timestamp)validity) || !UnitCalculator.isUnitInArticlesPackagingTableAtTime((IBasicArticle)replaceArticle, (IUnit)defaultRecipeUnit, (Timestamp)validity)) {
                        this.originRecipe.setInValid();
                        this.replaceArticle.setInValid();
                        a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ORIGIN_RECIPE_IS_NOT_CONVERTIBLE_TO_REPLACE_ARTICLE_ON_ROW, (Object[])new Object[]{recipeVariant.getName(), replaceArticle.getName(), index})));
                    }
                }
            }
            return a;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.flight).removeNodeListener((NodeListener)this);
            RecipeByArticleSubstitutionDetailsPanel.this.deregisterDateListenerForRow(this);
            this.originRecipe.kill();
            if (RecipeByArticleSubstitutionDetailsPanel.this.getShowFlightColumn()) {
                this.flight.kill();
            }
            this.cabinClass.kill();
            this.productSearch.kill();
            this.replaceArticle.kill();
            this.originAmount.kill();
            this.replacedAmount.kill();
            this.replacedArticleInfo.kill();
            this.remark.kill();
            this.delete.kill();
            this.useCompleteOrigin.kill();
            this.useCompleteReplaced.kill();
            this.unknownAllergens.kill();
            this.replacedArticleInfo = null;
            this.originRecipe = null;
            this.flight = null;
            this.cabinClass = null;
            this.productSearch = null;
            this.replaceArticle = null;
            this.originAmount = null;
            this.replacedAmount = null;
            this.remark = null;
            this.delete = null;
            this.useCompleteOrigin = null;
            this.useCompleteReplaced = null;
            this.unknownAllergens = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.flight);
            CheckedListAdder.addToList(focusList, this.cabinClass);
            CheckedListAdder.addToList(focusList, this.productSearch);
            CheckedListAdder.addToList(focusList, this.originRecipe);
            CheckedListAdder.addToList(focusList, this.useCompleteOrigin);
            CheckedListAdder.addToList(focusList, this.originAmount);
            CheckedListAdder.addToList(focusList, this.replaceArticle);
            CheckedListAdder.addToList(focusList, this.useCompleteReplaced);
            CheckedListAdder.addToList(focusList, this.replacedAmount);
            CheckedListAdder.addToList(focusList, this.unknownAllergens);
            CheckedListAdder.addToList(focusList, this.remark);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            if (RecipeByArticleSubstitutionDetailsPanel.this.getShowFlightColumn()) {
                this.flight.setEnabled(isEnabled);
            }
            this.cabinClass.setEnabled(isEnabled);
            this.productSearch.setEnabled(isEnabled);
            boolean hasOrigin = this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.originRp).getValue() != null;
            this.originRecipe.setEnabled(isEnabled);
            this.useCompleteOrigin.setEnabled(isEnabled && hasOrigin);
            this.originAmount.setEnabled(isEnabled && hasOrigin && !this.useCompleteOrigin.isChecked());
            boolean hasReplaced = this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.newArticle).getValue() != null;
            this.replaceArticle.setEnabled(isEnabled);
            this.replacedArticleInfo.setEnabled(isEnabled);
            this.useCompleteReplaced.setEnabled(isEnabled && hasReplaced);
            this.replacedAmount.setEnabled(isEnabled && hasReplaced && !this.useCompleteReplaced.isChecked());
            this.unknownAllergens.setEnabled(isEnabled);
            this.remark.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        public void valueChanged(Node<?> node) {
            RecipeByArticleSubstitutionDetailsPanel.this.updateArticleInfoIcon(this.replacedArticleInfo, (Node<ItemSubstitutionEntryComplete>)this.model.getNode(), (Node<BasicArticleComplete>)this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.newArticle));
            RecipeByArticleSubstitutionDetailsPanel.this.updateSelectableUnits(this.replacedAmount, (Node<ItemSubstitutionEntryComplete>)this.model.getNode(), (DtoField<BasicArticleLight>)ItemSubstitutionEntryComplete_.newArticle);
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?>[] nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            } else {
                this.setEnabled(this.isEnabled());
            }
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
            if (source == this.originRecipe) {
                this.setEnabled(this.isEnabled());
                this.replaceArticle.requestFocusInWindowNow();
            } else if (source == this.replaceArticle) {
                this.setEnabled(this.isEnabled());
                if (RecipeByArticleSubstitutionDetailsPanel.this.table.getAddButton() != null) {
                    RecipeByArticleSubstitutionDetailsPanel.this.table.getAddButton().requestFocusInWindowNow();
                }
                RecipeByArticleSubstitutionDetailsPanel.this.updateArticleInfoIcon(this.replacedArticleInfo, (Node<ItemSubstitutionEntryComplete>)this.model.getNode(), (Node<BasicArticleComplete>)this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.newArticle));
                RecipeByArticleSubstitutionDetailsPanel.this.updateSelectableUnits(this.replacedAmount, (Node<ItemSubstitutionEntryComplete>)this.model.getNode(), (DtoField<BasicArticleLight>)ItemSubstitutionEntryComplete_.newArticle);
            } else if (source == this.productSearch) {
                this.originRecipe.requestFocusInWindowNow();
            } else if (source == this.flight) {
                this.cabinClass.requestFocusInWindowNow();
            } else if (source == this.cabinClass) {
                this.productSearch.requestFocusInWindowNow();
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                int index = 1;
                if (RecipeByArticleSubstitutionDetailsPanel.this.getShowFlightColumn()) {
                    TableRowImpl.this.flight.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flight.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.flight.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flight.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                    index = 2;
                }
                TableRowImpl.this.cabinClass.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cabinClass.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cabinClass.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.cabinClass.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.productSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.productSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.productSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.productSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.originRecipe.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.originRecipe.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.originRecipe.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.originRecipe.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.useCompleteOrigin.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.useCompleteOrigin.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.useCompleteOrigin.setSize(TableRowImpl.this.useCompleteOrigin.getPreferredSize());
                TableRowImpl.this.originAmount.setLocation(TableRowImpl.this.useCompleteOrigin.getX() + TableRowImpl.this.useCompleteOrigin.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.originAmount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.originAmount.setSize(w - (2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding() + TableRowImpl.this.useCompleteOrigin.getWidth()), (int)TableRowImpl.this.originAmount.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.replaceArticle.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.replaceArticle.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.replaceArticle.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.replacedArticleInfo.getPreferredSize().getWidth())), (int)TableRowImpl.this.replaceArticle.getPreferredSize().getHeight());
                TableRowImpl.this.replacedArticleInfo.setLocation(TableRowImpl.this.replaceArticle.getX() + TableRowImpl.this.replaceArticle.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)((double)(TableRowImpl.this.replaceArticle.getY() + TableRowImpl.this.replaceArticle.getHeight()) - TableRowImpl.this.replacedArticleInfo.getPreferredSize().getHeight()) - 2);
                TableRowImpl.this.replacedArticleInfo.setSize(TableRowImpl.this.replacedArticleInfo.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.useCompleteReplaced.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.useCompleteReplaced.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.useCompleteReplaced.setSize(TableRowImpl.this.useCompleteReplaced.getPreferredSize());
                TableRowImpl.this.replacedAmount.setLocation(TableRowImpl.this.useCompleteReplaced.getX() + TableRowImpl.this.useCompleteReplaced.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.replacedAmount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.replacedAmount.setSize(w - (2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding() + TableRowImpl.this.useCompleteReplaced.getWidth()), (int)TableRowImpl.this.replacedAmount.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.unknownAllergens.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.unknownAllergens.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.unknownAllergens.setSize(TableRowImpl.this.unknownAllergens.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.remark.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.remark.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.remark.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.remark.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

