/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.language.MultiLanguageEditorTextArea;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.AdditiveCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AllergenCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ContentCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ContentCharacteristicComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.LanguageCodeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.OtherCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.util.MultilanguageTypeE;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class AllergenContentCharacteristicConfig
extends MasterDataInsert<ContentCharacteristicComplete> {
    private static final long serialVersionUID = 1L;

    public AllergenContentCharacteristicConfig(MasterDataModule p) {
        super(p);
    }

    public abstract ContentCharacteristicsType getContentType();

    @Override
    public DetailsPanel getDetails() {
        return new ContentCharacteristicConfigPanel();
    }

    @Override
    public Class<? extends ContentCharacteristicComplete> getMasterDataClass() {
        switch (this.getContentType()) {
            case ADDITVE: {
                return AdditiveCharacteristicComplete.class;
            }
            case ALLERGEN: {
                return AllergenCharacteristicComplete.class;
            }
            case OTHERS: {
                return OtherCharacteristicComplete.class;
            }
        }
        return null;
    }

    public MultilanguageTypeE getForeignType() {
        switch (this.getContentType()) {
            case ADDITVE: {
                return MultilanguageTypeE.ADDITIVE;
            }
            case ALLERGEN: {
                return MultilanguageTypeE.ALLERGEN;
            }
            case OTHERS: {
                return MultilanguageTypeE.OTHER;
            }
        }
        return MultilanguageTypeE.OTHER;
    }

    @Override
    public ContentCharacteristicComplete getNewObject() {
        switch (this.getContentType()) {
            case ADDITVE: {
                AdditiveCharacteristicComplete b = new AdditiveCharacteristicComplete();
                b.setClientOId(Long.valueOf(ADTO.getNextId()));
                return b;
            }
            case ALLERGEN: {
                AllergenCharacteristicComplete a = new AllergenCharacteristicComplete();
                a.setClientOId(Long.valueOf(ADTO.getNextId()));
                return a;
            }
            case OTHERS: {
                OtherCharacteristicComplete c = new OtherCharacteristicComplete();
                c.setClientOId(Long.valueOf(ADTO.getNextId()));
                return c;
            }
        }
        return null;
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(LanguageCodeComplete.class);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return AllergenContentCharacteristicConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public String getInsertName() {
        switch (this.getContentType()) {
            case ADDITVE: {
                return Words.ADDITIVE_CONTENT_CHARACTERISTICS;
            }
            case ALLERGEN: {
                return Words.ALLERGEN_CONTENT_CHARACTERISTICS;
            }
            case OTHERS: {
                return Words.OTHERS_CONTENT_CHARACTERISTICS;
            }
        }
        return "";
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(ContentCharacteristicComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(ContentCharacteristicComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.CODE_IS_NOT_UNIQUE, (Object[])new Object[]{n.getChildNamed(ContentCharacteristicComplete_.code).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(ContentCharacteristicComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CODE_IS_SET));
        }
        return a;
    }

    private class ContentCharacteristicConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
        private TitledItem<TextField> migrationCode = new TitledItem<TextField>(new TextField(null), Words.MIGRATION_CODE, TitledItem.TitledItemOrientation.NORTH);
        private TitledItem<CheckBox> declare = new TitledItem<CheckBox>(new CheckBox(), Words.DECLARE, TitledItem.TitledItemOrientation.EAST);
        private TitledItem<TextField> description = new TitledItem<TextField>(new TextField(), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
        private TitledItem<MultiLanguageEditorTextArea> texts;

        public ContentCharacteristicConfigPanel() {
            this.texts = new TitledItem<MultiLanguageEditorTextArea>(new MultiLanguageEditorTextArea(AllergenContentCharacteristicConfig.this.getForeignType()), Words.TEXT, TitledItem.TitledItemOrientation.NORTH);
            this.texts.setIgnorePrefHeight(true);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.migrationCode);
            this.add(this.declare);
            this.add(this.description);
            this.add(this.texts);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            a.addAll(this.declare.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.declare.setVisibleContainer(pane);
            this.texts.setVisibleContainer(pane);
            this.migrationCode.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.migrationCode.kill();
            this.declare.kill();
            this.texts.kill();
            this.description.kill();
            this.code = null;
            this.migrationCode = null;
            this.declare = null;
            this.texts = null;
            this.description = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.migrationCode.setEnabled(b);
            this.declare.setEnabled(b);
            this.texts.setEnabled(b);
            this.description.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(ContentCharacteristicComplete_.code));
            this.migrationCode.getElement().setNode(node.getChildNamed(ContentCharacteristicComplete_.migrationCode));
            this.declare.getElement().setNode(node.getChildNamed(ContentCharacteristicComplete_.declareDefault));
            this.texts.getElement().setNode(node.getChildNamed(ContentCharacteristicComplete_.texts));
            this.description.getElement().setNode(node.getChildNamed(ContentCharacteristicComplete_.description));
            this.setEnabled(true);
            AllergenContentCharacteristicConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return ContentCharacteristicComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                ContentCharacteristicConfigPanel.this.code.setLocation(AllergenContentCharacteristicConfig.this.masterDataTable.getCellPadding(), AllergenContentCharacteristicConfig.this.masterDataTable.getCellPadding());
                ContentCharacteristicConfigPanel.this.code.setSize(200, (int)ContentCharacteristicConfigPanel.this.code.getPreferredSize().getHeight());
                ContentCharacteristicConfigPanel.this.migrationCode.setLocation(AllergenContentCharacteristicConfig.this.masterDataTable.getCellPadding(), ContentCharacteristicConfigPanel.this.code.getY() + ContentCharacteristicConfigPanel.this.code.getHeight() + AllergenContentCharacteristicConfig.this.masterDataTable.getCellPadding());
                ContentCharacteristicConfigPanel.this.migrationCode.setSize(250, (int)ContentCharacteristicConfigPanel.this.migrationCode.getPreferredSize().getHeight());
                ContentCharacteristicConfigPanel.this.description.setLocation(AllergenContentCharacteristicConfig.this.masterDataTable.getCellPadding(), ContentCharacteristicConfigPanel.this.migrationCode.getY() + ContentCharacteristicConfigPanel.this.migrationCode.getHeight() + AllergenContentCharacteristicConfig.this.masterDataTable.getCellPadding());
                ContentCharacteristicConfigPanel.this.description.setSize(250, (int)ContentCharacteristicConfigPanel.this.description.getPreferredSize().getHeight());
                ContentCharacteristicConfigPanel.this.texts.setLocation(AllergenContentCharacteristicConfig.this.masterDataTable.getCellPadding(), ContentCharacteristicConfigPanel.this.description.getY() + ContentCharacteristicConfigPanel.this.description.getHeight() + AllergenContentCharacteristicConfig.this.masterDataTable.getCellPadding());
                ContentCharacteristicConfigPanel.this.texts.setSize(400, 100);
                ContentCharacteristicConfigPanel.this.declare.setLocation(AllergenContentCharacteristicConfig.this.masterDataTable.getCellPadding(), ContentCharacteristicConfigPanel.this.texts.getY() + ContentCharacteristicConfigPanel.this.texts.getHeight() + AllergenContentCharacteristicConfig.this.masterDataTable.getCellPadding());
                ContentCharacteristicConfigPanel.this.declare.setSize(ContentCharacteristicConfigPanel.this.declare.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }

    public static enum ContentCharacteristicsType {
        ALLERGEN,
        ADDITVE,
        OTHERS;

    }
}

