/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.NutritionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.NutritionCategoryComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class NutritionCategoryConfig
extends MasterDataInsert<NutritionCategoryComplete> {
    private static final long serialVersionUID = 1L;

    public NutritionCategoryConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new NutritionCategoryConfigPanel();
    }

    @Override
    public String getInsertName() {
        return "Meal Types";
    }

    @Override
    public NutritionCategoryComplete getNewObject() {
        NutritionCategoryComplete a = new NutritionCategoryComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends NutritionCategoryComplete> getMasterDataClass() {
        return NutritionCategoryComplete.class;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(NutritionCategoryComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(NutritionCategoryComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(NutritionCategoryComplete_.code).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(NutritionCategoryComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        return a;
    }

    private class NutritionCategoryConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> name;
        private TitledItem<TextField> code;
        private TitledItem<TextField> description;

        public NutritionCategoryConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.name);
            this.add(this.code);
            this.add(this.description);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.name);
            CheckedListAdder.addToList(a, this.code);
            CheckedListAdder.addToList(a, this.description);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.code.kill();
            this.description.kill();
            this.name = null;
            this.code = null;
            this.description = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.name.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.name.getElement().setNode(node.getChildNamed(NutritionCategoryComplete_.name));
            this.code.getElement().setNode(node.getChildNamed(NutritionCategoryComplete_.code));
            this.description.getElement().setNode(node.getChildNamed(NutritionCategoryComplete_.description));
            this.setEnabled(true);
            NutritionCategoryConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return NutritionCategoryComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                NutritionCategoryConfigPanel.this.name.setLocation(NutritionCategoryConfig.this.masterDataTable.getCellPadding(), NutritionCategoryConfig.this.masterDataTable.getCellPadding());
                NutritionCategoryConfigPanel.this.name.setSize(200, (int)NutritionCategoryConfigPanel.this.name.getPreferredSize().getHeight());
                NutritionCategoryConfigPanel.this.code.setLocation(NutritionCategoryConfig.this.masterDataTable.getCellPadding(), NutritionCategoryConfigPanel.this.name.getY() + NutritionCategoryConfigPanel.this.name.getHeight() + NutritionCategoryConfig.this.masterDataTable.getCellPadding());
                NutritionCategoryConfigPanel.this.code.setSize(200, (int)NutritionCategoryConfigPanel.this.code.getPreferredSize().getHeight());
                NutritionCategoryConfigPanel.this.description.setLocation(NutritionCategoryConfig.this.masterDataTable.getCellPadding(), NutritionCategoryConfigPanel.this.code.getY() + NutritionCategoryConfigPanel.this.code.getHeight() + NutritionCategoryConfig.this.masterDataTable.getCellPadding());
                NutritionCategoryConfigPanel.this.description.setSize(200, (int)NutritionCategoryConfigPanel.this.description.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

