/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SPMLMenuConfig
extends MasterDataInsert<SpecialMenuTypeComplete> {
    private static final long serialVersionUID = 1L;

    public SPMLMenuConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new SPMLConfigPanel();
    }

    @Override
    public SpecialMenuTypeComplete getNewObject() {
        SpecialMenuTypeComplete a = new SpecialMenuTypeComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllUnCached(SPMLMenuConfig.this.getMasterDataClass(), true);
            }

            @Override
            public RemoteLoader getInvoker() {
                return SPMLMenuConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Class<? extends SpecialMenuTypeComplete> getMasterDataClass() {
        return SpecialMenuTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return "SPML Menus";
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean additionalSet = true;
        boolean descriptionSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(new String[]{"description"}).getValue() == null) {
                descriptionSet = false;
            }
            if (n.getChildNamed(new String[]{"additional"}).getValue() == null) {
                additionalSet = false;
            }
            if (n.getChildNamed(new String[]{"code"}).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(new String[]{"code"}).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(new String[]{"code"}).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(new String[]{"code"}).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!additionalSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Additionals are set"));
        }
        if (!descriptionSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Descriptions are set"));
        }
        return a;
    }

    private class SPMLConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> description;
        private TitledItem<CheckBox> additional;
        private TitledItem<CheckBox> loadForOnlySPMLOnInbound;

        public SPMLConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), "Code", TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), "Description", TitledItem.TitledItemOrientation.NORTH);
            this.additional = new TitledItem<CheckBox>(new CheckBox(), "Additional", TitledItem.TitledItemOrientation.EAST);
            this.loadForOnlySPMLOnInbound = new TitledItem<CheckBox>(new CheckBox(), "Load for 'only SPML On Inbound'", TitledItem.TitledItemOrientation.EAST);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.description);
            this.add(this.additional);
            this.add(this.loadForOnlySPMLOnInbound);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            a.addAll(this.description.getFocusComponents());
            a.addAll(this.additional.getFocusComponents());
            CheckedListAdder.addToList(a, this.loadForOnlySPMLOnInbound);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
            this.additional.setVisibleContainer(pane);
            this.loadForOnlySPMLOnInbound.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.additional.kill();
            this.loadForOnlySPMLOnInbound.kill();
            this.code = null;
            this.description = null;
            this.loadForOnlySPMLOnInbound = null;
            this.additional = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.additional.setEnabled(b);
            this.loadForOnlySPMLOnInbound.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(new String[]{"code"}));
            this.description.getElement().setNode(node.getChildNamed(new String[]{"description"}));
            this.additional.getElement().setNode(node.getChildNamed(new String[]{"additional"}));
            this.loadForOnlySPMLOnInbound.getElement().setNode(node.getChildNamed(SpecialMenuTypeComplete_.loadForOnlySPMLOnInbound));
            this.setEnabled(true);
            SPMLMenuConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return SpecialMenuTypeComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                SPMLConfigPanel.this.code.setLocation(SPMLMenuConfig.this.masterDataTable.getCellPadding(), SPMLMenuConfig.this.masterDataTable.getCellPadding());
                SPMLConfigPanel.this.code.setSize(200, (int)SPMLConfigPanel.this.code.getPreferredSize().getHeight());
                SPMLConfigPanel.this.description.setLocation(SPMLMenuConfig.this.masterDataTable.getCellPadding(), SPMLConfigPanel.this.code.getY() + SPMLConfigPanel.this.code.getHeight() + SPMLMenuConfig.this.masterDataTable.getCellPadding());
                SPMLConfigPanel.this.description.setSize(200, (int)SPMLConfigPanel.this.description.getPreferredSize().getHeight());
                SPMLConfigPanel.this.additional.setLocation(SPMLConfigPanel.this.description.getX(), SPMLConfigPanel.this.description.getY() + SPMLConfigPanel.this.description.getHeight() + SPMLMenuConfig.this.masterDataTable.getCellPadding());
                SPMLConfigPanel.this.additional.setSize(SPMLConfigPanel.this.additional.getPreferredSize());
                SPMLConfigPanel.this.loadForOnlySPMLOnInbound.setLocation(SPMLConfigPanel.this.description.getX(), SPMLConfigPanel.this.additional.getY() + SPMLConfigPanel.this.additional.getHeight() + SPMLMenuConfig.this.masterDataTable.getCellPadding());
                SPMLConfigPanel.this.loadForOnlySPMLOnInbound.setSize(SPMLConfigPanel.this.loadForOnlySPMLOnInbound.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(parent.getSize());
            }
        }
    }
}

