/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ServiceTypeConfig
extends MasterDataInsert<CateringServiceTypeComplete> {
    private static final long serialVersionUID = 1L;

    public ServiceTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public CateringServiceTypeComplete getNewObject() {
        CateringServiceTypeComplete c = new CateringServiceTypeComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        return c;
    }

    @Override
    public Class<? extends CateringServiceTypeComplete> getMasterDataClass() {
        return CateringServiceTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Service Types";
    }

    @Override
    public DetailsPanel getDetails() {
        return new ServiceTypeDetailsPanel();
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> validations = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean descriptionSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(CateringServiceTypeComplete_.description).getValue() == null) {
                descriptionSet = false;
            }
            if (n.getChildNamed(CateringServiceTypeComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(CateringServiceTypeComplete_.code).getValue())) {
                validations.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(CateringServiceTypeComplete_.code).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(CateringServiceTypeComplete_.code).getValue());
        }
        if (!codeSet) {
            validations.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!descriptionSet) {
            validations.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Descriptions are set"));
        }
        return validations;
    }

    private class ServiceTypeDetailsPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> description;
        private TitledItem<TextField> sequence;

        public ServiceTypeDetailsPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.sequence = new TitledItem<TextField>(new TextField(null, TextFieldType.INT), Words.SEQUENCE, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.description);
            this.add(this.sequence);
        }

        @Override
        public void setNode(Node<?> n) {
            super.setNode(n);
            this.code.getElement().setNode(n.getChildNamed(CateringServiceTypeComplete_.code));
            this.description.getElement().setNode(n.getChildNamed(CateringServiceTypeComplete_.description));
            this.sequence.getElement().setNode(n.getChildNamed(CateringServiceTypeComplete_.sequence));
            this.setEnabled(true);
            ServiceTypeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return CateringServiceTypeComplete_.code;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.code);
            CheckedListAdder.addToList(focusList, this.description);
            CheckedListAdder.addToList(focusList, this.sequence);
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
            this.sequence.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.sequence.kill();
            this.code = null;
            this.description = null;
            this.sequence = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.sequence.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                ServiceTypeDetailsPanel.this.code.setLocation(ServiceTypeConfig.this.masterDataTable.getCellPadding(), ServiceTypeConfig.this.masterDataTable.getCellPadding());
                ServiceTypeDetailsPanel.this.code.setSize(200, (int)ServiceTypeDetailsPanel.this.code.getPreferredSize().getHeight());
                ServiceTypeDetailsPanel.this.description.setLocation(ServiceTypeConfig.this.masterDataTable.getCellPadding(), ServiceTypeDetailsPanel.this.code.getY() + ServiceTypeDetailsPanel.this.code.getHeight() + ServiceTypeConfig.this.masterDataTable.getCellPadding());
                ServiceTypeDetailsPanel.this.description.setSize(200, (int)ServiceTypeDetailsPanel.this.description.getPreferredSize().getHeight());
                ServiceTypeDetailsPanel.this.sequence.setLocation(ServiceTypeConfig.this.masterDataTable.getCellPadding(), ServiceTypeDetailsPanel.this.description.getY() + ServiceTypeDetailsPanel.this.description.getHeight() + ServiceTypeConfig.this.masterDataTable.getCellPadding());
                ServiceTypeDetailsPanel.this.sequence.setSize(200, (int)ServiceTypeDetailsPanel.this.sequence.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

