/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.mealplan.details;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.LegInfoConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.utils.SPMLFixPricePopupInsert;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantTableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiTaxesComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight_;
import ch.icit.pegasus.server.core.dtos.mealplan.ServiceFixPriceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ServiceFixPriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.core.util.MealCycleToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FixPriceDetailsPanel
extends StateDependantTableDetailsPanel<MealPlanLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDCheckBox> isFixCosts;
    private Node<MealPlanLight> node;

    public FixPriceDetailsPanel(RowEditor<MealPlanLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true, true);
        this.setTitleText(Words.FIX_PRICES);
        this.isFixCosts = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.USE_FIX_PRICES, TitledItem.TitledItemOrientation.WEST);
        this.isFixCosts.getElement().setOverrideName(MealPlanLight_.fixPriceUsed);
        this.isFixCosts.setIgnorePrefWidth(true);
        this.isFixCosts.getElement().addButtonListener(this);
        this.addToView(this.isFixCosts);
    }

    private boolean isDeletable() {
        return this.provider.isDeletable(MealPlanLight_.fixPrices);
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.CABIN_CLASS_SHORT, null, null, null, "", 120, 120, 120));
        columns.add(new TableColumnInfo(Words.LEG, null, null, null, "", 180, 180, 180));
        columns.add(new TableColumnInfo(Words.CUSTOMER_NUMBER, 40, 40, 40));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.CYCLE), null, null, null, "", 80, 80, 80));
        int tw = 2 * this.table.getCellPadding() + InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
        columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.TAXES, null, null, null, "", 160, 160, 160));
        tw = 2 * this.table.getCellPadding() + EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 25;
        columns.add(new TableColumnInfo(Words.SPML, null, null, null, "", tw, tw, tw));
        tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setOverrideName(MealPlanLight_.fixPrices);
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        ServiceFixPriceComplete f = new ServiceFixPriceComplete();
        f.setClientOId(Long.valueOf(ADTO.getNextId()));
        PriceComplete pc = new PriceComplete();
        pc.setPrice(Double.valueOf(0.0));
        pc.setClientOId(Long.valueOf(pc.getNextId()));
        pc.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
        f.setPrice(pc);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)f, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return MealPlanComplete_.state;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.isFixCosts.getElement().getEditor()) {
            this.ensureFixCost();
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.isFixCosts.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.isFixCosts.getElement().isChecked() && this.table.isWritable()) {
            boolean cycleError = false;
            boolean combinationError = false;
            HashMap<String, String> map = new HashMap<String, String>();
            for (Table2RowPanel p : this.table.getRows()) {
                List<String> s;
                TableRowImpl pp = (TableRowImpl)p;
                if (!pp.isCycleValid()) {
                    cycleError = true;
                }
                if ((s = pp.getConfig()).isEmpty()) {
                    pp.invalidateCycle();
                    cycleError = true;
                    continue;
                }
                for (String ss : s) {
                    if (map.get(ss) != null) {
                        combinationError = true;
                        pp.invalidateCycle();
                        continue;
                    }
                    map.put(ss, ss);
                }
            }
            if (cycleError) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENTER_ALL_CYCLES_LIKE));
            }
            if (combinationError) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.COMBINATION_OF_PAX_LEG_CYCLE_MUST_BE_UNIQUE));
            }
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enabled;
        super.setEnabled(isEnabled);
        boolean isDraft = this.isStateDraft();
        boolean bl = enabled = isEnabled && isDraft && this.isFixCosts.getElement().isChecked();
        if (isEnabled && this.isFixCosts.getElement().isChecked()) {
            if (isDraft) {
                this.table.setEnabled(enabled);
            } else {
                this.table.setLocked(isDraft);
            }
        } else {
            this.table.setEnabled(enabled);
        }
        this.isFixCosts.setEnabled(isEnabled && isDraft);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.isFixCosts.kill();
        this.isFixCosts = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.isFixCosts);
        CheckedListAdder.addToList(focusList, this.table);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.table.getModel().setNode(node.getChildNamed(MealPlanLight_.fixPrices));
        this.isFixCosts.getElement().setNode(node.getChildNamed(MealPlanLight_.fixPriceUsed));
        node.addNodeListener((NodeListener)this);
        this.node = node;
        this.ensureFixCost();
    }

    private void ensureFixCost() {
        this.setEnabled(true);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.isFixCosts.setLocation(this.horizontalBorder, this.verticalBorder);
        this.isFixCosts.setSize((int)this.isFixCosts.getPreferredSize().getWidth(), (int)this.isFixCosts.getPreferredSize().getHeight());
        this.table.setLocation(0, this.isFixCosts.getY() + this.isFixCosts.getHeight() + this.verticalBorder);
        this.table.setSize(parent.getWidth(), parent.getHeight() - this.table.getY());
    }

    @Override
    public Dimension calculatePreferredSize() {
        int h = this.verticalBorder;
        h = (int)((double)h + this.isFixCosts.getPreferredSize().getHeight());
        h += this.verticalBorder;
        h = (int)((double)h + this.table.getPreferredSize().getHeight());
        return new Dimension(0, h += this.verticalBorder);
    }

    @Override
    public void valueChanged(Node<?> node) {
        this.setNode(this.node);
    }

    @Override
    public void childAdded(Node<?> source, Node<?> child) {
    }

    @Override
    public void childRemoved(Node<?> source, Node<?> child) {
    }

    @Override
    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public boolean isSwingOnly() {
        return true;
    }

    public void updateAirports() {
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl i = (TableRowImpl)p;
            i.updateAirport();
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDComboBox paxClass;
        private RDComboBox leg;
        private RDTextField cycle;
        private InfoButton cycleInfo;
        private RDInputComboBox price;
        private EditButton spmls;
        private DeleteButton delete;
        private RDTextField customerInvoiceNumber;
        private RDMultiTaxesComboBox taxes;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            if (FixPriceDetailsPanel.this.isDeletable()) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
            }
            this.paxClass = new RDComboBox(FixPriceDetailsPanel.this.provider, ConverterRegistry.getConverter(CabinClassConverter.class));
            this.paxClass.setNode(m.getNode().getChildNamed(ServiceFixPriceComplete_.paxClass));
            this.paxClass.refreshPossibleValues(NodeToolkit.getAffixList(CabinClassComplete.class));
            this.leg = new RDComboBox(FixPriceDetailsPanel.this.provider, ConverterRegistry.getConverter(LegInfoConverter.class));
            this.leg.setNode(m.getNode().getChildNamed(ServiceFixPriceComplete_.leg));
            this.leg.refreshPossibleValues(FixPriceDetailsPanel.this.editor.getModel().getNode().getChildNamed(MealPlanLight_.legs));
            this.customerInvoiceNumber = new RDTextField(FixPriceDetailsPanel.this.provider);
            this.customerInvoiceNumber.setNode(m.getNode().getChildNamed(ServiceFixPriceComplete_.customerInvoiceNumber));
            this.cycle = new RDTextField(FixPriceDetailsPanel.this.provider);
            this.cycle.setNode(m.getNode().getChildNamed(ServiceFixPriceComplete_.cycle));
            this.cycleInfo = new InfoButton(SizedSkin1Field.SkinSize.MEDIUM);
            this.cycleInfo.installStringViewer(ProductToolkit.getCycleDescriptionString());
            this.price = new RDInputComboBox(FixPriceDetailsPanel.this.provider, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.price.setNode(m.getNode().getChildNamed(ServiceFixPriceComplete_.price));
            this.price.setPossibleUnits(NodeToolkit.getAffixList(CurrencyComplete.class));
            this.taxes = new RDMultiTaxesComboBox(FixPriceDetailsPanel.this.provider);
            this.taxes.setNode(m.getNode().getChildNamed(ServiceFixPriceComplete_.taxRates));
            this.spmls = new EditButton();
            this.spmls.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.paxClass);
            this.add(this.leg);
            this.add(this.customerInvoiceNumber);
            this.add(this.cycle);
            this.add(this.cycleInfo);
            this.add(this.price);
            this.add(this.taxes);
            this.add(this.spmls);
            if (this.delete != null) {
                this.add(this.delete);
            }
        }

        public void invalidateCycle() {
            this.cycle.setInvalid();
        }

        public List<String> getConfig() {
            Converter c = ConverterRegistry.getConverter(CabinClassConverter.class);
            String tt = (String)c.convert(this.paxClass.getNode().getValue(), this.paxClass.getNode(), new Object[0]);
            c = ConverterRegistry.getConverter(LegInfoConverter.class);
            tt = tt + " - " + c.convert(this.leg.getNode().getValue(), this.leg.getNode(), new Object[0]);
            List i = MealCycleToolkit.getIntegerForString((String)this.cycle.getText());
            ArrayList<String> t = new ArrayList<String>();
            for (Integer ii : i) {
                String ttt = tt + " - " + ii;
                t.add(ttt);
            }
            return t;
        }

        public boolean isCycleValid() {
            boolean isValid = true;
            String t = this.cycle.getText();
            if (t != null && t.matches(".*[^0123456789,\\-].*")) {
                isValid = false;
                this.cycle.setInvalid();
            }
            return isValid;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.paxClass.kill();
            this.paxClass = null;
            this.leg.kill();
            this.leg = null;
            this.customerInvoiceNumber.kill();
            this.customerInvoiceNumber = null;
            this.cycle.kill();
            this.cycle = null;
            this.cycleInfo.kill();
            this.cycleInfo = null;
            this.price.kill();
            this.price = null;
            this.taxes.kill();
            this.taxes = null;
            this.spmls.kill();
            this.spmls = null;
            if (this.delete != null) {
                this.delete.kill();
            }
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.paxClass);
            CheckedListAdder.addToList(focusList, this.leg);
            CheckedListAdder.addToList(focusList, this.customerInvoiceNumber);
            CheckedListAdder.addToList(focusList, this.cycle);
            CheckedListAdder.addToList(focusList, this.price);
            CheckedListAdder.addToList(focusList, this.taxes);
            CheckedListAdder.addToList(focusList, this.spmls);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new DtoField[]{ServiceFixPriceComplete_.paxClass, CabinClassComplete_.code}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new DtoField[]{ServiceFixPriceComplete_.leg, ALegComplete_.departureAirport}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(ServiceFixPriceComplete_.customerInvoiceNumber).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(ServiceFixPriceComplete_.cycle).getValue();
                }
                case 4: {
                    return null;
                }
                case 5: {
                    return this.model.getNode().getChildNamed(new DtoField[]{ServiceFixPriceComplete_.price, PriceComplete_.price}).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.paxClass.setEnabled(isEnabled);
            this.leg.setEnabled(isEnabled);
            this.customerInvoiceNumber.setEnabled(isEnabled);
            this.cycle.setEnabled(isEnabled);
            this.cycleInfo.setEnabled(FixPriceDetailsPanel.this.table.isEnabled());
            this.price.setEnabled(isEnabled);
            this.taxes.setEnabled(isEnabled);
            this.spmls.setEnabled(FixPriceDetailsPanel.this.table.isEnabled());
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            } else if (source == this.spmls) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, Words.EDIT_SPML_FIX_PRICES);
                popUp.setView(new SPMLFixPricePopupInsert(this.model.getNode().getChildNamed(ServiceFixPriceComplete_.spmls), FixPriceDetailsPanel.this.provider, FixPriceDetailsPanel.this.table.isEditable()));
                popUp.showPopUp(x, y, 450, 300, null, source, PopupType.FRAMELESS);
            }
        }

        public void updateAirport() {
            if (this.leg.getEditor() != null) {
                ((ComboBox)this.leg.getEditor()).removeAllItems();
                ((ComboBox)this.leg.getEditor()).refreshPossibleValues(FixPriceDetailsPanel.this.editor.getModel().getNode().getChildNamed(new String[]{"plegs"}));
            } else if (this.leg.getRenderer() != null) {
                ((TextLabel)this.leg.getRenderer()).updateString();
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.paxClass.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.paxClass.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.paxClass.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.paxClass.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.leg.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.leg.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.leg.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.leg.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.customerInvoiceNumber.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customerInvoiceNumber.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customerInvoiceNumber.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customerInvoiceNumber.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.cycle.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cycle.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cycle.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.cycleInfo.getPreferredSize().getWidth())), (int)TableRowImpl.this.cycle.getPreferredSize().getHeight());
                TableRowImpl.this.cycleInfo.setLocation(TableRowImpl.this.cycle.getX() + TableRowImpl.this.cycle.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cycleInfo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cycleInfo.setSize(TableRowImpl.this.cycleInfo.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.taxes.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.taxes.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.taxes.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.taxes.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.spmls.setLocation((int)((double)currentX + ((double)w - TableRowImpl.this.spmls.getPreferredSize().getWidth()) / 2.0), (int)(((double)parent.getHeight() - TableRowImpl.this.spmls.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.spmls.setSize(TableRowImpl.this.spmls.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(7);
                TableRowImpl.this.setControlsX(currentX);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }
}

