/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.mealplan.details;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantTableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ConfigButton;
import ch.icit.pegasus.client.gui.utils.panels.MappingTable2D;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.inserts.LegMappingPopupInsert;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.MealPlanConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MealPlanConfigurationDetailsPanel
extends StateDependantTableDetailsPanel<MealPlanLight> {
    private static final long serialVersionUID = 1L;

    public MealPlanConfigurationDetailsPanel(RowEditor<MealPlanLight> editor, RDProvider provider) {
        super(editor, provider, true, true, false, true);
        this.setTitleText(Words.MEAL_PLAN_STOWING_LIST_LEG_MAPPING);
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.STOWING, null, null, null, "", 120, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo(Words.VARIANT, null, null, null, "", TableColumnInfo.periodColumnWidth + 2 * this.table.getCellPadding()));
        int tw = ConfigButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
        table.setSortable(true);
        table.setSortedColumn(2);
        table.setSortDirection(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return MealPlanComplete_.state;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean isDraft = this.isStateDraft();
        if (isEnabled) {
            if (isDraft) {
                this.table.setEnabled(isEnabled);
            } else {
                this.table.setLocked(isDraft);
            }
        } else {
            this.table.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.node = node;
        this.table.getModel().setNode(node.getChildNamed(MealPlanComplete_.mealplanConfigs));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel no;
        private TextLabel name;
        private TextLabel period;
        private ConfigButton editMapping;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            if (m.getNode().getChildNamed(MealPlanConfigurationComplete_.stowingList).getValue() == null) {
                this.no = new TextLabel(m.getNode().getChildNamed(MealPlanConfigurationComplete_.stwNumber), ConverterRegistry.getConverter(StringConverter.class));
                this.name = new TextLabel(m.getNode().getChildNamed(MealPlanConfigurationComplete_.stwName), ConverterRegistry.getConverter(StringConverter.class));
                this.period = new TextLabel(m.getNode().getChildNamed(MealPlanConfigurationComplete_.stwPeriod), ConverterRegistry.getConverter(StringConverter.class));
            } else {
                StowingListTemplateVariantLight stw = (StowingListTemplateVariantLight)m.getNode().getChildNamed(MealPlanConfigurationComplete_.stowingList).getValue(StowingListTemplateVariantLight.class);
                this.no = stw.getBase() != null ? new TextLabel(m.getNode().getChildNamed(new DtoField[]{MealPlanConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.base, StowingListTemplateComplete_.number}), ConverterRegistry.getConverter(IntegerConverter.class)) : new TextLabel(m.getNode().getChildNamed(MealPlanConfigurationComplete_.stwNumber), ConverterRegistry.getConverter(StringConverter.class));
                this.name = new TextLabel(m.getNode().getChildNamed(new DtoField[]{MealPlanConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.name}), ConverterRegistry.getConverter(StringConverter.class));
                this.period = new TextLabel(m.getNode().getChildNamed(new DtoField[]{MealPlanConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.validityPeriod}), ConverterRegistry.getConverter(PeriodConverter.class));
            }
            this.editMapping = new ConfigButton();
            this.editMapping.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.no);
            this.add(this.name);
            this.add(this.period);
            this.add(this.editMapping);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.editMapping);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            try {
                if (this.model.getNode().getChildNamed(MealPlanConfigurationComplete_.stowingList).getValue() == null) {
                    switch (column) {
                        case 0: {
                            return this.model.getNode().getChildNamed(MealPlanConfigurationComplete_.stwNumber).getValue();
                        }
                        case 1: {
                            return this.model.getNode().getChildNamed(MealPlanConfigurationComplete_.stwName).getValue();
                        }
                        case 2: {
                            return this.model.getNode().getChildNamed(MealPlanConfigurationComplete_.stwPeriod).getValue();
                        }
                    }
                } else {
                    switch (column) {
                        case 0: {
                            return this.model.getNode().getChildNamed(new DtoField[]{MealPlanConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.baseNumber}).getValue();
                        }
                        case 1: {
                            return this.model.getNode().getChildNamed(new DtoField[]{MealPlanConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.name}).getValue();
                        }
                        case 2: {
                            return this.model.getNode().getChildNamed(new DtoField[]{MealPlanConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.validityPeriod, PeriodComplete_.startDate}).getValue();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean isDraft = true;
            if (MealPlanConfigurationDetailsPanel.this.node != null) {
                try {
                    isDraft = MealPlanConfigurationDetailsPanel.this.node.getChildNamed(MealPlanComplete_.state).getValue() != ModificationStateE.ACCEPTED;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            boolean enabled = isEnabled && isDraft;
            super.setEnabled(enabled);
            this.no.setEnabled(enabled);
            this.name.setEnabled(enabled);
            this.period.setEnabled(enabled);
            this.editMapping.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.no.kill();
            this.name.kill();
            this.period.kill();
            this.editMapping.kill();
            this.no = null;
            this.name = null;
            this.period = null;
            this.editMapping = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, Words.DEFINE_MEAL_PLAN_LEG_MAPPING);
            ArrayList<Node<ALegComplete>> sourceLeg = new ArrayList<Node<ALegComplete>>();
            this.model.getNode().getChildNamed(new DtoField[]{MealPlanConfigurationComplete_.mealplan, MealPlanComplete_.legs}).commit();
            Iterator it = this.model.getNode().getChildNamed(new DtoField[]{MealPlanConfigurationComplete_.mealplan, MealPlanComplete_.legs}).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                sourceLeg.add(n);
            }
            this.model.getNode().getChildNamed(new DtoField[]{MealPlanConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.legs}).commit();
            popUp.setView(new LegMappingPopupInsert(sourceLeg, MappingTable2D.createList(this.model.getNode().getChildNamed(new DtoField[]{MealPlanConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.legs})), (Node<Map<ALegComplete, ALegComplete>>)this.model.getNode().getChildNamed(MealPlanConfigurationComplete_.legMapping), "Leg (from Meal Plan)", "is replaced by Leg (from Stowing List)", false));
            popUp.showPopUp(x, y, 480, 200, null, source);
            popUp.getView().setEnabled(this.isEnabled());
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.no.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.no.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.no.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.no.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.period.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.period.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.period.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.period.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.editMapping.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.editMapping.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.editMapping.setSize(TableRowImpl.this.editMapping.getPreferredSize());
            }
        }
    }
}

