/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details.utils;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.PriceConverter2;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.PriceToolkit;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.product.CateringPointCostComplete;
import ch.icit.pegasus.server.core.dtos.product.CateringPointCostComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.DepartmentManHoursCostComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class CateringCostTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private Component toplevelParent;
    private RDProvider provider;
    private boolean isDeletable;
    private LoadingGroup loader;
    private boolean tender;
    private Node<CustomerLight> customerNode;
    private boolean loaderWasNull;
    private ComboBoxFactory.DepartmentType departmentType;
    private boolean allowSteps;

    public CateringCostTable(Component parent, RDProvider provider, boolean isDeletable, LoadingGroup loader, boolean isTender, ComboBoxFactory.DepartmentType type, boolean allowSteps) {
        this(parent, provider, isDeletable, loader, isTender, type, allowSteps, false);
    }

    public CateringCostTable(Component parent, RDProvider provider, boolean isDeletable, LoadingGroup loader, boolean isTender, ComboBoxFactory.DepartmentType type, boolean allowSteps, boolean withBackground) {
        super(true, Words.ADD, withBackground);
        this.toplevelParent = parent;
        this.isDeletable = isDeletable;
        this.provider = provider;
        this.loader = loader;
        this.tender = isTender;
        this.departmentType = type;
        this.allowSteps = allowSteps;
        if (this.loader == null) {
            this.loaderWasNull = true;
            this.loader = new DefaultLoadingGroup();
        }
        this.setProvider(provider);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                CateringCostTable.this.ensureAddbuttonState();
                CateringCostTable.this.ensureSelectableItems();
                CateringCostTable.this.updateOrder();
                CateringCostTable.this.toplevelParent.validate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                InternalCostCenterComplete department = CateringCostTable.this.getFreeCosts();
                if (department != null && CateringCostTable.this.getAddNode() != null) {
                    CateringPointCostComplete c = new CateringPointCostComplete();
                    c.setClientOId(Long.valueOf(ADTO.getNextId()));
                    c.setCostCenter(CateringCostTable.this.getFreeCosts());
                    c.setPoints(Double.valueOf(0.0));
                    c.setLoadFactor(Double.valueOf(1.0));
                    c.setFromAmount(Integer.valueOf(0));
                    c.setToAmount(Integer.valueOf(0));
                    Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false);
                    CateringCostTable.this.getAddNode().addChild(n, System.currentTimeMillis());
                    CateringCostTable.this.ensureAddbuttonState();
                    CateringCostTable.this.ensureSelectableItems();
                    CateringCostTable.this.updateOrder();
                    CateringCostTable.this.toplevelParent.validate();
                } else {
                    CateringCostTable.this.ensureAddbuttonState();
                }
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.PROCESS, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.CABIN_CLASS_SHORT, null, null, null, "", 30, 30, 30));
        int tw = TableColumnInfo.timeColumnWidth + 3 * this.getCellPadding() + InfoButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 5;
        columns.add(new TableColumnInfo(Words.CP, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.LOAD, null, null, null, "", 90, 90, 90));
        if (allowSteps) {
            columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", 65, 65, 65));
            columns.add(new TableColumnInfo(Words.TO, null, null, null, "", 65, 65, 65));
        }
        columns.add(new TableColumnInfo(Words.COST, null, null, null, "", 30, 30, 30));
        tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        if (!allowSteps) {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.4);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.35);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.29);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        } else {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.4);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.35);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(6)).setxExpand(0.29);
            ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
        }
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1, Table2RowPanel.TableControlsType.ONE)));
    }

    public void setCustomerNode(Node<CustomerLight> customer) {
        this.customerNode = customer;
    }

    protected Node getAddNode() {
        return this.getModel().getNode();
    }

    public abstract void load(boolean var1);

    private void ensureSelectableItems() {
        Node cc = NodeToolkit.getAffixList(InternalCostCenterComplete.class);
        ArrayList<Node> aList = new ArrayList<Node>();
        Iterator it = cc.getChilds();
        while (it.hasNext()) {
            Node c = (Node)it.next();
            boolean found = false;
            for (Table2RowPanel p : this.getRows()) {
                if (!((CostCenterComplete)c.getValue()).equals(p.getModel().getNode().getChildNamed(new String[]{"costCenter"}).getValue())) continue;
                found = true;
            }
            if (!found) continue;
            aList.add(c);
        }
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            pp.updatePossibles(aList);
        }
    }

    private void ensureAddbuttonState() {
        this.enableAddButton(this.getFreeCosts() != null);
    }

    public InternalCostCenterComplete getFreeCosts() {
        if (this.allowSteps) {
            Node cc = NodeToolkit.getAffixList(InternalCostCenterComplete.class);
            Iterator it = (cc = ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)cc, null, this.departmentType)).getChilds();
            if (it.hasNext()) {
                Node c = (Node)it.next();
                return (InternalCostCenterComplete)c.getValue();
            }
        } else {
            Node cc = NodeToolkit.getAffixList(InternalCostCenterComplete.class);
            cc = ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)cc, null, this.departmentType);
            Iterator it = cc.getChilds();
            while (it.hasNext()) {
                Node c = (Node)it.next();
                boolean found = false;
                if (c.getValue() instanceof InternalCostCenterComplete) {
                    for (Table2RowPanel p : this.getRows()) {
                        if (!((CostCenterComplete)c.getValue()).equals(p.getModel().getNode().getChildNamed(new String[]{"costCenter"}).getValue())) continue;
                        found = true;
                    }
                } else {
                    found = true;
                }
                if (found) continue;
                return (InternalCostCenterComplete)c.getValue();
            }
        }
        return null;
    }

    public void setNode(Node node) {
        this.getModel().setNode(node);
        this.getModel().allInitiated();
        this.ensureAddbuttonState();
        this.ensureSelectableItems();
    }

    @Override
    public int getRowCount() {
        return this.getRows().size();
    }

    public abstract void addProcessCost(ReloadablePriceView var1);

    public boolean isRowEditable(TableRowImpl row) {
        return this.getAddNode().hasChild4Value(row.getModel().getNode().getValue());
    }

    public abstract void removeProcessCost(ReloadablePriceView var1);

    @Override
    public boolean isInnerComponent(Component c) {
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (!pp.isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    private class DefaultLoadingGroup
    implements LoadingGroup,
    RemoteLoader {
        private DefaultLoadingGroup() {
        }

        @Override
        public void updateMe(final ReloadablePriceView rpv) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    CalculationRunnable runing = rpv.getCurrentRunnable();
                    if (runing.isAlive()) {
                        runing.run();
                        rpv.loaded();
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return DefaultLoadingGroup.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }

        public void remoteObjectLoaded(Node<?> node) {
        }

        public void errorOccurred(ClientException exception) {
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements NodeListener,
    ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDComboBox processName;
        private RDComboBox cabinClass;
        private RDTextField cpAmount;
        private RDTextField loadFactor;
        private InfoButton infoIcon;
        private ReloadablePriceView costs;
        private DeleteButton delete;
        private RDTextField fromField;
        private RDTextField toField;

        public TableRowImpl(Table2RowModel m, Table2RowPanel.TableControlsType controlSkin) {
            super(m);
            this.setUseControlSkin(controlSkin);
            this.processName = new RDComboBox(CateringCostTable.this.provider, ConverterRegistry.getConverter(CostCenterConverter.class));
            this.processName.refreshPossibleValues(ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)NodeToolkit.getAffixList(InternalCostCenterComplete.class), (Node<InternalCostCenterComplete>)m.getNode().getChildNamed(new String[]{"costCenter"}), CateringCostTable.this.departmentType));
            this.processName.setNode(m.getNode().getChildNamed(new String[]{"costCenter"}));
            this.cabinClass = new RDComboBox(CateringCostTable.this.provider, ConverterRegistry.getConverter(CabinClassConverter.class), true);
            this.cabinClass.refreshPossibleValues(NodeToolkit.getAffixList(CabinClassComplete.class));
            this.cabinClass.setNode(m.getNode().getChildNamed(new String[]{"cabinClass"}));
            this.cpAmount = new RDTextField(CateringCostTable.this.provider, TextFieldType.HOUR_MINUTE_SECOND_TIME);
            this.cpAmount.setMaxKommaStellen(2);
            this.cpAmount.setNode(m.getNode().getChildNamed(new String[]{"points"}));
            this.loadFactor = new RDTextField(CateringCostTable.this.provider, TextFieldType.DOUBLE);
            this.loadFactor.setMaxKommaStellen(3);
            this.loadFactor.setNode(m.getNode().getChildNamed(new String[]{"loadFactor"}));
            if (CateringCostTable.this.allowSteps) {
                this.fromField = new RDTextField(CateringCostTable.this.provider, TextFieldType.INT);
                this.toField = new RDTextField(CateringCostTable.this.provider, TextFieldType.INT);
                this.fromField.setNode(m.getNode().getChildNamed(CateringPointCostComplete_.fromAmount));
                this.toField.setNode(m.getNode().getChildNamed(CateringPointCostComplete_.toAmount));
            }
            this.infoIcon = new InfoButton("Department info");
            String t = ProductToolkit.createProcessCostInfoButton((CateringPointCostComplete)this.model.getNode().getValue(), (Node<CateringPointCostComplete>)this.model.getNode());
            this.infoIcon.installStringViewer(t);
            this.costs = new ReloadablePriceView(CateringCostTable.this.loader, PriceConverter2.class);
            this.setCalcAlgorithm();
            if (CateringCostTable.this.loaderWasNull) {
                CateringCostTable.this.loader.updateMe(this.costs);
            } else {
                CateringCostTable.this.addProcessCost(this.costs);
            }
            this.setLayout(new TableRowLayout());
            if (CateringCostTable.this.isDeletable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.add(this.delete);
            }
            this.processName.setProgress(1.0f);
            this.cabinClass.setProgress(1.0f);
            this.cpAmount.setProgress(1.0f);
            this.infoIcon.setProgress(1.0f);
            this.costs.setProgress(1.0f);
            this.loadFactor.setProgress(1.0f);
            m.getNode().getChildNamed(new String[]{"points"}).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(new String[]{"costCenter"}).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(new String[]{"cabinClass"}).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(new String[]{"loadFactor"}).addNodeListener((NodeListener)this);
            this.add(this.processName);
            this.add(this.cabinClass);
            this.add(this.cpAmount);
            this.add(this.loadFactor);
            this.add(this.infoIcon);
            this.add(this.costs);
            if (CateringCostTable.this.allowSteps) {
                this.add(this.fromField);
                this.add(this.toField);
                this.fromField.setProgress(1.0f);
                this.toField.setProgress(1.0f);
                m.getNode().getChildNamed(CateringPointCostComplete_.fromAmount).addNodeListener((NodeListener)this);
                m.getNode().getChildNamed(CateringPointCostComplete_.toAmount).addNodeListener((NodeListener)this);
            }
            this.updateValue();
        }

        @Override
        public Object getObject4Column(int column) {
            if (CateringCostTable.this.allowSteps) {
                switch (column) {
                    case 0: {
                        return this.processName.getStringValue();
                    }
                    case 1: {
                        return this.cabinClass.getStringValue();
                    }
                    case 2: {
                        return this.cpAmount.getStringValue();
                    }
                    case 3: {
                        return this.loadFactor.getStringValue();
                    }
                    case 4: {
                        return this.fromField.getStringValue();
                    }
                    case 5: {
                        return this.toField.getStringValue();
                    }
                    case 6: {
                        return this.costs.getTextLabel().getText();
                    }
                }
            } else {
                switch (column) {
                    case 0: {
                        return this.processName.getStringValue();
                    }
                    case 1: {
                        return this.cabinClass.getStringValue();
                    }
                    case 2: {
                        return this.cpAmount.getStringValue();
                    }
                    case 3: {
                        return this.loadFactor.getStringValue();
                    }
                    case 4: {
                        return this.costs.getTextLabel().getText();
                    }
                }
            }
            return null;
        }

        protected void updatePossibles(List<Node> list) {
        }

        private void updateValue() {
            if (CateringCostTable.this.loaderWasNull) {
                CateringCostTable.this.loader.updateMe(this.costs);
            } else {
                this.costs.load(true);
            }
        }

        private void ensureCustomerComplete() throws ClientServerCallException {
            if (CateringCostTable.this.customerNode.getValue(CustomerComplete.class) == null) {
                CustomerLight cl = (CustomerLight)CateringCostTable.this.customerNode.getValue(CustomerLight.class);
                CustomerComplete cc = (CustomerComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getCustomer(new CustomerReference(cl.getId())).getValue();
                CateringCostTable.this.customerNode.setValue((Object)cc, 0L);
            }
        }

        private void setCalcAlgorithm() {
            CalculationRunnable run = new CalculationRunnable(){

                @Override
                public void run() {
                    Node costPerManHour;
                    if (!TableRowImpl.this.isEnabled() || CateringCostTable.this.tender && CateringCostTable.this.customerNode == null) {
                        return;
                    }
                    PriceComplete p = new PriceComplete();
                    Double points = (Double)TableRowImpl.this.model.getNode().getChildNamed(new String[]{"points"}).getValue();
                    points = points / 3600.0;
                    TableRowImpl.this.model.getNode().commitThis();
                    InternalCostCenterComplete usedCostCenter = (InternalCostCenterComplete)TableRowImpl.this.model.getNode().getChildNamed(CateringPointCostComplete_.costCenter).getValue();
                    Date validityDate = new Date(System.currentTimeMillis());
                    PriceComplete pricePerManHour = null;
                    if (CateringCostTable.this.tender) {
                        try {
                            TableRowImpl.this.ensureCustomerComplete();
                        }
                        catch (ClientServerCallException e1) {
                            e1.printStackTrace();
                        }
                        CustomerComplete customer = (CustomerComplete)CateringCostTable.this.customerNode.getValue(CustomerComplete.class);
                        for (DepartmentManHoursCostComplete dpc : customer.getManHourCosts()) {
                            if (!dpc.getDepartment().equals((Object)usedCostCenter) || !dpc.getValidity().within(validityDate).booleanValue()) continue;
                            pricePerManHour = dpc.getManHourCost();
                        }
                    }
                    if (pricePerManHour == null) {
                        pricePerManHour = usedCostCenter.resolveBestPrice(validityDate);
                    }
                    if ((costPerManHour = INodeCreator.getDefaultImpl().getNode4DTO((Object)pricePerManHour, false, false)).getValue() == null) {
                        p.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
                        p.setPrice(Double.valueOf(0.0));
                    } else {
                        p.setCurrency(((PriceComplete)costPerManHour.getValue()).getCurrency());
                        double lf = 1.0;
                        try {
                            lf = Double.valueOf(TableRowImpl.this.loadFactor.getText());
                        }
                        catch (Exception e) {
                            lf = 1.0;
                        }
                        if (((PriceComplete)costPerManHour.getValue()).getPrice() != null) {
                            p.setPrice(Double.valueOf(((PriceComplete)costPerManHour.getValue()).getPrice() * points * lf));
                        } else {
                            p.setPrice(Double.valueOf(0.0));
                        }
                    }
                    if (TableRowImpl.this.costs != null) {
                        Node pn = TableRowImpl.this.costs.getNode();
                        if (pn == null) {
                            pn = new EmbeddedDTONode();
                            TableRowImpl.this.costs.setNode(pn);
                        }
                        p.setPrice(PriceToolkit.ensureDoubleFinite(p.getPrice()));
                        pn.setValue((Object)p, 0L);
                    }
                }

                @Override
                public boolean isAlive() {
                    return !TableRowImpl.this.costs.isKilled();
                }
            };
            this.costs.setRunnable(run);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(new String[]{"points"}).removeNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(new String[]{"costCenter"}).removeNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(new String[]{"cabinClass"}).removeNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(new String[]{"loadFactor"}).removeNodeListener((NodeListener)this);
            if (CateringCostTable.this.allowSteps) {
                this.model.getNode().getChildNamed(CateringPointCostComplete_.fromAmount).removeNodeListener((NodeListener)this);
                this.model.getNode().getChildNamed(CateringPointCostComplete_.toAmount).removeNodeListener((NodeListener)this);
                this.fromField.kill();
                this.toField.kill();
            }
            CateringCostTable.this.removeProcessCost(this.costs);
            this.processName.kill();
            this.cabinClass.kill();
            this.cpAmount.kill();
            this.infoIcon.kill();
            this.loadFactor.kill();
            this.costs.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            this.processName = null;
            this.cabinClass = null;
            this.cpAmount = null;
            this.infoIcon = null;
            this.costs = null;
            this.delete = null;
            this.loadFactor = null;
            this.fromField = null;
            this.toField = null;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.processName != null) {
                this.processName.requestFocusInWindowNow();
            }
        }

        @Override
        public boolean isInnerComponent(Component c) {
            if (((ComboBox)this.processName.getEditor()).getCurrentPopUp() != null) {
                for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                    if (!currentC.equals(((ComboBox)this.processName.getEditor()).getCurrentPopUp())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.processName);
            CheckedListAdder.addToList(a, this.cabinClass);
            CheckedListAdder.addToList(a, this.cpAmount);
            CheckedListAdder.addToList(a, this.loadFactor);
            CheckedListAdder.addToList(a, this.fromField);
            CheckedListAdder.addToList(a, this.toField);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean rowEditable = this.isRowEditable();
            this.processName.setEnabled(isEnabled && rowEditable);
            this.cabinClass.setEnabled(isEnabled && rowEditable);
            this.cpAmount.setEnabled(isEnabled && rowEditable);
            this.loadFactor.setEnabled(isEnabled && rowEditable);
            if (CateringCostTable.this.allowSteps) {
                this.fromField.setEnabled(isEnabled && rowEditable);
                this.toField.setEnabled(isEnabled && rowEditable);
            }
            this.infoIcon.setEnabled(this.getModel().getParentModel().getTable().isEnabled() && rowEditable);
            this.costs.setEnabled(isEnabled && rowEditable);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled && rowEditable);
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public void valueChanged(Node<?> node) {
            if (node.getName().equals("points")) {
                this.updateValue();
            } else if (node.getName().equals("costCenter")) {
                String t = ProductToolkit.createProcessCostInfoButton((CateringPointCostComplete)this.model.getNode().getValue(), (Node<CateringPointCostComplete>)this.model.getNode());
                this.infoIcon.installStringViewer(t);
                CateringCostTable.this.ensureSelectableItems();
                this.updateValue();
            } else if (node.getName().equals("loadFactor")) {
                this.updateValue();
            } else {
                this.updateValue();
            }
        }

        private boolean isRowEditable() {
            return CateringCostTable.this.isRowEditable(this);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (this.delete == source) {
                this.getModel().getNode().getParent().removeChild(this.getModel().getNode(), System.currentTimeMillis());
            }
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class TableRowLayout
        extends DefaultLayout {
            private TableRowLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.processName.setLocation(currentX + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.processName.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.processName.setSize(w - 2 * TableRowImpl.this.getInnerCellPadding(), (int)TableRowImpl.this.processName.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.cabinClass.setLocation(currentX + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cpAmount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cabinClass.setSize(w - 2 * TableRowImpl.this.getInnerCellPadding(), (int)TableRowImpl.this.cabinClass.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.cpAmount.setLocation(currentX + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cpAmount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cpAmount.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.infoIcon.getPreferredSize().getWidth() + (double)TableRowImpl.this.getInnerCellPadding())), (int)TableRowImpl.this.cpAmount.getPreferredSize().getHeight());
                TableRowImpl.this.infoIcon.setLocation(TableRowImpl.this.cpAmount.getX() + TableRowImpl.this.cpAmount.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.infoIcon.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.infoIcon.setSize(TableRowImpl.this.infoIcon.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.loadFactor.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.loadFactor.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.loadFactor.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.loadFactor.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                int currentIndex = 5;
                if (CateringCostTable.this.allowSteps) {
                    TableRowImpl.this.fromField.setLocation(currentX + TableRowImpl.this.model.getParentModel().getTable().getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fromField.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.fromField.setSize(w - 2 * TableRowImpl.this.model.getParentModel().getTable().getCellPadding(), (int)TableRowImpl.this.fromField.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(currentIndex++);
                    TableRowImpl.this.toField.setLocation(currentX + TableRowImpl.this.model.getParentModel().getTable().getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.toField.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.toField.setSize(w - 2 * TableRowImpl.this.model.getParentModel().getTable().getCellPadding(), (int)TableRowImpl.this.toField.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(currentIndex++);
                }
                TableRowImpl.this.costs.setLocation(currentX + TableRowImpl.this.model.getParentModel().getTable().getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.costs.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.costs.setSize(w - 2 * TableRowImpl.this.model.getParentModel().getTable().getCellPadding(), (int)TableRowImpl.this.costs.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(currentIndex++);
                TableRowImpl.this.setControlsX(currentX);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

