/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.details;

import ch.icit.pegasus.client.actions.impl.SendPurchaseOrderAction;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextButton;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderSendHistoryComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.PurchaseOrderAccess;
import ch.icit.pegasus.server.core.dtos.system.PurchaseApprovalSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SendHistoryDetailsPanel
extends TableDetailsPanel<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private RDTextButton resend;

    public SendHistoryDetailsPanel(RowEditor<PurchaseOrderLight> editor, RDProvider provider) {
        super(editor, provider, false);
        this.setTitleText(Words.SEND_HISTORY);
        PurchaseApprovalSettingsComplete settings = (PurchaseApprovalSettingsComplete)NodeToolkit.getAffixClass(PurchaseApprovalSettingsComplete.class).getValue();
        if (Boolean.TRUE.equals(settings.getUsePurchaseApproval())) {
            PurchaseOrderLight order = (PurchaseOrderLight)editor.getModel().getNode().getValue();
            if (Boolean.TRUE.equals(order.getApproved())) {
                this.resend = new RDTextButton(provider);
                this.resend.setOverrideName(PurchaseOrderAccess.SEND);
                this.resend.setText(Words.SEND_ORDER_TO_SUPPLIER);
                this.resend.setNode(null);
                this.resend.addButtonListener(this);
                this.addToView(this.resend);
            }
        } else {
            this.resend = new RDTextButton(provider);
            this.resend.setOverrideName(PurchaseOrderAccess.SEND);
            this.resend.setText(Words.SEND_ORDER_TO_SUPPLIER);
            this.resend.setNode(null);
            this.resend.addButtonListener(this);
            this.addToView(this.resend);
        }
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", 70, 70, 70));
        columns.add(new TableColumnInfo(Words.TARGET, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.USER, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", 30, 30, 30));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.33);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.33);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.34);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        return p;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (this.resend != null && source == this.resend.getEditor()) {
            this.editor.showCommittingAnimation(Words.RESEND_ORDER);
            this.editor.setEnabled(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    new SendPurchaseOrderAction().performAction(SendHistoryDetailsPanel.this, null, SendHistoryDetailsPanel.this.editor.getModel().getNode().getValue(PurchaseOrderComplete.class), ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                    PurchaseOrderComplete o = (PurchaseOrderComplete)SendHistoryDetailsPanel.this.editor.getModel().getNode().getValue(PurchaseOrderComplete.class);
                    PurchaseOrderComplete op = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrderByReference(new PurchaseOrderReference(o.getId())).getValue();
                    SendHistoryDetailsPanel.this.editor.getModel().getNode().setValue((Object)op, 0L);
                    SendHistoryDetailsPanel.this.editor.getModel().getNode().updateNode();
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return SendHistoryDetailsPanel.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        OrderReviewStateE o = (OrderReviewStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.reviewState).getValue();
        if (o == null) {
            o = OrderReviewStateE.UNCHECKED;
            this.editor.getModel().getNode().getChildNamed(new String[]{"reviewState"}).setValue((Object)o, 0L);
        }
        boolean isApproved = o.equals((Object)OrderReviewStateE.APPROVED);
        super.setEnabled(isEnabled && !isApproved);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.resend != null) {
            this.resend.kill();
        }
        this.resend = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.table);
        CheckedListAdder.addToList(a, this.resend);
        return a;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(PurchaseOrderComplete_.sendHistory));
    }

    @Override
    public void layoutContainer(Container parent) {
        this.table.setLocation(0, 0);
        this.table.setSize(parent.getWidth(), (int)((double)parent.getHeight() - ((double)this.inner_verticalBorder + (this.resend != null ? this.resend.getPreferredSize().getHeight() : 0.0) + (double)this.verticalBorder)));
        if (this.resend != null) {
            this.resend.setLocation(this.horizontalBorder, this.table.getY() + this.table.getHeight() + this.inner_verticalBorder);
            this.resend.setSize(this.resend.getPreferredSize());
        }
    }

    @Override
    public Dimension calculateContainerPreferredSize() {
        return new Dimension(0, 200);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel type;
        private TextLabel target;
        private TextLabel user;
        private TextLabel date;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.type = new TextLabel((Boolean)m.getNode().getChildNamed(PurchaseOrderSendHistoryComplete_.print).getValue() != false ? Words.PRINT_ONLY : Words.EMAIL);
            this.target = new TextLabel(m.getNode().getChildNamed(PurchaseOrderSendHistoryComplete_.target));
            UserLight user = (UserLight)m.getNode().getChildNamed(PurchaseOrderSendHistoryComplete_.sentUser).getValue(UserLight.class);
            if (user != null) {
                m.getNode().getChildNamed(PurchaseOrderSendHistoryComplete_.sentUser).removeExistingValues();
                m.getNode().getChildNamed(PurchaseOrderSendHistoryComplete_.sentUser).setValue((Object)user, 0L);
            }
            this.user = new TextLabel(m.getNode().getChildNamed(PurchaseOrderSendHistoryComplete_.sentUser), ConverterRegistry.getConverter(UserConverter.class));
            this.date = new TextLabel(m.getNode().getChildNamed(PurchaseOrderSendHistoryComplete_.sendDate), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.setLayout(new InnerLayout());
            this.add(this.type);
            this.add(this.target);
            this.add(this.user);
            this.add(this.date);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(PurchaseOrderSendHistoryComplete_.print).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(PurchaseOrderSendHistoryComplete_.target).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(PurchaseOrderSendHistoryComplete_.sentUser).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(PurchaseOrderSendHistoryComplete_.sendDate).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.type.setEnabled(isEnabled);
            this.target.setEnabled(isEnabled);
            this.user.setEnabled(isEnabled);
            this.date.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.type.kill();
            this.target.kill();
            this.user.kill();
            this.date.kill();
            this.type = null;
            this.target = null;
            this.user = null;
            this.date = null;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.type.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                int currentX = w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.target.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.target.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.target.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.target.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.user.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.user.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.user.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.user.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.date.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
            }
        }
    }
}

