/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator;

import ch.icit.pegasus.client.actions.impl.PrintPurchaseOrderForReceiving;
import ch.icit.pegasus.client.actions.impl.PrintPurchaseOrderSheet;
import ch.icit.pegasus.client.actions.impl.SendPurchaseOrderAction;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.TableModel;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.NoProExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationList;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.DeliveryTermComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderDeliveryWindowComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceAndUnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.PurchaseApprovalSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ManualOrderCreatorDataHandler
implements IDataHandler {
    private UserComplete currentUser;

    @Override
    public String getRemoteValidationText() {
        return "Load Article Prices";
    }

    public void doRemoteValidation(final Node readNode, final RemoteLoader listener, ProgressListener l, final boolean validateAll) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
                Node oldNode = readNode;
                Iterator it2 = readNode.getFailSafeChildIterator();
                while (it2.hasNext()) {
                    Node node = (Node)it2.next();
                    SupplierReference supplier = (SupplierReference)node.getChildNamed(new String[]{"supplier"}).getValue();
                    Date orderDate = (Date)node.getChildNamed(new String[]{"orderDate"}).getValue();
                    Boolean useTaxZone = (Boolean)node.getChildNamed(new String[]{"useTaxZone"}).getValue();
                    TaxZoneComplete taxZone = (TaxZoneComplete)node.getChildNamed(new String[]{"taxZone"}).getValue();
                    Iterator it = node.getChildNamed(new String[]{"orderPositions"}).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        boolean revalidateNeeded = false;
                        SupplierConditionComplete supplierCondition = null;
                        if (n.getChildNamed(new String[]{"supplierCondition"}) != null && n.getChildNamed(new String[]{"supplierCondition"}).getValue() != null) {
                            supplierCondition = (SupplierConditionComplete)n.getChildNamed(new String[]{"supplierCondition"}).getValue();
                        }
                        if (n.getChildNamed(new String[]{"supplierPrice"}) != null) {
                            if (n.getChildNamed(new String[]{"supplierPrice-price"}).getValue() == null) {
                                revalidateNeeded = true;
                            }
                            if (n.getChildNamed(new String[]{"supplierPrice-currency"}).getValue() == null) {
                                revalidateNeeded = true;
                            }
                        } else {
                            revalidateNeeded = true;
                        }
                        if (n.getChildNamed(new String[]{"priceUnit"}).getValue() == null) {
                            revalidateNeeded = true;
                        }
                        if (validateAll || n.getChildNamed(new String[]{"hasQuantityChange"}) != null) {
                            revalidateNeeded = true;
                        }
                        if (revalidateNeeded) {
                            UnitComplete u = (UnitComplete)n.getChildNamed(new String[]{"quantity-unit"}).getValue();
                            QuantityComplete q = new QuantityComplete();
                            q.setUnit(u);
                            q.setQuantity(TransactionToolkit.getDoubleValue(n.getChildNamed(new String[]{"quantity-amount"})));
                            BasicArticleLight r = (BasicArticleLight)n.getChildNamed(new String[]{"article"}).getValue();
                            PriceAndUnitComplete pau = null;
                            try {
                                PriceAndUnitComplete ret;
                                pau = ret = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getArticlePrice((BasicArticleReference)r, supplier, new DateWrapper(orderDate), q, useTaxZone, taxZone, supplierCondition);
                                if (pau != null) {
                                    n.getChildNamed(new String[]{"supplierPrice-price"}).setValue((Object)pau.getPrice().getPrice(), 0L);
                                    n.getChildNamed(new String[]{"supplierPrice-currency"}).setValue((Object)pau.getPrice().getCurrency(), 0L);
                                    n.getChildNamed(new String[]{"priceUnit"}).setValue((Object)pau.getUnit(), 0L);
                                    if (n.getChildNamed(new String[]{"hasQuantityChange"}) != null) {
                                        n.removeChild(n.getChildNamed(new String[]{"hasQuantityChange"}), 0L);
                                    }
                                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, r.getNumber() + " - " + r.getName() + ": " + pau.toString()));
                                } else {
                                    revalidateNeeded = true;
                                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Price found for " + r.getNumber() + " - " + r.getName()));
                                }
                            }
                            catch (Exception e) {
                                revalidateNeeded = true;
                                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()));
                            }
                        }
                        for (int count = 0; n instanceof ProxyNode && count < 10; ++count) {
                            n = ((ProxyNode)n).getRefNode();
                        }
                        if (n == null) continue;
                        n.commitThis(PurchaseOrderPositionComplete.class);
                    }
                    node.commit(PurchaseOrderComplete.class);
                }
                Node retNode = new Node();
                if (!a.isEmpty()) {
                    retNode.setValue(a, 0L);
                }
                return retNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void updateData(Node node, RemoteLoader model, ProgressListener l) {
    }

    @Override
    public long getLoadingID() {
        return 0L;
    }

    public Class<?> getCommittingClass() {
        return null;
    }

    public void createOrders(final Component source, final Node orderList, final RemoteLoader model, final ProgressListener l, final boolean send, final boolean printRec, final boolean printOrder) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Iterator it = orderList.getFailSafeChildIterator();
                ScreenValidationList messages = new ScreenValidationList();
                PurchaseApprovalSettingsComplete purchaseReleaseSettings = (PurchaseApprovalSettingsComplete)NodeToolkit.getAffixClass(PurchaseApprovalSettingsComplete.class).getValue();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    n.commit(PurchaseOrderComplete.class, true);
                    l.stateChanged(Words.CREATE_ORDERS);
                    PurchaseOrderComplete order = (PurchaseOrderComplete)n.getValue(PurchaseOrderComplete.class);
                    int c = 0;
                    for (PurchaseOrderPositionComplete p : order.getOrderPositions()) {
                        p.setOrder(order);
                        p.setSequenceNumber(Integer.valueOf(c));
                        ++c;
                    }
                    if (order.getEligibleLocations().isEmpty()) {
                        order.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                    }
                    Iterator it23 = order.getOrderPositions().iterator();
                    boolean emptyPositions = false;
                    while (it23.hasNext()) {
                        PurchaseOrderPositionComplete pos = (PurchaseOrderPositionComplete)it23.next();
                        if (pos.getQuantity().getAmount() > 0L) continue;
                        it23.remove();
                        emptyPositions = true;
                    }
                    if (order.getOrderPositions().isEmpty()) {
                        messages.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Order to " + order.getSupplier().getName() + " was removed, because the order has no positions."));
                    } else if (emptyPositions) {
                        messages.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Some positions from Order to " + order.getSupplier().getName() + " were removed, because the order amount was 0."));
                    }
                    if (order.getOrderPositions().size() <= 0) continue;
                    SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    try {
                        PurchaseOrderComplete nO = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).createPurchaseOrder(order).getValue();
                        boolean released = true;
                        if (Boolean.TRUE.equals(purchaseReleaseSettings.getUsePurchaseApproval()) && !Boolean.TRUE.equals(nO.getApproved())) {
                            released = false;
                        }
                        if (send && released) {
                            new SendPurchaseOrderAction().performAction(source, l, nO, ManualOrderCreatorDataHandler.this.getCurrentUser());
                        }
                        if (printRec) {
                            new PrintPurchaseOrderForReceiving().performAction(source, l, nO, settings);
                        }
                        if (printOrder) {
                            new PrintPurchaseOrderSheet().performAction(source, l, nO, settings);
                        }
                        messages.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, "Order to " + nO.getSupplier().getName() + " successfully placed"));
                    }
                    catch (Exception e) {
                        ScreenValidationObject v = new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage());
                        messages.add((Object)v);
                    }
                }
                if (ScreenValidationObject.isError((List)messages)) {
                    throw new ClientExceptionCollection("Unable to create all Orders", messages);
                }
                Node retNode = new Node();
                retNode.setValue((Object)messages, 0L);
                return retNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void createNewData(Node node, RemoteLoader model, boolean sameNode, ProgressListener l) {
    }

    public Node resetData(Node node) {
        return null;
    }

    @Override
    public void loadMasterData(final long id, final RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                progressListener.stateChanged("Load Module 1/9");
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                progressListener.stateChanged("Load Module 2/9");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                progressListener.stateChanged("Load Module 3/9");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ExternalCostCenterComplete.class);
                progressListener.stateChanged("Load Module 4/9");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderDeliveryWindowComplete.class);
                progressListener.stateChanged("Load Module 5/9");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(DeliveryTermComplete.class);
                progressListener.stateChanged("Load Module 6/9");
                UnitToolkit.loadUnits();
                progressListener.stateChanged("Load Module 7/9");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxZoneComplete.class);
                progressListener.stateChanged("Load Module 8/9");
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                progressListener.stateChanged("Load Module 9/9");
                ((NoProExchangeServiceManager)ServiceManagerRegistry.getService(NoProExchangeServiceManager.class)).getSettingsCached();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return loader;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void setModel(TableModel model) {
    }

    public Node createEmptyNode() {
        return null;
    }

    public boolean reloadDataBeforeOpening(Node node, RemoteLoader listener, ProgressListener progressListener) {
        return false;
    }

    public boolean reloadDataAfterClosing(Node node, RemoteLoader listener, ProgressListener progressListener) {
        return this.reloadDataBeforeOpening(node, listener, progressListener);
    }

    public UserComplete getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(UserComplete currentUser) {
        this.currentUser = currentUser;
    }
}

