/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseproposal.details;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.purchaseproposal.PurchaseProposalArticleComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.purchaseproposal.PurchaseProposalComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.purchaseproposal.PurchaseProposalLight;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ArticlesDetailsPanel
extends TableDetailsPanel<PurchaseProposalLight> {
    private static final long serialVersionUID = 1L;

    public ArticlesDetailsPanel(RowEditor<PurchaseProposalLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.ARTICLES);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.ARTICLE, "", String.class, null, "", 120, Integer.MAX_VALUE, 120));
        int tw = InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.QUANTITY, "", (Class)String.class, null, "", tw));
        columns.add(new TableColumnInfo("Flight Quantity", "", (Class)String.class, null, "", tw));
        columns.add(new TableColumnInfo("Purchase Incoming Quantity", "", (Class)String.class, null, "", tw));
        columns.add(new TableColumnInfo("Stock Quantity", "", (Class)String.class, null, "", tw));
        columns.add(new TableColumnInfo(Words.SUPPLIER, "", String.class, null, "", 75, Integer.MAX_VALUE, 75));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.75);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.25);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setUseAccessRight(true);
        table.setDontUseScrollBar(15);
        table.setSortedColumn(0);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        return new TableRowImpl(model);
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(PurchaseProposalComplete_.articles));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private TextLabel article;
        private QuantityRenderer flightQuantity;
        private QuantityRenderer purchaseIncomingQuantity;
        private QuantityRenderer stockQuantity;
        private RDInputComboBox orderQuantity;
        private RDSearchTextField2<SupplierLight> supplier;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            BasicArticleComplete artC = (BasicArticleComplete)m.getNode().getChildNamed(PurchaseProposalArticleComplete_.article).getValue(BasicArticleComplete.class);
            ViewNode un = new ViewNode("");
            if (artC != null) {
                List units = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)new Timestamp(System.currentTimeMillis()), (TransactionType)TransactionType.PURCHASE, (UserComplete)ArticlesDetailsPanel.this.currentUser, null, null, (SystemSettingsComplete)ArticlesDetailsPanel.this.settings);
                for (UnitComplete u : units) {
                    un.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)u, false, true), 0L);
                }
            }
            this.article = new TextLabel(m.getNode().getChildNamed(PurchaseProposalArticleComplete_.article), ConverterRegistry.getConverter(BasicArticleConverter.class));
            this.flightQuantity = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(PurchaseProposalArticleComplete_.flightQuantityInMainStore));
            this.purchaseIncomingQuantity = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(PurchaseProposalArticleComplete_.purchaseIncomingQuantityInMainStore));
            this.stockQuantity = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(PurchaseProposalArticleComplete_.stockQuantityInMainStore));
            this.orderQuantity = new RDInputComboBox(ArticlesDetailsPanel.this.provider, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.orderQuantity.setOverrideName(PurchaseProposalComplete_.articles);
            this.orderQuantity.setNode(m.getNode().getChildNamed(new DtoField[]{PurchaseProposalArticleComplete_.orderQuantityInMainStore, QuantityComplete_.quantity}), m.getNode().getChildNamed(new DtoField[]{PurchaseProposalArticleComplete_.orderQuantityInMainStore, QuantityComplete_.unit}));
            this.orderQuantity.setPossibleUnits((Node)un);
            this.supplier = new RDSearchTextField2(ArticlesDetailsPanel.this.provider, RDSearchTextField2.SearchTypes.SUPPLIER);
            this.supplier.setOverrideName(PurchaseProposalComplete_.articles);
            this.supplier.setNode(m.getNode().getChildNamed(PurchaseProposalArticleComplete_.supplier));
            this.setLayout(new Layout());
            this.add(this.article);
            this.add(this.orderQuantity);
            this.add(this.flightQuantity);
            this.add(this.purchaseIncomingQuantity);
            this.add(this.stockQuantity);
            this.add(this.supplier);
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(new DtoField[]{SafetyStockArticleComplete_.article, BasicArticleLight_.number}).getValue();
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.orderQuantity);
            CheckedListAdder.addToList(focusList, this.supplier);
            return focusList;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.article.kill();
            this.orderQuantity.kill();
            this.flightQuantity.kill();
            this.purchaseIncomingQuantity.kill();
            this.stockQuantity.kill();
            this.supplier.kill();
            this.article = null;
            this.orderQuantity = null;
            this.flightQuantity = null;
            this.purchaseIncomingQuantity = null;
            this.stockQuantity = null;
            this.supplier = null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = 0;
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(0);
                TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.article.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(1);
                TableRowImpl.this.orderQuantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.orderQuantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.orderQuantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.orderQuantity.getPreferredSize().getHeight());
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(2);
                TableRowImpl.this.flightQuantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightQuantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flightQuantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightQuantity.getPreferredSize().getHeight());
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(3);
                TableRowImpl.this.purchaseIncomingQuantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.purchaseIncomingQuantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.purchaseIncomingQuantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.purchaseIncomingQuantity.getPreferredSize().getHeight());
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(4);
                TableRowImpl.this.stockQuantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.stockQuantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.stockQuantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.stockQuantity.getPreferredSize().getHeight());
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(5);
                TableRowImpl.this.supplier.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.supplier.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.supplier.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.supplier.getPreferredSize().getHeight());
            }
        }
    }
}

