/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseproposal.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.articlegroup.ArticleGroupLight;
import ch.icit.pegasus.server.core.dtos.ordering.purchaseproposal.PurchaseProposalComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.purchaseproposal.PurchaseProposalLight;
import ch.icit.pegasus.server.core.dtos.ordering.purchaseproposal.PurchaseProposalLight_;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelLight;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<PurchaseProposalLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<RDTextField> name;
    private TitledPeriodEditor validity;
    private TitledItem<RDSearchTextField2<SafetyStockLight>> safetyStock;
    private TitledItem<RDSearchTextField2<ReorderLevelLight>> reorderLevel;
    private TitledItem<RDSearchTextField2<ArticleGroupLight>> articleGroup;

    public SpecificationDetailsPanel(RowEditor<PurchaseProposalLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.validity = new TitledPeriodEditor(null, true, provider);
        this.safetyStock = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.SAFETY_STOCK), "Safety Stock", TitledItem.TitledItemOrientation.NORTH);
        this.reorderLevel = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.REORDER_LEVEL), "Reorder Level", TitledItem.TitledItemOrientation.NORTH);
        this.articleGroup = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.ARTICLE_GROUP), "Article Group", TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.number);
        this.addToView(this.name);
        this.addToView(this.validity);
        this.addToView(this.safetyStock);
        this.addToView(this.reorderLevel);
        this.addToView(this.articleGroup);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
    }

    @Override
    public void setNode(Node<?> node) {
        this.number.getElement().setNode(node.getChildNamed(PurchaseProposalLight_.number));
        this.name.getElement().setNode(node.getChildNamed(PurchaseProposalLight_.name));
        this.validity.setNode((Node<PeriodComplete>)node.getChildNamed(PurchaseProposalLight_.flightsPeriod));
        this.safetyStock.getElement().setNode(node.getChildNamed(PurchaseProposalComplete_.safetyStock));
        this.reorderLevel.getElement().setNode(node.getChildNamed(PurchaseProposalComplete_.reorderLevel));
        this.articleGroup.getElement().setNode(node.getChildNamed(PurchaseProposalComplete_.articleGroup));
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.validity);
        CheckedListAdder.addToList(focusList, this.safetyStock);
        CheckedListAdder.addToList(focusList, this.reorderLevel);
        CheckedListAdder.addToList(focusList, this.articleGroup);
        return focusList;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        String n = (String)this.editor.getModel().getNode().getChildNamed(PurchaseProposalLight_.name).getValue();
        if (n == null || n.isEmpty()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        if (this.editor.getModel().getNode().getChildNamed(PurchaseProposalComplete_.safetyStock).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Safety Stock not set"));
        }
        if (this.editor.getModel().getNode().getChildNamed(PurchaseProposalComplete_.reorderLevel).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Reorder Level not set"));
        }
        if (this.editor.getModel().getNode().getChildNamed(PurchaseProposalComplete_.articleGroup).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article Group not set"));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.safetyStock.setEnabled(isEnabled);
        this.reorderLevel.setEnabled(isEnabled);
        this.articleGroup.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.number = null;
        this.name.kill();
        this.name = null;
        this.validity.kill();
        this.validity = null;
        this.safetyStock.kill();
        this.safetyStock = null;
        this.reorderLevel.kill();
        this.reorderLevel = null;
        this.articleGroup.kill();
        this.articleGroup = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(80, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(parent.getWidth() - (SpecificationDetailsPanel.this.horizontalBorder + SpecificationDetailsPanel.this.name.getX()), (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.validity.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.validity.setSize(SpecificationDetailsPanel.this.validity.getPreferredSize());
            SpecificationDetailsPanel.this.safetyStock.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.validity.getY() + SpecificationDetailsPanel.this.validity.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.safetyStock.setSize((parent.getWidth() - 4 * SpecificationDetailsPanel.this.horizontalBorder) / 2, (int)SpecificationDetailsPanel.this.safetyStock.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.reorderLevel.setLocation(SpecificationDetailsPanel.this.safetyStock.getX() + SpecificationDetailsPanel.this.safetyStock.getWidth() + 2 * SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.safetyStock.getY());
            SpecificationDetailsPanel.this.reorderLevel.setSize((parent.getWidth() - 4 * SpecificationDetailsPanel.this.horizontalBorder) / 2, (int)SpecificationDetailsPanel.this.reorderLevel.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.articleGroup.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.reorderLevel.getY() + SpecificationDetailsPanel.this.reorderLevel.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.articleGroup.setSize((parent.getWidth() - 4 * SpecificationDetailsPanel.this.horizontalBorder) / 2, (int)SpecificationDetailsPanel.this.articleGroup.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.validity.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.safetyStock.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.articleGroup.getPreferredSize().getHeight());
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

